/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import jakarta.ejb.EJBObject;
import jakarta.ejb.EntityContext;
import jakarta.ejb.TimerService;
import java.lang.reflect.Method;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.persistence.ejb.entitybean.container.EntityContainer;
import org.glassfish.persistence.ejb.entitybean.container.spi.CascadeDeleteNotifier;

public class EntityContextImpl
extends EJBContextImpl
implements EntityContext,
CascadeDeleteNotifier {
    private int lastTxStatus = -1;
    private boolean newlyActivated = false;
    private int nCallsInProgress = 0;
    private boolean dirty = false;
    private boolean inUnsetEntityContext = false;
    private boolean inEjbLoad = false;
    private boolean inEjbStore = false;
    private boolean cascadeDeleteBeforeEJBRemove = false;
    private boolean cascadeDeleteAfterSuperEJBRemove = false;
    private Object _primaryKey;
    private int _pkHashCode;
    private EntityContextImpl _next;
    private transient EntityContainer _container = null;

    EntityContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        this._container = (EntityContainer)container;
    }

    int getLastTransactionStatus() {
        return this.lastTxStatus;
    }

    void setLastTransactionStatus(int status) {
        this.lastTxStatus = status;
    }

    void setInUnsetEntityContext(boolean flag) {
        this.inUnsetEntityContext = flag;
    }

    void setInEjbLoad(boolean flag) {
        this.inEjbLoad = flag;
    }

    void setInEjbStore(boolean flag) {
        this.inEjbStore = flag;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty(boolean b) {
        this.dirty = b;
    }

    void setState(EJBContextImpl.BeanState s) {
        this.state = s;
        if (this.state == EJBContextImpl.BeanState.POOLED || this.state == EJBContextImpl.BeanState.DESTROYED) {
            this.dirty = false;
        }
    }

    boolean isNewlyActivated() {
        return this.newlyActivated;
    }

    void setNewlyActivated(boolean b) {
        this.newlyActivated = b;
    }

    boolean hasReentrantCall() {
        return this.nCallsInProgress > 1;
    }

    synchronized void decrementCalls() {
        --this.nCallsInProgress;
    }

    synchronized void incrementCalls() {
        ++this.nCallsInProgress;
    }

    boolean hasIdentity() {
        return this.ejbObjectImpl != null || this.ejbLocalObjectImpl != null;
    }

    public Object getPrimaryKey() throws IllegalStateException {
        if (this.ejbObjectImpl == null && this.ejbLocalObjectImpl == null) {
            throw new IllegalStateException("Primary key not available");
        }
        return this.getKey();
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        if (!this.isRemoteInterfaceSupported) {
            throw new IllegalStateException("EJBObject not available");
        }
        if (this.ejbStub == null) {
            Object pkey = this.getPrimaryKey();
            this.ejbStub = this._container.getEJBObjectStub(pkey, null);
        }
        return this.ejbStub;
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inUnsetEntityContext || this.inFinder()) {
            throw new IllegalStateException("Operation not allowed");
        }
        return EJBTimerService.getEJBTimerServiceWrapper((EJBContextImpl)this);
    }

    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inUnsetEntityContext) {
            throw new IllegalStateException("Operation not allowed");
        }
        this.checkActivatePassivate();
        if (this.inEjbLoad || this.inEjbStore) {
            return;
        }
    }

    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inUnsetEntityContext || this.inFinder() || this.inActivatePassivate() || !this.hasIdentity()) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    public final boolean isCascadeDeleteAfterSuperEJBRemove() {
        return this.cascadeDeleteAfterSuperEJBRemove;
    }

    @Override
    public final void setCascadeDeleteAfterSuperEJBRemove(boolean value) {
        this.cascadeDeleteAfterSuperEJBRemove = value;
    }

    public final boolean isCascadeDeleteBeforeEJBRemove() {
        return this.cascadeDeleteBeforeEJBRemove;
    }

    public final void setCascadeDeleteBeforeEJBRemove(boolean value) {
        this.cascadeDeleteBeforeEJBRemove = value;
    }

    private boolean inFinder() {
        boolean inFinder = false;
        ComponentInvocation ci = this._container.getCurrentInvocation();
        if (ci instanceof EjbInvocation) {
            EjbInvocation inv = (EjbInvocation)ci;
            Method currentMethod = inv.method;
            inFinder = currentMethod != null && inv.isHome && currentMethod.getName().startsWith("find");
        }
        return inFinder;
    }

    final void cachePrimaryKey() {
        Object pk;
        this._primaryKey = pk = this.getPrimaryKey();
        this._pkHashCode = pk.hashCode();
    }

    final void clearCachedPrimaryKey() {
        this._primaryKey = null;
    }

    final boolean doesMatch(BaseContainer baseContainer, int pkHashCode, Object pk) {
        return this.container == baseContainer && this._pkHashCode == pkHashCode && this._primaryKey.equals(pk);
    }

    final void _setNext(EntityContextImpl val) {
        this._next = val;
    }

    final EntityContextImpl _getNext() {
        return this._next;
    }

    final int _getPKHashCode() {
        return this._pkHashCode;
    }

    final boolean isInState(EJBContextImpl.BeanState value) {
        return this.getState() == value;
    }
}

