/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.nucleus.hotdeploy.ApplicationState;
import fish.payara.nucleus.hotdeploy.HotDeployService;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.internal.deployment.Verifier;
import org.glassfish.internal.deployment.analysis.DeploymentSpan;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

@Service(name="deploy")
@I18n(value="deploy.command")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.POST, path="deploy"), @RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="deploy", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="deploy", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="deploy", params={@RestParam(name="target", value="$parent")})})
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand,
EventListener,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    @Inject
    Applications apps;
    @Inject
    ServerEnvironment env;
    @Inject
    ServiceLocator habitat;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    Events events;
    @Inject
    VersioningService versioningService;
    @Inject
    private HotDeployService hotDeployService;
    private File safeCopyOfApp = null;
    private File safeCopyOfDeploymentPlan = null;
    private File safeCopyOfAltDD = null;
    private File safeCopyOfRuntimeAltDD = null;
    private File originalPathValue;
    private List<String> previousTargets = new ArrayList<String>();
    private final Properties previousVirtualServers = new Properties();
    private final Properties previousEnabledAttributes = new Properties();
    private Logger logger;
    private ExtendedDeploymentContext initialContext;
    private ExtendedDeploymentContext deploymentContext;
    private ArchiveHandler archiveHandler;
    private File expansionDir;
    private ReadableArchive archive;
    private DeploymentTracing timing;
    private transient DeployCommandSupplementalInfo suppInfo;
    private static final String EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private static final String SUN_EJB_JAR_XML = "META-INF/sun-ejb-jar.xml";
    private static final String GF_EJB_JAR_XML = "META-INF/glassfish-ejb-jar.xml";
    private static final String APPLICATION_XML = "META-INF/application.xml";
    private static final String SUN_APPLICATION_XML = "META-INF/sun-application.xml";
    private static final String GF_APPLICATION_XML = "META-INF/glassfish-application.xml";
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String APPLICATION_CLIENT_XML = "META-INF/application-client.xml";
    private static final String SUN_APPLICATION_CLIENT_XML = "META-INF/sun-application-client.xml";
    private static final String GF_APPLICATION_CLIENT_XML = "META-INF/glassfish-application-client.xml";
    private StructuredDeploymentTracing structuredTracing;

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean preAuthorization(AdminCommandContext context) {
        DeploymentSpan span;
        this.logger = context.getLogger();
        this.events.register((EventListener)this);
        this.suppInfo = new DeployCommandSupplementalInfo();
        context.getActionReport().setResultType(DeployCommandSupplementalInfo.class, (Object)this.suppInfo);
        this.structuredTracing = System.getProperty("org.glassfish.deployment.trace") != null ? StructuredDeploymentTracing.create((String)this.path.getName()) : StructuredDeploymentTracing.createDisabled((String)this.path.getName());
        this.timing = new DeploymentTracing(this.structuredTracing);
        ActionReport report = context.getActionReport();
        this.originalPathValue = this.path;
        if (!this.path.exists()) {
            report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{this.path.getAbsolutePath()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (!this.path.canRead()) {
            report.setMessage(localStrings.getLocalString("fnr", "File {0} does not have read permission", new Object[]{this.path.getAbsolutePath()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.snifferManager.hasNoSniffers()) {
            String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
            report.failure(this.logger, msg);
            return false;
        }
        try {
            span = this.structuredTracing.startSpan((Enum)DeploymentTracing.AppStage.OPENING_ARCHIVE);
            try {
                this.archive = this.archiveFactory.openArchive(this.path, (DeployCommandParameters)this);
            }
            finally {
                if (span != null) {
                    span.close();
                }
            }
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", new Object[]{this.path.getAbsolutePath()});
            if (this.logReportedErrors.booleanValue()) {
                report.failure(this.logger, msg, (Throwable)e);
                return false;
            }
            report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.altdd != null) {
            this.archive.addArchiveMetaData("altdd", (Object)this.altdd);
        }
        if (this.runtimealtdd != null) {
            this.archive.addArchiveMetaData("runtimealtdd", (Object)this.runtimealtdd);
        }
        this.expansionDir = null;
        this.deploymentContext = null;
        try {
            span = this.structuredTracing.startSequence((Enum)DeploymentTracing.AppStage.VALIDATE_TARGET, "command");
            try {
                boolean isRegistered;
                String versionIdentifier;
                this.deployment.validateSpecifiedTarget(this.target);
                span.start((Enum)DeploymentTracing.AppStage.OPENING_ARCHIVE, "ArchiveHandler");
                this.archiveHandler = this.deployment.getArchiveHandler(this.archive, this.type);
                if (this.archiveHandler == null) {
                    report.failure(this.logger, localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{this.path}));
                    boolean msg = false;
                    return msg;
                }
                span.start((Enum)DeploymentTracing.AppStage.CREATE_DEPLOYMENT_CONTEXT, "Initial");
                Optional appState = this.hotDeployService.getApplicationState(this.path);
                boolean hotswap = this.hotDeploy != false && this.metadataChanged == false && appState.map(ApplicationState::isHotswap).orElse(false) != false;
                this.initialContext = !hotswap ? new DeploymentContextImpl(report, this.archive, (OpsParams)this, this.env) : this.hotDeployService.getApplicationState(this.path).map(ApplicationState::getDeploymentContext).orElseThrow(() -> new RuntimeException());
                this.initialContext.setArchiveHandler(this.archiveHandler);
                if (this.hotDeploy.booleanValue() && !this.metadataChanged.booleanValue() && appState.isPresent()) {
                    if (!((ApplicationState)appState.get()).start((DeployCommandParameters)this, this.initialContext, this.events)) {
                        ((ApplicationState)appState.get()).close();
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.hotDeployService.removeApplicationState(this.path);
                }
                this.structuredTracing.register((DeploymentContext)this.initialContext);
                span.finish();
                span.start((Enum)DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.INITIAL_CONTEXT_CREATED.type());
                this.events.send(new EventListener.Event(Deployment.INITIAL_CONTEXT_CREATED, (Object)this.initialContext), false);
                span.start((Enum)DeploymentTracing.AppStage.DETERMINE_APP_NAME);
                if (!this.forceName.booleanValue()) {
                    boolean isModuleDescriptorAvailable = false;
                    if (this.archiveHandler.getArchiveType().equals("ejb") && (this.archive.exists(EJB_JAR_XML) || this.archive.exists(SUN_EJB_JAR_XML) || this.archive.exists(GF_EJB_JAR_XML))) {
                        isModuleDescriptorAvailable = true;
                    } else if (this.archiveHandler.getArchiveType().equals("ear") && (this.archive.exists(APPLICATION_XML) || this.archive.exists(SUN_APPLICATION_XML) || this.archive.exists(GF_APPLICATION_XML))) {
                        isModuleDescriptorAvailable = true;
                    } else if (this.archiveHandler.getArchiveType().equals("car") && (this.archive.exists(APPLICATION_CLIENT_XML) || this.archive.exists(SUN_APPLICATION_CLIENT_XML) || this.archive.exists(GF_APPLICATION_CLIENT_XML))) {
                        isModuleDescriptorAvailable = true;
                    } else if (this.archiveHandler.getArchiveType().equals("rar") && this.archive.exists(RA_XML)) {
                        isModuleDescriptorAvailable = true;
                    }
                    if (isModuleDescriptorAvailable) {
                        this.name = this.archiveHandler.getDefaultApplicationName(this.initialContext.getSource(), (DeploymentContext)this.initialContext, this.name);
                    }
                }
                if (this.name == null) {
                    this.name = this.archiveHandler.getDefaultApplicationName(this.initialContext.getSource(), (DeploymentContext)this.initialContext);
                } else {
                    DeploymentUtils.validateApplicationName((String)this.name);
                }
                boolean isUntagged = VersioningUtils.isUntagged((String)this.name);
                if (this.name != null && !isUntagged && this.type != null && this.type.equals("osgi")) {
                    ActionReport.MessagePart msgPart = context.getActionReport().getTopMessagePart();
                    msgPart.setChildrenType("WARNING");
                    ActionReport.MessagePart childPart = msgPart.addChild();
                    childPart.setMessage(VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.osgi.warning", "OSGi bundles will not use the GlassFish versioning, any version information embedded as part of the name option will be ignored"));
                    this.name = VersioningUtils.getUntaggedName((String)this.name);
                }
                if (isUntagged && (versionIdentifier = this.archiveHandler.getVersionIdentifier(this.initialContext.getSource())) != null && !versionIdentifier.isEmpty()) {
                    this.name = this.name + ":" + versionIdentifier;
                }
                if (this.target == null) {
                    this.target = this.deployment.getDefaultTarget(this.name, this.origin, this._classicstyle);
                }
                this.isredeploy = (isRegistered = this.deployment.isRegistered(this.name)) && this.force != false;
                boolean bl = true;
                return bl;
            }
            finally {
                if (span != null) {
                    span.close();
                }
            }
        }
        catch (Exception ex) {
            this.events.unregister((EventListener)this);
            if (this.initialContext == null) throw new RuntimeException(ex);
            if (this.initialContext.getSource() == null) throw new RuntimeException(ex);
            try {
                this.initialContext.getSource().close();
                throw new RuntimeException(ex);
            }
            catch (IOException ioex) {
                throw new RuntimeException(ioex);
            }
        }
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getResourceNameForApps(this.domain), "create"));
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target), "create"));
        if (this.isredeploy.booleanValue()) {
            String appResource = DeploymentCommandUtils.getResourceNameForNewApp(this.domain, this.name);
            accessChecks.add(new AccessRequired.AccessCheck(appResource, "delete"));
            String appRefResource = DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target, this.name);
            accessChecks.add(new AccessRequired.AccessCheck(appRefResource, "delete"));
        }
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        timeTakenToDeploy = 0L;
        deploymentTimeMillis = 0L;
        appState = Optional.empty();
        report = context.getActionReport();
        try {
            block128: {
                span = this.structuredTracing.startSequence((Enum)DeploymentTracing.AppStage.VALIDATE_TARGET, "registry");
                if (!this.hotDeploy.booleanValue()) {
                    this.hotDeployService.removeApplicationState(this.initialContext.getSourceDir());
                } else {
                    appState = this.hotDeployService.getApplicationState(this.initialContext.getSourceDir());
                    if (!appState.isPresent()) {
                        applicationState = new ApplicationState(this.name, this.path, this.initialContext);
                        applicationState.setTarget(this.target);
                        appState = Optional.of(applicationState);
                    }
                }
                interceptors = this.habitat.getAllServices(Interceptor.class, new Annotation[0]);
                if (interceptors != null) {
                    for (Interceptor interceptor : interceptors) {
                        interceptor.intercept(this, (DeploymentContext)this.initialContext);
                    }
                }
                this.deployment.validateDeploymentTarget(this.target, this.name, this.isredeploy.booleanValue());
                part = report.getTopMessagePart();
                part.addProperty("name", this.name);
                savedAppConfig = new ApplicationConfigInfo((Application)this.apps.getModule(Application.class, this.name));
                undeployProps = null;
                if (appState.map((Function<ApplicationState, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isInactive(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/lang/Boolean;)()).orElse(true).booleanValue()) {
                    undeployProps = this.handleRedeploy(this.name, report, context);
                }
                appState.filter((Predicate<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInactive(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Z)()).ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addApplicationState(fish.payara.nucleus.hotdeploy.ApplicationState ), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)((HotDeployService)this.hotDeployService));
                if (this.enabled == null) {
                    this.enabled = Boolean.TRUE;
                }
                if (this.keepreposdir.booleanValue()) ** GOTO lbl152
                span.start((Enum)DeploymentTracing.AppStage.CLEANUP, "applications");
                reposDir = new File(this.env.getApplicationRepositoryPath(), VersioningUtils.getRepositoryName((String)this.name));
                if (!reposDir.exists()) ** GOTO lbl150
                i = 0;
lbl41:
                // 2 sources

                while (i < this.domain.getApplications().getApplications().size()) {
                    existrepos = new File(new URI(((Application)this.domain.getApplications().getApplications().get(i)).getLocation()));
                    appname = ((Application)this.domain.getApplications().getApplications().get(i)).getName();
                    if (appname.equals(this.name) || !existrepos.getAbsoluteFile().equals(reposDir.getAbsoluteFile())) ** GOTO lbl-1000
                    report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.dupdeployment", "Application {0} is trying to use the same repository directory as application {1}, please choose a different application name to deploy", new Object[]{this.name, appname}));
                    if (span != null) {
                        break block128;
                    }
                    ** GOTO lbl104
                }
                ** GOTO lbl147
            }
            span.close();
            ** GOTO lbl104
        }
        catch (Throwable e) {
            block131: {
                block129: {
                    block130: {
                        try {
                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                            report.setFailureCause(e);
                            if (e.getMessage() == null) ** GOTO lbl395
                            report.setMessage(e.getMessage());
                        }
                        catch (Throwable var27_55) {
                            this.events.unregister((EventListener)this);
                            try {
                                this.archive.close();
                            }
                            catch (IOException e) {
                                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                            }
                            if (this.structuredTracing.isEnabled()) {
                                this.structuredTracing.print(System.out);
                            }
                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                report.setResultType(String.class, (Object)this.name);
                                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms at {2}", new Object[]{this.name, timeTakenToDeploy, DateFormat.getDateInstance().format(new Date(deploymentTimeMillis))}));
                            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                                errorMessage = report.getMessage();
                                cause = report.getFailureCause();
                                if (cause != null) {
                                    causeMessage = cause.getMessage();
                                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                        errorMessage = (String)errorMessage + " : " + cause.getMessage();
                                    }
                                    this.logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                                }
                                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                                report.setFailureCause(null);
                                if (this.expansionDir != null) {
                                    try {
                                        arch = DeploymentUtils.openAsFileArchive((File)this.expansionDir, (ArchiveFactory)this.archiveFactory);
                                        arch.delete();
                                    }
                                    catch (IOException ex) {
                                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                                        report.failure(this.logger, msg, (Throwable)ex);
                                    }
                                }
                                appState.map((Function<ApplicationState, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/io/File;)()).ifPresent((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, removeApplicationState(java.io.File ), (Ljava/io/File;)V)((HotDeployService)this.hotDeployService));
                            }
                            if (this.deploymentContext != null && !this.loadOnly.booleanValue()) {
                                this.deploymentContext.postDeployClean(true);
                            }
                            appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)());
                            throw var27_55;
                        }
lbl104:
                        // 2 sources

                        this.events.unregister((EventListener)this);
                        try {
                            this.archive.close();
                        }
                        catch (IOException e) {
                            this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                        }
                        if (this.structuredTracing.isEnabled()) {
                            this.structuredTracing.print(System.out);
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            report.setResultType(String.class, (Object)this.name);
                            report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                            this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms at {2}", new Object[]{this.name, timeTakenToDeploy, DateFormat.getDateInstance().format(new Date(deploymentTimeMillis))}));
                        } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                            errorMessage = report.getMessage();
                            cause = report.getFailureCause();
                            if (cause != null) {
                                causeMessage = cause.getMessage();
                                if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                    errorMessage = (String)errorMessage + " : " + cause.getMessage();
                                }
                                this.logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                            }
                            report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                            report.setFailureCause(null);
                            if (this.expansionDir != null) {
                                try {
                                    arch = DeploymentUtils.openAsFileArchive((File)this.expansionDir, (ArchiveFactory)this.archiveFactory);
                                    arch.delete();
                                }
                                catch (IOException ex) {
                                    msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                                    report.failure(this.logger, msg, (Throwable)ex);
                                }
                            }
                            appState.map((Function<ApplicationState, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/io/File;)()).ifPresent((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, removeApplicationState(java.io.File ), (Ljava/io/File;)V)((HotDeployService)this.hotDeployService));
                        }
                        if (this.deploymentContext != null && !this.loadOnly.booleanValue()) {
                            this.deploymentContext.postDeployClean(true);
                        }
                        appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)());
                        return;
lbl-1000:
                        // 1 sources

                        {
                            ++i;
                            ** GOTO lbl41
lbl147:
                            // 1 sources

                            arch = DeploymentUtils.openAsFileArchive((File)reposDir, (ArchiveFactory)this.archiveFactory);
                            arch.delete();
lbl150:
                            // 2 sources

                            span.finish();
lbl152:
                            // 2 sources

                            if (DeploymentUtils.isDomainTarget((String)this.target) || !this.enabled.booleanValue()) ** GOTO lbl-1000
                            try {
                                innerSpan = span.start((Enum)DeploymentTracing.AppStage.SWITCH_VERSIONS);
                                try {
                                    this.versioningService.handleDisable(this.name, this.target, report, context.getSubject());
                                }
                                finally {
                                    if (innerSpan != null) {
                                        innerSpan.close();
                                    }
                                }
                            }
                            catch (VersioningSyntaxException e) {
                                report.failure(this.logger, e.getMessage());
                                if (span != null) {
                                    span.close();
                                }
                                this.events.unregister((EventListener)this);
                                try {
                                    this.archive.close();
                                }
                                catch (IOException e) {
                                    this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                                }
                                if (this.structuredTracing.isEnabled()) {
                                    this.structuredTracing.print(System.out);
                                }
                                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                    report.setResultType(String.class, (Object)this.name);
                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                                    this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms at {2}", new Object[]{this.name, timeTakenToDeploy, DateFormat.getDateInstance().format(new Date(deploymentTimeMillis))}));
                                } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                                    errorMessage = report.getMessage();
                                    cause = report.getFailureCause();
                                    if (cause != null) {
                                        causeMessage = cause.getMessage();
                                        if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                            errorMessage = (String)errorMessage + " : " + cause.getMessage();
                                        }
                                        this.logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                                    }
                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                                    report.setFailureCause(null);
                                    if (this.expansionDir != null) {
                                        try {
                                            arch = DeploymentUtils.openAsFileArchive((File)this.expansionDir, (ArchiveFactory)this.archiveFactory);
                                            arch.delete();
                                        }
                                        catch (IOException ex) {
                                            msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                                            report.failure(this.logger, msg, (Throwable)ex);
                                        }
                                    }
                                    appState.map((Function<ApplicationState, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/io/File;)()).ifPresent((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, removeApplicationState(java.io.File ), (Ljava/io/File;)V)((HotDeployService)this.hotDeployService));
                                }
                                if (this.deploymentContext != null && !this.loadOnly.booleanValue()) {
                                    this.deploymentContext.postDeployClean(true);
                                }
                                appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)());
                                return;
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            source = new File(this.archive.getURI().getSchemeSpecificPart());
                            isDirectoryDeployed = true;
                            if (!source.isDirectory()) {
                                isDirectoryDeployed = false;
                                this.path = this.expansionDir = new File(this.domain.getApplicationRoot(), VersioningUtils.getRepositoryName((String)this.name));
                                break block129;
                            }
                            versionFromSameDir = this.versioningService.getVersionFromSameDir(source);
                            if (this.force.booleanValue() || versionFromSameDir == null) break block129;
                            report.failure(this.logger, VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.dual.inplace", "GlassFish do not support versioning for directory deployment when using the same directory. The directory {0} is already assigned to the version {1}.", new Object[]{source.getPath(), versionFromSameDir}));
                            if (span == null) break block130;
                        }
                        span.close();
                    }
                    this.events.unregister((EventListener)this);
                    try {
                        this.archive.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                    }
                    if (this.structuredTracing.isEnabled()) {
                        this.structuredTracing.print(System.out);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        report.setResultType(String.class, (Object)this.name);
                        report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                        this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms at {2}", new Object[]{this.name, timeTakenToDeploy, DateFormat.getDateInstance().format(new Date(deploymentTimeMillis))}));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        errorMessage = report.getMessage();
                        cause = report.getFailureCause();
                        if (cause != null) {
                            causeMessage = cause.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                errorMessage = (String)errorMessage + " : " + cause.getMessage();
                            }
                            this.logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                        }
                        report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                        report.setFailureCause(null);
                        if (this.expansionDir != null) {
                            try {
                                arch = DeploymentUtils.openAsFileArchive((File)this.expansionDir, (ArchiveFactory)this.archiveFactory);
                                arch.delete();
                            }
                            catch (IOException ex) {
                                msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                                report.failure(this.logger, msg, (Throwable)ex);
                            }
                        }
                        appState.map((Function<ApplicationState, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/io/File;)()).ifPresent((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, removeApplicationState(java.io.File ), (Ljava/io/File;)V)((HotDeployService)this.hotDeployService));
                    }
                    if (this.deploymentContext != null && !this.loadOnly.booleanValue()) {
                        this.deploymentContext.postDeployClean(true);
                    }
                    appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)());
                    return;
                }
                ** try [egrp 16[TRYBLOCK] [15 : 2201->3070)] { 
lbl262:
                // 1 sources

                span.start((Enum)DeploymentTracing.AppStage.CREATE_DEPLOYMENT_CONTEXT, "Full");
                this.deploymentContext = this.deployment.getBuilder(this.logger, (OpsParams)this, report).source(this.initialContext.getSource()).archiveHandler(this.archiveHandler).build(this.initialContext);
                if (undeployProps != null) {
                    this.deploymentContext.getAppProps().putAll((Map<?, ?>)undeployProps);
                }
                if (this.properties != null || this.property != null) {
                    if (this.properties == null) {
                        this.properties = new Properties();
                    }
                    if (this.property != null) {
                        this.properties.putAll((Map<?, ?>)this.property);
                    }
                }
                if (this.properties != null) {
                    this.deploymentContext.getAppProps().putAll((Map<?, ?>)this.properties);
                    this.validateDeploymentProperties(this.properties, (DeploymentContext)this.deploymentContext);
                }
                span.start((Enum)DeploymentTracing.AppStage.CLEANUP, "generated");
                this.deploymentContext.clean();
                span.start((Enum)DeploymentTracing.AppStage.PREPARE, "ServerConfig");
                appProps = this.deploymentContext.getAppProps();
                appLocation = DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.deploymentContext.getSource().getURI());
                appProps.setProperty("location", appLocation);
                appProps.setProperty("object-type", "user");
                if (this.contextroot != null) {
                    appProps.setProperty("context-root", this.contextroot);
                }
                appProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                if (this.type == null) {
                    this.type = this.archiveHandler.getArchiveType();
                }
                appProps.setProperty("archiveType", this.type);
                if (appProps.getProperty("cdiDevModeEnabled") == null) {
                    appProps.setProperty("cdiDevModeEnabled", Boolean.FALSE.toString());
                }
                savedAppConfig.store(appProps);
                this.deploymentContext.addTransientAppMetaData("previousTargets", this.previousTargets);
                this.deploymentContext.addTransientAppMetaData("previousVirtualServers", (Object)this.previousVirtualServers);
                this.deploymentContext.addTransientAppMetaData("previousEnabledAttributes", (Object)this.previousEnabledAttributes);
                tx = this.deployment.prepareAppConfigChanges((DeploymentContext)this.deploymentContext);
                span.finish();
                deplResult = this.deployment.prepare(null, this.deploymentContext);
                if (deplResult != null && !this.loadOnly.booleanValue()) {
                    appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$1(fish.payara.nucleus.hotdeploy.ApplicationState ), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)((DeployCommand)this));
                    this.deployment.initialize(deplResult.appInfo, deplResult.appInfo.getSniffers(), deplResult.context);
                }
                appInfo = deplResult != null ? deplResult.appInfo : null;
                downloadableArtifacts = DeploymentUtils.downloadableArtifacts((DeploymentContext)this.deploymentContext);
                generatedArtifacts = DeploymentUtils.generatedArtifacts((DeploymentContext)this.deploymentContext);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    try {
                        innerSpan = span.start((Enum)DeploymentTracing.AppStage.REGISTRATION);
                        try {
                            this.moveAppFilesToPermanentLocation(this.deploymentContext, this.logger);
                            this.recordFileLocations(appProps);
                            downloadableArtifacts.record(appProps);
                            generatedArtifacts.record(appProps);
                            timeTakenToDeploy = this.timing.elapsed();
                            deploymentTimeMillis = System.currentTimeMillis();
                            if (tx != null) {
                                application = (Application)this.deploymentContext.getTransientAppMetaData("application", Application.class);
                                application.setDeploymentTime(Long.toString(timeTakenToDeploy));
                                application.setTimeDeployed(Long.toString(deploymentTimeMillis));
                                this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)this.deploymentContext, tx);
                            }
                            if (this.retrieve != null) {
                                DeployCommand.retrieveArtifacts(context, downloadableArtifacts.getArtifacts(), this.retrieve, false, this.name);
                            }
                            this.suppInfo.setDeploymentContext(this.deploymentContext);
                            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_COMMAND_FINISH, (Object)appInfo), false);
                            worstExitCode = ActionReport.ExitCode.SUCCESS;
                            for (ActionReport subReport : report.getSubActionsReport()) {
                                actionExitCode = subReport.getActionExitCode();
                                if (!actionExitCode.isWorse(worstExitCode)) continue;
                                worstExitCode = actionExitCode;
                            }
                            report.setActionExitCode(worstExitCode);
                            report.setResultType(String.class, (Object)this.name);
                            break block131;
                        }
                        finally {
                            if (innerSpan != null) {
                                innerSpan.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.deployment.undeploy(this.name, this.deploymentContext);
                        this.deploymentContext.clean();
                        throw e;
                    }
                }
                break block131;
lbl349:
                // 1 sources

                finally {
                    if (span != null) {
                        span.close();
                    }
                }
            }
            this.events.unregister((EventListener)this);
            try {
                this.archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (this.structuredTracing.isEnabled()) {
                this.structuredTracing.print(System.out);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                report.setResultType(String.class, (Object)this.name);
                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms at {2}", new Object[]{this.name, timeTakenToDeploy, DateFormat.getDateInstance().format(new Date(deploymentTimeMillis))}));
            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = report.getMessage();
                cause = report.getFailureCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = (String)errorMessage + " : " + cause.getMessage();
                    }
                    this.logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                }
                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                report.setFailureCause(null);
                if (this.expansionDir != null) {
                    try {
                        arch = DeploymentUtils.openAsFileArchive((File)this.expansionDir, (ArchiveFactory)this.archiveFactory);
                        arch.delete();
                    }
                    catch (IOException ex) {
                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                        report.failure(this.logger, msg, (Throwable)ex);
                    }
                }
                appState.map((Function<ApplicationState, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/io/File;)()).ifPresent((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, removeApplicationState(java.io.File ), (Ljava/io/File;)V)((HotDeployService)this.hotDeployService));
            }
            if (this.deploymentContext != null && !this.loadOnly.booleanValue()) {
                this.deploymentContext.postDeployClean(true);
            }
            appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)());
            return;
lbl395:
            // 2 sources

            this.events.unregister((EventListener)this);
            try {
                this.archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (this.structuredTracing.isEnabled()) {
                this.structuredTracing.print(System.out);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                report.setResultType(String.class, (Object)this.name);
                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms at {2}", new Object[]{this.name, timeTakenToDeploy, DateFormat.getDateInstance().format(new Date(deploymentTimeMillis))}));
            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = report.getMessage();
                cause = report.getFailureCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = (String)errorMessage + " : " + cause.getMessage();
                    }
                    this.logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                }
                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                report.setFailureCause(null);
                if (this.expansionDir != null) {
                    try {
                        arch = DeploymentUtils.openAsFileArchive((File)this.expansionDir, (ArchiveFactory)this.archiveFactory);
                        arch.delete();
                    }
                    catch (IOException ex) {
                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                        report.failure(this.logger, msg, (Throwable)ex);
                    }
                }
                appState.map((Function<ApplicationState, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPath(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)Ljava/io/File;)()).ifPresent((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, removeApplicationState(java.io.File ), (Ljava/io/File;)V)((HotDeployService)this.hotDeployService));
            }
            if (this.deploymentContext != null && !this.loadOnly.booleanValue()) {
                this.deploymentContext.postDeployClean(true);
            }
            appState.ifPresent((Consumer<ApplicationState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, close(), (Lfish/payara/nucleus/hotdeploy/ApplicationState;)V)());
            return;
        }
    }

    private void moveAppFilesToPermanentLocation(ExtendedDeploymentContext deploymentContext, Logger logger) throws IOException {
        File finalUploadDir = deploymentContext.getAppInternalDir();
        File finalAltDDDir = deploymentContext.getAppAltDDDir();
        if (!finalUploadDir.mkdirs()) {
            logger.log(Level.FINE, " Attempting to create upload directory {0} was reported as failed; attempting to continue", new Object[]{finalUploadDir.getAbsolutePath()});
        }
        if (!finalAltDDDir.mkdirs()) {
            logger.log(Level.FINE, " Attempting to create altdd directory {0} was reported as failed; attempting to continue", new Object[]{finalAltDDDir.getAbsolutePath()});
        }
        this.safeCopyOfApp = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.originalPathValue, logger, this.env);
        this.safeCopyOfDeploymentPlan = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.deploymentplan, logger, this.env);
        this.safeCopyOfAltDD = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalAltDDDir, this.altdd, logger, this.env);
        this.safeCopyOfRuntimeAltDD = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalAltDDDir, this.runtimealtdd, logger, this.env);
    }

    private void recordFileLocations(Properties appProps) throws URISyntaxException {
        if (this.safeCopyOfApp != null) {
            appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.safeCopyOfApp.toURI()));
        }
        if (this.safeCopyOfDeploymentPlan != null) {
            appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.safeCopyOfDeploymentPlan.toURI()));
        }
        if (this.safeCopyOfAltDD != null) {
            appProps.setProperty("altDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.safeCopyOfAltDD.toURI()));
        }
        if (this.safeCopyOfRuntimeAltDD != null) {
            appProps.setProperty("runtimeAltDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)this.safeCopyOfRuntimeAltDD.toURI()));
        }
    }

    private Properties handleRedeploy(String name, ActionReport report, AdminCommandContext context) throws Exception {
        if (this.isredeploy.booleanValue()) {
            Application app = (Application)this.apps.getModule(Application.class, name);
            if (app.isLifecycleModule()) {
                throw new IllegalArgumentException(localStrings.getLocalString("lifecyclemodule_withsamename_exists", "Lifecycle module with same name {0} already exists, please pick a different name for the application. ", new Object[]{name}));
            }
            this.settingsFromDomainXML(app);
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)name);
            parameters.add((Object)"target", (Object)this.target);
            parameters.add((Object)"keepreposdir", (Object)this.keepreposdir.toString());
            parameters.add((Object)"isredeploy", (Object)this.isredeploy.toString());
            if (this.dropandcreatetables != null) {
                parameters.add((Object)"droptables", (Object)this.dropandcreatetables.toString());
            }
            parameters.add((Object)"_ignoreCascade", (Object)this.force.toString());
            if (this.keepstate != null) {
                parameters.add((Object)"keepstate", (Object)this.keepstate.toString());
            }
            ActionReport subReport = report.addSubActionsReport();
            subReport.setExtraProperties(new Properties());
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.add("keepSessions");
            propertyNames.add("preserveAppScopedResources");
            this.populatePropertiesToParameterMap(parameters, propertyNames);
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", subReport, context.getSubject());
            inv.parameters(parameters).execute();
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void populatePropertiesToParameterMap(ParameterMap parameters, List<String> propertyNamesList) {
        Properties props = new Properties();
        if (this.properties != null) {
            for (String propertyName : propertyNamesList) {
                if (!this.properties.containsKey(propertyName)) continue;
                props.put(propertyName, this.properties.getProperty(propertyName));
            }
        }
        parameters.add((Object)"properties", (Object)DeploymentUtils.propertiesValue((Properties)props, (char)':'));
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir) {
        DeployCommand.retrieveArtifacts(context, app, targetLocalDir, true);
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir, boolean reportErrorsInTopReport) {
        DeployCommand.retrieveArtifacts(context, DeploymentUtils.downloadableArtifacts((Application)app).getArtifacts(), targetLocalDir, reportErrorsInTopReport, app.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retrieveArtifacts(AdminCommandContext context, Collection<Artifacts.FullAndPartURIs> artifactInfo, String targetLocalDir, boolean reportErrorsInTopReport, String appname) {
        if (artifactInfo.isEmpty()) {
            ActionReport report = context.getActionReport();
            ActionReport subReport = report.addSubActionsReport();
            subReport.setMessage(localStrings.getLocalString(DeployCommand.class, "get-client-stubs.noStubApp", "There are no files to retrieve for application {0}", new Object[]{appname}));
            subReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        Logger logger = context.getLogger();
        FileOutputStream targetStream = null;
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            boolean retrieveArtifacts = false;
            if (outboundPayload == null) {
                outboundPayload = PayloadImpl.Outbound.newInstance();
                retrieveArtifacts = true;
            }
            Properties props = new Properties();
            props.setProperty("file-xfer-root", targetLocalDir.replace('\\', '/'));
            for (Artifacts.FullAndPartURIs uriPair : artifactInfo) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "About to download artifact {0}", uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
            }
            if (retrieveArtifacts) {
                String msg;
                File targetLocalFile = new File(targetLocalDir);
                if (targetLocalFile.exists()) {
                    msg = localStrings.getLocalString("download.errFileExists", "Unable to generate files. File [{0}] already exists.", new Object[]{targetLocalFile.getAbsolutePath()});
                    throw new Exception(msg);
                }
                if (!targetLocalFile.getParentFile().exists()) {
                    msg = localStrings.getLocalString("download.errParentFileMissing", "Unable to generate files. Directory [{0}] does not exist.", new Object[]{targetLocalFile.getParent()});
                    throw new Exception(msg);
                }
                targetStream = new FileOutputStream(targetLocalFile);
                outboundPayload.writeTo((OutputStream)targetStream);
                targetStream.flush();
            }
        }
        catch (Exception e) {
            DeployCommand.handleRetrieveException(e, context, reportErrorsInTopReport);
        }
        finally {
            if (targetStream != null) {
                try {
                    targetStream.close();
                }
                catch (IOException ex) {
                    DeployCommand.handleRetrieveException(ex, context, reportErrorsInTopReport);
                }
            }
        }
    }

    private static void handleRetrieveException(Exception e, AdminCommandContext context, boolean reportErrorsInTopReport) {
        String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
        Logger logger = context.getLogger();
        logger.log(Level.SEVERE, errorMsg, e);
        ActionReport report = context.getActionReport();
        if (!reportErrorsInTopReport) {
            report = report.addSubActionsReport();
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        } else {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        report.setMessage(errorMsg);
        report.setFailureCause((Throwable)e);
    }

    private void settingsFromDomainXML(Application app) {
        if (this.name != null) {
            String compatProp;
            if (this.contextroot == null && app.getContextRoot() != null) {
                this.previousContextRoot = app.getContextRoot();
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            this.previousTargets = this.domain.getAllReferencedTargetsForApplication(this.name);
            if (this.virtualservers == null) {
                if (DeploymentUtils.isDomainTarget((String)this.target)) {
                    for (String tgt : this.previousTargets) {
                        String vs = this.domain.getVirtualServersForApplication(tgt, this.name);
                        if (vs == null) continue;
                        this.previousVirtualServers.put(tgt, vs);
                    }
                } else {
                    this.virtualservers = this.domain.getVirtualServersForApplication(this.target, this.name);
                }
            }
            if (this.enabled == null) {
                if (DeploymentUtils.isDomainTarget((String)this.target)) {
                    for (String tgt : this.previousTargets) {
                        this.previousEnabledAttributes.put(tgt, this.domain.getEnabledForApplication(tgt, this.name));
                    }
                    this.previousEnabledAttributes.put("domain", app.getEnabled());
                    this.enabled = this.deployment.isAppEnabled(app);
                } else {
                    this.enabled = Boolean.valueOf(this.domain.getEnabledForApplication(this.target, this.name));
                }
            }
            if ((compatProp = app.getDeployProperties().getProperty("compatibility")) != null) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                if (this.properties.getProperty("compatibility") == null) {
                    this.properties.setProperty("compatibility", compatProp);
                }
            }
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION)) {
            DeploymentContext context = (DeploymentContext)event.hook();
            if (this.verify.booleanValue()) {
                Verifier verifier = (Verifier)this.habitat.getService(Verifier.class, new Annotation[0]);
                if (verifier != null) {
                    verifier.verify(context);
                } else {
                    context.getLogger().warning("Verifier is not installed yet. Install verifier module.");
                }
            }
        }
    }

    private void validateDeploymentProperties(Properties properties, DeploymentContext context) {
        String compatProp = properties.getProperty("compatibility");
        if (compatProp != null && !compatProp.equals("v2")) {
            String warningMsg = localStrings.getLocalString("compat.value.not.supported", "{0} is not a supported value for compatibility property.", new Object[]{compatProp});
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            subReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            subReport.setMessage(warningMsg);
            context.getLogger().log(Level.WARNING, warningMsg);
        }
    }

    private /* synthetic */ void lambda$execute$1(ApplicationState s) {
        s.storeMetaData(this.deploymentContext);
    }

    @Contract
    public static interface Interceptor {
        public void intercept(DeployCommand var1, DeploymentContext var2);
    }
}

