/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.concurrent.MPSCQueue;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobClassLoaderService;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.exception.JobTerminateRequestedException;
import com.hazelcast.jet.impl.exception.TerminatedWithSnapshotException;
import com.hazelcast.jet.impl.execution.ExecutionCancellationException;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.SnapshotContext;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.operation.SnapshotPhase1Operation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecutionContext
implements DynamicMetricsProvider {
    private static final Function<? super SenderReceiverKey, ? extends Queue<byte[]>> CREATE_RECEIVER_QUEUE_FN = key -> new MPSCQueue(null);
    private final long jobId;
    private final long executionId;
    private final boolean isLightJob;
    private volatile Address coordinator;
    private volatile Set<Address> participants;
    private final long createdOn = System.nanoTime();
    private final Object executionLock = new Object();
    private final ILogger logger;
    private final Counter startTime = MwCounter.newMwCounter(-1L);
    private final Counter completionTime = MwCounter.newMwCounter(-1L);
    private final ConcurrentHashMap<String, File> tempDirectories = new ConcurrentHashMap();
    private String jobName;
    private volatile Map<SenderReceiverKey, ReceiverTasklet> receiverMap;
    private volatile Map<SenderReceiverKey, SenderTasklet> senderMap;
    private final Map<SenderReceiverKey, Queue<byte[]>> receiverQueuesMap;
    private List<VertexDef> vertices = Collections.emptyList();
    private List<Tasklet> tasklets = Collections.emptyList();
    private volatile CompletableFuture<Void> executionFuture;
    private final CompletableFuture<Void> cancellationFuture = new CompletableFuture();
    private final NodeEngineImpl nodeEngine;
    private final JetServiceBackend jetServiceBackend;
    private volatile SnapshotContext snapshotContext;
    private JobConfig jobConfig;
    private boolean metricsEnabled;
    private volatile RawJobMetrics jobMetrics = RawJobMetrics.empty();
    private InternalSerializationService serializationService;
    private final AtomicBoolean executionCompleted = new AtomicBoolean();

    public ExecutionContext(NodeEngineImpl nodeEngine, long jobId, long executionId, boolean isLightJob) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.isLightJob = isLightJob;
        this.nodeEngine = nodeEngine;
        this.jetServiceBackend = (JetServiceBackend)nodeEngine.getService("hz:impl:jetService");
        this.jobName = Util.idToString(jobId);
        this.logger = nodeEngine.getLogger(this.getClass());
        this.receiverQueuesMap = isLightJob ? new ConcurrentHashMap() : new HashMap();
    }

    public CompletableFuture<Void> initialize(@Nonnull Address coordinator, @Nonnull Set<Address> participants, @Nonnull ExecutionPlan plan) {
        this.coordinator = coordinator;
        this.participants = participants;
        this.jobConfig = plan.getJobConfig();
        this.jobName = this.jobConfig.getName() == null ? this.jobName : this.jobConfig.getName();
        this.vertices = plan.getVertices();
        this.snapshotContext = new SnapshotContext(this.nodeEngine.getLogger(SnapshotContext.class), this.jobNameAndExecutionId(), plan.lastSnapshotId(), this.jobConfig.getProcessingGuarantee());
        JetServiceBackend jetServiceBackend = (JetServiceBackend)this.nodeEngine.getService("hz:impl:jetService");
        this.serializationService = jetServiceBackend.createSerializationService(this.jobConfig.getSerializerConfigs());
        this.metricsEnabled = this.jobConfig.isMetricsEnabled() && this.nodeEngine.getConfig().getMetricsConfig().isEnabled();
        return plan.initialize(this.nodeEngine, this.jobId, this.executionId, this.snapshotContext, this.tempDirectories, this.serializationService).thenAccept(ignored -> this.initWithPlan(plan));
    }

    private void initWithPlan(@Nonnull ExecutionPlan plan) {
        int numPrioritySsTasklets = plan.getStoreSnapshotTaskletCount() != 0 ? plan.getHigherPriorityVertexCount() : 0;
        this.snapshotContext.initTaskletCount(plan.getProcessorTaskletCount(), plan.getStoreSnapshotTaskletCount(), numPrioritySsTasklets);
        HashMap<SenderReceiverKey, ReceiverTasklet> receiverMapTmp = new HashMap<SenderReceiverKey, ReceiverTasklet>();
        for (Map.Entry<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> vertexIdEntry : plan.getReceiverMap().entrySet()) {
            for (Map.Entry<Integer, Map<Address, ReceiverTasklet>> ordinalEntry : vertexIdEntry.getValue().entrySet()) {
                for (Map.Entry<Address, ReceiverTasklet> addressEntry : ordinalEntry.getValue().entrySet()) {
                    SenderReceiverKey key = new SenderReceiverKey(vertexIdEntry.getKey(), ordinalEntry.getKey(), addressEntry.getKey());
                    Queue<byte[]> queue = this.receiverQueuesMap.computeIfAbsent(key, CREATE_RECEIVER_QUEUE_FN);
                    ReceiverTasklet receiverTasklet = addressEntry.getValue();
                    receiverTasklet.initIncomingQueue(queue);
                    receiverMapTmp.put(new SenderReceiverKey(vertexIdEntry.getKey(), ordinalEntry.getKey(), addressEntry.getKey()), receiverTasklet);
                }
            }
        }
        this.receiverMap = Collections.unmodifiableMap(receiverMapTmp);
        HashMap<SenderReceiverKey, SenderTasklet> senderMapTmp = new HashMap<SenderReceiverKey, SenderTasklet>();
        for (Map.Entry<Integer, Map<Integer, Map<Address, SenderTasklet>>> e1 : plan.getSenderMap().entrySet()) {
            for (Map.Entry<Integer, Map<Address, SenderTasklet>> e2 : e1.getValue().entrySet()) {
                for (Map.Entry<Address, SenderTasklet> e3 : e2.getValue().entrySet()) {
                    senderMapTmp.put(new SenderReceiverKey(e1.getKey(), e2.getKey(), e3.getKey()), e3.getValue());
                }
            }
        }
        this.senderMap = Collections.unmodifiableMap(senderMapTmp);
        this.tasklets = plan.getTasklets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> beginExecution(TaskletExecutionService taskletExecService) {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.executionFuture != null) {
                LoggingUtil.logFine(this.logger, "%s: execution started after cancelled", this.jobNameAndExecutionId());
                return this.executionFuture;
            }
            ClassLoader cl = this.jetServiceBackend.getJobClassLoaderService().getClassLoader(this.jobId);
            if (cl == null) {
                cl = this.nodeEngine.getConfigClassLoader();
            }
            this.startTime.set(System.currentTimeMillis());
            this.executionFuture = ((CompletableFuture)taskletExecService.beginExecute(this.tasklets, this.cancellationFuture, cl).whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.logger, (r, t) -> this.setCompletionTime()))).thenApply(res -> {
                if (this.snapshotContext.isTerminalSnapshot()) {
                    throw new TerminatedWithSnapshotException();
                }
                return res;
            });
            return this.executionFuture;
        }
    }

    public CompletableFuture<Void> completeExecution(Throwable error) {
        assert (this.executionFuture == null || this.executionFuture.isDone()) : "If execution was begun, then completeExecution() should not be called before execution is done.";
        if (!this.executionCompleted.compareAndSet(false, true)) {
            return CompletableFuture.completedFuture(null);
        }
        for (Tasklet tasklet : this.tasklets) {
            try {
                tasklet.close();
            }
            catch (Throwable e2) {
                this.logger.severe(this.jobNameAndExecutionId() + " encountered an exception in Processor.close(), ignoring it", e2);
            }
        }
        JobClassLoaderService jobClassloaderService = this.jetServiceBackend.getJobClassLoaderService();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(this.vertices.size());
        ManagedExecutorService offloadExecutor = this.nodeEngine.getExecutionService().getExecutor("hz:jet-job-offloadable");
        for (VertexDef vertex : this.vertices) {
            ProcessorSupplier processorSupplier = vertex.processorSupplier();
            RunnableEx closeAction = () -> {
                try {
                    ClassLoader processorCl = this.isLightJob ? null : jobClassloaderService.getProcessorClassLoader(this.jobId, vertex.name());
                    com.hazelcast.jet.impl.util.Util.doWithClassLoader(processorCl, () -> processorSupplier.close(error));
                }
                catch (Throwable e) {
                    this.logger.severe(this.jobNameAndExecutionId() + " encountered an exception in ProcessorSupplier.close(), ignoring it", e);
                }
            };
            Executor executor = processorSupplier.closeIsCooperative() ? ConcurrencyUtil.CALLER_RUNS : offloadExecutor;
            futures.add(CompletableFuture.runAsync(closeAction, executor));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.logger, (ignored, e) -> {
            this.tempDirectories.forEach((k, dir) -> {
                try {
                    IOUtil.delete(dir);
                }
                catch (Exception ex) {
                    this.logger.warning("Failed to delete temporary directory " + dir);
                }
            });
            if (this.serializationService != null) {
                this.serializationService.dispose();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean terminateExecution(@Nullable TerminationMode mode, Throwable cause) {
        assert (mode == null || !mode.isWithTerminalSnapshot()) : "terminating with a mode that should do a terminal snapshot";
        Object object = this.executionLock;
        synchronized (object) {
            if (mode == null) {
                this.cancellationFuture.completeExceptionally(new ExecutionCancellationException(cause));
            } else {
                this.cancellationFuture.completeExceptionally(new JobTerminateRequestedException(mode));
            }
            if (this.executionFuture == null) {
                this.executionFuture = this.cancellationFuture;
                return false;
            }
            this.snapshotContext.cancel();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SnapshotPhase1Operation.SnapshotPhase1Result> beginSnapshotPhase1(long snapshotId, String mapName, int flags) {
        LoggingUtil.logFine(this.logger, "Starting snapshot %d phase 1 for %s on member", snapshotId, this.jobNameAndExecutionId());
        Object object = this.executionLock;
        synchronized (object) {
            if (this.cancellationFuture.isDone()) {
                throw new CancellationException();
            }
            if (this.executionFuture != null && this.executionFuture.isDone()) {
                LoggingUtil.logFine(this.logger, "Ignoring snapshot %d phase 1 for %s: execution completed", snapshotId, this.jobNameAndExecutionId());
                return CompletableFuture.completedFuture(new SnapshotPhase1Operation.SnapshotPhase1Result(0L, 0L, 0L, null));
            }
            return this.snapshotContext.startNewSnapshotPhase1(snapshotId, mapName, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> beginSnapshotPhase2(long snapshotId, boolean success) {
        LoggingUtil.logFine(this.logger, "Starting snapshot %d phase 2 for %s on member", snapshotId, this.jobNameAndExecutionId());
        Object object = this.executionLock;
        synchronized (object) {
            if (this.cancellationFuture.isDone()) {
                throw new CancellationException();
            }
            if (this.executionFuture != null && this.executionFuture.isDone()) {
                LoggingUtil.logFine(this.logger, "Ignoring snapshot %d phase 2 for %s: execution completed", snapshotId, this.jobNameAndExecutionId());
                return CompletableFuture.completedFuture(null);
            }
            return this.snapshotContext.startNewSnapshotPhase2(snapshotId, success);
        }
    }

    public void handlePacket(int vertexId, int ordinal, Address sender, byte[] payload) {
        this.receiverQueuesMap.computeIfAbsent(new SenderReceiverKey(vertexId, ordinal, sender), CREATE_RECEIVER_QUEUE_FN).add(payload);
    }

    public boolean hasParticipant(Address member) {
        return this.participants != null && this.participants.contains(member);
    }

    public long jobId() {
        return this.jobId;
    }

    public long executionId() {
        return this.executionId;
    }

    public String jobNameAndExecutionId() {
        return com.hazelcast.jet.impl.util.Util.jobNameAndExecutionId(this.jobName, this.executionId);
    }

    public boolean isLightJob() {
        return this.isLightJob;
    }

    public Address coordinator() {
        return this.coordinator;
    }

    public Map<SenderReceiverKey, SenderTasklet> senderMap() {
        return this.senderMap;
    }

    public Map<SenderReceiverKey, ReceiverTasklet> receiverMap() {
        return this.receiverMap;
    }

    @Nullable
    public String jobName() {
        return this.jobName;
    }

    public RawJobMetrics getJobMetrics() {
        return this.jobMetrics;
    }

    public void setJobMetrics(RawJobMetrics jobMetrics) {
        this.jobMetrics = jobMetrics;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        if (!this.metricsEnabled) {
            return;
        }
        descriptor = descriptor.withTag("job", Util.idToString(this.jobId)).withTag("jobName", this.jobName).withTag("exec", Util.idToString(this.executionId));
        context.collect(descriptor, "executionStartTime", ProbeLevel.INFO, ProbeUnit.MS, this.startTime.get());
        context.collect(descriptor, "executionCompletionTime", ProbeLevel.INFO, ProbeUnit.MS, this.completionTime.get());
        for (Tasklet tasklet : this.tasklets) {
            tasklet.provideDynamicMetrics(descriptor.copy(), context);
        }
    }

    public void setCompletionTime() {
        this.completionTime.set(System.currentTimeMillis());
    }

    public CompletableFuture<Void> getExecutionFuture() {
        return this.executionFuture;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public static final class SenderReceiverKey {
        public final int vertexId;
        public final int ordinal;
        public final Address address;

        public SenderReceiverKey(int vertexId, int ordinal, @Nonnull Address address) {
            this.vertexId = vertexId;
            this.ordinal = ordinal;
            this.address = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SenderReceiverKey that = (SenderReceiverKey)o;
            return this.vertexId == that.vertexId && this.ordinal == that.ordinal && this.address.equals(that.address);
        }

        public int hashCode() {
            return Objects.hash(this.vertexId, this.ordinal, this.address);
        }
    }
}

