/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import jakarta.ejb.EJBException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class CallbackInterceptor {
    protected int index;
    protected Method method;

    CallbackInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            Method finalM = method;
            if (System.getSecurityManager() == null) {
                if (!finalM.isAccessible()) {
                    finalM.setAccessible(true);
                }
            } else {
                PrivilegedExceptionAction<Void> action = () -> {
                    if (!finalM.isAccessible()) {
                        finalM.setAccessible(true);
                    }
                    return null;
                };
                AccessController.doPrivileged(action);
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(CallbackInvocationContext invContext) throws Throwable {
        try {
            Object[] interceptors = invContext.getInterceptorInstances();
            if (System.getSecurityManager() != null) {
                PrivilegedExceptionAction<Object> action = () -> this.method.invoke(interceptors[this.index], invContext);
                return AccessController.doPrivileged(action);
            }
            return this.method.invoke(interceptors[this.index], invContext);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    boolean isBeanCallback() {
        return false;
    }

    public String toString() {
        return "callback[" + this.index + "]: " + this.method;
    }
}

