/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment;

import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.ScheduledTimerDescriptor;

public final class BeanMethodCalculatorImpl {
    private static final Logger _logger = LogDomains.getLogger(BeanMethodCalculatorImpl.class, (String)"javax.enterprise.system.tools.deployment");
    private static final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private static final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private static Map<Class<?>, String[]> disallowedMethodsPerInterface;

    private BeanMethodCalculatorImpl() {
        throw new UnsupportedOperationException("util");
    }

    public static Vector<FieldDescriptor> getPossibleCmpCmrFields(ClassLoader cl, String className) throws ClassNotFoundException {
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        Method[] methods = theClass.getMethods();
        for (int mIndex = 0; mIndex < methods.length; ++mIndex) {
            Method next = methods[mIndex];
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (!Modifier.isAbstract(nextModifiers) || !nextName.startsWith("get") || nextName.length() <= 3) continue;
            String field = nextName.substring(3, 4).toLowerCase(Locale.US) + nextName.substring(4);
            fieldDescriptors.add(new FieldDescriptor(field));
        }
        return fieldDescriptors;
    }

    public static Vector<Method> getMethodsFor(com.sun.enterprise.deployment.EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector<Method> methods = new Vector<Method>();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getRemoteBusinessClassNames()) {
                BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getLocalBusinessClassNames()) {
                BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalBean()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getEjbClassName()));
        }
        if (ejbDescriptor.hasWebServiceEndpointInterface()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName()));
        }
        return methods;
    }

    private static void addAllInterfaceMethodsIn(Collection<Method> methods, Class<?> c) {
        methods.addAll(Arrays.asList(c.getMethods()));
    }

    public static Collection<MethodDescriptor> getTransactionalMethodsFor(com.sun.enterprise.deployment.EjbDescriptor desc, ClassLoader loader) throws ClassNotFoundException {
        Collection<Method> potentials;
        EjbDescriptor ejbDescriptor = (EjbDescriptor)desc;
        boolean statefulSessionBean = false;
        Vector<MethodDescriptor> methods = new Vector<MethodDescriptor>();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Method next;
            int n;
            int n2;
            Method[] methodArray;
            Method[] busIntfMethods;
            Class<?> businessIntf;
            Object disallowedMethods;
            statefulSessionBean = ((EjbSessionDescriptor)ejbDescriptor).isStateful();
            boolean singletonSessionBean = ((EjbSessionDescriptor)ejbDescriptor).isSingleton();
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                disallowedMethods = BeanMethodCalculatorImpl.extractDisallowedMethodsFor(EJBObject.class, sessionBeanMethodsDisallowed);
                potentials = BeanMethodCalculatorImpl.getTransactionMethodsFor(loader, ejbDescriptor.getRemoteClassName(), (Collection<Method>)disallowedMethods);
                BeanMethodCalculatorImpl.transformAndAdd(potentials, "Remote", methods);
            }
            if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getRemoteBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    methodArray = busIntfMethods = businessIntf.getMethods();
                    n2 = methodArray.length;
                    for (n = 0; n < n2; ++n) {
                        next = methodArray[n];
                        methods.add(new MethodDescriptor(next, "Remote"));
                    }
                }
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                disallowedMethods = BeanMethodCalculatorImpl.extractDisallowedMethodsFor(EJBLocalObject.class, sessionLocalBeanMethodsDisallowed);
                potentials = BeanMethodCalculatorImpl.getTransactionMethodsFor(loader, ejbDescriptor.getLocalClassName(), (Collection<Method>)disallowedMethods);
                BeanMethodCalculatorImpl.transformAndAdd(potentials, "Local", methods);
            }
            if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getLocalBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    methodArray = busIntfMethods = businessIntf.getMethods();
                    n2 = methodArray.length;
                    for (n = 0; n < n2; ++n) {
                        next = methodArray[n];
                        methods.add(new MethodDescriptor(next, "Local"));
                    }
                }
            }
            if (ejbDescriptor.isLocalBean()) {
                Method[] busIntfMethods2;
                String intfName = ejbDescriptor.getEjbClassName();
                Class<?> businessIntf2 = loader.loadClass(intfName);
                for (Method next2 : busIntfMethods2 = businessIntf2.getMethods()) {
                    methods.add(new MethodDescriptor(next2, "Local"));
                }
            }
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                Class<?> webServiceClass = loader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName());
                Method[] webMethods = webServiceClass.getMethods();
                for (int i = 0; i < webMethods.length; ++i) {
                    methods.add(new MethodDescriptor((Method)webMethods[i], "ServiceEndpoint"));
                }
            }
            if (statefulSessionBean || singletonSessionBean) {
                Set<LifecycleCallbackDescriptor> lcds = ejbDescriptor.getLifecycleCallbackDescriptors();
                for (LifecycleCallbackDescriptor lcd : lcds) {
                    try {
                        Method m = lcd.getLifecycleCallbackMethodObject(loader);
                        MethodDescriptor md = new MethodDescriptor(m, "LifecycleCallback");
                        methods.add(md);
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, "Lifecycle callback processing error", e);
                    }
                }
            }
        } else {
            String localHomeIntf;
            String homeIntf = ejbDescriptor.getHomeClassName();
            if (homeIntf != null) {
                Class<?> home = loader.loadClass(homeIntf);
                potentials = BeanMethodCalculatorImpl.getTransactionMethodsFor(EJBHome.class, home);
                BeanMethodCalculatorImpl.transformAndAdd(potentials, "Home", methods);
                String remoteIntf = ejbDescriptor.getRemoteClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = BeanMethodCalculatorImpl.getTransactionMethodsFor(EJBObject.class, remote);
                BeanMethodCalculatorImpl.transformAndAdd(potentials, "Remote", methods);
            }
            if ((localHomeIntf = ejbDescriptor.getLocalHomeClassName()) != null) {
                Class<?> home = loader.loadClass(localHomeIntf);
                Collection<Method> potentials2 = BeanMethodCalculatorImpl.getTransactionMethodsFor(EJBLocalHome.class, home);
                BeanMethodCalculatorImpl.transformAndAdd(potentials2, "LocalHome", methods);
                String remoteIntf = ejbDescriptor.getLocalClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials2 = BeanMethodCalculatorImpl.getTransactionMethodsFor(EJBLocalObject.class, remote);
                BeanMethodCalculatorImpl.transformAndAdd(potentials2, "Local", methods);
            }
        }
        if (!statefulSessionBean && ejbDescriptor.isTimedObject()) {
            if (ejbDescriptor.getEjbTimeoutMethod() != null) {
                methods.add(ejbDescriptor.getEjbTimeoutMethod());
            }
            for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
                methods.add(schd.getTimeoutMethod());
            }
        }
        return methods;
    }

    private static Collection<Method> getTransactionMethodsFor(ClassLoader loader, String interfaceName, Collection<Method> disallowedMethods) throws ClassNotFoundException {
        Class<?> clazz = loader.loadClass(interfaceName);
        return BeanMethodCalculatorImpl.getTransactionMethodsFor(clazz, disallowedMethods);
    }

    private static Collection<Method> getTransactionMethodsFor(Class<?> interfaceImpl, Collection<Method> disallowedMethods) {
        Vector<Method> v = new Vector<Method>(Arrays.asList(interfaceImpl.getMethods()));
        v.removeAll(disallowedMethods);
        return v;
    }

    private static Collection<Method> getTransactionMethodsFor(Class<?> interfaceType, Class<?> interfaceImpl) {
        Collection<Method> disallowedTransactionMethods = BeanMethodCalculatorImpl.getDisallowedTransactionMethodsFor(interfaceType);
        return BeanMethodCalculatorImpl.getTransactionMethodsFor(interfaceImpl, disallowedTransactionMethods);
    }

    private static Collection<Method> getDisallowedTransactionMethodsFor(Class<?> interfaceType) {
        return BeanMethodCalculatorImpl.extractDisallowedMethodsFor(interfaceType, BeanMethodCalculatorImpl.getDisallowedMethodsNamesFor(interfaceType));
    }

    private static Collection<Method> extractDisallowedMethodsFor(Class<?> interfaceType, String[] methodNames) {
        Vector<Method> v = new Vector<Method>();
        if (methodNames.length == 0) {
            return v;
        }
        Method[] methods = interfaceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methodNames[0].equals("*")) {
                v.addElement(methods[i]);
                continue;
            }
            if (Arrays.binarySearch(methodNames, methods[i].getName()) < 0) continue;
            v.addElement(methods[i]);
        }
        return v;
    }

    private static void transformAndAdd(Collection<Method> methods, String methodIntf, Vector<MethodDescriptor> globalList) {
        for (Method m : methods) {
            globalList.add(new MethodDescriptor(m, methodIntf));
        }
    }

    private static String[] getDisallowedMethodsNamesFor(Class<?> interfaceType) {
        return BeanMethodCalculatorImpl.getDisallowedMethodsNames().get(interfaceType);
    }

    private static Map<Class<?>, String[]> getDisallowedMethodsNames() {
        if (disallowedMethodsPerInterface == null) {
            disallowedMethodsPerInterface = new Hashtable();
            disallowedMethodsPerInterface.put(EJBHome.class, new String[]{"getEJBMetaData", "getHomeHandle"});
            disallowedMethodsPerInterface.put(EJBObject.class, new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"});
            disallowedMethodsPerInterface.put(EJBLocalHome.class, new String[0]);
            disallowedMethodsPerInterface.put(EJBLocalObject.class, new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"});
        }
        return disallowedMethodsPerInterface;
    }
}

