/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.folb.InitialGroupInfoService;
import com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject;
import com.sun.corba.ee.impl.orb.ORBImpl;
import com.sun.corba.ee.impl.orb.ORBSingleton;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.osgi.ORBFactory;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.GlassFishORBLifeCycleListener;
import org.glassfish.enterprise.iiop.impl.CSIv2SSLTaggedComponentHandlerImpl;
import org.glassfish.enterprise.iiop.impl.GlassFishORBInitializer;
import org.glassfish.enterprise.iiop.impl.IIOPSSLSocketFactory;
import org.glassfish.enterprise.iiop.impl.IiopFolbGmsClient;
import org.glassfish.enterprise.iiop.impl.PEORBConfigurator;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.glassfish.orb.admin.config.Orb;
import org.jvnet.hk2.config.types.Property;
import org.omg.CORBA.ORBPackage.InvalidName;

public final class GlassFishORBManager {
    static final Logger logger = LogDomains.getLogger(GlassFishORBManager.class, (String)"javax.enterprise.resource.corba", (boolean)false);
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String ORB_CLASS = ORBImpl.class.getName();
    private static final String ORB_SINGLETON_CLASS = ORBSingleton.class.getName();
    private static final String ORB_EE_CLASS = "com.sun.corba.ee.impl.orb.ORBImpl";
    private static final String ORB_EE_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String PEORB_CONFIG_CLASS = PEORBConfigurator.class.getName();
    private static final String IIOP_SSL_SOCKET_FACTORY_CLASS = IIOPSSLSocketFactory.class.getName();
    private static final String RMI_UTIL_CLASS = Util.class.getName();
    private static final String RMI_STUB_CLASS = StubDelegateImpl.class.getName();
    private static final String RMI_PRO_CLASS = PortableRemoteObject.class.getName();
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBSocketFactoryClass";
    private static final String DEFAULT_SERVER_ID = "100";
    private static final String ACC_DEFAULT_SERVER_ID = "101";
    private static final String USER_DEFINED_ORB_SERVER_ID_PROPERTY = "org.glassfish.orb.iiop.orbserverid";
    private static final String DEFAULT_MAX_CONNECTIONS = "1024";
    private static final String GLASSFISH_INITIALIZER = GlassFishORBInitializer.class.getName();
    private static final String SUN_GIOP_DEFAULT_FRAGMENT_SIZE = "1024";
    private static final String SUN_GIOP_DEFAULT_BUFFER_SIZE = "1024";
    public static final String DEFAULT_ORB_INIT_HOST = "localhost";
    public static final String DEFAULT_ORB_INIT_PORT = "3700";
    private static final String ORB_SSL_STANDALONE_CLIENT_REQUIRED = "com.sun.CSIV2.ssl.standalone.client.required";
    public static final String S1AS_ORB_ID = "S1AS-ORB";
    private static final String DISABLE_SSL_CHECK = "fish.payara.orb.disable-ssl-check";
    private ServiceLocator services;
    private IIOPUtils iiopUtils;
    private ORB orb = null;
    private ReferenceFactoryManager rfm = null;
    private int orbInitialPort = -1;
    private List<IiopListener> iiopListeners = null;
    private Orb orbBean = null;
    private IiopService iiopService = null;
    private Properties csiv2Props = new Properties();
    private ProcessEnvironment.ProcessType processType;
    private IiopFolbGmsClient gmsClient;
    private static boolean disableSSLCheck;
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    private static final String IIOP_URL = "iiop:1.2@";

    private static void fineLog(String fmt, Object ... args) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, fmt, args);
        }
    }

    private static void finestLog(String fmt, Object ... args) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, fmt, args);
        }
    }

    GlassFishORBManager(ServiceLocator h) {
        GlassFishORBManager.fineLog("GlassFishORBManager: Constructing GlassFishORBManager: h {0}", h);
        this.services = h;
        this.iiopUtils = (IIOPUtils)this.services.getService(IIOPUtils.class, new Annotation[0]);
        ProcessEnvironment processEnv = (ProcessEnvironment)this.services.getService(ProcessEnvironment.class, new Annotation[0]);
        this.processType = processEnv.getProcessType();
        this.initProperties();
    }

    public boolean isEjbAdapterName(String[] adapterName) {
        boolean result = false;
        if (this.rfm != null) {
            result = this.rfm.isRfmName(adapterName);
        }
        return result;
    }

    public boolean isClusterActive() {
        return this.gmsClient != null && this.gmsClient.isGMSAvailable();
    }

    boolean isIsACall(String operationName) {
        return operationName.equals("_is_a");
    }

    synchronized ORB getORB(Properties props) {
        ORB oRB;
        try {
            GlassFishORBManager.finestLog("GlassFishORBManager.getORB->: {0}", this.orb);
            if (this.orb == null) {
                this.initORB(props);
            }
            oRB = this.orb;
        }
        catch (Throwable throwable) {
            GlassFishORBManager.finestLog("GlassFishORBManager.getORB<-: {0}", this.orb);
            throw throwable;
        }
        GlassFishORBManager.finestLog("GlassFishORBManager.getORB<-: {0}", this.orb);
        return oRB;
    }

    Properties getCSIv2Props() {
        return new Properties(this.csiv2Props);
    }

    void setCSIv2Prop(String name, String value) {
        this.csiv2Props.setProperty(name, value);
    }

    int getORBInitialPort() {
        return this.orbInitialPort;
    }

    public static boolean disableSSLCheck() {
        return disableSSLCheck;
    }

    private void initProperties() {
        String sslClientRequired;
        GlassFishORBManager.fineLog("GlassFishORBManager: initProperties: processType {0}", this.processType);
        if (this.processType != ProcessEnvironment.ProcessType.ACC && (sslClientRequired = System.getProperty(ORB_SSL_STANDALONE_CLIENT_REQUIRED)) != null && sslClientRequired.equals("true")) {
            this.csiv2Props.put("com.sun.CSIV2.ssl.client.required", "true");
        }
        disableSSLCheck = Boolean.getBoolean(DISABLE_SSL_CHECK);
        if (!this.processType.isServer()) {
            this.checkORBInitialPort(EMPTY_PROPERTIES);
        } else {
            this.iiopService = this.iiopUtils.getIiopService();
            this.iiopListeners = this.iiopService.getIiopListener();
            assert (this.iiopListeners != null);
            this.checkORBInitialPort(EMPTY_PROPERTIES);
            this.orbBean = this.iiopService.getOrb();
            assert (this.orbBean != null);
            this.csiv2Props.put("com.sun.CSIV2.client.auth.required", String.valueOf(this.iiopService.getClientAuthenticationRequired()));
            boolean corbaSSLRequired = true;
            for (IiopListener bean : this.iiopListeners) {
                if (bean.getSsl() != null) continue;
                corbaSSLRequired = false;
                break;
            }
            this.csiv2Props.put("com.sun.CSIV2.ssl.server.required", String.valueOf(corbaSSLRequired));
        }
    }

    private void setORBSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (System.getProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").contains("Sun Microsystems Inc.")) {
                        System.setProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY, GlassFishORBManager.ORB_EE_CLASS);
                    } else {
                        System.setProperty(GlassFishORBManager.OMG_ORB_CLASS_PROPERTY, ORB_CLASS);
                    }
                }
                if (System.getProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, GlassFishORBManager.ORB_EE_SINGLETON_CLASS);
                    } else {
                        System.setProperty(GlassFishORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, ORB_SINGLETON_CLASS);
                    }
                }
                System.setProperty(GlassFishORBManager.ORB_UTIL_CLASS_PROPERTY, RMI_UTIL_CLASS);
                System.setProperty(GlassFishORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, RMI_STUB_CLASS);
                System.setProperty(GlassFishORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, RMI_PRO_CLASS);
                return null;
            }
        });
    }

    private void setFOLBProperties(Properties orbInitProperties) {
        orbInitProperties.put("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.oa.rfm.ReferenceManagerConfigurator", "dummy");
        orbInitProperties.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, IIOP_SSL_SOCKET_FACTORY_CLASS);
        orbInitProperties.setProperty("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.folb.ClientGroupManager", "dummy");
        orbInitProperties.setProperty("com.sun.corba.ee.ORBUserConfigurators." + CSIv2SSLTaggedComponentHandlerImpl.class.getName(), "dummy");
        if (this.processType.isServer()) {
            this.gmsClient = new IiopFolbGmsClient(this.services);
            if (this.gmsClient.isGMSAvailable()) {
                GlassFishORBManager.fineLog("GMS available and enabled - doing EE initialization", new Object[0]);
                orbInitProperties.setProperty("com.sun.corba.ee.ORBUserConfigurators.com.sun.corba.ee.impl.folb.ServerGroupManager", "dummy");
                GlassFishORBManager.fineLog("Did EE property initialization", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initORB(Properties props) {
        try {
            HK2Module corbaOrbModule;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ".initORB->: ");
            }
            this.setORBSystemProperties();
            Properties orbInitProperties = new Properties();
            orbInitProperties.putAll((Map<?, ?>)props);
            orbInitProperties.put("com.sun.corba.ee.ORBAppServerMode", "true");
            orbInitProperties.put("com.sun.corba.ee.ORBUserConfigurators." + PEORB_CONFIG_CLASS, "dummy");
            this.setFOLBProperties(orbInitProperties);
            String orbDefaultServerId = DEFAULT_SERVER_ID;
            if (!this.processType.isServer()) {
                orbDefaultServerId = ACC_DEFAULT_SERVER_ID;
            }
            orbDefaultServerId = System.getProperty(USER_DEFINED_ORB_SERVER_ID_PROPERTY, orbDefaultServerId);
            orbInitProperties.put("org.omg.CORBA.ORBServerId", orbDefaultServerId);
            orbInitProperties.put(OMG_ORB_CLASS_PROPERTY, ORB_CLASS);
            orbInitProperties.put("org.omg.PortableInterceptor.ORBInitializerClass." + GLASSFISH_INITIALIZER, "");
            orbInitProperties.put("com.sun.corba.ee.ORBAllowLocalOptimization", "true");
            orbInitProperties.put("com.sun.corba.ee.ORBGetServiceContextReturnsNull", "true");
            orbInitProperties.put("org.omg.CORBA.ORBId", S1AS_ORB_ID);
            orbInitProperties.put("com.sun.corba.ee.ORBShowInfoMessages", "true");
            String initialPort = this.checkORBInitialPort(orbInitProperties);
            String orbInitialHost = this.checkORBInitialHost(orbInitProperties);
            String[] orbInitRefArgs = System.getProperty(IIOP_ENDPOINTS_PROPERTY) != null && !System.getProperty(IIOP_ENDPOINTS_PROPERTY).isEmpty() ? this.getORBInitRef(System.getProperty(IIOP_ENDPOINTS_PROPERTY)) : this.getORBInitRef(orbInitialHost, initialPort);
            if (this.processType.isServer()) {
                this.validateIiopListeners();
                orbInitProperties.put("com.sun.corba.ee.transport.ORBNoDefaultAcceptors", "true");
                this.checkORBServerHost(orbInitProperties);
            }
            this.checkConnectionSettings(orbInitProperties);
            this.checkMessageFragmentSize(orbInitProperties);
            this.checkServerSSLOutboundSettings(orbInitProperties);
            this.checkForOrbPropertyValues(orbInitProperties);
            Collection lcListeners = this.iiopUtils.getGlassFishORBLifeCycleListeners();
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.addAll(Arrays.asList(orbInitRefArgs));
            for (GlassFishORBLifeCycleListener listener : lcListeners) {
                listener.initializeORBInitProperties(argsList, orbInitProperties);
            }
            String[] args = argsList.toArray(new String[argsList.size()]);
            if (this.processType.isServer()) {
                PEORBConfigurator.setThreadPoolManager();
            }
            boolean useOSGI = false;
            ClassLoader prevCL = Utility.getClassLoader();
            try {
                Utility.setContextClassLoader((ClassLoader)GlassFishORBManager.class.getClassLoader());
                if (this.processType.isServer()) {
                    corbaOrbModule = null;
                    ModulesRegistry modulesRegistry = (ModulesRegistry)this.services.getService(ModulesRegistry.class, new Annotation[0]);
                    for (HK2Module m : modulesRegistry.getModules()) {
                        if (!m.getName().equals("org.glassfish.corba.glassfish-corba-orb")) continue;
                        corbaOrbModule = m;
                        break;
                    }
                    if (corbaOrbModule != null) {
                        useOSGI = true;
                        corbaOrbModule.start();
                    }
                }
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)prevCL);
            }
            System.setProperty("org.glassfish.gmbal.no.multipleUpperBoundsException", "true");
            this.orb = ORBFactory.create();
            prevCL = Utility.getClassLoader();
            try {
                if (this.processType != ProcessEnvironment.ProcessType.Other && !prevCL.getClass().getName().contains("OSGi")) {
                    Utility.setContextClassLoader((ClassLoader)prevCL.getParent());
                }
                ORBFactory.initialize((ORB)this.orb, (String[])args, (Properties)orbInitProperties, (boolean)useOSGI);
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)prevCL);
            }
            try {
                corbaOrbModule = this.orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName in) {
                logger.log(Level.SEVERE, "Problem resolving RootPOA ORB reference", in);
            }
            if (this.processType.isServer()) {
                this.gmsClient.setORB(this.orb);
                this.orbInitialPort = this.getORBInitialPort();
                for (GlassFishORBLifeCycleListener listener : lcListeners) {
                    listener.orbCreated((org.omg.CORBA.ORB)this.orb);
                }
                this.rfm = (ReferenceFactoryManager)this.orb.resolve_initial_references("ReferenceFactoryManager");
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                new InitialGroupInfoService((org.omg.CORBA.ORB)this.orb);
                Thread.currentThread().setContextClassLoader(cl);
                this.iiopUtils.setORB((org.omg.CORBA.ORB)this.orb);
            }
            this.orb.getFVDCodeBaseIOR();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "UTIL6009:Unexpected Exception in createORB.", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ".initORB<-: ");
            }
        }
    }

    private String checkForAddrAny(Properties props, String orbInitialHost) {
        if (orbInitialHost.equals("0.0.0.0") || orbInitialHost.equals("::") || orbInitialHost.equals("::ffff:0.0.0.0")) {
            try {
                String localAddress = InetAddress.getLocalHost().getHostAddress();
                return localAddress;
            }
            catch (UnknownHostException uhe) {
                logger.log(Level.WARNING, "Unknown host exception - Setting host to localhost");
                return DEFAULT_ORB_INIT_HOST;
            }
        }
        return orbInitialHost;
    }

    private IiopListener getClearTextIiopListener() {
        if (this.iiopListeners != null) {
            for (IiopListener il : this.iiopListeners) {
                if (il.getSsl() != null) continue;
                return il;
            }
        }
        return null;
    }

    private String checkORBInitialHost(Properties props) {
        IiopListener il;
        String initialHost = System.getProperty("org.omg.CORBA.ORBInitialHost");
        if (initialHost == null) {
            initialHost = props.getProperty("org.omg.CORBA.ORBInitialHost");
        }
        if (initialHost == null && (il = this.getClearTextIiopListener()) != null) {
            initialHost = il.getAddress();
        }
        if (initialHost == null) {
            initialHost = DEFAULT_ORB_INIT_HOST;
        }
        initialHost = this.checkForAddrAny(props, initialHost);
        props.setProperty("org.omg.CORBA.ORBInitialHost", initialHost);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting orb initial host to {0}", initialHost);
        }
        return initialHost;
    }

    private String checkORBInitialPort(Properties props) {
        IiopListener il;
        String initialPort = System.getProperty("org.omg.CORBA.ORBInitialPort");
        if (initialPort == null) {
            initialPort = props.getProperty("org.omg.CORBA.ORBInitialPort");
        }
        if (initialPort == null && (il = this.getClearTextIiopListener()) != null) {
            initialPort = il.getPort();
        }
        if (initialPort == null) {
            initialPort = DEFAULT_ORB_INIT_PORT;
        }
        props.setProperty("org.omg.CORBA.ORBInitialPort", initialPort);
        if (this.processType.isServer()) {
            props.setProperty("com.sun.corba.ee.POA.ORBPersistentServerPort", initialPort);
        }
        GlassFishORBManager.fineLog("Setting orb initial port to {0}", initialPort);
        this.orbInitialPort = Integer.parseInt(initialPort);
        return initialPort;
    }

    private String checkORBServerHost(Properties props) {
        IiopListener il;
        String serverHost = System.getProperty("com.sun.corba.ee.ORBServerHost");
        if (serverHost == null) {
            serverHost = props.getProperty("com.sun.corba.ee.ORBServerHost");
        }
        if (serverHost == null && (il = this.getClearTextIiopListener()) != null) {
            serverHost = il.getAddress();
        }
        if (serverHost != null) {
            props.setProperty("com.sun.corba.ee.ORBServerHost", serverHost);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Setting orb server host to {0}", serverHost);
            }
        }
        return serverHost;
    }

    private void validateIiopListeners() {
        if (this.iiopListeners != null) {
            int lazyCount = 0;
            for (IiopListener ilb : this.iiopListeners) {
                boolean securityEnabled = Boolean.valueOf(ilb.getSecurityEnabled());
                boolean isLazy = Boolean.valueOf(ilb.getLazyInit());
                if (isLazy) {
                    ++lazyCount;
                }
                if (lazyCount > 1) {
                    throw new IllegalStateException("Invalid iiop-listener " + ilb.getId() + ". Only one iiop-listener can be configured with lazy-init=true");
                }
                if (securityEnabled || ilb.getSsl() == null) continue;
                if (isLazy) {
                    throw new IllegalStateException("Invalid iiop-listener " + ilb.getId() + ". Lazy-init not supported for SSL iiop-listeners");
                }
                Ssl sslBean = ilb.getSsl();
                assert (sslBean != null);
            }
        }
    }

    private void checkConnectionSettings(Properties props) {
        if (this.orbBean != null) {
            String maxConnections;
            try {
                maxConnections = this.orbBean.getMaxConnections();
                Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException nfe) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "UTIL6031:Number Format Exception, Using default value(s).", nfe);
                }
                maxConnections = "1024";
            }
            props.setProperty("com.sun.corba.ee.connection.ORBHighWaterMark", maxConnections);
        }
    }

    private void checkMessageFragmentSize(Properties props) {
        if (this.orbBean != null) {
            String bufferSize;
            String fragmentSize;
            try {
                int fsize = Integer.parseInt(this.orbBean.getMessageFragmentSize().trim()) / 8 * 8;
                if (fsize < 32) {
                    fragmentSize = "32";
                    logger.log(Level.INFO, "Setting ORB Message Fragment size to {0}", fragmentSize);
                } else {
                    fragmentSize = String.valueOf(fsize);
                }
                bufferSize = fragmentSize;
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "UTIL6035: Exception converting to integer", nfe);
                logger.log(Level.INFO, "Setting ORB Message Fragment size to Default 1024");
                fragmentSize = "1024";
                bufferSize = "1024";
            }
            props.setProperty("com.sun.corba.ee.giop.ORBFragmentSize", fragmentSize);
            props.setProperty("com.sun.corba.ee.giop.ORBBufferSize", bufferSize);
        }
    }

    private void checkServerSSLOutboundSettings(Properties props) {
        SslClientConfig sslClientConfigBean;
        if (this.iiopService != null && (sslClientConfigBean = this.iiopService.getSslClientConfig()) != null) {
            Ssl ssl = sslClientConfigBean.getSsl();
            assert (ssl != null);
        }
    }

    private void checkForOrbPropertyValues(Properties props) {
        List orbBeanProps;
        if (this.orbBean != null && (orbBeanProps = this.orbBean.getProperty()) != null) {
            for (int i = 0; i < orbBeanProps.size(); ++i) {
                props.setProperty(((Property)orbBeanProps.get(i)).getName(), ((Property)orbBeanProps.get(i)).getValue());
            }
        }
    }

    private String[] getORBInitRef(String orbInitialHost, String initialPort) {
        String[] newArgs = new String[]{"-ORBInitRef", "NameService=corbaloc:iiop:1.2@" + orbInitialHost + ":" + initialPort + "/NameService"};
        return newArgs;
    }

    private String[] getORBInitRef(String endpoints) {
        Object[] list = endpoints.split(",");
        String corbalocURL = this.getCorbalocURL(list);
        logger.log(Level.FINE, "GlassFishORBManager.getORBInitRef = {0}", corbalocURL);
        String[] newArgs = new String[]{"-ORBInitRef", "NameService=corbaloc:" + corbalocURL + "/NameService"};
        return newArgs;
    }

    private String getCorbalocURL(Object[] list) {
        StringBuilder corbalocURL = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            logger.log(Level.INFO, "list[i] ==> {0}", list[i]);
            if (corbalocURL.length() == 0) {
                corbalocURL.append(IIOP_URL).append(((String)list[i]).trim());
                continue;
            }
            corbalocURL.append(",").append(IIOP_URL).append(((String)list[i]).trim());
        }
        String corbalocURLString = corbalocURL.toString();
        logger.info(() -> "corbaloc url ==> " + corbalocURLString);
        return corbalocURLString;
    }

    String getIIOPEndpoints() {
        return this.gmsClient.getIIOPEndpoints();
    }
}

