/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.Locale;
import org.apache.catalina.deploy.SecurityCollection;

public class SecurityConstraint
implements Serializable {
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(boolean authConstraint) {
        this.authConstraint = authConstraint;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public void setUserConstraint(String userConstraint) {
        if (userConstraint != null) {
            this.userConstraint = userConstraint;
        }
    }

    public void addAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        if ("*".equals(authRole)) {
            this.allRoles = true;
            return;
        }
        String[] results = new String[this.authRoles.length + 1];
        System.arraycopy(this.authRoles, 0, results, 0, this.authRoles.length);
        results[this.authRoles.length] = authRole;
        this.authRoles = results;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        SecurityCollection[] results = new SecurityCollection[this.collections.length + 1];
        System.arraycopy(this.collections, 0, results, 0, this.collections.length);
        results[this.collections.length] = collection;
        this.collections = results;
    }

    public boolean findAuthRole(String role) {
        if (role == null) {
            return false;
        }
        for (String authRole : this.authRoles) {
            if (!role.equals(authRole)) continue;
            return true;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String name) {
        if (name == null) {
            return null;
        }
        for (SecurityCollection collection : this.collections) {
            if (!name.equals(collection.getName())) continue;
            return collection;
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean included(String uri, String method, boolean caseSensitiveMapping) {
        if (method == null) {
            return false;
        }
        for (SecurityCollection collection : this.collections) {
            if (!collection.findMethod(method)) continue;
            String[] patterns = collection.findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                if (!this.matchPattern(uri, patterns[j], caseSensitiveMapping)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.authRoles.length; ++i) {
            if (!this.authRoles[i].equals(authRole)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.authRoles.length - 1];
            for (int i = 0; i < this.authRoles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.authRoles[i];
            }
            this.authRoles = results;
        }
    }

    public void removeCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.collections.length; ++i) {
            if (!this.collections[i].equals(collection)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            SecurityCollection[] results = new SecurityCollection[this.collections.length - 1];
            for (int i = 0; i < this.collections.length; ++i) {
                if (i == n) continue;
                results[j++] = this.collections[i];
            }
            this.collections = results;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SecurityConstraint: ");
        for (SecurityCollection collection : this.collections) {
            sb.append(" collection: ").append(collection);
        }
        for (String authRole : this.authRoles) {
            sb.append(" authRole: ").append(authRole);
        }
        sb.append(" userConstraint: ").append(this.userConstraint);
        return sb.toString();
    }

    private boolean matchPattern(String path, String pattern, boolean caseSensitiveMapping) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (!caseSensitiveMapping) {
            path = path.toLowerCase(Locale.ENGLISH);
            pattern = pattern.toLowerCase(Locale.ENGLISH);
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }
}

