/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cdi.transaction.TransactionScopedCDIEventHelper;
import org.glassfish.cdi.transaction.TransactionScopedCDIEventHelperImpl;
import org.glassfish.cdi.transaction.TransactionScopedCDIEventPayload;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class TransactionScopedCDIUtil {
    public static final String INITIALIZED_EVENT = "INITIALIZED_EVENT";
    public static final String DESTORYED_EVENT = "DESTORYED_EVENT";
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.cdi.LogMessages";
    @LoggerInfo(subsystem="AS-CDI-JTA", description="CDI-JTA", publish=true)
    public static final String CDI_JTA_LOGGER_SUBSYSTEM_NAME = "javax.enterprise.resource.jta";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    public static void log(String message) {
        _logger.log(Level.WARNING, message);
    }

    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Class<?> annotatedClass, Class<A> annotationType) {
        if (annotatedClass.isAnnotationPresent(annotationType)) {
            return Optional.of(annotatedClass.getAnnotation(annotationType));
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedClass.getAnnotations()));
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Method annotatedMethod, Class<A> annotationType) {
        if (annotatedMethod.isAnnotationPresent(annotationType)) {
            return Optional.of(annotatedMethod.getAnnotation(annotationType));
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedMethod.getAnnotations()));
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    public static Bean<?> createHelperBean(BeanManager beanManager, Class<? extends Object> beanClass) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(beanClass);
        BeanWrapper result = new BeanWrapper(beanClass);
        InjectionTargetFactory factory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = factory.createInjectionTarget((Bean)result);
        result.setInjectionTarget((InjectionTarget<Object>)injectionTarget);
        return result;
    }

    public static void fireEvent(String eventType) {
        BeanManager beanManager = null;
        try {
            beanManager = CDI.current().getBeanManager();
        }
        catch (Exception e) {
            TransactionScopedCDIUtil.log("Can't get instance of BeanManager to process TransactionScoped CDI Event!");
        }
        if (beanManager != null) {
            Set availableBeans = beanManager.getBeans(TransactionScopedCDIEventHelperImpl.class, new Annotation[0]);
            if (null != availableBeans && !availableBeans.isEmpty()) {
                Bean bean = beanManager.resolve(availableBeans);
                TransactionScopedCDIEventHelper eventHelper = (TransactionScopedCDIEventHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(null));
                if (eventType.equalsIgnoreCase(INITIALIZED_EVENT)) {
                    eventHelper.fireInitializedEvent(new TransactionScopedCDIEventPayload());
                } else {
                    eventHelper.fireDestroyedEvent(new TransactionScopedCDIEventPayload());
                }
            }
        } else {
            TransactionScopedCDIUtil.log("Can't get instance of BeanManager to process TransactionScoped CDI Event!");
        }
    }

    private static class BeanWrapper
    implements Bean<Object> {
        private Class<?> beanClass;
        private InjectionTarget<Object> injectionTarget = null;
        private final Optional<JavaEEContextUtil.Instance> ctxUtil;

        public BeanWrapper(Class<?> beanClass) {
            this.beanClass = beanClass;
            Optional<JavaEEContextUtil> ctxUtil = Optional.empty();
            try {
                ServiceLocator serviceLocator = Globals.getDefaultHabitat();
                if (serviceLocator == null) {
                    serviceLocator = Globals.getStaticHabitat();
                }
                if (serviceLocator != null) {
                    ctxUtil = Optional.ofNullable((JavaEEContextUtil)serviceLocator.getService(JavaEEContextUtil.class, new Annotation[0]));
                }
            }
            catch (MultiException e) {
                TransactionScopedCDIUtil.log(e.getMessage());
            }
            this.ctxUtil = ctxUtil.map(ctx -> ctx.getInvocationComponentId() != null ? ctx.currentInvocation() : ctx.empty());
        }

        private void setInjectionTarget(InjectionTarget<Object> injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionTarget.getInjectionPoints();
        }

        public String getName() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            qualifiers.add((Annotation)((Object)new DefaultAnnotationLiteral()));
            qualifiers.add((Annotation)((Object)new AnyAnnotationLiteral()));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(this.beanClass);
            types.add((Type)((Object)Object.class));
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public Object create(CreationalContext<Object> ctx) {
            try (JavaEEContextUtil.Context eeCtx = this.ctxUtil.isPresent() ? this.ctxUtil.get().pushContext() : null;){
                Object instance = this.injectionTarget.produce(ctx);
                this.injectionTarget.inject(instance, ctx);
                this.injectionTarget.postConstruct(instance);
                Object object = instance;
                return object;
            }
        }

        public void destroy(Object instance, CreationalContext<Object> ctx) {
            try (JavaEEContextUtil.Context eeCtx = this.ctxUtil.isPresent() ? this.ctxUtil.get().pushContext() : null;){
                this.injectionTarget.preDestroy(instance);
                this.injectionTarget.dispose(instance);
            }
            ctx.release();
        }

        public static class AnyAnnotationLiteral
        extends AnnotationLiteral<Any> {
            private static final long serialVersionUID = -4700109250603725375L;
        }

        public static class DefaultAnnotationLiteral
        extends AnnotationLiteral<Default> {
            private static final long serialVersionUID = -9065007202240742004L;
        }
    }
}

