/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.loader.WebappClassLoader;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

public class ACLSingletonProvider
extends SingletonProvider {
    public <T> ACLSingleton<T> create(Class<? extends T> expectedType) {
        return new ACLSingleton();
    }

    private static class ACLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new ConcurrentHashMap<ClassLoader, T>();
        private final Map<String, T> storeById = new ConcurrentHashMap<String, T>();
        private ClassLoader ccl = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getCommonClassLoader();
        private static ClassLoader bootstrapCL;

        private ACLSingleton() {
        }

        public T get(String id) {
            ClassLoader acl;
            T instance = this.storeById.get(id);
            if (instance == null && (instance = this.store.get(acl = this.getClassLoader())) == null) {
                throw new IllegalStateException("Singleton not set for " + acl);
            }
            return instance;
        }

        private ClassLoader getClassLoader() {
            ClassLoader tccl;
            SecurityManager sm = System.getSecurityManager();
            ClassLoader classLoader = tccl = sm != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }) : Thread.currentThread().getContextClassLoader();
            if (tccl == null) {
                throw new RuntimeException("Thread's context class loader is null");
            }
            ClassLoader cl = tccl;
            ClassLoader appClassLoader = tccl;
            while (cl != this.ccl && cl != bootstrapCL) {
                if (cl.getClass().getName().equals("org.glassfish.javaee.full.deployment.EarLibClassLoader")) {
                    return cl;
                }
                if (cl instanceof WebappClassLoader) {
                    appClassLoader = cl;
                }
                cl = this.getParent(cl);
            }
            return appClassLoader;
        }

        private ClassLoader getParent(final ClassLoader cl) {
            SecurityManager sm = System.getSecurityManager();
            return sm != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return cl.getParent();
                }
            }) : cl.getParent();
        }

        public boolean isSet(String id) {
            return this.store.containsKey(this.getClassLoader()) || this.storeById.containsKey(id);
        }

        public void set(String id, T object) {
            this.store.put(this.getClassLoader(), object);
            this.storeById.put(id, object);
        }

        public void clear(String id) {
            this.store.remove(this.getClassLoader());
            this.storeById.remove(id);
        }

        static {
            SecurityManager sm = System.getSecurityManager();
            bootstrapCL = sm != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Object.class.getClassLoader();
                }
            }) : Object.class.getClassLoader();
        }
    }
}

