/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.SkipIfPortableExtensionPresent;
import jakarta.enterprise.inject.spi.Extension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.common.util.ObjectInputStreamWithLoader;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.lite.extension.translator.LiteExtensionTranslator;

public class DeploymentImpl
implements CDI11Deployment,
Serializable {
    private static final long serialVersionUID = 1L;
    static final ThreadLocal<DeploymentImpl> currentDeployment = new ThreadLocal();
    static final ThreadLocal<Map<Integer, BeanDeploymentArchiveImpl>> currentBDAs = new ThreadLocal();
    static final ThreadLocal<DeploymentContext> currentDeploymentContext = new ThreadLocal();
    private final Set<RootBeanDeploymentArchive> rarRootBdas = new LinkedHashSet<RootBeanDeploymentArchive>();
    final Set<RootBeanDeploymentArchive> ejbRootBdas = new LinkedHashSet<RootBeanDeploymentArchive>();
    private final Set<RootBeanDeploymentArchive> warRootBdas = new LinkedHashSet<RootBeanDeploymentArchive>();
    private final Set<RootBeanDeploymentArchive> libJarRootBdas = new LinkedHashSet<RootBeanDeploymentArchive>();
    private final Set<BeanDeploymentArchive> beanDeploymentArchives = new LinkedHashSet<BeanDeploymentArchive>();
    final transient DeploymentContext context;
    final Map<String, BeanDeploymentArchive> idToBeanDeploymentArchive = new HashMap<String, BeanDeploymentArchive>();
    private transient SimpleServiceRegistry simpleServiceRegistry = null;
    private final transient Logger logger;
    private final Map<ClassLoader, BeanDeploymentArchive> extensionBDAMap = new HashMap<ClassLoader, BeanDeploymentArchive>();
    private final List<Metadata<Extension>> extensions = new ArrayList<Metadata<Extension>>();
    private final List<Metadata<Extension>> dynamicExtensions = new ArrayList<Metadata<Extension>>();
    private final transient Collection<EjbDescriptor> deployedEjbs;
    private final transient ArchiveFactory archiveFactory;
    private boolean earContextAppLibBdasProcessed = false;
    private String appName;
    private String contextId;
    final transient InjectionManager injectionManager;

    public DeploymentImpl(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, ArchiveFactory archiveFactory, String moduleName, InjectionManager injectionManager) {
        this.logger = CDILoggerInfo.getLogger();
        this.deployedEjbs = new LinkedList<EjbDescriptor>();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00018", new Object[]{archive.getName()});
        }
        this.archiveFactory = archiveFactory;
        this.context = context;
        this.injectionManager = injectionManager;
        this.libJarRootBdas.addAll(this.scanForLibJars(archive, ejbs, context));
        if (!this.libJarRootBdas.isEmpty()) {
            return;
        }
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        this.appName = holder != null && holder.app != null ? holder.app.getAppName() : (moduleName != null ? moduleName : "CDIApp");
        this.contextId = moduleName != null ? moduleName : archive.getName();
        this.createModuleBda(archive, ejbs, context, this.contextId);
    }

    DeploymentImpl(DeploymentImpl deployment) {
        this.rarRootBdas.addAll(deployment.rarRootBdas);
        this.ejbRootBdas.addAll(deployment.ejbRootBdas);
        this.warRootBdas.addAll(deployment.warRootBdas);
        this.libJarRootBdas.addAll(deployment.libJarRootBdas);
        this.beanDeploymentArchives.addAll(deployment.beanDeploymentArchives);
        this.appName = deployment.appName;
        this.contextId = deployment.contextId;
        this.earContextAppLibBdasProcessed = deployment.earContextAppLibBdasProcessed;
        this.context = currentDeploymentContext.get();
        this.archiveFactory = DeploymentImpl.currentDeployment.get().archiveFactory;
        this.getServices().addAll((Collection)currentDeployment.get().getServices().entrySet());
        this.injectionManager = DeploymentImpl.currentDeployment.get().injectionManager;
        this.logger = DeploymentImpl.currentDeployment.get().logger;
        this.deployedEjbs = DeploymentImpl.currentDeployment.get().deployedEjbs;
    }

    DeploymentImpl filter(RootBeanDeploymentArchive rootBDA, ApplicationInfo applicationInfo) {
        DeploymentImpl filteredDeployment;
        try {
            filteredDeployment = this.serializeAndDeserialize(this, applicationInfo.getAppClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        List<String> nonRooIDs = List.of(rootBDA.getId(), rootBDA.getModuleBda().getId());
        filteredDeployment.clearAndAddAll(filteredDeployment.warRootBdas, this.filterBDAs(filteredDeployment.warRootBdas, nonRooIDs, new Set[0]));
        filteredDeployment.clearAndAddAll(filteredDeployment.beanDeploymentArchives, this.filterBDAs(filteredDeployment.beanDeploymentArchives, nonRooIDs, filteredDeployment.rarRootBdas, filteredDeployment.ejbRootBdas, filteredDeployment.libJarRootBdas));
        filteredDeployment.contextId = rootBDA.getId() + ".bda";
        return filteredDeployment;
    }

    private <TT extends BeanDeploymentArchive> void clearAndAddAll(Set<TT> originalBdas, Set<TT> bdas) {
        originalBdas.clear();
        originalBdas.addAll(bdas);
    }

    Set<RootBeanDeploymentArchive> getRootBDAs() {
        if (!this.warRootBdas.isEmpty()) {
            return this.warRootBdas;
        }
        if (!this.ejbRootBdas.isEmpty()) {
            return this.ejbRootBdas;
        }
        if (!this.rarRootBdas.isEmpty()) {
            return this.rarRootBdas;
        }
        if (!this.libJarRootBdas.isEmpty()) {
            return this.libJarRootBdas;
        }
        return Collections.emptySet();
    }

    private <TT> TT serializeAndDeserialize(TT original, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);){
            outputStream.writeObject(original);
        }
        try (ObjectInputStreamWithLoader inputStream = new ObjectInputStreamWithLoader((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), classLoader);){
            Object object = inputStream.readObject();
            return (TT)object;
        }
    }

    Object readResolve() throws ObjectStreamException {
        return new DeploymentImpl(this);
    }

    @SafeVarargs
    private <TT extends BeanDeploymentArchive> Set<TT> filterBDAs(Set<TT> bdas, List<String> bda, Set<RootBeanDeploymentArchive> ... include) {
        if (bdas == null) {
            return null;
        }
        List includeRootList = Arrays.stream(include).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List includeList = includeRootList.stream().flatMap(list -> Stream.of(list, list.getModuleBda())).collect(Collectors.toList());
        return bdas.stream().filter(b -> bda.stream().anyMatch(b.getId()::startsWith) || includeList.contains(b)).collect(Collectors.toSet());
    }

    private void addBeanDeploymentArchives(RootBeanDeploymentArchive bda) {
        this.rootBDAs(bda).add(bda);
    }

    private Set<RootBeanDeploymentArchive> rootBDAs(RootBeanDeploymentArchive bda) {
        WeldUtils.BDAType moduleBDAType = bda.getModuleBDAType();
        if (moduleBDAType.equals((Object)WeldUtils.BDAType.WAR)) {
            return this.warRootBdas;
        }
        if (moduleBDAType.equals((Object)WeldUtils.BDAType.JAR)) {
            return this.ejbRootBdas;
        }
        if (moduleBDAType.equals((Object)WeldUtils.BDAType.RAR)) {
            return this.rarRootBdas;
        }
        throw new IllegalArgumentException("Unknown BDAType: " + moduleBDAType);
    }

    public void scanArchive(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, String moduleName) {
        if (this.libJarRootBdas.isEmpty()) {
            this.libJarRootBdas.addAll(this.scanForLibJars(archive, ejbs, context));
            if (!this.libJarRootBdas.isEmpty()) {
                return;
            }
        }
        this.createModuleBda(archive, ejbs, context, moduleName);
    }

    public void buildDeploymentGraph() {
        BeanDeploymentArchive rarModuleBda;
        BeanDeploymentArchive libJarModuleBda;
        for (RootBeanDeploymentArchive ejbRootBda : this.ejbRootBdas) {
            BeanDeploymentArchive ejbModuleBda = ejbRootBda.getModuleBda();
            boolean modifiedArchive = false;
            for (RootBeanDeploymentArchive otherEjbRootBda : this.ejbRootBdas) {
                BeanDeploymentArchive otherEjbModuleBda = otherEjbRootBda.getModuleBda();
                if (otherEjbModuleBda.getId().equals(ejbModuleBda.getId())) continue;
                ejbRootBda.getBeanDeploymentArchives().add(otherEjbRootBda);
                ejbRootBda.getBeanDeploymentArchives().add(otherEjbModuleBda);
                ejbModuleBda.getBeanDeploymentArchives().add(otherEjbModuleBda);
                modifiedArchive = true;
            }
            for (RootBeanDeploymentArchive libJarRootBda : this.libJarRootBdas) {
                libJarModuleBda = libJarRootBda.getModuleBda();
                ejbRootBda.getBeanDeploymentArchives().add(libJarRootBda);
                ejbRootBda.getBeanDeploymentArchives().add(libJarModuleBda);
                ejbModuleBda.getBeanDeploymentArchives().add(libJarRootBda);
                ejbModuleBda.getBeanDeploymentArchives().add(libJarModuleBda);
                modifiedArchive = true;
            }
            for (RootBeanDeploymentArchive rarRootBda : this.rarRootBdas) {
                rarModuleBda = rarRootBda.getModuleBda();
                ejbRootBda.getBeanDeploymentArchives().add(rarRootBda);
                ejbRootBda.getBeanDeploymentArchives().add(rarModuleBda);
                ejbModuleBda.getBeanDeploymentArchives().add(rarRootBda);
                ejbModuleBda.getBeanDeploymentArchives().add(rarModuleBda);
                modifiedArchive = true;
            }
            if (!modifiedArchive || !this.getBeanDeploymentArchives().remove(ejbModuleBda)) continue;
            this.getBeanDeploymentArchives().add(ejbModuleBda);
        }
        Iterator<RootBeanDeploymentArchive> warIter = this.warRootBdas.iterator();
        boolean modifiedArchive = false;
        while (warIter.hasNext()) {
            RootBeanDeploymentArchive warRootBda = warIter.next();
            BeanDeploymentArchive warModuleBda = warRootBda.getModuleBda();
            for (RootBeanDeploymentArchive ejbRootBda : this.ejbRootBdas) {
                BeanDeploymentArchive ejbModuleBda = ejbRootBda.getModuleBda();
                warRootBda.getBeanDeploymentArchives().add(ejbRootBda);
                warRootBda.getBeanDeploymentArchives().add(ejbModuleBda);
                warModuleBda.getBeanDeploymentArchives().add(ejbRootBda);
                warModuleBda.getBeanDeploymentArchives().add(ejbModuleBda);
                for (Object oneBda : warModuleBda.getBeanDeploymentArchives()) {
                    oneBda.getBeanDeploymentArchives().add(ejbRootBda);
                    oneBda.getBeanDeploymentArchives().add(ejbModuleBda);
                }
                modifiedArchive = true;
            }
            for (RootBeanDeploymentArchive libJarRootBda : this.libJarRootBdas) {
                Object oneBda;
                libJarModuleBda = libJarRootBda.getModuleBda();
                warRootBda.getBeanDeploymentArchives().add(libJarRootBda);
                warRootBda.getBeanDeploymentArchives().add(libJarModuleBda);
                warModuleBda.getBeanDeploymentArchives().add(libJarRootBda);
                warModuleBda.getBeanDeploymentArchives().add(libJarModuleBda);
                Set<BeanDeploymentArchive> seen = Collections.newSetFromMap(new IdentityHashMap());
                this.beanDeploymentArchives.stream().filter(RootBeanDeploymentArchive.class::isInstance).map(RootBeanDeploymentArchive.class::cast).forEach(bda -> this.recursivelyAdd(bda.getBeanDeploymentArchives(), warModuleBda, seen));
                this.recursivelyAdd(this.beanDeploymentArchives, warModuleBda, seen);
                libJarRootBda.getBeanDeploymentArchives().add(warRootBda);
                libJarModuleBda.getBeanDeploymentArchives().add(warRootBda);
                libJarRootBda.getBeanDeploymentArchives().add(warModuleBda);
                libJarModuleBda.getBeanDeploymentArchives().add(warModuleBda);
                oneBda = warModuleBda.getBeanDeploymentArchives().iterator();
                while (oneBda.hasNext()) {
                    BeanDeploymentArchive oneBda2 = (BeanDeploymentArchive)oneBda.next();
                    oneBda2.getBeanDeploymentArchives().add(libJarRootBda);
                    oneBda2.getBeanDeploymentArchives().add(libJarModuleBda);
                }
                modifiedArchive = true;
            }
            for (RootBeanDeploymentArchive rarRootBda : this.rarRootBdas) {
                rarModuleBda = rarRootBda.getModuleBda();
                warRootBda.getBeanDeploymentArchives().add(rarRootBda);
                warRootBda.getBeanDeploymentArchives().add(rarModuleBda);
                warModuleBda.getBeanDeploymentArchives().add(rarRootBda);
                warModuleBda.getBeanDeploymentArchives().add(rarModuleBda);
                for (Object oneBda : warModuleBda.getBeanDeploymentArchives()) {
                    oneBda.getBeanDeploymentArchives().add(rarRootBda);
                    oneBda.getBeanDeploymentArchives().add(rarModuleBda);
                }
                modifiedArchive = true;
            }
            if (!modifiedArchive) continue;
            if (this.getBeanDeploymentArchives().remove(warModuleBda)) {
                this.getBeanDeploymentArchives().add(warModuleBda);
            }
            modifiedArchive = false;
        }
        this.addDependentBdas();
    }

    private void addDependentBdas() {
        HashSet<BeanDeploymentArchive> additionalBdas = new HashSet<BeanDeploymentArchive>();
        for (BeanDeploymentArchive oneBda : this.beanDeploymentArchives) {
            BeanDeploymentArchiveImpl beanDeploymentArchiveImpl = (BeanDeploymentArchiveImpl)oneBda;
            Collection<BeanDeploymentArchive> subBdas = beanDeploymentArchiveImpl.getBeanDeploymentArchives();
            for (BeanDeploymentArchive subBda : subBdas) {
                if (subBda.getBeanClasses().isEmpty()) continue;
                additionalBdas.add(subBda);
            }
        }
        for (BeanDeploymentArchive oneBda : additionalBdas) {
            if (this.beanDeploymentArchives.contains(oneBda)) continue;
            this.beanDeploymentArchives.add(oneBda);
        }
    }

    private void recursivelyAdd(Collection<BeanDeploymentArchive> bdas, BeanDeploymentArchive bda, Set<BeanDeploymentArchive> seen) {
        for (BeanDeploymentArchive subBda : new LinkedHashSet<BeanDeploymentArchive>(bdas)) {
            if (!seen.add(subBda)) continue;
            subBda.getBeanDeploymentArchives().add(bda);
            this.recursivelyAdd(subBda.getBeanDeploymentArchives(), bda, seen);
        }
    }

    public Set<BeanDeploymentArchive> getBeanDeploymentArchives() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00019", new Object[]{this.beanDeploymentArchives});
        }
        return this.beanDeploymentArchives;
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00020", new Object[]{beanClass});
        }
        Collection beanDeploymentArchives = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : beanDeploymentArchives) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00021", new Object[]{beanClass, bda.getId()});
            }
            if (((BeanDeploymentArchiveImpl)bda).getModuleBeanClasses().contains(beanClass.getName())) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00022", new Object[]{beanClass.getName(), bda});
                }
                return bda;
            }
            if (bda.getBeanDeploymentArchives().isEmpty()) continue;
            for (BeanDeploymentArchive subBda : bda.getBeanDeploymentArchives()) {
                boolean match;
                Collection<String> moduleBeanClassNames = ((BeanDeploymentArchiveImpl)subBda).getModuleBeanClasses();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00023", new Object[]{beanClass, subBda.getId()});
                }
                if (!(match = moduleBeanClassNames.contains(beanClass.getName()))) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00022", new Object[]{beanClass.getName(), subBda});
                }
                return subBda;
            }
        }
        BeanDeploymentArchive extensionBDA = this.extensionBDAMap.get(beanClass.getClassLoader());
        if (extensionBDA != null) {
            return extensionBDA;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00024", new Object[]{beanClass});
        }
        ArrayList beanClasses = new ArrayList();
        CopyOnWriteArrayList<URL> beanXMLUrls = new CopyOnWriteArrayList<URL>();
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        beanClasses.add(beanClass);
        BeanDeploymentArchiveImpl newBda = new BeanDeploymentArchiveImpl(beanClass.getName(), beanClasses, beanXMLUrls, ejbs, this.context);
        newBda.getServices().add(InjectionServices.class, (Service)new InjectionServicesImpl(this.injectionManager, DOLUtils.getCurrentBundleForContext((DeploymentContext)this.context), this));
        BeansXml beansXml = newBda.getBeansXml();
        if (beansXml == null || !beansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00025", new Object[0]);
            }
            for (BeanDeploymentArchive bda : beanDeploymentArchives) {
                bda.getBeanDeploymentArchives().add(newBda);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00026", new Object[]{beanClass, newBda});
            }
            beanDeploymentArchives.add(newBda);
            newBda.getBeanDeploymentArchives().addAll(this.extensionBDAMap.values());
            this.idToBeanDeploymentArchive.put(newBda.getId(), newBda);
            this.extensionBDAMap.put(beanClass.getClassLoader(), newBda);
            return newBda;
        }
        return null;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        if (!this.extensions.isEmpty()) {
            return this.extensions;
        }
        Collection bdas = this.getBeanDeploymentArchives();
        ArrayList<Metadata<Extension>> extnList = new ArrayList<Metadata<Extension>>();
        final List<Class<? extends BuildCompatibleExtension>> buildExtensions = this.getBuildCompatibleExtensions();
        if (!buildExtensions.isEmpty()) {
            try {
                LiteExtensionTranslator extensionTranslator = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<LiteExtensionTranslator>(){

                    @Override
                    public LiteExtensionTranslator run() {
                        return new LiteExtensionTranslator(buildExtensions, Thread.currentThread().getContextClassLoader());
                    }
                }) : new LiteExtensionTranslator(buildExtensions, Thread.currentThread().getContextClassLoader());
                extnList.add((Metadata<Extension>)new MetadataImpl((Object)extensionTranslator));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Problem to register CDI Build Compatible Extensions");
                throw new RuntimeException(e);
            }
        }
        HashSet<ClassLoader> scannedClassLoaders = new HashSet<ClassLoader>();
        HashMap loadedExtensions = new HashMap();
        for (BeanDeploymentArchive bda : bdas) {
            ClassLoader moduleClassLoader;
            if (bda instanceof RootBeanDeploymentArchive || scannedClassLoaders.contains(moduleClassLoader = ((BeanDeploymentArchiveImpl)bda).getModuleClassLoaderForBDA())) continue;
            scannedClassLoaders.add(moduleClassLoader);
            Iterable extensions = ((WeldBootstrap)this.context.getTransientAppMetaData("[PerBDA]org.glassfish.weld.WeldBootstrap", WeldBootstrap.class)).loadExtensions(moduleClassLoader);
            for (Metadata bdaExtn : extensions) {
                if (loadedExtensions.get(((Extension)bdaExtn.getValue()).getClass()) != null) continue;
                extnList.add((Metadata<Extension>)bdaExtn);
                loadedExtensions.put(((Extension)bdaExtn.getValue()).getClass(), bdaExtn);
            }
        }
        Iterable snifferExtensions = (Iterable)this.context.getTransientAppMetaData("org.glassfish.weld.sniffers", Iterable.class);
        if (snifferExtensions != null) {
            for (Supplier extensionCreator : snifferExtensions) {
                Extension extension = (Extension)extensionCreator.get();
                Class<?> extensionClass = extension.getClass();
                MetadataImpl extensionMetadata = new MetadataImpl((Object)extension, extensionClass.getName());
                extnList.add((Metadata<Extension>)extensionMetadata);
            }
        }
        extnList.addAll(this.dynamicExtensions);
        this.extensions.addAll(extnList);
        return extnList;
    }

    public boolean addDynamicExtension(Metadata<Extension> extension) {
        return this.dynamicExtensions.add(extension);
    }

    public boolean removeDynamicExtension(Metadata<Extension> extension) {
        return this.dynamicExtensions.remove(extension);
    }

    public void clearDynamicExtensions() {
        this.dynamicExtensions.clear();
    }

    public String toString() {
        StringBuilder valBuff = new StringBuilder();
        Collection beanDeploymentArchives = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : beanDeploymentArchives) {
            valBuff.append(bda.toString());
        }
        return valBuff.toString();
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForArchive(String archiveId) {
        return this.idToBeanDeploymentArchive.get(archiveId);
    }

    public void cleanup() {
        this.ejbRootBdas.clear();
        this.warRootBdas.clear();
        this.libJarRootBdas.clear();
        this.rarRootBdas.clear();
        this.idToBeanDeploymentArchive.clear();
    }

    private List<Class<? extends BuildCompatibleExtension>> getBuildCompatibleExtensions() {
        return ServiceLoader.load(BuildCompatibleExtension.class, Thread.currentThread().getContextClassLoader()).stream().map(ServiceLoader.Provider::get).map(Object::getClass).filter(e -> !e.isAnnotationPresent(SkipIfPortableExtensionPresent.class)).collect(Collectors.toList());
    }

    private Set<RootBeanDeploymentArchive> scanForLibJars(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        String libDir;
        ArrayList<ReadableArchive> libJars = null;
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder != null && holder.app != null && (libDir = holder.app.getLibraryDirectory()) != null && !libDir.isEmpty()) {
            Enumeration entries = archive.entries(libDir);
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!DOLUtils.isScanningAllowed((Application)holder.app, (String)entryName) || !entryName.endsWith(".jar") || entryName.indexOf(47, libDir.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    if (jarInLib == null || !jarInLib.exists("META-INF/beans.xml") && !WeldUtils.isImplicitBeanArchive((DeploymentContext)context, (ReadableArchive)jarInLib)) continue;
                    if (libJars == null) {
                        libJars = new ArrayList<ReadableArchive>();
                    }
                    libJars.add(jarInLib);
                }
                catch (IOException e) {
                    this.logger.log(Level.FINE, "AS-CDI-00027", new Object[]{e});
                }
            }
        }
        if (libJars != null) {
            libDir = holder.app.getLibraryDirectory();
            for (ReadableArchive libJarArchive : libJars) {
                this.createLibJarBda(libJarArchive, ejbs, libDir);
            }
        }
        return this.libJarRootBdas;
    }

    private void createLibJarBda(ReadableArchive libJarArchive, Collection<EjbDescriptor> ejbs, String libDir) {
        RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(libJarArchive, ejbs, this.context, libDir + "/" + libJarArchive.getName());
        this.createLibJarBda(rootBda);
    }

    private void createLibJarBda(RootBeanDeploymentArchive rootLibBda) {
        BeanDeploymentArchive libModuleBda = rootLibBda.getModuleBda();
        BeansXml moduleBeansXml = libModuleBda.getBeansXml();
        if (moduleBeansXml == null || !moduleBeansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            this.addBdaToDeploymentBdas(rootLibBda);
            this.addBdaToDeploymentBdas(libModuleBda);
            for (RootBeanDeploymentArchive existingLibJarRootBda : this.libJarRootBdas) {
                rootLibBda.getBeanDeploymentArchives().add(existingLibJarRootBda);
                rootLibBda.getBeanDeploymentArchives().add(existingLibJarRootBda.getModuleBda());
                rootLibBda.getModuleBda().getBeanDeploymentArchives().add(existingLibJarRootBda);
                rootLibBda.getModuleBda().getBeanDeploymentArchives().add(existingLibJarRootBda.getModuleBda());
                existingLibJarRootBda.getBeanDeploymentArchives().add(rootLibBda);
                existingLibJarRootBda.getBeanDeploymentArchives().add(rootLibBda.getModuleBda());
                existingLibJarRootBda.getModuleBda().getBeanDeploymentArchives().add(rootLibBda);
                existingLibJarRootBda.getModuleBda().getBeanDeploymentArchives().add(rootLibBda.getModuleBda());
            }
            this.libJarRootBdas.add(rootLibBda);
        }
    }

    private void addBdaToDeploymentBdas(BeanDeploymentArchive bda) {
        if (!this.beanDeploymentArchives.contains(bda)) {
            this.beanDeploymentArchives.add(bda);
            this.idToBeanDeploymentArchive.put(bda.getId(), bda);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBdasForAppLibs(ReadableArchive archive, DeploymentContext context) {
        ArrayList<RootBeanDeploymentArchive> libBdas;
        block12: {
            libBdas = new ArrayList<RootBeanDeploymentArchive>();
            try {
                List appLibs = context.getAppLibs();
                Set installedLibraries = InstalledLibrariesResolver.getInstalledLibraries((ReadableArchive)archive);
                if (appLibs == null || appLibs.isEmpty() || installedLibraries == null || installedLibraries.isEmpty()) break block12;
                block9: for (URI oneAppLib : appLibs) {
                    for (String oneInstalledLibrary : installedLibraries) {
                        if (!oneAppLib.getPath().endsWith(oneInstalledLibrary)) continue;
                        ReadableArchive libArchive = null;
                        try {
                            libArchive = this.archiveFactory.openArchive(oneAppLib);
                            if (!libArchive.exists("META-INF/beans.xml")) continue block9;
                            String bdaId = archive.getName() + "_" + libArchive.getName();
                            RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(libArchive, Collections.emptyList(), context, bdaId);
                            libBdas.add(rootBda);
                            continue block9;
                        }
                        finally {
                            if (libArchive == null) continue block9;
                            try {
                                libArchive.close();
                            }
                            catch (Exception exception) {}
                            continue block9;
                        }
                    }
                }
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        for (RootBeanDeploymentArchive oneBda : libBdas) {
            this.createLibJarBda(oneBda);
        }
    }

    protected void addDeployedEjbs(Collection<EjbDescriptor> ejbs) {
        if (ejbs != null) {
            this.deployedEjbs.addAll(ejbs);
        }
    }

    public Collection<EjbDescriptor> getDeployedEjbs() {
        return this.deployedEjbs;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        for (BeanDeploymentArchive oneBda : this.beanDeploymentArchives) {
            BeanDeploymentArchiveImpl beanDeploymentArchiveImpl = (BeanDeploymentArchiveImpl)oneBda;
            if (!beanDeploymentArchiveImpl.getKnownClasses().contains(beanClass.getName())) continue;
            return oneBda;
        }
        ClassLoader classLoader = beanClass.getClassLoader();
        RootBeanDeploymentArchive rootBda = this.findRootBda(classLoader, this.ejbRootBdas);
        if (rootBda == null && (rootBda = this.findRootBda(classLoader, this.warRootBdas)) == null && (rootBda = this.findRootBda(classLoader, this.libJarRootBdas)) == null) {
            rootBda = this.findRootBda(classLoader, this.rarRootBdas);
        }
        return rootBda;
    }

    private RootBeanDeploymentArchive findRootBda(ClassLoader classLoader, Set<RootBeanDeploymentArchive> rootBdas) {
        if (rootBdas == null || classLoader == null) {
            return null;
        }
        for (RootBeanDeploymentArchive oneRootBda : rootBdas) {
            if (!classLoader.equals(oneRootBda.getModuleClassLoaderForBDA())) continue;
            return oneRootBda;
        }
        return null;
    }

    private void createModuleBda(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, String moduleName) {
        DeploymentContextImpl deploymentContext;
        ExtendedDeploymentContext parentContext;
        RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(archive, ejbs, context, moduleName);
        BeanDeploymentArchive moduleBda = rootBda.getModuleBda();
        BeansXml moduleBeansXml = moduleBda.getBeansXml();
        if (moduleBeansXml == null || !moduleBeansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE) || this.forceInitialisation(context)) {
            this.addBdaToDeploymentBdas(rootBda);
            this.addBdaToDeploymentBdas(moduleBda);
            this.addBeanDeploymentArchives(rootBda);
        }
        if (!this.earContextAppLibBdasProcessed && context instanceof DeploymentContextImpl && (parentContext = (deploymentContext = (DeploymentContextImpl)context).getParentContext()) != null) {
            this.processBdasForAppLibs(parentContext.getSource(), (DeploymentContext)parentContext);
            parentContext.getSource();
            this.earContextAppLibBdasProcessed = true;
        }
        this.processBdasForAppLibs(archive, context);
    }

    public Iterator<RootBeanDeploymentArchive> getLibJarRootBdas() {
        return this.libJarRootBdas.iterator();
    }

    public Iterator<RootBeanDeploymentArchive> getRarRootBdas() {
        return this.rarRootBdas.iterator();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getContextId() {
        return this.contextId;
    }

    public Types getTypes() {
        return (Types)this.context.getTransientAppMetaData(Types.class.getName(), Types.class);
    }

    private boolean forceInitialisation(DeploymentContext context) {
        Boolean force = (Boolean)context.getTransientAppMetaData("fish.payara.faces.integration.allowFacesCdiInitialisation", Boolean.class);
        if (force != null && force.booleanValue()) {
            this.logger.fine("allowFacesCdiInitialisation enabled, forcing initialisation of Weld");
            return true;
        }
        return false;
    }
}

