/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.WeldDeployer;
import org.jboss.weld.Container;
import org.jboss.weld.SimpleCDI;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;

public class GlassFishWeldProvider
implements CDIProvider {
    private static final WeldDeployer weldDeployer = (WeldDeployer)((Object)Globals.get(WeldDeployer.class));
    private static final InvocationManager invocationManager = (InvocationManager)Globals.get(InvocationManager.class);

    public CDI<Object> getCDI() {
        try {
            BundleDescriptor bundle = null;
            Object componentEnv = invocationManager.getCurrentInvocation().getJNDIEnvironment();
            if (componentEnv instanceof EjbDescriptor) {
                bundle = (BundleDescriptor)((EjbDescriptor)componentEnv).getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
            } else if (componentEnv instanceof WebBundleDescriptor) {
                bundle = (BundleDescriptor)componentEnv;
            }
            BeanDeploymentArchive bda = weldDeployer.getBeanDeploymentArchiveForBundle(bundle);
            if (bda == null) {
                return new GlassFishEnhancedWeld();
            }
            return new GlassFishEnhancedWeld(weldDeployer.getContextIdForArchive(bda));
        }
        catch (Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause instanceof IllegalStateException) {
                return null;
            }
            throw throwable;
        }
    }

    private static class GlassFishEnhancedWeld
    extends SimpleCDI {
        GlassFishEnhancedWeld() {
        }

        GlassFishEnhancedWeld(String contextId) {
            super(contextId == null ? Container.instance() : Container.instance((String)contextId));
        }

        protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
            if (Container.instance().beanDeploymentArchives().values().size() == 1) {
                return (BeanManagerImpl)Container.instance().beanDeploymentArchives().values().iterator().next();
            }
            Map beanDeploymentArchives = Container.instance().beanDeploymentArchives();
            Set entries = beanDeploymentArchives.entrySet();
            for (Map.Entry entry : entries) {
                BeanDeploymentArchive beanDeploymentArchive = (BeanDeploymentArchive)entry.getKey();
                if (!(beanDeploymentArchive instanceof RootBeanDeploymentArchive)) continue;
                RootBeanDeploymentArchive rootBeanDeploymentArchive = (RootBeanDeploymentArchive)beanDeploymentArchive;
                ClassLoader moduleClassLoaderForBDA = rootBeanDeploymentArchive.getModuleClassLoaderForBDA();
                try {
                    Class.forName(callerClassName, false, moduleClassLoaderForBDA);
                    return (BeanManagerImpl)entry.getValue();
                }
                catch (Exception exception) {
                }
            }
            return super.unsatisfiedBeanManager(callerClassName);
        }
    }
}

