/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.jsp.tagext.JspTag;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.NamingException;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.ResourceLoaderImpl;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.WeldApplicationContainer;
import org.glassfish.weld.WeldContainer;
import org.glassfish.weld.WeldTerminationListenerProxy;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.EjbServicesImpl;
import org.glassfish.weld.services.ExecutorServicesImpl;
import org.glassfish.weld.services.ExternalConfigurationImpl;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.NonModuleInjectionServices;
import org.glassfish.weld.services.ProxyServicesImpl;
import org.glassfish.weld.services.SecurityServicesImpl;
import org.glassfish.weld.services.TransactionServicesImpl;
import org.glassfish.weld.util.Util;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.EEModuleDescriptorImpl;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagerLookupService;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.NewInstanceAction;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jvnet.hk2.annotations.Service;

@Service
public class WeldDeployer
extends SimpleDeployer<WeldContainer, WeldApplicationContainer>
implements PostConstruct,
EventListener {
    private Logger logger = Logger.getLogger(WeldDeployer.class.getName());
    public static final String WELD_EXTENSION = "org.glassfish.weld";
    public static final String WELD_DEPLOYMENT = "org.glassfish.weld.WeldDeployment";
    static final String WELD_BOOTSTRAP = "[PerBDA]org.glassfish.weld.WeldBootstrap";
    public static final String SNIFFER_EXTENSIONS = "org.glassfish.weld.sniffers";
    private static final String WELD_CONTEXT_LISTENER = "org.glassfish.weld.WeldContextListener";
    private static final String WELD_LISTENER = "org.jboss.weld.module.web.servlet.WeldListener";
    static final String WELD_TERMINATION_LISTENER = "org.jboss.weld.module.web.servlet.WeldTerminalListener";
    private static final String WELD_SHUTDOWN = "weld_shutdown";
    private static final String WELD_BOOTSTRAP_SHUTDOWN = "weld_bootstrap_shutdown";
    private static final String WELD_CONVERSATION_FILTER_CLASS = "org.jboss.weld.module.web.servlet.ConversationFilter";
    private static final String WELD_CONVERSATION_FILTER_NAME = "CDI Conversation Filter";
    public static final String DEV_MODE_PROPERTY = "org.jboss.weld.development";
    private static final String PROBE_FILTER_NAME = "weld-probe-filter";
    private static final String PROBE_FILTER_CLASS_NAME = "org.jboss.weld.probe.ProbeFilter";
    private static final boolean PROBE_FILTER_ASYNC_SUPPORT = true;
    private static final String PROBE_FILTER_URL_PATTERN = "/*";
    private static final String PROBE_FILTER_DISPATCHER_TYPE = "REQUEST";
    private static final String PROBE_INVOCATION_MONITOR_EXCLUDE_TYPE = ".*payara.*|.*glassfish.*";
    private static final String PROBE_EVENT_MONITOR_EXCLUDE_TYPE = "jakarta.servlet.http.*";
    private static final String PROBE_ALLOW_REMOTE_ADDRESS = "";
    private static final String JERSEY_PROCESS_ALL_CLASS_NAME = "org.glassfish.jersey.ext.cdi1x.internal.ProcessAllAnnotatedTypes";
    private static final String JERSEY_HK2_CLASS_NAME = "org.glassfish.jersey.ext.cdi1x.spi.Hk2CustomBoundTypesProvider";
    private static final String JERSEY_PROCESS_JAXRS_CLASS_NAME = "org.glassfish.jersey.ext.cdi1x.internal.ProcessJAXRSAnnotatedTypes";
    @Inject
    private Events events;
    @Inject
    private ServiceLocator services;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    private org.glassfish.internal.deployment.Deployment deployment;
    private Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();
    private static final Class<?>[] NON_CONTEXT_CLASSES = new Class[]{Servlet.class, ServletContextListener.class, Filter.class, HttpSessionListener.class, ServletRequestListener.class, JspTag.class};

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public boolean prepare(DeploymentContext context) {
        context.addTransientAppMetaData(SNIFFER_EXTENSIONS, new HashSet());
        return super.prepare(context);
    }

    public WeldApplicationContainer load(WeldContainer container, DeploymentContext context) {
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        ApplicationInfo applicationInfo = this.applicationRegistry.get(deployParams.name);
        ReadableArchive archive = context.getSource();
        this.ensureWeldBootstrapCreated(context, applicationInfo);
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        if (ejbBundle != null) {
            ejbs.addAll(ejbBundle.getEjbs());
            ejbServices = new EjbServicesImpl(this.services);
        }
        String archiveName = this.getArchiveName(context, applicationInfo, archive);
        DeploymentImpl deploymentImpl = (DeploymentImpl)applicationInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
        if (deploymentImpl == null) {
            deploymentImpl = new DeploymentImpl(archive, ejbs, context, this.archiveFactory, archiveName, (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]));
            TransactionServicesImpl transactionServices = new TransactionServicesImpl(this.services);
            deploymentImpl.getServices().add(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)transactionServices);
            SecurityServicesImpl securityServices = new SecurityServicesImpl();
            deploymentImpl.getServices().add(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)securityServices);
            ProxyServicesImpl proxyServices = new ProxyServicesImpl(this.services);
            deploymentImpl.getServices().add(ProxyServices.class, (org.jboss.weld.bootstrap.api.Service)proxyServices);
            try {
                ExecutorServicesImpl executorServices = new ExecutorServicesImpl();
                deploymentImpl.getServices().add(ExecutorServices.class, (org.jboss.weld.bootstrap.api.Service)executorServices);
            }
            catch (NamingException ex) {
                throw new RuntimeException(ex);
            }
            this.addWeldListenerToAllWars(context);
        } else {
            deploymentImpl.scanArchive(archive, ejbs, context, archiveName);
        }
        deploymentImpl.addDeployedEjbs(ejbs);
        if (ejbBundle != null && !deploymentImpl.getServices().contains(EjbServices.class)) {
            deploymentImpl.getServices().add(EjbServices.class, (org.jboss.weld.bootstrap.api.Service)ejbServices);
        }
        ExternalConfigurationImpl externalConfiguration = new ExternalConfigurationImpl();
        externalConfiguration.setRollingUpgradesDelimiter(System.getProperty("fish.payara.rollingUpgradesDelimiter", ":"));
        externalConfiguration.setBeanIndexOptimization(deployParams.isAvailabilityEnabled() == false);
        externalConfiguration.setNonPortableMode(false);
        this.configureConcurrentDeployment(context, externalConfiguration);
        deploymentImpl.getServices().add(ExternalConfiguration.class, (org.jboss.weld.bootstrap.api.Service)externalConfiguration);
        BeanDeploymentArchive beanDeploymentArchive = deploymentImpl.getBeanDeploymentArchiveForArchive(archiveName);
        if (beanDeploymentArchive != null && !beanDeploymentArchive.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE) || this.forceInitialisation(context)) {
            WebBundleDescriptor bundle;
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
            boolean developmentMode = this.isDevelopmentMode(context);
            if (webBundleDescriptor != null) {
                webBundleDescriptor.setExtensionProperty(WELD_EXTENSION, "true");
                webBundleDescriptor.addAppListenerDescriptorToFirst((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_LISTENER));
                webBundleDescriptor.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_CONTEXT_LISTENER));
                webBundleDescriptor.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WeldTerminationListenerProxy.class.getName()));
                this.registerWeldConversationFilter(webBundleDescriptor);
                if (developmentMode) {
                    this.registerProbeFilter(webBundleDescriptor);
                }
            }
            if (developmentMode) {
                this.registerProbeExtension(externalConfiguration, deploymentImpl);
            }
            Object object = bundle = webBundleDescriptor != null ? webBundleDescriptor : ejbBundle;
            if (bundle != null && (!beanDeploymentArchive.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE) || this.forceInitialisation(context))) {
                InjectionServicesImpl injectionServices = new InjectionServicesImpl(deploymentImpl.injectionManager, (BundleDescriptor)bundle, deploymentImpl);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, beanDeploymentArchive.getId()});
                }
                beanDeploymentArchive.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
                EEModuleDescriptor eeModuleDescriptor = this.getEEModuleDescriptor(beanDeploymentArchive);
                if (eeModuleDescriptor != null) {
                    beanDeploymentArchive.getServices().add(EEModuleDescriptor.class, (org.jboss.weld.bootstrap.api.Service)eeModuleDescriptor);
                }
                for (BeanDeploymentArchive subBda : beanDeploymentArchive.getBeanDeploymentArchives()) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, subBda.getId()});
                    }
                    subBda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
                    eeModuleDescriptor = this.getEEModuleDescriptor(beanDeploymentArchive);
                    if (eeModuleDescriptor == null) continue;
                    beanDeploymentArchive.getServices().add(EEModuleDescriptor.class, (org.jboss.weld.bootstrap.api.Service)eeModuleDescriptor);
                }
            }
            this.bundleToBeanDeploymentArchive.put((BundleDescriptor)bundle, beanDeploymentArchive);
        }
        applicationInfo.addTransientAppMetaData(WELD_DEPLOYMENT, (Object)deploymentImpl);
        return new WeldApplicationContainer();
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_LOADED)) {
            this.processApplicationLoaded((ApplicationInfo)event.hook());
        } else if (WeldDeployer.isOneOf(event, org.glassfish.internal.deployment.Deployment.APPLICATION_STOPPED, org.glassfish.internal.deployment.Deployment.APPLICATION_UNLOADED, org.glassfish.internal.deployment.Deployment.APPLICATION_DISABLED)) {
            this.processApplicationStopped((ApplicationInfo)event.hook());
        }
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.get(bundle);
    }

    public boolean isCdiEnabled(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle);
    }

    public boolean is299Enabled(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle);
    }

    public WeldBootstrap getBootstrapForArchive(BeanDeploymentArchive archive) {
        return ((BeanDeploymentArchiveImpl)archive).weldBootstrap;
    }

    public String getContextIdForArchive(BeanDeploymentArchive archive) {
        BeanDeploymentArchiveImpl impl = (BeanDeploymentArchiveImpl)archive;
        String rootContextId = impl.getBeanDeploymentArchives().stream().filter(RootBeanDeploymentArchive.class::isInstance).map(RootBeanDeploymentArchive.class::cast).filter(bda -> bda.moduleBda.getBDAType() != WeldUtils.BDAType.UNKNOWN).findFirst().map(BeanDeploymentArchive::getId).orElse(null);
        return rootContextId == null ? null : rootContextId + ".bda";
    }

    private WeldBootstrap ensureWeldBootstrapCreated(DeploymentContext context, ApplicationInfo applicationInfo) {
        WeldBootstrap bootstrap;
        ArrayList<WeldBootstrap> toShutdown = (ArrayList<WeldBootstrap>)applicationInfo.getTransientAppMetaData(WELD_BOOTSTRAP, List.class);
        if (toShutdown == null) {
            toShutdown = new ArrayList<WeldBootstrap>();
            applicationInfo.addTransientAppMetaData(WELD_BOOTSTRAP, toShutdown);
        }
        if ((bootstrap = (WeldBootstrap)context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class)) == null) {
            bootstrap = new WeldBootstrap();
            context.addTransientAppMetaData(WELD_BOOTSTRAP, (Object)bootstrap);
            toShutdown.add(bootstrap);
            applicationInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, (Object)"false");
        }
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApplicationLoaded(ApplicationInfo applicationInfo) {
        DeploymentImpl deploymentImpl = (DeploymentImpl)applicationInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
        if (deploymentImpl == null) {
            return;
        }
        ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
        this.invocationManager.pushAppEnvironment(() -> ((ApplicationInfo)applicationInfo).getName());
        ComponentInvocation componentInvocation = this.createComponentInvocation(applicationInfo);
        try {
            this.invocationManager.preInvoke(componentInvocation);
            if (deploymentImpl.ejbRootBdas.isEmpty()) {
                for (RootBeanDeploymentArchive rootBDA : deploymentImpl.getRootBDAs()) {
                    DeploymentImpl.currentDeployment.set(deploymentImpl);
                    DeploymentImpl.currentBDAs.set(new HashMap());
                    DeploymentImpl.currentDeploymentContext.set(rootBDA.context);
                    try {
                        DeploymentImpl filtered = deploymentImpl.filter(rootBDA, applicationInfo);
                        this.completeDeployment(filtered);
                        WeldBootstrap bootstrap = (WeldBootstrap)filtered.context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
                        this.startWeldBootstrap(applicationInfo, rootBDA, bootstrap, filtered, componentInvocation);
                    }
                    finally {
                        DeploymentImpl.currentDeployment.remove();
                        DeploymentImpl.currentBDAs.remove();
                        DeploymentImpl.currentDeploymentContext.remove();
                    }
                }
            } else if (!deploymentImpl.getRootBDAs().isEmpty()) {
                this.completeDeployment(deploymentImpl);
                RootBeanDeploymentArchive bda = deploymentImpl.getRootBDAs().iterator().next();
                WeldBootstrap bootstrap = this.unifyBootstrap(bda, applicationInfo);
                this.startWeldBootstrap(applicationInfo, bda, bootstrap, deploymentImpl, componentInvocation);
            }
        }
        catch (Throwable t) {
            this.doBootstrapShutdown(applicationInfo);
            throw new DeploymentException(this.getDeploymentErrorMsgPrefix(t) + t.getMessage(), t);
        }
        finally {
            try {
                this.invocationManager.postInvoke(componentInvocation);
                this.invocationManager.popAppEnvironment();
                this.deploymentComplete(deploymentImpl);
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "Exception dispatching post deploy event", t);
            }
            Thread.currentThread().setContextClassLoader(oldTCL);
        }
    }

    private void completeDeployment(DeploymentImpl deploymentImpl) {
        deploymentImpl.buildDeploymentGraph();
        Collection archives = deploymentImpl.getBeanDeploymentArchives();
        this.addResourceLoaders((Set<BeanDeploymentArchive>)archives);
        this.addCdiServicesToNonModuleBdas(deploymentImpl.getLibJarRootBdas(), (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]));
        this.addCdiServicesToNonModuleBdas(deploymentImpl.getRarRootBdas(), (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]));
    }

    private WeldBootstrap unifyBootstrap(BeanDeploymentArchiveImpl rootArchive, ApplicationInfo applicationInfo) {
        WeldBootstrap bootstrap = this.ensureWeldBootstrapCreated(rootArchive.context, applicationInfo);
        rootArchive.getBeanDeploymentArchives().stream().map(BeanDeploymentArchiveImpl.class::cast).forEach(bda -> {
            bda.weldBootstrap = bootstrap;
        });
        return bootstrap;
    }

    private void startWeldBootstrap(ApplicationInfo applicationInfo, RootBeanDeploymentArchive rootBDA, WeldBootstrap bootstrap, DeploymentImpl deploymentImpl, ComponentInvocation componentInvocation) {
        bootstrap.startExtensions(this.postProcessExtensions(deploymentImpl.getExtensions(), (Set<BeanDeploymentArchive>)deploymentImpl.getBeanDeploymentArchives()));
        bootstrap.startContainer(deploymentImpl.getContextId(), (Environment)Environments.SERVLET, (Deployment)deploymentImpl);
        if (!rootBDA.getBeanDeploymentArchives().isEmpty()) {
            WeldDeployer.createProxyEJBs(rootBDA, bootstrap, componentInvocation, deploymentImpl);
        }
        bootstrap.startInitialization();
        this.fireProcessInjectionTargetEvents(bootstrap, applicationInfo, deploymentImpl);
        bootstrap.deployBeans();
        bootstrap.validateBeans();
        bootstrap.endInitialization();
    }

    private static void createProxyEJBs(RootBeanDeploymentArchive warRootBDA, final WeldBootstrap bootstrap, ComponentInvocation componentInvocation, final DeploymentImpl deploymentImpl) {
        BeanManagerImpl beanManager = bootstrap.getManager((BeanDeploymentArchive)warRootBDA);
        componentInvocation.setInstance((Object)beanManager);
        ServiceRegistry rootServices = beanManager.getServices();
        final EjbSupport originalEjbSupport = (EjbSupport)rootServices.get(EjbSupport.class);
        if (originalEjbSupport != null) {
            EjbSupport proxyEjbSupport = (EjbSupport)Proxy.newProxyInstance(EjbSupport.class.getClassLoader(), new Class[]{EjbSupport.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object enhancedAnnotated;
                    Class beanClass;
                    EjbSupport targetEjbSupport;
                    if (method.getName().equals("isEjb")) {
                        EjbSupport targetEjbSupport2 = this.getTargetEjbSupport((Class)args[0]);
                        if (targetEjbSupport2 != null) {
                            return method.invoke((Object)targetEjbSupport2, args);
                        }
                    } else if (method.getName().equals("createSessionBeanAttributes") && (targetEjbSupport = this.getTargetEjbSupport(beanClass = (Class)(enhancedAnnotated = args[0]).getClass().getMethod("getJavaClass", new Class[0]).invoke(enhancedAnnotated, new Object[0]))) != null) {
                        return method.invoke((Object)targetEjbSupport, args);
                    }
                    return method.invoke((Object)originalEjbSupport, args);
                }

                private EjbSupport getTargetEjbSupport(Class<?> beanClass) {
                    BeanDeploymentArchive ejbArchive = deploymentImpl.getBeanDeploymentArchive(beanClass);
                    if (ejbArchive == null) {
                        return null;
                    }
                    BeanManagerImpl ejbBeanManager = BeanManagerLookupService.lookupBeanManager(beanClass, (BeanManagerImpl)bootstrap.getManager(ejbArchive));
                    return (EjbSupport)ejbBeanManager.getServices().get(EjbSupport.class);
                }
            });
            rootServices.add(EjbSupport.class, (org.jboss.weld.bootstrap.api.Service)proxyEjbSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApplicationStopped(ApplicationInfo applicationInfo) {
        String shutdown;
        Application application = (Application)applicationInfo.getMetaData(Application.class);
        if (application != null) {
            this.removeBundleDescriptors(application);
        }
        if (Boolean.valueOf(shutdown = (String)applicationInfo.getTransientAppMetaData(WELD_SHUTDOWN, String.class)).equals(Boolean.TRUE)) {
            return;
        }
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(applicationInfo.getAppClassLoader());
        try {
            this.invocationManager.pushAppEnvironment(() -> ((ApplicationInfo)applicationInfo).getName());
            try {
                this.doBootstrapShutdown(applicationInfo);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "AS-CDI-00036", new Object[]{e});
            }
            finally {
                this.invocationManager.popAppEnvironment();
            }
            applicationInfo.addTransientAppMetaData(WELD_SHUTDOWN, (Object)"true");
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
        DeploymentImpl deploymentImpl = (DeploymentImpl)applicationInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
        if (deploymentImpl != null) {
            deploymentImpl.cleanup();
        }
    }

    private void addResourceLoaders(Set<BeanDeploymentArchive> archives) {
        for (BeanDeploymentArchive archive : archives) {
            archive.getServices().add(ResourceLoader.class, (org.jboss.weld.bootstrap.api.Service)new ResourceLoaderImpl(((BeanDeploymentArchiveImpl)archive).getModuleClassLoaderForBDA()));
        }
    }

    private ComponentInvocation createComponentInvocation(ApplicationInfo applicationInfo) {
        BundleDescriptor bundleDescriptor = DOLUtils.getCurrentBundleForContext((DeploymentContext)this.deployment.getCurrentDeploymentContext());
        ComponentInvocation componentInvocation = new ComponentInvocation(DOLUtils.getComponentEnvId((JndiNameEnvironment)((JndiNameEnvironment)bundleDescriptor)), ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION, (Object)applicationInfo, applicationInfo.getName(), applicationInfo.getName(), applicationInfo.getName());
        componentInvocation.setJNDIEnvironment((Object)bundleDescriptor);
        return componentInvocation;
    }

    private Iterable<Metadata<Extension>> postProcessExtensions(Iterable<Metadata<Extension>> extensions, Set<BeanDeploymentArchive> archives) {
        Optional<Metadata<Extension>> optionaProcessAllAnnotatedTypes = this.findJerseyProcessAll(extensions);
        if (optionaProcessAllAnnotatedTypes.isPresent()) {
            Metadata<Extension> processAllMeta = optionaProcessAllAnnotatedTypes.get();
            ClassLoader jaxRsClassLoader = ((Extension)processAllMeta.getValue()).getClass().getClassLoader();
            try {
                if (!this.hasJerseyHk2Provider(archives, jaxRsClassLoader)) {
                    return this.replaceWith(extensions, processAllMeta, this.newProcessJaxRsMeta(jaxRsClassLoader));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Exception trying to replace JaxRs scan all extension", e);
            }
        }
        return extensions;
    }

    private Optional<Metadata<Extension>> findJerseyProcessAll(Iterable<Metadata<Extension>> extensions) {
        return StreamSupport.stream(extensions.spliterator(), false).filter(e -> ((Extension)e.getValue()).getClass().getName().equals(JERSEY_PROCESS_ALL_CLASS_NAME)).findAny();
    }

    private boolean hasJerseyHk2Provider(Set<BeanDeploymentArchive> archives, ClassLoader jaxRsClassLoader) throws ClassNotFoundException {
        Class<?> hk2Provider = Class.forName(JERSEY_HK2_CLASS_NAME, false, jaxRsClassLoader);
        for (BeanDeploymentArchive archive : archives) {
            archive.getBeanClasses();
            if (!ServiceLoader.load(hk2Provider).iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    private Iterable<Metadata<Extension>> replaceWith(Iterable<Metadata<Extension>> extensions, Metadata<Extension> processAllMeta, Metadata<Extension> processJaxRsMeta) {
        return StreamSupport.stream(extensions.spliterator(), false).map(e -> e.equals(processAllMeta) ? processJaxRsMeta : e).collect(Collectors.toList());
    }

    private Metadata<Extension> newProcessJaxRsMeta(ClassLoader jaxRsClassLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Extension processJAXRSAnnotatedTypes = (Extension)Class.forName(JERSEY_PROCESS_JAXRS_CLASS_NAME, false, jaxRsClassLoader).newInstance();
        return new MetadataImpl((Object)processJAXRSAnnotatedTypes);
    }

    @SafeVarargs
    private static final boolean isOneOf(EventListener.Event<?> event, EventTypes<ApplicationInfo> ... eventTypes) {
        return Arrays.stream(eventTypes).anyMatch(e -> event.is(e));
    }

    private void removeBundleDescriptors(Application application) {
        for (BundleDescriptor bundleDescriptor : application.getBundleDescriptors()) {
            if (!(bundleDescriptor instanceof EjbBundleDescriptor) && !(bundleDescriptor instanceof WebBundleDescriptor)) continue;
            this.bundleToBeanDeploymentArchive.remove(bundleDescriptor);
        }
    }

    private void deploymentComplete(DeploymentImpl deploymentImpl) {
        for (BeanDeploymentArchive beanDeploymentArchive : deploymentImpl.getBeanDeploymentArchives()) {
            ((BeanDeploymentArchiveImpl)beanDeploymentArchive).setDeploymentComplete(true);
        }
    }

    private void doBootstrapShutdown(ApplicationInfo applicationInfo) {
        List bootstrap = (List)applicationInfo.getTransientAppMetaData(WELD_BOOTSTRAP, List.class);
        String bootstrapShutdown = (String)applicationInfo.getTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, String.class);
        if (bootstrapShutdown == null || Boolean.valueOf(bootstrapShutdown).equals(Boolean.FALSE)) {
            if (bootstrap != null) {
                bootstrap.forEach(WeldBootstrap::shutdown);
            }
            applicationInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, (Object)"true");
        }
    }

    private String getArchiveName(DeploymentContext context, ApplicationInfo applicationInfo, ReadableArchive archive) {
        String archiveName;
        boolean isSubArchive = archive.getParentArchive() != null;
        String string = archiveName = !isSubArchive ? applicationInfo.getName() : archive.getName();
        if (isSubArchive) {
            archiveName = BeanDeploymentArchiveImpl.stripMavenVersion(archiveName);
        }
        if (!context.getArchiveHandler().getArchiveType().isEmpty()) {
            archiveName = String.format("%s.%s", BeanDeploymentArchiveImpl.stripApplicationVersion(archiveName), context.getArchiveHandler().getArchiveType());
        }
        return archiveName;
    }

    private String getDeploymentErrorMsgPrefix(Throwable t) {
        if (t instanceof DefinitionException) {
            return "CDI definition failure:";
        }
        if (t instanceof jakarta.enterprise.inject.spi.DeploymentException) {
            return "CDI deployment failure:";
        }
        Throwable cause = t.getCause();
        if (cause == t || cause == null) {
            return "CDI deployment failure:";
        }
        return this.getDeploymentErrorMsgPrefix(cause);
    }

    private void fireProcessInjectionTargetEvents(WeldBootstrap bootstrap, ApplicationInfo applicationInfo, DeploymentImpl deploymentImpl) {
        Collection beanDeploymentArchives = deploymentImpl.getBeanDeploymentArchives();
        Class<?> messageListenerClass = this.getMessageListenerClass();
        boolean isFullProfile = messageListenerClass != null;
        for (BeanDeploymentArchive beanDeploymentArchive : beanDeploymentArchives) {
            Collection<Class<?>> beanClassObjects = ((BeanDeploymentArchiveImpl)beanDeploymentArchive).getBeanClassObjects();
            for (Class<?> bdaClazz : beanClassObjects) {
                for (Class<?> nonClazz : NON_CONTEXT_CLASSES) {
                    if (!nonClazz.isAssignableFrom(bdaClazz)) continue;
                    this.firePITEvent(bootstrap, beanDeploymentArchive, bdaClazz);
                }
                if (!isFullProfile || !messageListenerClass.isAssignableFrom(bdaClazz)) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00038", new Object[]{bdaClazz});
                }
                this.firePITEvent(bootstrap, beanDeploymentArchive, bdaClazz);
            }
            Collection injectionTargetClassNames = WeldUtils.getInjectionTargetClassNames((Types)deploymentImpl.getTypes(), (Collection)beanDeploymentArchive.getKnownClasses());
            for (String injectionTargetClassName : injectionTargetClassNames) {
                if (beanDeploymentArchive.getBeanClasses().contains(injectionTargetClassName)) continue;
                Class<?> injectionTargetClass = null;
                try {
                    injectionTargetClass = applicationInfo.getAppClassLoader().loadClass(injectionTargetClassName);
                }
                catch (ClassNotFoundException appClassLoaderClassNotFoundException) {
                    try {
                        this.logger.log(Level.FINE, "Caught exception loading class using application class loader, trying again with module class loader");
                        injectionTargetClass = applicationInfo.getModuleClassLoader().loadClass(injectionTargetClassName);
                    }
                    catch (ClassNotFoundException moduleClassLoaderClassNotFoundException) {
                        this.logger.log(Level.FINE, "Caught exception loading class using module class loader, ProcessInjectionTarget event may not get fired for " + injectionTargetClassName);
                    }
                }
                if (injectionTargetClass == null) continue;
                for (Class<?> nonClazz : NON_CONTEXT_CLASSES) {
                    if (!nonClazz.isAssignableFrom(injectionTargetClass)) continue;
                    this.firePITEvent(bootstrap, beanDeploymentArchive, injectionTargetClass);
                }
                if (!isFullProfile || !messageListenerClass.isAssignableFrom(injectionTargetClass)) continue;
                this.firePITEvent(bootstrap, beanDeploymentArchive, injectionTargetClass);
            }
        }
    }

    private Class<?> getMessageListenerClass() {
        try {
            Class<?> messageListenerClass = Thread.currentThread().getContextClassLoader().loadClass("jakarta.jms.MessageListener");
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00037");
            }
            return messageListenerClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private void firePITEvent(WeldBootstrap bootstrap, BeanDeploymentArchive beanDeploymentArchive, Class<?> bdaClazz) {
        if (bdaClazz.isInterface()) {
            return;
        }
        AnnotatedType annotatedType = bootstrap.getManager(beanDeploymentArchive).createAnnotatedType(bdaClazz);
        ((BeanDeploymentArchiveImpl)beanDeploymentArchive).putInjectionTarget(annotatedType, bootstrap.getManager(beanDeploymentArchive).fireProcessInjectionTarget(annotatedType));
    }

    private EEModuleDescriptor getEEModuleDescriptor(BeanDeploymentArchive beanDeploymentArchive) {
        EEModuleDescriptorImpl eeModuleDescriptor = null;
        if (beanDeploymentArchive instanceof BeanDeploymentArchiveImpl) {
            WeldUtils.BDAType bdaType = ((BeanDeploymentArchiveImpl)beanDeploymentArchive).getBDAType();
            if (bdaType.equals((Object)WeldUtils.BDAType.JAR)) {
                eeModuleDescriptor = new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.EJB_JAR);
            } else if (bdaType.equals((Object)WeldUtils.BDAType.WAR)) {
                eeModuleDescriptor = new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.WEB);
            } else if (bdaType.equals((Object)WeldUtils.BDAType.RAR)) {
                eeModuleDescriptor = new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.CONNECTOR);
            }
        }
        return eeModuleDescriptor;
    }

    private boolean isDevelopmentMode(DeploymentContext context) {
        boolean devMode = WeldUtils.isCDIDevModeEnabled((DeploymentContext)context) || Boolean.getBoolean(DEV_MODE_PROPERTY);
        WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
        if (!devMode && wDesc != null) {
            Enumeration cpEnumeration = wDesc.getContextParameters();
            while (cpEnumeration.hasMoreElements()) {
                ContextParameter param = (ContextParameter)cpEnumeration.nextElement();
                if (!DEV_MODE_PROPERTY.equals(param.getName()) || !Boolean.valueOf(param.getValue()).booleanValue()) continue;
                devMode = true;
                WeldUtils.setCDIDevMode((DeploymentContext)context, (boolean)devMode);
                break;
            }
        }
        return devMode;
    }

    private void registerWeldConversationFilter(WebBundleDescriptor webBundleDescriptor) {
        for (ServletFilterMapping filterMapping : webBundleDescriptor.getServletFilterMappings()) {
            if (!WELD_CONVERSATION_FILTER_NAME.equals(((ServletFilterMappingDescriptor)filterMapping).getDisplayName())) continue;
            ServletFilterDescriptor servletFilter = new ServletFilterDescriptor();
            servletFilter.setClassName(WELD_CONVERSATION_FILTER_CLASS);
            servletFilter.setName(WELD_CONVERSATION_FILTER_NAME);
            webBundleDescriptor.addServletFilter((ServletFilter)servletFilter);
            break;
        }
    }

    private void registerProbeFilter(WebBundleDescriptor webBundleDescriptor) {
        ServletFilterDescriptor servletFilter = new ServletFilterDescriptor();
        servletFilter.setClassName(PROBE_FILTER_CLASS_NAME);
        servletFilter.setName(PROBE_FILTER_NAME);
        servletFilter.setAsyncSupported(true);
        webBundleDescriptor.addServletFilter((ServletFilter)servletFilter);
        ServletFilterMappingDescriptor servletFilterMapping = new ServletFilterMappingDescriptor();
        servletFilterMapping.setName(PROBE_FILTER_NAME);
        servletFilterMapping.addURLPattern(PROBE_FILTER_URL_PATTERN);
        servletFilterMapping.addDispatcher(PROBE_FILTER_DISPATCHER_TYPE);
        webBundleDescriptor.addServletFilterMapping((ServletFilterMapping)servletFilterMapping);
    }

    private void registerProbeExtension(ExternalConfigurationImpl externalConfiguration, DeploymentImpl deploymentImpl) {
        externalConfiguration.setProbeEventMonitorExcludeType(PROBE_EVENT_MONITOR_EXCLUDE_TYPE);
        externalConfiguration.setProbeInvocationMonitorExcludeType(PROBE_INVOCATION_MONITOR_EXCLUDE_TYPE);
        externalConfiguration.setProbeAllowRemoteAddress(PROBE_ALLOW_REMOTE_ADDRESS);
        deploymentImpl.addDynamicExtension(this.createProbeExtension());
    }

    private void configureConcurrentDeployment(DeploymentContext context, ExternalConfigurationImpl configuration) {
        configuration.setConcurrentDeployment(WeldUtils.isConcurrentDeploymentEnabled());
        configuration.setPreLoaderThreadPoolSize(WeldUtils.getPreLoaderThreads());
    }

    private Metadata<Extension> createProbeExtension() {
        ProbeExtension probeExtension;
        Class<ProbeExtension> probeExtensionClass = ProbeExtension.class;
        try {
            probeExtension = System.getSecurityManager() != null ? (ProbeExtension)AccessController.doPrivileged(NewInstanceAction.of(probeExtensionClass)) : (ProbeExtension)probeExtensionClass.newInstance();
        }
        catch (Exception e) {
            throw new WeldException(e.getCause());
        }
        return new MetadataImpl((Object)probeExtension, "N/A");
    }

    private void addWeldListenerToAllWars(DeploymentContext context) {
        ApplicationHolder applicationHolder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (applicationHolder != null && applicationHolder.app.getBundleDescriptors(EjbBundleDescriptor.class).size() > 0) {
            Set webBundleDescriptors = applicationHolder.app.getBundleDescriptors(WebBundleDescriptor.class);
            for (WebBundleDescriptor oneWebBundleDescriptor : webBundleDescriptors) {
                oneWebBundleDescriptor.addAppListenerDescriptorToFirst((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_LISTENER));
                oneWebBundleDescriptor.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WeldTerminationListenerProxy.class.getName()));
            }
        }
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }

    private void addCdiServicesToNonModuleBdas(Iterator<RootBeanDeploymentArchive> rootBdas, InjectionManager injectionMgr) {
        if (injectionMgr != null && rootBdas != null) {
            while (rootBdas.hasNext()) {
                RootBeanDeploymentArchive oneRootBda = rootBdas.next();
                this.addCdiServicesToBda(injectionMgr, oneRootBda);
                this.addCdiServicesToBda(injectionMgr, oneRootBda.getModuleBda());
            }
        }
    }

    private void addCdiServicesToBda(InjectionManager injectionMgr, BeanDeploymentArchive bda) {
        NonModuleInjectionServices injectionServices = new NonModuleInjectionServices(injectionMgr);
        bda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
    }

    private boolean forceInitialisation(DeploymentContext context) {
        Boolean force = (Boolean)context.getTransientAppMetaData("fish.payara.faces.integration.allowFacesCdiInitialisation", Boolean.class);
        if (force != null && force.booleanValue()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("allowFacesCdiInitialisation enabled, forcing initialisation of Weld");
            }
            return true;
        }
        return false;
    }

    static {
        try {
            Util.initializeWeldSingletonProvider();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

