/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.appserv.BytecodePreprocessor;
import com.sun.appserv.ClassLoaderUtil;
import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.loader.CacheCleaner;
import com.sun.enterprise.security.integration.DDPermissionsLoader;
import com.sun.enterprise.security.integration.PermsHolder;
import com.sun.enterprise.util.io.FileUtils;
import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.JarFileResourcesProvider;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.naming.resources.WebDirContext;
import org.glassfish.api.deployment.GeneratedResourceEntry;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.ResourceClassLoader;
import org.glassfish.api.deployment.ResourceEntry;
import org.glassfish.common.util.InstanceCounter;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.web.loader.LogFacade;
import org.glassfish.web.loader.NonCachedJarStreamHandler;
import org.glassfish.web.loader.Reloader;
import org.glassfish.web.util.ExceptionUtils;
import org.glassfish.web.util.IntrospectionUtils;

public class WebappClassLoader
extends URLClassLoader
implements Reloader,
ResourceClassLoader,
InstrumentableClassLoader,
PreDestroy,
DDPermissionsLoader,
JarFileResourcesProvider {
    private static final Logger logger;
    private static final ResourceBundle rb;
    private static final String[] packageTriggers;
    private static final Permission ALL_PERMISSION;
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final boolean packageDefinitionEnabled = System.getProperty("package.definition") != null;
    protected DirContext resources = null;
    protected ConcurrentHashMap<String, ResourceEntry> resourceEntries = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> notFoundResources = new ConcurrentHashMap();
    protected int debug = 0;
    private String cookieSameSiteValue = "";
    protected boolean delegate = false;
    protected long lastJarAccessed = 0L;
    protected String[] repositories = new String[0];
    protected URL[] repositoryURLs = null;
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected final Object jarFilesLock = new Object();
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected List<String> jarNames = new ArrayList<String>();
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    private final ConcurrentLinkedQueue<Permission> permissionList = new ConcurrentLinkedQueue();
    private PermsHolder permissionsHolder;
    protected File loaderDir = null;
    protected String canonicalLoaderDir = null;
    private final ConcurrentHashMap<String, PermissionCollection> loaderPC = new ConcurrentHashMap();
    private SecurityManager securityManager = null;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    private final ConcurrentLinkedQueue<BytecodePreprocessor> byteCodePreprocessors = new ConcurrentLinkedQueue();
    private boolean useMyFaces;
    private ConcurrentLinkedQueue<String> overridablePackages;
    private volatile boolean resourcesExtracted = false;
    private boolean clearReferencesStatic = false;
    private String contextName = "unknown";
    boolean antiJARLocking = false;
    private Class<?> jdbcLeakPreventionResourceClass = null;
    private final Application application;
    private final Date creationTime = new Date();
    private boolean hotDeploy = false;
    private final InstanceCounter instanceCounter = new InstanceCounter(this);
    private static final Class<?>[] CONSTRUCTOR_ARGS_TYPES;
    private static final Object CONSTRUCTOR_ARGUMENTS;
    private static final Boolean isMultiReleaseJar;
    private static final Attributes.Name MULTI_RELEASE;

    public WebappClassLoader(Application application) {
        super(new URL[0]);
        this.application = application;
        this.init();
    }

    public WebappClassLoader(ClassLoader parent, Application application) {
        super(new URL[0], parent);
        this.application = application;
        this.init();
    }

    public WebappClassLoader(ClassLoader parent, Application application, boolean hotDeploy) {
        super(new URL[0], parent);
        this.application = application;
        this.hotDeploy = hotDeploy;
        this.init();
    }

    public WebappClassLoader(ClassLoader parent) {
        this(parent, Application.createApplication());
    }

    public WebappClassLoader(URL[] urls, ClassLoader parent, Application application) {
        super(new URL[0], parent);
        this.application = application;
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                super.addURL(url);
            }
        }
        this.init();
    }

    public synchronized void addOverridablePackage(String packageName) {
        if (this.overridablePackages == null) {
            this.overridablePackages = new ConcurrentLinkedQueue();
        }
        this.overridablePackages.add(packageName);
    }

    @Deprecated
    public DirContext getResources() {
        return null;
    }

    public void setResources(DirContext resources) {
        this.resources = resources;
        DirContext res = resources;
        if (resources instanceof ProxyDirContext) {
            ProxyDirContext proxyRes = (ProxyDirContext)res;
            this.contextName = proxyRes.getContextName();
            res = proxyRes.getDirContext();
        }
        if (res instanceof WebDirContext) {
            ((WebDirContext)res).setJarFileResourcesProvider((JarFileResourcesProvider)this);
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public ConcurrentHashMap<String, ResourceEntry> getResourceEntries() {
        return this.resourceEntries;
    }

    public Class addResourceEntry(String name, String path, ResourceEntry entry) {
        Class<?> clazz = null;
        if (!this.resourceEntries.containsKey(name)) {
            this.definePackage(name, entry);
            clazz = this.defineLoadedClass(name, entry);
            this.resourceEntries.put(name, entry);
            for (Map.Entry e : entry.generatedResources.entrySet()) {
                String generatedClassName = (String)e.getKey();
                GeneratedResourceEntry generatedEntry = (GeneratedResourceEntry)e.getValue();
                generatedEntry.loadedClass = this.defineClass(generatedClassName, generatedEntry.binaryContent, 0, generatedEntry.binaryContent.length, generatedEntry.protectionDomain);
            }
        }
        return clazz;
    }

    public Class reloadResourceEntry(String name, String path, ResourceEntry entry) {
        try {
            InputStream binaryStream = null;
            Resource resource = null;
            Object lookupResult = this.resources.lookup(path);
            if (lookupResult instanceof Resource) {
                resource = (Resource)lookupResult;
            }
            ResourceAttributes attributes = (ResourceAttributes)this.resources.getAttributes(path);
            int contentLength = (int)attributes.getContentLength();
            entry.lastModified = attributes.getLastModified();
            if (resource != null) {
                try {
                    binaryStream = resource.streamContent();
                }
                catch (IOException e) {
                    return null;
                }
            }
            this.readEntryData(entry, name, binaryStream, contentLength, null);
            return this.loadClass(name);
        }
        catch (ClassNotFoundException | NamingException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Class addGeneratedResourceEntry(String mainClassName, String generatedClassName, byte[] generatedBinaryContent, ProtectionDomain protectionDomain) {
        Class<?> generatedClass;
        if (this.resourceEntries.containsKey(mainClassName)) {
            generatedClass = this.defineClass(generatedClassName, generatedBinaryContent, 0, generatedBinaryContent.length, protectionDomain);
            GeneratedResourceEntry generatedResourceEntry = new GeneratedResourceEntry();
            generatedResourceEntry.binaryContent = generatedBinaryContent;
            generatedResourceEntry.loadedClass = generatedClass;
            generatedResourceEntry.protectionDomain = protectionDomain;
            ResourceEntry entry = this.resourceEntries.get(mainClassName);
            entry.generatedResources.put(generatedClassName, generatedResourceEntry);
        } else {
            generatedClass = this.defineClass(generatedClassName, generatedBinaryContent, 0, generatedBinaryContent.length, protectionDomain);
        }
        return generatedClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getCookieSameSiteValue() {
        return this.cookieSameSiteValue;
    }

    public void setCookieSameSiteValue(String cookieSameSiteValue) {
        this.cookieSameSiteValue = cookieSameSiteValue;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        this.antiJARLocking = antiJARLocking;
    }

    public JarFile[] getJarFiles() {
        if (!this.openJARs()) {
            return null;
        }
        return this.jarFiles;
    }

    public void addPermission(String path) {
        if (path == null) {
            return;
        }
        if (this.securityManager != null) {
            this.securityManager.checkSecurityAccess("createPolicy.eepermissions");
            Object permission = null;
            if (((String)path).startsWith("jndi:") || ((String)path).startsWith("jar:jndi:")) {
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                permission = new JndiPermission((String)path + "*");
                this.permissionList.add((Permission)permission);
            } else {
                if (!((String)path).endsWith(File.separator)) {
                    permission = new FilePermission((String)path, "read");
                    this.permissionList.add((Permission)permission);
                    path = (String)path + File.separator;
                }
                permission = new FilePermission((String)path + "-", "read");
                this.permissionList.add((Permission)permission);
            }
        }
    }

    public void addPermission(URL url) {
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.securityManager.checkSecurityAccess("createPolicy.eepermissions");
            this.permissionList.add(permission);
        }
    }

    @Override
    public void addDeclaredPermissions(PermissionCollection declaredPc) throws SecurityException {
        if (this.securityManager != null) {
            this.securityManager.checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setDeclaredPermissions(declaredPc);
        }
    }

    @Override
    public void addEEPermissions(PermissionCollection eePc) throws SecurityException {
        if (this.securityManager != null) {
            this.securityManager.checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setEEPermissions(eePc);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setWorkDir(File workDir) {
        this.loaderDir = new File(workDir, "loader_" + this.hashCode());
        try {
            this.canonicalLoaderDir = this.loaderDir.getCanonicalPath();
            if (!this.canonicalLoaderDir.endsWith(File.separator)) {
                this.canonicalLoaderDir = this.canonicalLoaderDir + File.separator;
            }
        }
        catch (IOException ioe) {
            this.canonicalLoaderDir = null;
        }
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
        if (useMyFaces) {
            this.addOverridablePackage("jakarta.faces");
            this.addOverridablePackage("com.sun.faces");
        }
    }

    public boolean getClearReferencesStatic() {
        return this.clearReferencesStatic;
    }

    public void setClearReferencesStatic(boolean clearReferencesStatic) {
        this.clearReferencesStatic = clearReferencesStatic;
    }

    @Override
    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            this.addRepository(new URL(repository));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid repository: " + repository, e);
        }
    }

    public void addRepository(URL url) {
        super.addURL(url);
        this.hasExternalRepositories = true;
    }

    public synchronized void addRepository(String repository, File file) {
        if (repository == null) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "addRepository({0})", repository);
        }
        String[] result = new String[this.repositories.length + 1];
        for (int i = 0; i < this.repositories.length; ++i) {
            result[i] = this.repositories[i];
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        for (int i = 0; i < this.files.length; ++i) {
            result2[i] = this.files[i];
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "addJar({0})", jar);
        }
        Object object = this.jarFilesLock;
        synchronized (object) {
            super.addURL(this.getURL(file));
            if (this.jarPath != null && jar.startsWith(this.jarPath)) {
                String jarName = jar.substring(this.jarPath.length());
                while (jarName.startsWith("/")) {
                    jarName = jarName.substring(1);
                }
                this.jarNames.add(jarName);
            }
            try {
                long lastModified = ((ResourceAttributes)this.resources.getAttributes(jar)).getLastModified();
                String[] result = new String[this.paths.length + 1];
                for (int i = 0; i < this.paths.length; ++i) {
                    result[i] = this.paths[i];
                }
                result[this.paths.length] = jar;
                this.paths = result;
                long[] result3 = new long[this.lastModifiedDates.length + 1];
                for (int i = 0; i < this.lastModifiedDates.length; ++i) {
                    result3[i] = this.lastModifiedDates[i];
                }
                result3[this.lastModifiedDates.length] = lastModified;
                this.lastModifiedDates = result3;
            }
            catch (NamingException lastModified) {
                // empty catch block
            }
            JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
            for (int i = 0; i < this.jarFiles.length; ++i) {
                result2[i] = this.jarFiles[i];
            }
            result2[this.jarFiles.length] = jarFile;
            this.jarFiles = result2;
            File[] result4 = new File[this.jarRealFiles.length + 1];
            for (int i = 0; i < this.jarRealFiles.length; ++i) {
                result4[i] = this.jarRealFiles[i];
            }
            result4[this.jarRealFiles.length] = file;
            this.jarRealFiles = result4;
        }
    }

    @Override
    public boolean modified() {
        int lastModifiedDatesLength;
        int pathsLength;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "modified()");
        }
        if ((pathsLength = this.paths.length) > (lastModifiedDatesLength = this.lastModifiedDates.length)) {
            pathsLength = lastModifiedDatesLength;
        }
        for (int i = 0; i < pathsLength; ++i) {
            try {
                long lastModified = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (lastModified == this.lastModifiedDates[i]) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "  Resource ''{0}'' was modified; Date is now: {1} Was: {2}", new Object[]{this.paths[i], new Date(lastModified), new Date(this.lastModifiedDates[i])});
                }
                return true;
            }
            catch (NamingException e) {
                logger.log(Level.SEVERE, "AS-WEB-UTIL-00001", this.paths[i]);
                return true;
            }
        }
        pathsLength = this.jarNames.size();
        if (this.getJarPath() != null) {
            try {
                String name;
                NameClassPair ncPair;
                NamingEnumeration<Binding> enumeration = this.resources.listBindings(this.getJarPath());
                int i = 0;
                while (enumeration.hasMoreElements() && i < pathsLength) {
                    ncPair = (NameClassPair)enumeration.nextElement();
                    name = ncPair.getName();
                    if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                    if (!name.equals(this.jarNames.get(i))) {
                        logger.log(Level.FINER, "    Additional JARs have been added : ''{0}''", name);
                        return true;
                    }
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        ncPair = (NameClassPair)enumeration.nextElement();
                        name = ncPair.getName();
                        if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                        logger.log(Level.FINER, "    Additional JARs have been added");
                        return true;
                    }
                } else if (i < this.jarNames.size()) {
                    logger.log(Level.FINER, "    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "    Failed tracking modifications of ''{0}''", this.getJarPath());
                }
            }
            catch (ClassCastException e) {
                logger.log(Level.SEVERE, "AS-WEB-UTIL-00002", new Object[]{this.getJarPath(), e.getMessage()});
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Predicate<String> matchesInternal = str -> str.matches(".*generated/.*__.*");
        boolean isInternal = false;
        if (this.repositoryURLs != null) {
            isInternal = Arrays.stream(this.repositoryURLs).map(URL::toString).filter(matchesInternal).findAny().isPresent();
        }
        if (this.canonicalLoaderDir != null && matchesInternal.test(this.canonicalLoaderDir)) {
            isInternal = true;
        }
        if (isInternal) {
            sb.append("(internal) ");
        }
        sb.append("WebappClassLoader (delegate=");
        sb.append(this.delegate);
        if (this.repositoryURLs != null) {
            sb.append("; repositoryURLs=");
            for (int i = 0; i < this.repositoryURLs.length; ++i) {
                sb.append(this.repositoryURLs[i]);
                if (i == this.repositoryURLs.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(") ");
        sb.append("JarNames: ").append(this.jarNames).append("; ");
        sb.append("canonicalLoaderDir: ").append(this.canonicalLoaderDir).append("; ");
        sb.append("Object: ").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" Created: ").append(SimpleDateFormat.getDateTimeInstance().format(this.creationTime));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "    findClass({0})", name);
        }
        if (this.securityManager != null && this.packageDefinitionEnabled && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "      findClassInternal({0})", name);
            }
            try {
                ResourceEntry entry = this.findClassInternal(name);
                WebappClassLoader webappClassLoader = this;
                synchronized (webappClassLoader) {
                    clazz = entry.loadedClass == null ? this.defineLoadedClass(name, entry) : entry.loadedClass;
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.hasExternalRepositories) {
                    throw cnfe;
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(WebappClassLoader.getString("AS-WEB-UTIL-00005", name, this.getJavaVersion()));
            }
            catch (AccessControlException ace) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "AS-WEB-UTIL-00003", new Object[]{name, ace.getMessage()});
                }
                throw new ClassNotFoundException(name, ace);
            }
            catch (Error | RuntimeException rex) {
                throw rex;
            }
            catch (Throwable t) {
                throw new RuntimeException(WebappClassLoader.getString("AS-WEB-UTIL-00006", name, t.toString()), t);
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    if (logger.isLoggable(Level.WARNING)) {
                        String msg = WebappClassLoader.getString("AS-WEB-UTIL-00003", name, ace.getMessage());
                        logger.log(Level.WARNING, msg, ace);
                    }
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "      -->RuntimeException Rethrown", e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "    --> Passing on ClassNotFoundException");
            }
            throw e;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "      Returning class {0}", clazz);
        }
        if (logger.isLoggable(Level.FINER)) {
            ClassLoader cl = this.securityManager != null ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            logger.log(Level.FINER, "      Loaded by {0}", cl);
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        ResourceEntry entry;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "    findResource({0})", name);
        }
        URL url = null;
        if (".".equals(name)) {
            name = "";
        }
        if ((entry = this.resourceEntries.get(name)) == null) {
            entry = this.findResourceInternal(name, name);
        }
        if (entry != null) {
            url = entry.source;
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        if (logger.isLoggable(Level.FINER)) {
            if (url != null) {
                logger.log(Level.FINER, "    --> Returning ''{0}''", url.toString());
            } else {
                logger.log(Level.FINER, "    --> Resource not found, returning null");
            }
        }
        return NonCachedJarStreamHandler.forceNonCachedJarURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "    findResources({0})", name);
        }
        ArrayList<URL> result = new ArrayList<URL>();
        if (this.repositories != null) {
            Object object = this.jarFilesLock;
            synchronized (object) {
                int repositoriesLength = this.repositories.length;
                for (int i = 0; i < repositoriesLength; ++i) {
                    try {
                        String fullPath = this.repositories[i] + name;
                        this.resources.lookup(fullPath);
                        try {
                            result.add(this.getURI(new File(this.files[i], name)));
                        }
                        catch (MalformedURLException malformedURLException) {}
                        continue;
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
            }
        }
        Enumeration<URL> otherResourcePaths = super.findResources(name);
        while (otherResourcePaths.hasMoreElements()) {
            result.add(otherResourcePaths.nextElement());
        }
        return Collections.enumeration(result.stream().map(NonCachedJarStreamHandler::forceNonCachedJarURL).collect(Collectors.toList()));
    }

    @Override
    public URL getResource(String name) {
        ClassLoader loader;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "getResource({0})", name);
        }
        URL url = null;
        if (this.isResourceDelegate(name)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0}  Delegating to parent classloader ", this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "  --> Returning ''{0}''", url.toString());
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (this.antiJARLocking) {
                ResourceEntry entry = this.resourceEntries.get(name);
                try {
                    String repository = entry.codeBase.toString();
                    if (repository.endsWith(".jar") && !name.endsWith(".class") && !name.endsWith(".jar")) {
                        File resourceFile = new File(this.loaderDir, name);
                        url = resourceFile.toURI().toURL();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.FINEST, null, e);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  --> Returning ''{0}''", url.toString());
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "  --> Returning ''{0}''", url.toString());
                }
                return url;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "getResourceAsStream({0})", name);
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.isResourceDelegate(name)) {
            ClassLoader loader;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  Delegating to parent classloader {0}", this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException e) {
                logger.log(Level.FINEST, null, e);
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  Delegating to parent classloader unconditionally {0}", this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(final String name) throws IOException {
        final Enumeration[] enums = new Enumeration[2];
        if (name.startsWith(META_INF_SERVICES) && this.application.isWhitelistEnabled() && !DOLUtils.isWhiteListed((Application)this.application, (String)name)) {
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public URL nextElement() {
                    throw new NoSuchElementException(String.format("Resource: %s is not whitelisted", name));
                }
            };
        }
        Enumeration<URL> localResources = this.findResources(name);
        Enumeration<URL> parentResources = null;
        parentResources = this.parent != null ? this.parent.getResources(name) : this.system.getResources(name);
        if (this.delegate) {
            enums[0] = parentResources;
            enums[1] = localResources;
        } else {
            enums[0] = localResources;
            enums[1] = parentResources;
        }
        return new Enumeration<URL>(){
            int index = 0;

            private boolean next() {
                while (this.index < enums.length) {
                    if (enums[this.index] != null && enums[this.index].hasMoreElements()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                return (URL)enums[this.index].nextElement();
            }
        };
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean delegateLoad;
        ClassLoader delegateLoader;
        int i;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "loadClass({0})", name);
        }
        Class<?> clazz = null;
        if (!this.started) {
            throw new IllegalStateException(WebappClassLoader.getString("AS-WEB-UTIL-00010", name));
        }
        clazz = this.findLoadedClass0(name);
        if (clazz != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && this.packageDefinitionEnabled && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = WebappClassLoader.getString("AS-WEB-UTIL-00004", name);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, error, se);
                }
                throw new ClassNotFoundException(error, se);
            }
        }
        if ((delegateLoader = this.parent) == null) {
            delegateLoader = this.system;
        }
        boolean isWhitelisted = this.application.isWhitelistEnabled() && DOLUtils.isWhiteListed((Application)this.application, (String)name);
        boolean bl = delegateLoad = this.delegate && (!this.application.isWhitelistEnabled() || isWhitelisted) || this.filter(name);
        if (delegateLoad) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  Delegating to classloader1 {0}", delegateLoader);
            }
            try {
                clazz = delegateLoader.loadClass(name);
                if (clazz != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "  Loading class from delegate");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.useMyFaces && !delegateLoad && (name.startsWith("javax.faces") || name.startsWith("jakarta.faces") || name.startsWith("com.sun.faces"))) {
            throw new ClassNotFoundException(String.format("Class [%s] could not be found in bundled JSF", name));
        }
        if (!(this.application.isWhitelistEnabled() && !isWhitelisted || delegateLoad)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "  Delegating to classloader {0}", delegateLoader);
            }
            try {
                clazz = delegateLoader.loadClass(name);
                if (clazz != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "  Loading class from delegate");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else if (this.application.isWhitelistEnabled() && !isWhitelisted) {
            throw new ClassNotFoundException(String.format("Whitelist enabled, but class [%s] is not whitelisted", name));
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc == null) {
            PermissionCollection tmpPc;
            pc = new Permissions();
            PermissionCollection spc = super.getPermissions(codeSource);
            Enumeration<Permission> permsa = spc.elements();
            while (permsa.hasMoreElements()) {
                Permission p = permsa.nextElement();
                pc.add(p);
            }
            for (Permission permission : this.permissionList) {
                pc.add(permission);
            }
            PermissionCollection pc1 = this.permissionsHolder.getPermissions(codeSource, null);
            if (pc1 != null) {
                Enumeration<Permission> dperms = pc1.elements();
                while (dperms.hasMoreElements()) {
                    Permission p = dperms.nextElement();
                    pc.add(p);
                }
            }
            if ((tmpPc = this.loaderPC.putIfAbsent(codeUrl, pc)) != null) {
                pc = tmpPc;
            }
        }
        return pc;
    }

    @Override
    public synchronized URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return this.repositoryURLs;
        }
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int length = filesLength + jarFilesLength + external.length;
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < length; ++i) {
                if (i < filesLength) {
                    urls.add(i, this.getURL(this.files[i]));
                    continue;
                }
                if (i < filesLength + jarFilesLength) {
                    urls.add(i, this.getURL(this.jarRealFiles[i - filesLength]));
                    continue;
                }
                urls.add(i, external[i - filesLength - jarFilesLength]);
            }
            this.repositoryURLs = this.removeDuplicate(urls);
        }
        catch (MalformedURLException e) {
            this.repositoryURLs = new URL[0];
        }
        return this.repositoryURLs;
    }

    private URL[] removeDuplicate(ArrayList<URL> urls) {
        HashSet<URL> h = new HashSet<URL>(urls);
        urls.clear();
        urls.addAll(h);
        return urls.toArray(new URL[urls.size()]);
    }

    private void init() {
        this.parent = this.getParent();
        this.system = this.getClass().getClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
        this.addOverridablePackage("com.sun.faces.extensions");
        this.permissionsHolder = new PermsHolder();
    }

    public void start() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void preDestroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        ClassLoader curCl = null;
        try {
            curCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this);
            this.clearReferences();
        }
        finally {
            if (curCl != null) {
                Thread.currentThread().setContextClassLoader(curCl);
            }
        }
        ClassLoaderUtil.releaseLoader((URLClassLoader)this);
        CacheCleaner.clearCaches(this);
        Object object = this.jarFilesLock;
        synchronized (object) {
            int i;
            this.started = false;
            int length = this.files.length;
            for (i = 0; i < length; ++i) {
                this.files[i] = null;
            }
            length = this.jarFiles.length;
            for (i = 0; i < length; ++i) {
                try {
                    if (this.jarFiles[i] != null) {
                        this.jarFiles[i].close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.jarFiles[i] = null;
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notFoundResources.clear();
            this.resourceEntries.clear();
            this.resources = null;
            this.repositories = null;
            this.repositoryURLs = null;
            this.files = null;
            this.jarFiles = null;
            this.jarRealFiles = null;
            this.jarPath = null;
            this.jarNames.clear();
            this.lastModifiedDates = null;
            this.paths = null;
            this.hasExternalRepositories = false;
            this.parent = null;
            this.permissionList.clear();
            this.permissionsHolder = null;
            this.loaderPC.clear();
            if (this.loaderDir != null) {
                WebappClassLoader.deleteDir(this.loaderDir);
            }
            DirContextURLStreamHandler.unbind((ClassLoader)this);
            MainHelper.HotSwapHelper.closeClassLoader((ClassLoader)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeJARs(boolean force) {
        if (this.jarFiles.length > 0) {
            Object object = this.jarFilesLock;
            synchronized (object) {
                if (force || System.currentTimeMillis() > this.lastJarAccessed + 90000L) {
                    for (int i = 0; i < this.jarFiles.length; ++i) {
                        try {
                            if (this.jarFiles[i] == null) continue;
                            this.jarFiles[i].close();
                            this.jarFiles[i] = null;
                            continue;
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, "Failed to close JAR", e);
                        }
                    }
                    try {
                        WeakHashMap closeables;
                        Field closeField = URLClassLoader.class.getDeclaredField("closeables");
                        closeField.setAccessible(true);
                        WeakHashMap weakHashMap = closeables = (WeakHashMap)closeField.get(this);
                        synchronized (weakHashMap) {
                            Set keys = closeables.keySet();
                            for (Closeable c : keys) {
                                try {
                                    if (!(c instanceof JarFile)) continue;
                                    c.close();
                                }
                                catch (IOException iOException) {}
                            }
                            closeables.clear();
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(WebappClassLoader.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    protected void clearReferences() {
        this.clearReferencesJdbc();
        this.checkThreadLocalsForLeaks();
        this.clearReferencesRmiTargets();
        if (this.clearReferencesStatic) {
            this.clearReferencesStaticFinal();
        }
        IntrospectionUtils.clear();
        this.clearReferencesResourceBundles();
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearReferencesJdbc() {
        InputStream is = this.getResourceAsStream("org/glassfish/web/loader/JdbcLeakPrevention.class");
        byte[] classBytes = new byte[2048];
        int offset = 0;
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            if (this.jdbcLeakPreventionResourceClass == null) {
                int read = is.read(classBytes, offset, classBytes.length - offset);
                while (read > -1) {
                    if ((offset += read) == classBytes.length) {
                        byte[] tmp = new byte[classBytes.length * 2];
                        System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                        classBytes = tmp;
                    }
                    read = is.read(classBytes, offset, classBytes.length - offset);
                }
                this.jdbcLeakPreventionResourceClass = this.defineClass("org.glassfish.web.loader.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
            } else {
                logger.log(Level.FINE, WebappClassLoader.getString("AS-WEB-UTIL-00040", this.contextName));
            }
        }
        Object obj = this.jdbcLeakPreventionResourceClass.newInstance();
        List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
        String msg = rb.getString("AS-WEB-UTIL-00007");
        for (String name : driverNames) {
            logger.warning(MessageFormat.format(msg, this.contextName, name));
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00009", this.contextName), ioe);
        }
        return;
        catch (Exception e) {
            try {
                Throwable t = ExceptionUtils.unwrapInvocationTargetException(e);
                ExceptionUtils.handleThrowable(t);
                logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00008", this.contextName), t);
                if (is == null) return;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00009", this.contextName), ioe);
                }
                throw throwable;
            }
            try {
                is.close();
                return;
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00009", this.contextName), ioe);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void clearReferencesStaticFinal() {
        Field[] fields2;
        Class clazz;
        Collection<ResourceEntry> values = this.resourceEntries.values();
        block10: for (ResourceEntry entry : values) {
            clazz = null;
            Field[] fieldArray = this;
            // MONITORENTER : this
            clazz = entry.loadedClass;
            // MONITOREXIT : fieldArray
            if (clazz == null) continue;
            try {
                for (Field field : fields2 = clazz.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers())) continue;
                    field.get(null);
                    continue block10;
                }
            }
            catch (Throwable fields2) {
            }
        }
        Iterator<ResourceEntry> loadedClasses = values.iterator();
        block12: while (loadedClasses.hasNext()) {
            ResourceEntry entry;
            entry = loadedClasses.next();
            clazz = null;
            fields2 = this;
            // MONITORENTER : this
            clazz = entry.loadedClass;
            // MONITOREXIT : fields2
            if (clazz == null) continue;
            try {
                Field[] fieldArray = fields2 = clazz.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (true) {
                    block18: {
                        Field field;
                        if (n2 >= n) continue block12;
                        field = fieldArray[n2];
                        int mods = field.getModifiers();
                        if (!field.getType().isPrimitive() && field.getName().indexOf(36) == -1 && Modifier.isStatic(mods)) {
                            try {
                                this.setAccessible(field);
                                if (Modifier.isFinal(mods)) {
                                    if (!(field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.") || field.getType().getName().startsWith("jakarta."))) {
                                        this.nullInstance(field.get(null));
                                    }
                                    break block18;
                                }
                                field.set(null, null);
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "Set field {0} to null in class {1}", new Object[]{field.getName(), clazz.getName()});
                                }
                            }
                            catch (Throwable t) {
                                ExceptionUtils.handleThrowable(t);
                                if (!logger.isLoggable(Level.FINE)) break block18;
                                logger.log(Level.FINE, "Could not set field " + field.getName() + " to null in class " + clazz.getName(), t);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Could not clean fields for class " + clazz.getName(), t);
            }
        }
    }

    protected void nullInstance(Object instance) {
        Field[] fields;
        if (instance == null) {
            return;
        }
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf(36) != -1) continue;
            try {
                Object value;
                this.setAccessible(field);
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods) || null == (value = field.get(instance))) continue;
                Class<?> valueClass = value.getClass();
                if (!this.loadedByThisOrChild(valueClass)) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Not setting field {0} to null in object of class {1} because the referenced object was of type {2} which was not loaded by this WebappClassLoader.", new Object[]{field.getName(), instance.getClass().getName(), valueClass.getName()});
                    continue;
                }
                field.set(instance, null);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Set field {0} to null in class {1}", new Object[]{field.getName(), instance.getClass().getName()});
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName(), t);
            }
        }
    }

    private void checkThreadLocalsForLeaks() {
        block4: {
            Thread[] threads = this.getThreads();
            try {
                Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
                threadLocalsField.setAccessible(true);
                Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
                inheritableThreadLocalsField.setAccessible(true);
                Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                Field tableField = tlmClass.getDeclaredField("table");
                tableField.setAccessible(true);
                Method expungeStaleEntriesMethod = tlmClass.getDeclaredMethod("expungeStaleEntries", new Class[0]);
                expungeStaleEntriesMethod.setAccessible(true);
                for (Thread thread : threads) {
                    if (thread == null) continue;
                    Object threadLocalMap = threadLocalsField.get(thread);
                    if (null != threadLocalMap) {
                        expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                        this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                    }
                    if (null == (threadLocalMap = inheritableThreadLocalsField.get(thread))) continue;
                    expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00011", this.contextName), e);
            }
        }
    }

    private void checkThreadLocalMapForLeaks(Object map, Field internalTableField) throws IllegalAccessException, NoSuchFieldException {
        Object[] table;
        if (map != null && (table = (Object[])internalTableField.get(map)) != null) {
            for (int j = 0; j < table.length; ++j) {
                if (table[j] == null) continue;
                boolean potentialLeak = false;
                Object key = ((Reference)table[j]).get();
                if (this.equals(key) || this.loadedByThisOrChild(key)) {
                    potentialLeak = true;
                }
                Field valueField = table[j].getClass().getDeclaredField("value");
                valueField.setAccessible(true);
                Object value = valueField.get(table[j]);
                if (this.equals(value) || this.loadedByThisOrChild(value)) {
                    potentialLeak = true;
                }
                if (!potentialLeak) continue;
                Object[] args = new Object[5];
                args[0] = this.contextName;
                if (key != null) {
                    args[1] = this.getPrettyClassName(key.getClass());
                    try {
                        args[2] = key.toString();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, WebappClassLoader.getString("AS-WEB-UTIL-00012", args[1]), e);
                        args[2] = WebappClassLoader.getString("AS-WEB-UTIL-00013", new Object[0]);
                    }
                }
                if (value != null) {
                    args[3] = this.getPrettyClassName(value.getClass());
                    try {
                        args[4] = value.toString();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, WebappClassLoader.getString("AS-WEB-UTIL-00014", args[3]), e);
                        args[4] = WebappClassLoader.getString("AS-WEB-UTIL-00013", new Object[0]);
                    }
                }
                if (value == null) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, WebappClassLoader.getString("AS-WEB-UTIL-00015", args));
                    continue;
                }
                logger.log(Level.SEVERE, WebappClassLoader.getString("AS-WEB-UTIL-00016", args));
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    private boolean loadedByThisOrChild(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        for (ClassLoader cl = clazz.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != this) continue;
            return true;
        }
        if (o instanceof Collection) {
            for (Object entry : (Collection)o) {
                if (!this.loadedByThisOrChild(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    private void clearReferencesRmiTargets() {
        block10: {
            try {
                Class<?> objectTargetClass = Class.forName("sun.rmi.transport.Target");
                Field cclField = objectTargetClass.getDeclaredField("ccl");
                cclField.setAccessible(true);
                Class<?> objectTableClass = Class.forName("sun.rmi.transport.ObjectTable");
                Field objTableField = objectTableClass.getDeclaredField("objTable");
                objTableField.setAccessible(true);
                Object objTable = objTableField.get(null);
                if (objTable == null) {
                    return;
                }
                if (objTable instanceof Map) {
                    Iterator iter = ((Map)objTable).values().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        Object cclObject = cclField.get(obj);
                        if (this != cclObject) continue;
                        iter.remove();
                    }
                }
                Field implTableField = objectTableClass.getDeclaredField("implTable");
                implTableField.setAccessible(true);
                Object implTable = implTableField.get(null);
                if (implTable == null) {
                    return;
                }
                if (implTable instanceof Map) {
                    Iterator iter = ((Map)implTable).values().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        Object cclObject = cclField.get(obj);
                        if (this != cclObject) continue;
                        iter.remove();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, WebappClassLoader.getString("AS-WEB-UTIL-00017", this.contextName), e);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                if (!logger.isLoggable(Level.WARNING)) break block10;
                logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00018", this.contextName), e);
            }
        }
    }

    private void clearReferencesResourceBundles() {
        block8: {
            try {
                Field cacheListField = ResourceBundle.class.getDeclaredField("cacheList");
                cacheListField.setAccessible(true);
                Map cacheList = (Map)cacheListField.get(null);
                Set keys = cacheList.keySet();
                Field loaderRefField = null;
                Iterator keysIter = keys.iterator();
                int countRemoved = 0;
                while (keysIter.hasNext()) {
                    ClassLoader loader;
                    WeakReference loaderRef;
                    Object key = keysIter.next();
                    if (loaderRefField == null) {
                        loaderRefField = key.getClass().getDeclaredField("loaderRef");
                        loaderRefField.setAccessible(true);
                    }
                    if ((loaderRef = (WeakReference)loaderRefField.get(key)) == null) continue;
                    for (loader = (ClassLoader)loaderRef.get(); loader != null && loader != this; loader = loader.getParent()) {
                    }
                    if (loader == null) continue;
                    keysIter.remove();
                    ++countRemoved;
                }
                if (countRemoved > 0 && logger.isLoggable(Level.FINE)) {
                    logger.fine(WebappClassLoader.getString("AS-WEB-UTIL-00019", countRemoved, this.contextName));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                logger.log(Level.SEVERE, WebappClassLoader.getString("AS-WEB-UTIL-00020", this.contextName), e);
            }
            catch (NoSuchFieldException e) {
                String msg = WebappClassLoader.getString("AS-WEB-UTIL-00020", this.contextName);
                if (System.getProperty("java.vendor").startsWith("Sun")) {
                    logger.log(Level.SEVERE, msg, e);
                }
                if (!logger.isLoggable(Level.FINE)) break block8;
                logger.log(Level.FINE, msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean openJARs() {
        if (this.started && this.jarFiles.length > 0) {
            Object object = this.jarFilesLock;
            synchronized (object) {
                this.lastJarAccessed = System.currentTimeMillis();
                if (this.jarFiles[0] == null) {
                    for (int i = 0; i < this.jarFiles.length; ++i) {
                        try {
                            this.jarFiles[i] = WebappClassLoader.newJarFile(this.jarRealFiles[i]);
                            continue;
                        }
                        catch (IOException e) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Failed to open JAR", e);
                            }
                            for (int j = 0; j < i; ++j) {
                                try {
                                    this.jarFiles[j].close();
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = tempPath + ".class";
        ResourceEntry entry = this.findResourceInternal(name, classPath);
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            Class clazz = entry.loadedClass;
            if (clazz != null) {
                return entry;
            }
            if (entry.binaryContent == null) {
                throw new ClassNotFoundException(name);
            }
        }
        this.definePackage(name, entry);
        return entry;
    }

    private ResourceEntry findResourceInternal(File file, String path) {
        ResourceEntry entry = new ResourceEntry();
        try {
            entry.source = this.getURI(new File(file, path));
            entry.codeBase = this.getURL(new File(file, path));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        if (!this.started) {
            throw new IllegalStateException(WebappClassLoader.getString("AS-WEB-UTIL-00010", name));
        }
        if (name == null || path == null) {
            return null;
        }
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry;
        }
        if (this.notFoundResources.containsKey(name)) {
            return null;
        }
        entry = this.findResourceInternalFromRepositories(name, path);
        if (entry == null) {
            Object object = this.jarFilesLock;
            synchronized (object) {
                entry = this.findResourceInternalFromJars(name, path);
            }
        }
        if (entry == null) {
            this.notFoundResources.put(name, name);
            return null;
        }
        ResourceEntry entry2 = this.resourceEntries.putIfAbsent(name, entry);
        if (entry2 != null) {
            entry = entry2;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceEntry findResourceInternalFromRepositories(String name, String path) {
        if (this.repositories == null) {
            return null;
        }
        ResourceEntry entry = null;
        int contentLength = -1;
        InputStream binaryStream = null;
        int repositoriesLength = this.repositories.length;
        Resource resource = null;
        for (int i = 0; entry == null && i < repositoriesLength; ++i) {
            try {
                String fullPath = this.repositories[i] + path;
                Object lookupResult = this.resources.lookup(fullPath);
                if (lookupResult instanceof Resource) {
                    resource = (Resource)lookupResult;
                }
                if (this.securityManager != null) {
                    PrivilegedFindResource dp = new PrivilegedFindResource(this.files[i], path);
                    entry = AccessController.doPrivileged(dp);
                } else {
                    entry = this.findResourceInternal(this.files[i], path);
                }
                ResourceAttributes attributes = (ResourceAttributes)this.resources.getAttributes(fullPath);
                contentLength = (int)attributes.getContentLength();
                entry.lastModified = attributes.getLastModified();
                if (resource == null) continue;
                try {
                    binaryStream = resource.streamContent();
                }
                catch (IOException e) {
                    return null;
                }
                Permission permission = ALL_PERMISSION;
                synchronized (permission) {
                    int j;
                    long[] result2 = new long[this.lastModifiedDates.length + 1];
                    for (j = 0; j < this.lastModifiedDates.length; ++j) {
                        result2[j] = this.lastModifiedDates[j];
                    }
                    result2[this.lastModifiedDates.length] = entry.lastModified;
                    this.lastModifiedDates = result2;
                    String[] result = new String[this.paths.length + 1];
                    for (j = 0; j < this.paths.length; ++j) {
                        result[j] = this.paths[j];
                    }
                    result[this.paths.length] = fullPath;
                    this.paths = result;
                    continue;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (entry != null) {
            this.readEntryData(entry, name, binaryStream, contentLength, null);
        }
        return entry;
    }

    private ResourceEntry findResourceInternalFromJars(String name, String path) {
        ResourceEntry entry = null;
        JarEntry jarEntry = null;
        int contentLength = -1;
        InputStream binaryStream = null;
        if (!this.openJARs()) {
            return null;
        }
        int jarFilesLength = this.jarFiles.length;
        for (int i = 0; entry == null && i < jarFilesLength; ++i) {
            File resourceFile;
            jarEntry = this.jarFiles[i].getJarEntry(path);
            if (jarEntry == null) continue;
            entry = new ResourceEntry();
            try {
                entry.codeBase = this.getURL(this.jarRealFiles[i]);
                Object jarFakeUrl = this.getURI(this.jarRealFiles[i]).toString();
                jarFakeUrl = "jar:" + (String)jarFakeUrl + "!/" + path;
                entry.source = new URL((String)jarFakeUrl);
                entry.lastModified = this.jarRealFiles[i].lastModified();
            }
            catch (MalformedURLException e) {
                return null;
            }
            contentLength = (int)jarEntry.getSize();
            try {
                entry.manifest = this.jarFiles[i].getManifest();
                binaryStream = this.jarFiles[i].getInputStream(jarEntry);
            }
            catch (IOException e) {
                return null;
            }
            if (!this.antiJARLocking || path.endsWith(".class") || (resourceFile = new File(this.loaderDir, jarEntry.getName())).exists()) continue;
            this.extractResources();
        }
        if (entry != null) {
            this.readEntryData(entry, name, binaryStream, contentLength, jarEntry);
        }
        return entry;
    }

    private synchronized void extractResources() {
        if (!this.antiJARLocking || this.resourcesExtracted) {
            return;
        }
        for (int i = this.jarFiles.length - 1; i >= 0; --i) {
            this.extractResource(this.jarFiles[i]);
        }
        this.resourcesExtracted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractResource(JarFile jarFile) {
        byte[] buf = new byte[1024];
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry2 = entries.nextElement();
            if (jarEntry2.isDirectory() || jarEntry2.getName().endsWith(".class")) continue;
            File resourceFile = new File(this.loaderDir, jarEntry2.getName());
            try {
                if (!resourceFile.getCanonicalPath().startsWith(this.canonicalLoaderDir)) {
                    throw new IllegalArgumentException(WebappClassLoader.getString("AS-WEB-UTIL-00021", jarEntry2.getName()));
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(WebappClassLoader.getString("AS-WEB-UTIL-00022", jarEntry2.getName(), ioe));
            }
            if (!FileUtils.mkdirsMaybe(resourceFile.getParentFile())) {
                logger.log(Level.WARNING, "AS-WEB-UTIL-00023", resourceFile.getParentFile().toString());
            }
            FileOutputStream os = null;
            InputStream is = null;
            try {
                int n;
                is = jarFile.getInputStream(jarEntry2);
                os = new FileOutputStream(resourceFile);
                while ((n = is.read(buf)) > 0) {
                    os.write(buf, 0, n);
                }
            }
            catch (IOException iOException) {}
            continue;
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (os == null) continue;
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getExtractedResourcePath(String path) {
        this.extractResources();
        File extractedResource = new File(this.loaderDir, path);
        return extractedResource.exists() ? extractedResource : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEntryData(ResourceEntry entry, String name, InputStream binaryStream, int contentLength, JarEntry jarEntry) {
        if (binaryStream == null) {
            return;
        }
        byte[] binaryContent = new byte[contentLength];
        try {
            int n;
            int pos = 0;
            while ((n = binaryStream.read(binaryContent, pos, binaryContent.length - pos)) > 0) {
                pos += n;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, WebappClassLoader.getString("AS-WEB-UTIL-00025", name), e);
            return;
        }
        finally {
            try {
                binaryStream.close();
            }
            catch (IOException iOException) {}
        }
        if (PreprocessorUtil.isPreprocessorEnabled()) {
            binaryContent = PreprocessorUtil.processClass(name, binaryContent);
        }
        entry.binaryContent = binaryContent;
        if (jarEntry != null) {
            entry.certificates = jarEntry.getCertificates();
        }
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + "/";
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            WebappClassLoader webappClassLoader = this;
            synchronized (webappClassLoader) {
                return entry.loadedClass;
            }
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("java.")) {
            return true;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        if (this.overridablePackages != null) {
            for (String overridePkg : this.overridablePackages) {
                if (!packageName.startsWith(overridePkg)) continue;
                return false;
            }
        }
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!packageName.startsWith(packageTriggers[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        return !name.startsWith("java.");
    }

    protected URL getURL(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURI().toURL();
    }

    protected URL getURI(File file) throws MalformedURLException {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.toURI().toURL();
    }

    protected static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (String file1 : files) {
            File file = new File(dir, file1);
            if (file.isDirectory()) {
                WebappClassLoader.deleteDir(file);
                continue;
            }
            if (FileUtils.deleteFileMaybe(file)) continue;
            logger.log(Level.WARNING, "AS-WEB-UTIL-00024", file.toString());
        }
        if (!FileUtils.deleteFileMaybe(dir)) {
            logger.log(Level.WARNING, "AS-WEB-UTIL-00024", dir.toString());
        }
    }

    public void addByteCodePreprocessor(BytecodePreprocessor preprocessor) {
        this.byteCodePreprocessors.add(preprocessor);
    }

    public ClassLoader copy() {
        logger.entering("WebModuleListener$InstrumentableWebappClassLoader", "copy");
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(WebappClassLoader.this.getURLs(), WebappClassLoader.this.getParent());
            }
        });
    }

    public void addTransformer(final ClassFileTransformer transformer) {
        final WebappClassLoader cl = this;
        this.addByteCodePreprocessor(new BytecodePreprocessor(){

            public boolean initialize(Hashtable parameters) {
                return true;
            }

            public byte[] preprocess(String resourceName, byte[] classBytes) {
                try {
                    String classname = resourceName.substring(0, resourceName.length() - 6);
                    byte[] newBytes = transformer.transform(cl, classname, null, null, classBytes);
                    return newBytes == null ? classBytes : newBytes;
                }
                catch (IllegalClassFormatException e) {
                    logger.logp(Level.WARNING, "WebModuleListener$InstrumentableClassLoader$BytecodePreprocessor", "preprocess", e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String name, ResourceEntry entry) {
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            packageName = name.substring(0, pos);
        }
        Package pkg = null;
        if (packageName != null) {
            ConcurrentHashMap<String, PermissionCollection> concurrentHashMap = this.loaderPC;
            synchronized (concurrentHashMap) {
                pkg = this.getPackage(packageName);
                if (pkg == null) {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
            }
        }
        if (this.securityManager != null && pkg != null) {
            boolean sealCheck;
            if (pkg.isSealed()) {
                sealCheck = pkg.isSealed(entry.codeBase);
            } else {
                boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
            }
            if (!sealCheck) {
                throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
            }
        }
    }

    private synchronized Class<?> defineLoadedClass(String name, ResourceEntry entry) {
        Class<?> clazz;
        CodeSource codeSource = new CodeSource(entry.codeBase, entry.certificates);
        byte[] binaryContent = entry.binaryContent;
        if (!this.byteCodePreprocessors.isEmpty() && entry.loadedClass == null) {
            String resourceName = name.replace('.', '/') + ".class";
            for (BytecodePreprocessor preprocessor : this.byteCodePreprocessors) {
                binaryContent = preprocessor.preprocess(resourceName, binaryContent);
            }
        }
        entry.loadedClass = clazz = this.defineClass(name, binaryContent, 0, binaryContent.length, codeSource);
        if (!this.hotDeploy) {
            entry.binaryContent = null;
            entry.source = null;
            entry.codeBase = null;
            entry.manifest = null;
            entry.certificates = null;
        }
        return clazz;
    }

    private String getJavaVersion() {
        SecurityManager sm = System.getSecurityManager();
        String version = sm != null ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.version");
            }
        }) : System.getProperty("java.version");
        return version;
    }

    private void setAccessible(final Field field) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        } else {
            field.setAccessible(true);
        }
    }

    private boolean isResourceDelegate(String name) {
        return this.delegate || (name.startsWith("javax") || name.startsWith("jakarta")) && (!name.startsWith("jakarta.faces") || !this.useMyFaces) || name.startsWith("sun") || name.startsWith("com/sun/faces") && !name.startsWith("com/sun/faces/extensions") && !this.useMyFaces || name.startsWith("org/apache/taglibs/standard");
    }

    private static String getString(String key, Object ... arguments) {
        String msg = rb.getString(key);
        return MessageFormat.format(msg, arguments);
    }

    private static JarFile newJarFile(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        if (!isMultiReleaseJar.booleanValue()) {
            return jarFile;
        }
        if (WebappClassLoader.isMultiReleaseJar(jarFile)) {
            return WebappClassLoader.newInstance(JarFile.class, CONSTRUCTOR_ARGS_TYPES, new Object[]{file, true, 1, CONSTRUCTOR_ARGUMENTS});
        }
        return jarFile;
    }

    public static <T> T newInstance(Class<T> ofClass, Class<?>[] constructorArgTypes, Object[] args) {
        try {
            Constructor<T> constructor = ofClass.getConstructor(constructorArgTypes);
            return constructor.newInstance(args);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static boolean isMultiReleaseJar(JarFile jarFile) {
        try {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return false;
            }
            return manifest.getMainAttributes().containsKey(MULTI_RELEASE);
        }
        catch (IOException ex) {
            return false;
        }
    }

    static {
        Object constructorArguments;
        Class[] constructorArgsTypes;
        logger = LogFacade.getLogger();
        rb = logger.getResourceBundle();
        packageTriggers = new String[]{"javax", "jakarta", "sun", "org.xml.sax", "org.w3c.dom", "org.apache.taglibs.standard", "com.sun.faces", "org.apache.commons.logging"};
        ALL_PERMISSION = new AllPermission();
        MULTI_RELEASE = new Attributes.Name("Multi-Release");
        boolean isException = false;
        try {
            Class<?> runtimeVersionClass = Class.forName("java.lang.Runtime$Version");
            constructorArgsTypes = new Class[]{File.class, Boolean.TYPE, Integer.TYPE, runtimeVersionClass};
            constructorArguments = Runtime.class.getDeclaredMethod("version", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            isException = true;
            constructorArgsTypes = null;
            constructorArguments = null;
        }
        isMultiReleaseJar = !isException;
        CONSTRUCTOR_ARGS_TYPES = constructorArgsTypes;
        CONSTRUCTOR_ARGUMENTS = constructorArguments;
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        public Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    protected class PrivilegedFindResource
    implements PrivilegedAction<ResourceEntry> {
        private final File file;
        private final String path;

        PrivilegedFindResource(File file, String path) {
            this.file = file;
            this.path = path;
        }

        @Override
        public ResourceEntry run() {
            return WebappClassLoader.this.findResourceInternal(this.file, this.path);
        }
    }
}

