/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.toml;

import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import fish.payara.microprofile.config.extensions.toml.TOMLConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;

@Service(name="toml-config-source")
public class TOMLConfigSource
extends ConfiguredExtensionConfigSource<TOMLConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(TOMLConfigSource.class.getName());
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private long lastModified;
    @Inject
    MicroprofileConfigConfiguration mpConfig;

    @Override
    public String getValue(String s) {
        return this.getProperties().get(s);
    }

    @Override
    public String getName() {
        return "toml";
    }

    @Override
    public int getOrdinal() {
        return Integer.parseInt(this.mpConfig.getTomlOrdinality());
    }

    @Override
    public Map<String, String> getProperties() {
        Path tomlFilePath = this.getFilePath();
        if (tomlFilePath == null) {
            return this.properties;
        }
        long tomlFileLastModified = tomlFilePath.toFile().lastModified();
        if (this.lastModified == tomlFileLastModified) {
            return this.properties;
        }
        try {
            this.properties.clear();
            this.lastModified = tomlFileLastModified;
            TomlMapper tomlMapper = new TomlMapper();
            Map config = (Map)tomlMapper.readValue(tomlFilePath.toFile(), Map.class);
            this.flattenToml(config, "", this.properties, 0, Integer.parseInt(((TOMLConfigSourceConfiguration)this.configuration).getDepth()));
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
        return this.properties;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    @Override
    public boolean setValue(String name, String value) {
        return false;
    }

    @Override
    public boolean deleteValue(String name) {
        return false;
    }

    @Override
    public String getSource() {
        return "toml";
    }

    private Path getFilePath() {
        File file;
        String path = ((TOMLConfigSourceConfiguration)this.configuration).getPath();
        if (path == null || path.isEmpty()) {
            return null;
        }
        Path tomlPath = Paths.get(path, new String[0]);
        if (!tomlPath.isAbsolute()) {
            tomlPath = Paths.get(System.getProperty("com.sun.aas.instanceRoot"), tomlPath.toString()).normalize();
        }
        return (file = tomlPath.toFile()).exists() ? tomlPath : null;
    }

    private void flattenToml(Map<?, ?> tomlTable, String prefix, Map<String, String> resultMap, int depth, int maxDepth) {
        if (depth > maxDepth) {
            throw new IllegalArgumentException("Exceeded maximum depth of " + maxDepth);
        }
        for (Object key : tomlTable.keySet()) {
            String fullKey;
            Object value;
            try {
                value = tomlTable.get(key);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            String string = fullKey = prefix.isEmpty() ? key.toString() : prefix + "." + key.toString();
            if (value instanceof Map) {
                this.flattenToml((Map)value, fullKey, resultMap, depth + 1, maxDepth);
                continue;
            }
            if (value instanceof ArrayList) {
                this.flattenTomlArray((ArrayList)value, fullKey, resultMap, depth + 1, maxDepth);
                continue;
            }
            if (value == null) continue;
            resultMap.put(fullKey, value.toString());
        }
    }

    private void flattenTomlArray(ArrayList<?> array, String prefix, Map<String, String> resultMap, int depth, int maxDepth) {
        if (depth > maxDepth) {
            throw new IllegalArgumentException(String.format("Exceeded maximum depth of %s with depth of %s", maxDepth, depth));
        }
        for (int i = 0; i < array.size(); ++i) {
            Object arrayValue = array.get(i);
            String arrayKey = prefix + "[" + i + "]";
            if (arrayValue instanceof Map) {
                this.flattenToml((Map)arrayValue, arrayKey, resultMap, depth + 1, maxDepth);
                continue;
            }
            if (arrayValue instanceof ArrayList) {
                this.flattenTomlArray((ArrayList)arrayValue, arrayKey, resultMap, depth + 1, maxDepth);
                continue;
            }
            resultMap.put(arrayKey, arrayValue.toString());
        }
    }
}

