/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification;

import fish.payara.internal.notification.EventLevel;
import fish.payara.internal.notification.PayaraNotification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PayaraNotificationBuilder {
    private final String hostName;
    private final String domainName;
    private final String instanceName;
    private final String serverName;
    private String subject;
    private String eventType;
    private EventLevel eventLevel = EventLevel.INFO;
    private List<String> notifierWhitelist;
    private List<String> notifierBlacklist;
    private String message;
    private Serializable data;

    protected PayaraNotificationBuilder(String hostName, String domainName, String instanceName, String serverName) {
        this.hostName = hostName;
        this.domainName = domainName;
        this.instanceName = instanceName;
        this.serverName = serverName;
    }

    public PayaraNotificationBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public PayaraNotificationBuilder message(String message) {
        this.message = message;
        if (this.data == null) {
            this.data = message;
        }
        return this;
    }

    public PayaraNotificationBuilder data(Serializable data) {
        this.data = data;
        if (this.message == null) {
            this.message = data.toString();
        }
        return this;
    }

    public PayaraNotificationBuilder eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public PayaraNotificationBuilder level(EventLevel eventLevel) {
        this.eventLevel = eventLevel;
        return this;
    }

    public PayaraNotificationBuilder whitelist(String ... notifierNames) {
        for (int i = 0; i < notifierNames.length; ++i) {
            if (this.notifierWhitelist == null) {
                this.notifierWhitelist = new ArrayList<String>();
            }
            this.notifierWhitelist.add(notifierNames[i]);
        }
        if (notifierNames.length == 0) {
            this.notifierWhitelist = new ArrayList<String>();
        }
        return this;
    }

    public PayaraNotificationBuilder blacklist(String ... notifierNames) {
        for (int i = 0; i < notifierNames.length; ++i) {
            if (this.notifierBlacklist == null) {
                this.notifierBlacklist = new ArrayList<String>();
            }
            this.notifierBlacklist.add(notifierNames[i]);
        }
        return this;
    }

    public PayaraNotification build() {
        return new PayaraNotification(this.eventType, this.serverName, this.hostName, this.domainName, this.instanceName, this.subject, this.message, this.data, this.eventLevel, this.notifierWhitelist, this.notifierBlacklist);
    }
}

