/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.generator;

import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import java.util.ArrayList;
import java.util.HashMap;

final class ImplHelper
extends Assertion {
    static final String[] COMMENT_ENHANCER_ADDED = null;
    static final String[] COMMENT_NOT_ENHANCER_ADDED = null;
    static final String CLASSNAME_JDO_PERSISTENCE_CAPABLE = "com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable";
    static final String CLASSNAME_JDO_PERSISTENCE_MANAGER = "com.sun.jdo.api.persistence.support.PersistenceManager";
    static final String CLASSNAME_JDO_STATE_MANAGER = "com.sun.jdo.spi.persistence.support.sqlstore.StateManager";
    static final String CLASSNAME_JDO_SCO = "com.sun.jdo.spi.persistence.support.sqlstore.SCO";
    static final String CLASSNAME_JDO_FATAL_EXCEPTION = "com.sun.jdo.api.persistence.support.JDOFatalException";
    static final String FIELDNAME_JDO_FLAGS = "jdoFlags";
    static final String FIELDNAME_JDO_STATE_MANAGER = "jdoStateManager";
    static final String FIELDNAME_JDO_INHERITED_FIELD_COUNT = "jdoInheritedFieldCount";
    static final String FIELDNAME_JDO_FIELD_NAMES = "jdoFieldNames";
    static final String FIELDNAME_JDO_FIELD_TYPES = "jdoFieldTypes";
    static final String FIELDNAME_JDO_FIELD_FLAGS = "jdoFieldFlags";
    static final String METHODNAME_JDO_NEW_INSTANCE = "jdoNewInstance";
    static final String METHODNAME_JDO_SET_FIELD = "jdoSetField";
    static final String METHODNAME_JDO_GET_FIELD = "jdoGetField";
    static final String METHODNAME_JDO_GET_STATE_MANAGER = "jdoGetStateManager";
    static final String METHODNAME_JDO_SET_STATE_MANAGER = "jdoSetStateManager";
    static final String METHODNAME_JDO_GET_FLAGS = "jdoGetFlags";
    static final String METHODNAME_JDO_SET_FLAGS = "jdoSetFlags";
    static final String METHODNAME_JDO_GET_PERSISTENCE_MANAGER = "jdoGetPersistenceManager";
    static final String METHODNAME_JDO_CLEAR = "jdoClear";
    static final String METHODNAME_JDO_MAKE_DIRTY = "jdoMakeDirty";
    static final String METHODNAME_JDO_GET_OBJECT_ID = "jdoGetObjectId";
    static final String METHODNAME_JDO_IS_PERSISTENT = "jdoIsPersistent";
    static final String METHODNAME_JDO_IS_TRANSACTIONAL = "jdoIsTransactional";
    static final String METHODNAME_JDO_IS_NEW = "jdoIsNew";
    static final String METHODNAME_JDO_IS_DIRTY = "jdoIsDirty";
    static final String METHODNAME_JDO_IS_DELETED = "jdoIsDeleted";
    private static final HashMap typeNameConversion = new HashMap();

    ImplHelper() {
    }

    private static boolean isPrimitiveClass(String className) {
        ImplHelper.affirm(!className.equals("void"));
        return JavaTypeHelper.getWrapperName(className) != null;
    }

    private static String getConvertedTypeName(String fieldType) {
        String name = (String)typeNameConversion.get(fieldType);
        return name != null ? name : "Object";
    }

    private static String getMethodNameGetField(String fieldType) {
        return "get" + ImplHelper.getConvertedTypeName(fieldType) + "Field";
    }

    private static String getMethodNameSetField(String fieldType) {
        return "set" + ImplHelper.getConvertedTypeName(fieldType) + "Field";
    }

    static String[] getJDOManagedFieldCountImpl(int fieldcount) {
        return new String[]{"jdoInheritedFieldCount + " + fieldcount + ";"};
    }

    static String[] getDefaultConstructorImpl() {
        return JavaClassWriterHelper.super_;
    }

    static String[] getCloneImpl(String className) {
        className = ImplHelper.normalizeClassName(className);
        String[] bodies = new String[4];
        int i = 0;
        bodies[i++] = className + " clone = (" + className + ")super.clone();";
        bodies[i++] = "clone.jdoFlags = (byte)0;";
        bodies[i++] = "clone.jdoStateManager = null;";
        bodies[i++] = "return clone;";
        return bodies;
    }

    static String[] getJDOConstructorSMImpl(String statemanager) {
        String[] bodies = new String[2];
        int i = 0;
        bodies[i++] = "jdoFlags = (byte)1; // == LOAD_REQUIRED";
        bodies[i++] = "this.jdoStateManager = " + statemanager + ";";
        return bodies;
    }

    static String[] getJDONewInstanceImpl(String className, String statemanager) {
        className = ImplHelper.getClassName(className);
        return new String[]{"return new " + className + "(" + statemanager + ");"};
    }

    static String[] getFieldDirectReadImpl(String fieldName, String fieldType, int fieldNumber) {
        ImplHelper.normalizeClassName(fieldType);
        return new String[]{"// annotation: grant direct read access", "return " + fieldName + ";"};
    }

    static String[] getFieldMediateReadImpl(String fieldName, String fieldType, int fieldNumber) {
        ImplHelper.normalizeClassName(fieldType);
        String[] bodies = new String[6];
        int i = 0;
        bodies[i++] = "// annotation: mediate read access";
        bodies[i++] = "final " + CLASSNAME_JDO_STATE_MANAGER + " stateManager = this." + FIELDNAME_JDO_STATE_MANAGER + ";";
        bodies[i++] = "if (stateManager != null) {";
        bodies[i++] = "    " + "stateManager.prepareGetField(" + fieldNumber + ");";
        bodies[i++] = "}";
        bodies[i++] = "return " + fieldName + ";";
        return bodies;
    }

    static String[] getFieldCheckReadImpl(String fieldName, String fieldType, int fieldNumber) {
        String[] bodies = new String[5];
        int i = 0;
        ImplHelper.normalizeClassName(fieldType);
        bodies[i++] = "// annotation: check read access";
        bodies[i++] = "if (" + FIELDNAME_JDO_FLAGS + " > 0) {";
        bodies[i++] = "   jdoStateManager.loadForRead();";
        bodies[i++] = "}";
        bodies[i++] = "return " + fieldName + ";";
        return bodies;
    }

    static String[] getFieldDirectWriteImpl(String fieldName, String fieldType, int fieldNumber, String newvalue) {
        ImplHelper.normalizeClassName(fieldType);
        return new String[]{"// annotation: grant direct write access", "this." + fieldName + " = " + newvalue + ";"};
    }

    static String[] getFieldMediateWriteImpl(String fieldName, String fieldType, int fieldNumber, String newvalue) {
        String[] bodies = new String[7];
        int i = 0;
        fieldType = ImplHelper.normalizeClassName(fieldType);
        bodies[i++] = "// annotation: mediate write access";
        bodies[i++] = "final " + CLASSNAME_JDO_STATE_MANAGER + " stateManager = this." + FIELDNAME_JDO_STATE_MANAGER + ";";
        bodies[i++] = "if (stateManager == null) {";
        bodies[i++] = "    this." + fieldName + " = " + newvalue + ";";
        bodies[i++] = "} else {";
        bodies[i++] = "    stateManager." + ImplHelper.getMethodNameSetField(fieldType) + '(' + fieldNumber + ", " + newvalue + ");";
        bodies[i++] = "}";
        return bodies;
    }

    static String[] getFieldCheckWriteImpl(String fieldName, String fieldType, int fieldNumber, String newvalue) {
        String[] bodies = new String[5];
        int i = 0;
        ImplHelper.normalizeClassName(fieldType);
        bodies[i++] = "// annotation: check write access";
        bodies[i++] = "if (jdoFlags != 0) {";
        bodies[i++] = "    jdoStateManager.loadForUpdate();";
        bodies[i++] = "}";
        bodies[i++] = "this." + fieldName + " = " + newvalue + ";";
        return bodies;
    }

    static String[] getJDOClearImpl(String className, ExtendedJDOMetaData meta, String[] fieldNames, String[] fieldTypes) {
        ArrayList<Object> impl = new ArrayList<Object>(20);
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldTypeClassPath = fieldTypes[i];
            String fieldType = ImplHelper.normalizeClassName(fieldTypes[i]);
            String fieldName = fieldNames[i];
            if (meta.isKeyField(className, fieldName)) continue;
            String primClass = JavaTypeHelper.getWrapperName(fieldType);
            if (meta.isMutableSecondClassObjectType(fieldTypeClassPath)) {
                impl.add("if (" + fieldName + " instanceof " + CLASSNAME_JDO_SCO + ") {");
                impl.add("    ((" + CLASSNAME_JDO_SCO + ")" + fieldName + ").unsetOwner();");
                impl.add("}");
                impl.add(fieldName + " = null;");
                continue;
            }
            if (primClass == null) {
                impl.add(fieldName + " = null;");
                continue;
            }
            if ("boolean".equals(fieldType)) {
                impl.add(fieldName + " = false;");
                continue;
            }
            impl.add(fieldName + " = 0;");
        }
        String[] strArr = new String[impl.size()];
        return impl.toArray(strArr);
    }

    static String[] getJDOGetFieldImpl(String fieldNumber, String[] fieldNames, String[] fieldTypes) {
        ArrayList<Object> impl = new ArrayList<Object>(20);
        impl.add("switch (" + fieldNumber + ") {");
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldType = ImplHelper.normalizeClassName(fieldTypes[i]);
            impl.add("case " + i + ":");
            String primClass = JavaTypeHelper.getWrapperName(fieldType);
            if (primClass == null) {
                impl.add("    return " + fieldNames[i] + ";");
                continue;
            }
            impl.add("    return new " + primClass + "(" + fieldNames[i] + ");");
        }
        impl.add("default:");
        impl.add("    throw new com.sun.jdo.api.persistence.support.JDOFatalException();");
        impl.add("}");
        String[] strArr = new String[impl.size()];
        return impl.toArray(strArr);
    }

    static String[] getJDOSetFieldImpl(String fieldNumber, String objName, String[] fieldNames, String[] fieldTypes) {
        ArrayList<Object> impl = new ArrayList<Object>(20);
        impl.add("switch (" + fieldNumber + ") {");
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldType = ImplHelper.normalizeClassName(fieldTypes[i]);
            impl.add("case " + i + ":");
            String primClass = JavaTypeHelper.getWrapperName(fieldType);
            if (primClass == null) {
                impl.add("    this." + fieldNames[i] + " = (" + fieldType + ")" + objName + ";");
            } else {
                impl.add("    this." + fieldNames[i] + " = ((" + primClass + ")" + objName + ")." + ((String)typeNameConversion.get(fieldType)).toLowerCase() + "Value();");
            }
            impl.add("    return;");
        }
        impl.add("default:");
        impl.add("    throw new com.sun.jdo.api.persistence.support.JDOFatalException();");
        impl.add("}");
        String[] strArr = new String[impl.size()];
        return impl.toArray(strArr);
    }

    private static String[] getJDOStateManagerDelegationImpl(String delegation, String returnType) {
        ArrayList<String> impl = new ArrayList<String>(7);
        impl.add("final " + CLASSNAME_JDO_STATE_MANAGER + " stateManager = this." + FIELDNAME_JDO_STATE_MANAGER + ";");
        impl.add("if (stateManager != null) {");
        StringBuilder buf = new StringBuilder("    ");
        if (returnType != null) {
            buf.append("return ");
        }
        impl.add(buf.append("stateManager.").append(delegation).append(";").toString());
        impl.add("}");
        if (returnType != null) {
            impl.add("return " + returnType + ";");
        }
        String[] strArr = new String[impl.size()];
        return impl.toArray(strArr);
    }

    static String[] getJDOStateManagerVoidDelegationImpl(String delegation) {
        return ImplHelper.getJDOStateManagerDelegationImpl(delegation, null);
    }

    static String[] getJDOStateManagerObjectDelegationImpl(String delegation) {
        return ImplHelper.getJDOStateManagerDelegationImpl(delegation, "null");
    }

    static String[] getJDOStateManagerBooleanDelegationImpl(String delegation) {
        return ImplHelper.getJDOStateManagerDelegationImpl(delegation, "false");
    }

    static String[] getOidHashCodeImpl(String[] pknames, String[] pktypes, boolean isRoot) {
        ArrayList<Object> impl = new ArrayList<Object>(3);
        if (isRoot) {
            impl.add("int hash = 0;");
        } else {
            impl.add("int hash = super.hashCode();");
        }
        for (int i = 0; i < pknames.length; ++i) {
            if (ImplHelper.isPrimitiveClass(pktypes[i])) {
                if (pktypes[i].equals("boolean")) {
                    impl.add("hash += (" + pknames[i] + " ? 1 : 0);");
                    continue;
                }
                impl.add("hash += (int)" + pknames[i] + ";");
                continue;
            }
            impl.add("hash += (this." + pknames[i] + " != null ? this." + pknames[i] + ".hashCode() : 0);");
        }
        impl.add("return hash;");
        String[] strArr = new String[impl.size()];
        return impl.toArray(strArr);
    }

    static String[] getOidEqualsImpl(String oidClassName, String[] pknames, String[] pktypes, String pk, boolean isRoot) {
        ArrayList<Object> impl = new ArrayList<Object>(31);
        if (isRoot) {
            impl.add("if (" + pk + " == null || !this.getClass().equals(" + pk + ".getClass())) {");
        } else {
            impl.add("if (!super.equals(" + pk + ")) {");
        }
        impl.add("    return false;");
        impl.add("}");
        oidClassName = ImplHelper.getClassName(oidClassName);
        impl.add(oidClassName + " oid = (" + oidClassName + ")" + pk + ";");
        for (int i = 0; i < pknames.length; ++i) {
            if (ImplHelper.isPrimitiveClass(pktypes[i])) {
                impl.add("if (this." + pknames[i] + " != oid." + pknames[i] + ") return false;");
                continue;
            }
            impl.add("if (this." + pknames[i] + " != oid." + pknames[i] + " && (this." + pknames[i] + " == null || !this." + pknames[i] + ".equals(oid." + pknames[i] + "))) return false;");
        }
        impl.add("return true;");
        String[] strArr = new String[impl.size()];
        return impl.toArray(strArr);
    }

    static String normalizeClassName(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('/', '.').replace('$', '.');
    }

    static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        return JavaTypeHelper.getPackageName(className.replace('/', '.'));
    }

    static String getClassName(String className) {
        return JavaTypeHelper.getShortClassName(ImplHelper.normalizeClassName(className));
    }

    static {
        typeNameConversion.put(Integer.TYPE.getName(), "Int");
        typeNameConversion.put(Long.TYPE.getName(), "Long");
        typeNameConversion.put(Byte.TYPE.getName(), "Byte");
        typeNameConversion.put(Character.TYPE.getName(), "Char");
        typeNameConversion.put(Boolean.TYPE.getName(), "Boolean");
        typeNameConversion.put(Short.TYPE.getName(), "Short");
        typeNameConversion.put(Float.TYPE.getName(), "Float");
        typeNameConversion.put(Double.TYPE.getName(), "Double");
        typeNameConversion.put("String", "String");
    }
}

