/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FilePath {
    private static String cwdAbsolute;

    public static String getAbsolutePath(File file) {
        String basicAbsolute = file.getAbsolutePath();
        if (File.separatorChar == '/') {
            return basicAbsolute.replace('\\', '/');
        }
        return basicAbsolute.replace('/', '\\');
    }

    private static String getCwdAbsolute() {
        if (cwdAbsolute == null) {
            cwdAbsolute = FilePath.getAbsolutePath(new File("."));
        }
        return cwdAbsolute;
    }

    public static String canonicalize(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String absolutePath = FilePath.getAbsolutePath(file);
            Vector<String> components = new Vector<String>();
            StringTokenizer parser = new StringTokenizer(absolutePath, File.separator, true);
            while (parser.hasMoreElements()) {
                components.addElement(parser.nextToken());
            }
            boolean editted = true;
            while (editted) {
                editted = false;
                for (int i = 1; i < components.size() && !editted; ++i) {
                    String s = (String)components.elementAt(i);
                    if (s.equals(".")) {
                        components.removeElementAt(i);
                        components.removeElementAt(i - 1);
                        editted = true;
                        continue;
                    }
                    if (!s.equals("..")) continue;
                    components.removeElementAt(i);
                    components.removeElementAt(i - 1);
                    if (i > 2 && !((String)components.elementAt(i - 2)).equals(File.separator) && ((String)components.elementAt(i - 3)).equals(File.separator)) {
                        components.removeElementAt(i - 2);
                        components.removeElementAt(i - 3);
                    }
                    editted = true;
                }
            }
            String cwd = FilePath.getCwdAbsolute();
            if (cwd.length() > 2 && cwd.charAt(0) != File.separatorChar && cwd.charAt(1) == ':' && ((String)components.elementAt(0)).equals(File.separator) && (components.size() == 1 || !((String)components.elementAt(1)).equals(File.separator))) {
                String drive = cwd.substring(0, 2);
                components.insertElementAt(drive, 0);
            }
            if (components.size() > 0 && ((String)components.elementAt(components.size() - 1)).equals(File.separator)) {
                components.removeElementAt(components.size() - 1);
            }
            StringBuilder result = new StringBuilder();
            for (int j = 0; j < components.size(); ++j) {
                result.append((String)components.elementAt(j));
            }
            return result.toString();
        }
    }

    public static boolean canonicalNamesEqual(String f1, String f2) {
        String cwd = FilePath.getCwdAbsolute();
        boolean equal = cwd.length() > 2 && cwd.charAt(0) != File.separatorChar && cwd.charAt(1) == ':' ? f1.equalsIgnoreCase(f2) : f1.equals(f2);
        return equal;
    }
}

