/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ManagedScheduledExecutorDefinitionDescriptor;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ManagedScheduledExecutorServiceConfig;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=ManagedScheduledExecutorDefinitionDescriptor.class)
public class ManagedScheduledExecutorDefinitionDeployer
implements ResourceDeployer {
    private static final Logger logger = Logger.getLogger(ManagedScheduledExecutorDefinitionDeployer.class.getName());
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ResourceNamingService resourceNamingService;

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ManagedScheduledExecutorDefinitionDescriptor mseDefinitionDescriptor = (ManagedScheduledExecutorDefinitionDescriptor)resource;
        ManagedScheduledExecutorServiceConfig mseConfig = new ManagedScheduledExecutorServiceConfig(new CustomManagedScheduledExecutorDefinitionImpl(mseDefinitionDescriptor));
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        ContextServiceImpl contextService = concurrentRuntime.findOrCreateContextService(mseDefinitionDescriptor.getContext(), mseDefinitionDescriptor.getName(), applicationName, moduleName);
        String customNameOfResource = ConnectorsUtil.deriveResourceName((String)mseDefinitionDescriptor.getResourceId(), (String)mseDefinitionDescriptor.getName(), (JavaEEResourceType)mseDefinitionDescriptor.getResourceType());
        ResourceInfo resourceInfo = new ResourceInfo(customNameOfResource, applicationName, moduleName);
        ManagedScheduledExecutorServiceImpl managedScheduledExecutorService = concurrentRuntime.createManagedScheduledExecutorService(resourceInfo, mseConfig, contextService);
        this.resourceNamingService.publishObject((GenericResourceInfo)resourceInfo, customNameOfResource, (Object)managedScheduledExecutorService, true);
    }

    public void deployResource(Object resource) throws Exception {
        String applicationName = this.invocationManager.getCurrentInvocation().getAppName();
        String moduleName = this.invocationManager.getCurrentInvocation().getModuleName();
        this.deployResource(resource, applicationName, moduleName);
    }

    public void undeployResource(Object resource) throws Exception {
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void redeployResource(Object resource) throws Exception {
    }

    public void enableResource(Object resource) throws Exception {
    }

    public void disableResource(Object resource) throws Exception {
    }

    public boolean handles(Object resource) {
        return false;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return false;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    class CustomManagedScheduledExecutorDefinitionImpl
    implements ManagedScheduledExecutorService {
        ManagedScheduledExecutorDefinitionDescriptor descriptor;

        public CustomManagedScheduledExecutorDefinitionImpl(ManagedScheduledExecutorDefinitionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public String getContextInfoEnabled() {
            return null;
        }

        @Override
        public void setContextInfoEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getContextInfo() {
            return null;
        }

        @Override
        public void setContextInfo(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        public Property addProperty(Property property) {
            return null;
        }

        public Property lookupProperty(String name) {
            return null;
        }

        public Property removeProperty(String name) {
            return null;
        }

        public Property removeProperty(Property removeMe) {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public String getPropertyValue(String name) {
            return null;
        }

        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        @Override
        public String getThreadPriority() {
            return null;
        }

        @Override
        public void setThreadPriority(String value) throws PropertyVetoException {
        }

        @Override
        public String getLongRunningTasks() {
            return null;
        }

        @Override
        public void setLongRunningTasks(String value) throws PropertyVetoException {
        }

        @Override
        public String getHungAfterSeconds() {
            return String.valueOf(this.descriptor.getHungTaskThreshold());
        }

        @Override
        public void setHungAfterSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getCorePoolSize() {
            return String.valueOf(this.descriptor.getMaxAsync());
        }

        @Override
        public void setCorePoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getKeepAliveSeconds() {
            return null;
        }

        @Override
        public void setKeepAliveSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getThreadLifetimeSeconds() {
            return null;
        }

        @Override
        public void setThreadLifetimeSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getContext() {
            return this.descriptor.getContext();
        }

        @Override
        public void setContext(String value) throws PropertyVetoException {
        }

        @Override
        public String getJndiName() {
            return this.descriptor.getName();
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
        }

        @Override
        public String getEnabled() {
            return null;
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return null;
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> type) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> type) throws TransactionFailure {
            return null;
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) throws TransactionFailure {
            return null;
        }
    }
}

