/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployment.annotation.handlers;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.ContextServiceDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ContextServiceDefinition.class)
public class ContextServiceDefinitionHandler
extends AbstractResourceHandler {
    private static final Logger logger = Logger.getLogger(ContextServiceDefinitionHandler.class.getName());
    @Inject
    private Domain domain;

    protected HandlerProcessingResult processAnnotation(AnnotationInfo annotationInfo, ResourceContainerContext[] resourceContainerContexts) throws AnnotationProcessorException {
        logger.log(Level.INFO, "Entering ContextServiceDefinitionHandler.processAnnotation");
        ContextServiceDefinition contextServiceDefinition = (ContextServiceDefinition)annotationInfo.getAnnotation();
        this.processSingleAnnotation(contextServiceDefinition, resourceContainerContexts);
        return this.getDefaultProcessedResult();
    }

    public void processSingleAnnotation(ContextServiceDefinition contextServiceDefinition, ResourceContainerContext[] resourceContainerContexts) {
        logger.log(Level.INFO, "Creating custom context service by annotation");
        ContextServiceDefinitionDescriptor csdd = this.createDescriptor(contextServiceDefinition);
        for (ResourceContainerContext context : resourceContainerContexts) {
            Set csddes = context.getResourceDescriptors(JavaEEResourceType.CSDD);
            csddes.add(csdd);
        }
    }

    public ContextServiceDefinitionDescriptor createDescriptor(ContextServiceDefinition contectServiceDefinition) {
        Set<String> unusedContexts = this.collectUnusedContexts(contectServiceDefinition);
        ContextServiceDefinitionDescriptor csdd = new ContextServiceDefinitionDescriptor();
        csdd.setDescription("Context Service Definition");
        csdd.setName(TranslatedConfigView.expandValue(contectServiceDefinition.name()));
        csdd.setPropagated(this.evaluateContexts(contectServiceDefinition.propagated(), unusedContexts));
        csdd.setCleared(this.evaluateContexts(contectServiceDefinition.cleared(), unusedContexts));
        csdd.setUnchanged(this.evaluateContexts(contectServiceDefinition.unchanged(), unusedContexts));
        return csdd;
    }

    private Set<String> evaluateContexts(String[] sourceContexts, Set<String> unusedContexts) {
        HashSet<String> contexts = new HashSet<String>();
        for (String context : sourceContexts) {
            if ("Remaining".equals(context)) {
                contexts.addAll(unusedContexts);
                contexts.add("Remaining");
                continue;
            }
            contexts.add(context);
        }
        return contexts;
    }

    private Set<String> collectUnusedContexts(ContextServiceDefinition csdd) {
        String previous;
        HashMap<String, String> usedContexts = new HashMap<String, String>();
        for (String context : csdd.propagated()) {
            usedContexts.put(context, "propagated");
        }
        for (String context : csdd.cleared()) {
            previous = usedContexts.put(context, "cleared");
            if (previous == null) continue;
            throw new RuntimeException("Duplicate context " + context + " in " + previous + " and cleared context attributes in ContextServiceDefinition annotation!");
        }
        for (String context : csdd.unchanged()) {
            previous = usedContexts.put(context, "unchanged");
            if (previous == null) continue;
            throw new RuntimeException("Duplicate context " + context + " in " + previous + " and unchanged context attributes in ContextServiceDefinition annotation!");
        }
        HashSet<String> allStandardContexts = new HashSet<String>(Set.of("Application", "Security", "Transaction"));
        allStandardContexts.removeAll(usedContexts.keySet());
        return allStandardContexts;
    }
}

