/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.connector;

import com.sun.enterprise.config.serverbeans.Config;
import jakarta.decorator.Decorator;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Model;
import jakarta.enterprise.inject.Stereotype;
import jakarta.inject.Inject;
import jakarta.inject.Scope;
import jakarta.interceptor.Interceptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.weld.connector.CDIService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WeldUtils {
    private static Logger logger = Logger.getLogger(WeldUtils.class.getName());
    private static final String EMPTY_BEANS_XML_MODE_ALL = "fish.payara.deployment.emptyBeansXmlModeALL";
    public static final char SEPARATOR_CHAR = '/';
    public static final String WEB_INF = "WEB-INF";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String BEANS_XML_FILENAME = "beans.xml";
    public static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_CLASSES_META_INF_BEANS_XML = "WEB-INF/classes/META-INF/beans.xml";
    private static final String SERVICES_DIR = "services";
    private static final String SERVICES_CLASSNAME = "jakarta.enterprise.inject.spi.Extension";
    private static final String BCE_SERVICES_CLASSNAME = "jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    public static final String META_INF_SERVICES_EXTENSION = "META-INF/services/jakarta.enterprise.inject.spi.Extension";
    public static final String META_INF_BCE_SERVICES_EXTENSION = "META-INF/services/jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    public static final String WEB_INF_SERVICES_EXTENSION = "WEB-INF/classes/META-INF/services/jakarta.enterprise.inject.spi.Extension";
    public static final String WEB_INF_BCE_EXTENSION = "WEB-INF/classes/META-INF/services/jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension";
    public static final String CLASS_SUFFIX = ".class";
    public static final String JAR_SUFFIX = ".jar";
    public static final String RAR_SUFFIX = ".rar";
    public static final String EXPANDED_RAR_SUFFIX = "_rar";
    public static final String EXPANDED_JAR_SUFFIX = "_jar";
    protected static final Set<String> cdiScopeAnnotations;
    protected static final Set<String> cdiEnablingAnnotations;

    public static boolean isImplicitBeanArchive(DeploymentContext context, ReadableArchive archive) throws IOException {
        if (!WeldUtils.isValidBdaBasedOnExtensionAndBeansXml(archive)) {
            return false;
        }
        return WeldUtils.isImplicitBeanArchive(context, archive.getURI());
    }

    public static boolean isImplicitBeanArchive(DeploymentContext context, URI archivePath) {
        return WeldUtils.isImplicitBeanDiscoveryEnabled(context) && WeldUtils.hasCDIEnablingAnnotations(context, archivePath);
    }

    public static boolean hasCDIEnablingAnnotations(DeploymentContext context, URI path) {
        return WeldUtils.hasCDIEnablingAnnotations(context, Collections.singleton(path));
    }

    public static boolean hasCDIEnablingAnnotations(DeploymentContext context, Collection<URI> paths) {
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            HashSet<String> exclusions = new HashSet<String>();
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType || !type.wasDefinedIn(paths)) continue;
                for (AnnotationModel am : type.getAnnotations()) {
                    AnnotationType at = am.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(at, exclusions)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String[] getCDIEnablingAnnotations(DeploymentContext context) {
        HashSet<String> result = new HashSet<String>();
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            HashSet<String> exclusions = new HashSet<String>();
            for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel am : type.getAnnotations()) {
                    AnnotationType at = am.getType();
                    if (!WeldUtils.isCDIEnablingAnnotation(at, exclusions)) continue;
                    result.add(at.getName());
                }
            }
        }
        return result.toArray(new String[0]);
    }

    public static Collection<String> getCDIAnnotatedClassNames(DeploymentContext context) {
        HashSet<String> result = new HashSet<String>();
        HashSet cdiEnablingAnnotations = new HashSet();
        Collections.addAll(cdiEnablingAnnotations, WeldUtils.getCDIEnablingAnnotations(context));
        Types types = WeldUtils.getTypes(context);
        if (types != null) {
            block0: for (Type type : types.getAllTypes()) {
                if (type instanceof AnnotationType) continue;
                for (AnnotationModel am : type.getAnnotations()) {
                    AnnotationType at = am.getType();
                    if (!cdiEnablingAnnotations.contains(at.getName())) continue;
                    result.add(type.getName());
                    continue block0;
                }
            }
        }
        return result;
    }

    public static Collection<String> getInjectionTargetClassNames(Types types, Collection<String> knownClassNames) {
        HashSet<String> result = new HashSet<String>();
        if (types != null) {
            for (String knownClassName : knownClassNames) {
                FieldModel fieldModel;
                Type type = types.getBy(knownClassName);
                if (type == null || !(type instanceof ClassModel)) continue;
                boolean injectionTarget = false;
                Collection fieldModels = ((ClassModel)type).getFields();
                Iterator iterator = fieldModels.iterator();
                while (iterator.hasNext() && !(injectionTarget = WeldUtils.annotatedWithInject((fieldModel = (FieldModel)iterator.next()).getAnnotations()))) {
                }
                if (!injectionTarget) {
                    MethodModel methodModel;
                    Collection methodModels = type.getMethods();
                    Iterator iterator2 = methodModels.iterator();
                    while (iterator2.hasNext() && !(injectionTarget = WeldUtils.annotatedWithInject((methodModel = (MethodModel)iterator2.next()).getAnnotations()))) {
                    }
                }
                if (!injectionTarget) continue;
                result.add(type.getName());
            }
        }
        return result;
    }

    private static boolean annotatedWithInject(Collection<AnnotationModel> annotationModels) {
        boolean injectionTarget = false;
        for (AnnotationModel annotationModel : annotationModels) {
            if (!annotationModel.getType().getName().equals(Inject.class.getName())) continue;
            injectionTarget = true;
            break;
        }
        return injectionTarget;
    }

    public static boolean hasScopeAnnotation(Class clazz) {
        return WeldUtils.hasValidAnnotation(clazz, cdiScopeAnnotations, null);
    }

    public static boolean hasCDIEnablingAnnotation(Class clazz) {
        return WeldUtils.hasValidAnnotation(clazz, cdiEnablingAnnotations, null);
    }

    private static boolean isCDIEnablingAnnotation(AnnotationType annotationType) {
        return WeldUtils.isCDIEnablingAnnotation(annotationType, new HashSet<String>());
    }

    private static boolean isCDIEnablingAnnotation(AnnotationType annotationType, Set<String> exclusions) {
        String annotationTypeName = annotationType.getName();
        if (cdiEnablingAnnotations.contains(annotationTypeName)) {
            return true;
        }
        if (exclusions.add(annotationTypeName)) {
            for (AnnotationModel parent : annotationType.getAnnotations()) {
                if (!WeldUtils.isCDIEnablingAnnotation(parent.getType(), exclusions)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasValidAnnotation(Class annotatedClass, Set<String> validScopes, Collection<String> excludedScopes) {
        Set<String> copyOfExcludedScopes = WeldUtils.copyCollectionToSet(excludedScopes);
        for (Annotation annotation : annotatedClass.getAnnotations()) {
            if (!WeldUtils.isValidAnnotation(annotation.annotationType(), validScopes, copyOfExcludedScopes)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> copyCollectionToSet(Collection<String> toBeCopied) {
        HashSet<Object> copy = toBeCopied == null ? new HashSet() : new HashSet<String>(toBeCopied);
        return copy;
    }

    private static boolean isValidAnnotation(Class<? extends Annotation> annotationType, Set<String> validTypeNames, Set<String> excludedTypeNames) {
        Objects.requireNonNull(validTypeNames);
        Objects.requireNonNull(excludedTypeNames);
        if (validTypeNames.isEmpty()) {
            return false;
        }
        String annotationTypeName = annotationType.getName();
        if (validTypeNames.contains(annotationTypeName) && !excludedTypeNames.contains(annotationTypeName)) {
            return true;
        }
        if (excludedTypeNames.add(annotationTypeName)) {
            for (Annotation parent : annotationType.getAnnotations()) {
                if (!WeldUtils.isValidAnnotation(parent.annotationType(), validTypeNames, excludedTypeNames)) continue;
                return true;
            }
        }
        return false;
    }

    private static Types getTypes(DeploymentContext context) {
        String metadataKey = Types.class.getName();
        Types types = (Types)context.getTransientAppMetadata().get(metadataKey);
        while (types == null && (context = ((ExtendedDeploymentContext)context).getParentContext()) != null) {
            types = (Types)context.getTransientAppMetadata().get(metadataKey);
        }
        return types;
    }

    public static int getPreLoaderThreads() {
        Config config;
        int result = 0;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Integer.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getPreLoaderThreadPoolSize());
        }
        return result;
    }

    public static boolean isConcurrentDeploymentEnabled() {
        Config config;
        boolean result = false;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Boolean.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getEnableConcurrentDeployment());
        }
        return result;
    }

    public static boolean isImplicitBeanDiscoveryEnabled() {
        Config config;
        boolean result = false;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        if (serviceLocator != null && (config = (Config)serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0])) != null) {
            result = Boolean.valueOf(((CDIService)config.getExtensionByType(CDIService.class)).getEnableImplicitCdi());
        }
        return result;
    }

    public static boolean isImplicitBeanDiscoveryEnabled(DeploymentContext context) {
        boolean result = false;
        if (WeldUtils.isImplicitBeanDiscoveryEnabled()) {
            Object propValue = context.getAppProps().get("implicitCdiEnabled");
            Object appPropValue = context.getAppProps().get("enable-implicit-cdi");
            if (appPropValue != null) {
                propValue = appPropValue;
            }
            result = propValue == null || Boolean.parseBoolean((String)propValue);
        }
        return result;
    }

    public static boolean isCDIDevModeEnabled(DeploymentContext context) {
        Object propValue = context.getAppProps().get("cdiDevModeEnabled");
        return propValue != null && Boolean.parseBoolean((String)propValue);
    }

    public static void setCDIDevMode(DeploymentContext context, boolean enabled) {
        context.getAppProps().setProperty("cdiDevModeEnabled", String.valueOf(enabled));
    }

    public static boolean isEmptyBeansXmlModeALL(DeploymentContext context) {
        if (Boolean.getBoolean(EMPTY_BEANS_XML_MODE_ALL)) {
            return true;
        }
        Object propValue = context.getAppProps().get("emptyBeansXmlModeALL");
        return propValue != null && Boolean.parseBoolean((String)propValue);
    }

    public static InputStream getBeansXmlInputStream(DeploymentContext context) {
        return WeldUtils.getBeansXmlInputStream(context.getSource());
    }

    public static boolean isValidBdaBasedOnExtensionAndBeansXml(ReadableArchive archive) {
        try {
            if (WeldUtils.hasExtension(archive) && !WeldUtils.hasBeansXML(archive)) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean hasExtension(ReadableArchive archive) {
        try {
            if (WeldUtils.isWar(archive)) {
                return archive.exists(WEB_INF_SERVICES_EXTENSION) || archive.exists(WEB_INF_BCE_EXTENSION);
            }
            return archive.exists(META_INF_SERVICES_EXTENSION) || archive.exists(META_INF_BCE_SERVICES_EXTENSION);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error when searching extensions", ioe);
            return false;
        }
    }

    public static boolean hasBeansXML(ReadableArchive archive) throws IOException {
        if (WeldUtils.isWar(archive)) {
            return archive.exists(WEB_INF_BEANS_XML) || archive.exists(WEB_INF_CLASSES_META_INF_BEANS_XML);
        }
        return archive.exists(META_INF_BEANS_XML);
    }

    private static boolean isWar(ReadableArchive archive) throws IOException {
        return archive.exists(WEB_INF);
    }

    public static InputStream getBeansXmlInputStream(ReadableArchive archive) {
        InputStream inputStream = null;
        try {
            if (archive.exists(WEB_INF)) {
                inputStream = archive.getEntry(WEB_INF_BEANS_XML);
                if (inputStream == null) {
                    inputStream = archive.getEntry(WEB_INF_CLASSES_META_INF_BEANS_XML);
                }
            } else {
                inputStream = archive.getEntry(META_INF_BEANS_XML);
            }
        }
        catch (IOException e) {
            return null;
        }
        return inputStream;
    }

    public static String getBeanDiscoveryMode(InputStream beansXmlInputStream) {
        if (beansXmlInputStream == null) {
            return "annotated";
        }
        String beanDiscoveryMode = null;
        LocalDefaultHandler handler = new LocalDefaultHandler();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(beansXmlInputStream, (DefaultHandler)handler);
        }
        catch (SAXStoppedIntentionallyException exc) {
            beanDiscoveryMode = handler.getBeanDiscoveryMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanDiscoveryMode == null) {
            return "annotated";
        }
        if (beanDiscoveryMode.equals("")) {
            return "annotated";
        }
        return beanDiscoveryMode;
    }

    static {
        HashSet<Object> cdi = new HashSet<String>();
        cdi.add(Scope.class.getName());
        cdi.add(NormalScope.class.getName());
        cdi.add("jakarta.faces.view.ViewScoped");
        cdi.add("jakarta.faces.flow.FlowScoped");
        cdi.add(ConversationScoped.class.getName());
        cdi.add(ApplicationScoped.class.getName());
        cdi.add(SessionScoped.class.getName());
        cdi.add(RequestScoped.class.getName());
        cdi.add(Dependent.class.getName());
        cdi.add(jakarta.inject.Singleton.class.getName());
        cdi.add(Model.class.getName());
        cdiScopeAnnotations = Collections.unmodifiableSet(cdi);
        cdi = new HashSet<String>(cdiScopeAnnotations);
        cdi.add(Decorator.class.getName());
        cdi.add(Interceptor.class.getName());
        cdi.add(Stereotype.class.getName());
        cdi.add(MessageDriven.class.getName());
        cdi.add(Stateful.class.getName());
        cdi.add(Stateless.class.getName());
        cdi.add(Singleton.class.getName());
        cdiEnablingAnnotations = Collections.unmodifiableSet(cdi);
    }

    private static class SAXStoppedIntentionallyException
    extends SAXException {
        private SAXStoppedIntentionallyException() {
        }
    }

    private static class LocalDefaultHandler
    extends DefaultHandler {
        String beanDiscoveryMode = null;

        private LocalDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("beans")) {
                this.beanDiscoveryMode = attributes.getValue("bean-discovery-mode");
                throw new SAXStoppedIntentionallyException();
            }
        }

        public String getBeanDiscoveryMode() {
            return this.beanDiscoveryMode;
        }
    }

    public static enum BDAType {
        WAR,
        JAR,
        RAR,
        UNKNOWN;

    }
}

