/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.cdi.MetricUtils;
import fish.payara.microprofile.metrics.impl.MetricsCustomBuckets;
import fish.payara.microprofile.metrics.impl.MetricsCustomPercentiles;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;

public class MetricsConfigParserUtil {
    private static final Logger logger = Logger.getLogger(MetricsConfigParserUtil.class.getName());
    private static final String PROPERTY_NAME_SEPARATOR = ";";
    private static final String PROPERTY_KEY_VALUE_SEPARATOR = "=";
    private static final String PROPERTY_VALUE_SEPARATOR = ",";

    public static Collection<MetricsCustomPercentiles> parsePercentile(String percentileProperty) {
        String[] valuePairs;
        ArrayDeque<MetricsCustomPercentiles> metricPercentileCollection = new ArrayDeque<MetricsCustomPercentiles>();
        if (percentileProperty == null || percentileProperty.length() == 0) {
            return null;
        }
        MetricsCustomPercentiles customPercentile = null;
        for (String nameValue : valuePairs = percentileProperty.split(PROPERTY_NAME_SEPARATOR)) {
            String[] resultKeyValueSplit = nameValue.split(PROPERTY_KEY_VALUE_SEPARATOR);
            String metricName = resultKeyValueSplit[0];
            if (resultKeyValueSplit.length == 1) {
                customPercentile = new MetricsCustomPercentiles(metricName, true);
            } else {
                Object[] percentileValues = (Double[])Arrays.asList(resultKeyValueSplit[1].split(PROPERTY_VALUE_SEPARATOR)).stream().map(MetricsConfigParserUtil::evaluatePercentileValue).filter(d -> d != null && d >= 0.0 && d <= 1.0).toArray(Double[]::new);
                Arrays.sort(percentileValues);
                customPercentile = new MetricsCustomPercentiles(metricName, (Double[])percentileValues);
            }
            metricPercentileCollection.addFirst(customPercentile);
        }
        return metricPercentileCollection;
    }

    public static Collection<MetricsCustomBuckets> parseHistogramBuckets(String histogramBucketsProperty) {
        String[] valuePairs;
        ArrayDeque<MetricsCustomBuckets> metricHistogramCollection = new ArrayDeque<MetricsCustomBuckets>();
        if (histogramBucketsProperty == null || histogramBucketsProperty.length() == 0) {
            return null;
        }
        MetricsCustomBuckets customBucket = null;
        for (String nameValue : valuePairs = histogramBucketsProperty.split(PROPERTY_NAME_SEPARATOR)) {
            String[] resultKeyValueSplit = nameValue.split(PROPERTY_KEY_VALUE_SEPARATOR);
            String metricName = resultKeyValueSplit[0];
            if (resultKeyValueSplit.length != 1) {
                Object[] bucketValues = (Double[])Arrays.asList(resultKeyValueSplit[1].split(PROPERTY_VALUE_SEPARATOR)).stream().map(MetricsConfigParserUtil::evaluateHistogramBucketValue).filter(d -> d != null).toArray(Double[]::new);
                Arrays.sort(bucketValues);
                customBucket = new MetricsCustomBuckets(metricName, (Double[])bucketValues);
            }
            metricHistogramCollection.addFirst(customBucket);
        }
        return metricHistogramCollection;
    }

    public static Collection<MetricsCustomBuckets> parseTimerBuckets(String timerBucketsProperty) {
        String[] valuePairs;
        ArrayDeque<MetricsCustomBuckets> metricTimerCollection = new ArrayDeque<MetricsCustomBuckets>();
        if (timerBucketsProperty == null || timerBucketsProperty.length() == 0) {
            return null;
        }
        MetricsCustomBuckets customBucket = null;
        for (String nameValue : valuePairs = timerBucketsProperty.split(PROPERTY_NAME_SEPARATOR)) {
            String[] resultKeyValueSplit = nameValue.split(PROPERTY_KEY_VALUE_SEPARATOR);
            String metricName = resultKeyValueSplit[0];
            if (resultKeyValueSplit.length != 1) {
                Duration[] bucketValues = (Duration[])Arrays.asList(resultKeyValueSplit[1].split(PROPERTY_VALUE_SEPARATOR)).stream().map(MetricsConfigParserUtil::evaluateTimerBucketValue).filter(d -> d != null).toArray(Duration[]::new);
                customBucket = new MetricsCustomBuckets(metricName, (Double[])Arrays.stream(bucketValues).mapToDouble(Duration::toNanos).boxed().toArray(Double[]::new));
            }
            metricTimerCollection.addFirst(customBucket);
        }
        return metricTimerCollection;
    }

    public static Collection<MetricsCustomPercentiles> processPercentileMap(String appName) {
        Config config = MetricUtils.getConfigProvider();
        if (config != null) {
            Optional<String> customPercentiles = config.getOptionalValue("mp.metrics.distribution.percentiles", String.class);
            return customPercentiles.isPresent() ? MetricsConfigParserUtil.parsePercentile(customPercentiles.get()) : null;
        }
        return null;
    }

    public static Double evaluatePercentileValue(String percentile) {
        if (percentile.matches("[0][.][0-9]+")) {
            return Double.parseDouble(percentile);
        }
        logger.info(String.format("Error when trying to read property %s with %s name", "mp.metrics.distribution.percentiles", percentile));
        return null;
    }

    public static Double evaluateHistogramBucketValue(String bucket) {
        if (bucket.matches("[0-9]+[.]*[0-9]*")) {
            return Double.parseDouble(bucket);
        }
        logger.info(String.format("Error when trying to read property %s with %s name", "mp.metrics.distribution.histogram.buckets", bucket));
        return null;
    }

    public static Duration evaluateTimerBucketValue(String bucket) {
        if ((bucket = bucket.trim()).matches("[0-9]+ms")) {
            return Duration.ofMillis(Long.parseLong(bucket.substring(0, bucket.length() - 2)));
        }
        if (bucket.matches("[0-9]+s")) {
            return Duration.ofSeconds(Long.parseLong(bucket.substring(0, bucket.length() - 1)));
        }
        if (bucket.matches("[0-9]+m")) {
            return Duration.ofMinutes(Long.parseLong(bucket.substring(0, bucket.length() - 1)));
        }
        if (bucket.matches("[0-9]+h")) {
            return Duration.ofHours(Long.parseLong(bucket.substring(0, bucket.length() - 1)));
        }
        if (bucket.matches("[0-9]+")) {
            return Duration.ofMillis(Long.parseLong(bucket));
        }
        logger.info(String.format("Error when trying to read property %s with %s name", "mp.metrics.distribution.timer.buckets", bucket));
        return null;
    }
}

