/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.cdi.MetricUtils;
import fish.payara.microprofile.metrics.impl.Clock;
import fish.payara.microprofile.metrics.impl.ConfigurationProperties;
import fish.payara.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import fish.payara.microprofile.metrics.impl.HistogramImpl;
import fish.payara.microprofile.metrics.impl.MetricsConfigParserUtil;
import fish.payara.microprofile.metrics.impl.MetricsCustomBuckets;
import fish.payara.microprofile.metrics.impl.MetricsCustomPercentiles;
import jakarta.enterprise.inject.Vetoed;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
public class TimerImpl
implements Timer {
    private final Histogram histogram;
    private final Clock clock;
    private ExponentiallyDecayingReservoir reservoir;
    private ConfigurationProperties configurationProperties;

    public TimerImpl(String metricName, Map<String, Collection<MetricsCustomPercentiles>> percentilesConfigMap, Map<String, Collection<MetricsCustomBuckets>> timerBucketsConfigMap, Clock clock) {
        this(clock);
        this.validateMetricsConfiguration(metricName, percentilesConfigMap, timerBucketsConfigMap);
    }

    public TimerImpl() {
        this(new ExponentiallyDecayingReservoir());
    }

    public TimerImpl(Clock clock) {
        this(new ExponentiallyDecayingReservoir(), clock);
    }

    public TimerImpl(ExponentiallyDecayingReservoir reservoir) {
        this(reservoir, Clock.defaultClock());
    }

    public TimerImpl(ExponentiallyDecayingReservoir reservoir, Clock clock) {
        this.clock = clock;
        this.reservoir = reservoir;
        this.histogram = new HistogramImpl(reservoir);
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    @Override
    public void update(Duration duration) {
        this.update(duration.toNanos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    @Override
    public Timer.Context time() {
        return new Context(this, this.clock);
    }

    @Override
    public Duration getElapsedTime() {
        return Duration.ofNanos(this.histogram.getSum());
    }

    @Override
    public long getCount() {
        return this.histogram.getCount();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
        }
    }

    public String toString() {
        return "Timer[" + this.getCount() + "]";
    }

    void validateMetricsConfiguration(String metricName, Map<String, Collection<MetricsCustomPercentiles>> percentilesConfigMap, Map<String, Collection<MetricsCustomBuckets>> timerBucketsConfigMap) {
        Collection computedPercentiles = percentilesConfigMap.computeIfAbsent(metricName, MetricsConfigParserUtil::processPercentileMap);
        Collection computedTimersBuckets = timerBucketsConfigMap.computeIfAbsent(metricName, this::processTimerBucketMap);
        MetricsCustomPercentiles resultPercentile = null;
        MetricsCustomBuckets resultBucket = null;
        this.configurationProperties = new ConfigurationProperties();
        if (computedPercentiles != null && !computedPercentiles.isEmpty()) {
            resultPercentile = MetricsCustomPercentiles.matches(computedPercentiles, metricName);
        }
        if (resultPercentile != null && resultPercentile.getPercentiles() != null && resultPercentile.getPercentiles().length > 0) {
            this.configurationProperties.setPercentilesFromConfig(resultPercentile.getPercentiles());
        } else if (resultPercentile == null || resultPercentile.getPercentiles() != null || !resultPercentile.isDisabled()) {
            Double[] percentiles = new Double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
            this.configurationProperties.setPercentilesFromConfig(percentiles);
        }
        if (computedTimersBuckets != null && computedTimersBuckets.size() != 0) {
            resultBucket = MetricsCustomBuckets.matches(computedTimersBuckets, metricName);
        }
        if (resultBucket != null && resultBucket.getBuckets() != null && resultBucket.getBuckets().length > 0) {
            this.configurationProperties.setBucketValuesFromConfig(resultBucket.getBuckets());
        }
        this.reservoir.setConfigAdapter(this.configurationProperties);
    }

    private Collection<MetricsCustomBuckets> processTimerBucketMap(String appName) {
        Config config = MetricUtils.getConfigProvider();
        if (config != null) {
            Optional<String> customBuckets = config.getOptionalValue("mp.metrics.distribution.timer.buckets", String.class);
            return customBuckets.isPresent() ? MetricsConfigParserUtil.parseTimerBuckets(customBuckets.get()) : null;
        }
        return null;
    }

    private static class Context
    implements Timer.Context {
        private final Timer timer;
        private final Clock clock;
        private final long startTime;

        Context(Timer timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        @Override
        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

