/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.faces.integration;

import com.sun.enterprise.util.Utility;
import com.sun.faces.config.FacesInitializer;
import com.sun.faces.config.FacesInitializer2;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletContainerInitializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.GenericSniffer;
import org.glassfish.web.loader.ServletContainerInitializerUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="mojarra-sniffer")
@Singleton
public class MojarraSniffer
extends GenericSniffer {
    private static final String ALLOW_FACES_CDI_INITIALISATION_SYSTEM_PROPERTY = "fish.payara.faces.integration.allowFacesCdiInitialisation";
    private static final String ALLOW_FACES_CDI_INITIALISATION_DEPLOY_PROPERTY = "allowFacesCdiInitialisation";
    private static final String[] containers = new String[]{"org.glassfish.weld.WeldContainer"};
    private static final Logger logger = Logger.getLogger(MojarraSniffer.class.getName());

    public MojarraSniffer() {
        super("cdi", null, null);
    }

    public String[] getContainersNames() {
        return containers;
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.toString().equals(ModuleType.WAR.toString());
    }

    public boolean handles(DeploymentContext context) {
        if (this.skipHandler(context)) {
            return false;
        }
        ArchiveType archiveType = (ArchiveType)this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        if (archiveType != null) {
            context.getSource().setExtraData(ArchiveType.class, (Object)archiveType);
        }
        logger.fine("Checking if application has a faces-config.xml file...");
        boolean handles = this.hasFacesXml(context);
        if (!handles) {
            logger.fine("No faces-config.xml file found, checking if application contains a class which the Mojarra ServletContainerInitializers should handle");
            handles = this.hasFacesEnablingClass(context);
        }
        if (handles) {
            logger.fine("Faces content has been detected in application, setting fish.payara.faces.integration.allowFacesCdiInitialisation to true");
            context.addTransientAppMetaData(ALLOW_FACES_CDI_INITIALISATION_SYSTEM_PROPERTY, (Object)Boolean.TRUE);
            return true;
        }
        logger.fine("No Faces content detected");
        return false;
    }

    private boolean skipHandler(DeploymentContext context) {
        Object propValue;
        boolean skip = true;
        if (Boolean.getBoolean(ALLOW_FACES_CDI_INITIALISATION_SYSTEM_PROPERTY)) {
            skip = false;
        }
        if ((propValue = context.getAppProps().get(ALLOW_FACES_CDI_INITIALISATION_DEPLOY_PROPERTY)) != null) {
            skip = !Boolean.parseBoolean((String)propValue);
        }
        return skip;
    }

    private boolean hasFacesXml(DeploymentContext context) {
        return this.isEntryPresent(context.getSource(), "WEB-INF/faces-config.xml");
    }

    private boolean isEntryPresent(ReadableArchive archive, String entry) {
        boolean entryPresent = false;
        try {
            logger.finer("Checking if " + entry + " exists in " + archive.getName());
            entryPresent = archive.exists(entry);
        }
        catch (IOException ioException) {
            logger.log(Level.FINE, "Ignoring exception encountered while checking if faces-config.xml file is present", ioException);
        }
        return entryPresent;
    }

    private boolean hasFacesEnablingClass(DeploymentContext context) {
        boolean result = false;
        List<ServletContainerInitializer> facesInitialisers = this.getMojarraServletContextInitialisers(context);
        Map interestList = ServletContainerInitializerUtil.getInterestList(facesInitialisers);
        Map initialiserList = ServletContainerInitializerUtil.getInitializerList(facesInitialisers, (Map)interestList, (Types)this.getTypes(context), (ClassLoader)Utility.getClassLoader(), (boolean)false);
        for (Map.Entry initialiserEntry : initialiserList.entrySet()) {
            if (initialiserEntry.getValue() == null || ((Set)initialiserEntry.getValue()).isEmpty()) continue;
            if (logger.isLoggable(Level.FINE)) {
                ArrayList classNames = new ArrayList();
                ((Set)initialiserEntry.getValue()).stream().forEach(clazz -> classNames.add(clazz.getName()));
                logger.fine(((Class)initialiserEntry.getKey()).getName() + " container initialiser has an interest in the following classes detected within the application: " + Arrays.toString(classNames.toArray()));
            }
            result = true;
            break;
        }
        return result;
    }

    private List<ServletContainerInitializer> getMojarraServletContextInitialisers(DeploymentContext context) {
        ArrayList<ServletContainerInitializer> facesInitialisers = new ArrayList<ServletContainerInitializer>();
        logger.finer("Getting Mojarra FacesInitializer and FacesInitializer2 servlet context initialisers");
        ServiceLoader<ServletContainerInitializer> servletContainerInitialisers = ServiceLoader.load(ServletContainerInitializer.class);
        for (ServletContainerInitializer servletContainerInitialiser : servletContainerInitialisers) {
            if (!(servletContainerInitialiser instanceof FacesInitializer) && !(servletContainerInitialiser instanceof FacesInitializer2)) continue;
            logger.finer("Found " + servletContainerInitialiser.getClass().getName());
            facesInitialisers.add(servletContainerInitialiser);
        }
        return facesInitialisers;
    }

    private Types getTypes(DeploymentContext context) {
        String metadataKey = Types.class.getName();
        Types types = (Types)context.getTransientAppMetadata().get(metadataKey);
        while (types == null && (context = ((ExtendedDeploymentContext)context).getParentContext()) != null) {
            types = (Types)context.getTransientAppMetadata().get(metadataKey);
        }
        if (types == null) {
            logger.fine("No types found!");
        }
        return types;
    }
}

