/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-protocol")
@PerLookup
@I18n(value="create.protocol")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateProtocol
implements AdminCommand {
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="securityenabled", alias="securityEnabled", optional=true, defaultValue="false")
    Boolean securityEnabled = false;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        for (Protocol protocol : protocols.getProtocol()) {
            if (this.protocolName == null || !this.protocolName.equalsIgnoreCase(protocol.getName())) continue;
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00017"), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            CreateProtocol.create(protocols, this.protocolName, this.securityEnabled);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00018"), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        catch (Exception e) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00018"), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public static void create(Protocols protocols, final String name, final Boolean securityEnabled) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol newProtocol = (Protocol)param.createChild(Protocol.class);
                newProtocol.setName(name);
                newProtocol.setSecurityEnabled(securityEnabled == null ? null : securityEnabled.toString());
                param.getProtocol().add(newProtocol);
                if (securityEnabled.booleanValue()) {
                    Ssl ssl = (Ssl)newProtocol.createChild(Ssl.class);
                    ssl.setCertNickname("s1as");
                    newProtocol.setSsl(ssl);
                }
                return newProtocol;
            }
        }, (ConfigBeanProxy)protocols);
    }
}

