/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.callbacks;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExtensibleTreeMap;
import fish.payara.microprofile.openapi.impl.model.OperationImpl;
import fish.payara.microprofile.openapi.impl.model.PathItemImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class CallbackImpl
extends ExtensibleTreeMap<PathItem, Callback>
implements Callback {
    private static final long serialVersionUID = 5549098533131353142L;
    private String ref;
    private String urlExpression;
    private List<Operation> operations = ModelUtils.createList();

    public static Callback createInstance(AnnotationModel annotation, ApiContext context) {
        String urlExpression;
        CallbackImpl from = new CallbackImpl();
        from.setExtensions(ExtensibleImpl.parseExtensions(annotation));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        if ((urlExpression = (String)annotation.getValue("callbackUrlExpression", String.class)) != null && !urlExpression.isEmpty()) {
            from.setUrlExpression(urlExpression);
            List<Operation> operations = ModelUtils.createList();
            ModelUtils.extractAnnotations(annotation, context, "operations", OperationImpl::createInstance, operations::add);
            from.setOperations(operations);
        }
        return from;
    }

    public CallbackImpl() {
    }

    public CallbackImpl(Map<String, ? extends PathItem> items) {
        super(items);
    }

    public Callback addPathItem(String name, PathItem item) {
        if (item != null) {
            this.put(name, item);
        }
        return this;
    }

    public void removePathItem(String name) {
        this.remove(name);
    }

    public Map<String, PathItem> getPathItems() {
        return ModelUtils.readOnlyView(this);
    }

    public void setPathItems(Map<String, PathItem> items) {
        this.clear();
        this.putAll(items);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !((String)ref).contains(".") && !((String)ref).contains("/")) {
            ref = "#/components/callbacks/" + (String)ref;
        }
        this.ref = ref;
    }

    public String getUrlExpression() {
        return this.urlExpression;
    }

    public void setUrlExpression(String urlExpression) {
        this.urlExpression = urlExpression;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = ModelUtils.createList(operations);
    }

    public static void merge(Callback from, Callback to, boolean override, ApiContext context) {
        CallbackImpl fromImpl;
        String urlExpression;
        if (from == null) {
            return;
        }
        to.setExtensions(ModelUtils.mergeProperty(to.getExtensions(), from.getExtensions(), override));
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        if (from instanceof CallbackImpl && (urlExpression = (fromImpl = (CallbackImpl)from).getUrlExpression()) != null && !urlExpression.isEmpty()) {
            PathItem pathItem = to.getPathItems().getOrDefault(urlExpression, new PathItemImpl());
            to.addPathItem(urlExpression, pathItem);
            if (fromImpl.getOperations() != null) {
                for (Operation callbackOperation : fromImpl.getOperations()) {
                    CallbackImpl.applyCallbackOperationAnnotation(pathItem, callbackOperation, override, context);
                }
            }
        }
    }

    private static void applyCallbackOperationAnnotation(PathItem pathItem, Operation callbackOperation, boolean override, ApiContext context) {
        PathItem.HttpMethod method;
        OperationImpl callbackOperationImpl;
        if (callbackOperation instanceof OperationImpl && (callbackOperationImpl = (OperationImpl)callbackOperation).getMethod() != null && (method = ModelUtils.getHttpMethod(callbackOperationImpl.getMethod())) != null) {
            Operation operation = ModelUtils.getOrCreateOperation(pathItem, method);
            OperationImpl.merge(callbackOperation, operation, override, context);
        }
    }
}

