/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.security;

import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class OAuthFlowImpl
extends ExtensibleImpl<OAuthFlow>
implements OAuthFlow {
    private String authorizationUrl;
    private String tokenUrl;
    private String refreshUrl;
    private Map<String, String> scopes = ModelUtils.createMap();

    public static OAuthFlow createInstance(AnnotationModel annotation) {
        OAuthFlowImpl from = new OAuthFlowImpl();
        from.setAuthorizationUrl((String)annotation.getValue("authorizationUrl", String.class));
        from.setTokenUrl((String)annotation.getValue("tokenUrl", String.class));
        from.setRefreshUrl((String)annotation.getValue("refreshUrl", String.class));
        from.setExtensions(OAuthFlowImpl.parseExtensions(annotation));
        List scopesAnnotation = (List)annotation.getValue("scopes", List.class);
        if (scopesAnnotation != null) {
            Map<String, String> scopes = ModelUtils.createMap();
            for (AnnotationModel scopeAnnotation : scopesAnnotation) {
                scopes.put((String)scopeAnnotation.getValue("name", String.class), (String)scopeAnnotation.getValue("description", String.class));
            }
            from.setScopes(scopes);
        }
        return from;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public void setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public Map<String, String> getScopes() {
        return ModelUtils.readOnlyView(this.scopes);
    }

    public void setScopes(Map<String, String> scopes) {
        this.scopes = ModelUtils.createMap(scopes);
    }

    public OAuthFlow addScope(String scope, String description) {
        if (scope != null) {
            if (this.scopes == null) {
                this.scopes = ModelUtils.createMap();
            }
            this.scopes.put(scope, description);
        }
        return this;
    }

    public void removeScope(String scope) {
        if (this.scopes != null) {
            this.scopes.remove(scope);
        }
    }

    public static void merge(OAuthFlow from, OAuthFlow to, boolean override) {
        if (from == null) {
            return;
        }
        to.setTokenUrl(ModelUtils.mergeProperty(to.getTokenUrl(), from.getTokenUrl(), override));
        if (from.getScopes() != null) {
            to.setScopes(ModelUtils.mergeProperty(to.getScopes(), from.getScopes(), override));
        }
        to.setRefreshUrl(ModelUtils.mergeProperty(to.getRefreshUrl(), from.getRefreshUrl(), override));
        to.setExtensions(ModelUtils.mergeProperty(to.getExtensions(), from.getExtensions(), override));
        to.setAuthorizationUrl(ModelUtils.mergeProperty(to.getAuthorizationUrl(), from.getAuthorizationUrl(), override));
    }
}

