/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.EpochCarrier;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public abstract class BaseAuthConfigImpl {
    String loggerName;
    EpochCarrier providerEpoch;
    long epoch;
    MessagePolicyDelegate policyDelegate;
    String layer;
    String appContext;
    CallbackHandler callbackHandler;
    private ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private Lock instanceReadLock = this.instanceReadWriteLock.readLock();
    private Lock instanceWriteLock = this.instanceReadWriteLock.writeLock();

    public BaseAuthConfigImpl(String loggerName, EpochCarrier providerEpoch, MessagePolicyDelegate mpDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        this.loggerName = loggerName;
        this.providerEpoch = providerEpoch;
        this.policyDelegate = mpDelegate;
        this.layer = layer;
        this.appContext = appContext;
        this.callbackHandler = cbh;
        this.initialize();
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return this.policyDelegate.getAuthContextID(messageInfo);
    }

    public void refresh() {
        try {
            this.initialize();
        }
        catch (AuthException ae) {
            throw new RuntimeException(ae);
        }
    }

    private void initialize() throws AuthException {
        this.instanceWriteLock.lock();
        try {
            this.epoch = this.providerEpoch.getEpoch();
            this.initializeContextMap();
        }
        finally {
            this.instanceWriteLock.unlock();
        }
    }

    private void doRefreshIfNeeded() {
        boolean hasChanged = false;
        this.instanceReadLock.lock();
        try {
            hasChanged = this.providerEpoch.hasChanged(this.epoch);
        }
        finally {
            this.instanceReadLock.unlock();
        }
        if (hasChanged) {
            this.refresh();
        }
    }

    private Integer getHashCode(Map<String, ?> properties) {
        if (properties == null) {
            return Integer.valueOf("0");
        }
        return properties.hashCode();
    }

    private <M> M getContextFromMap(Map<String, Map<Integer, M>> contextMap, String authContextID, Map<String, Object> properties) {
        M context = null;
        Map<Integer, M> internalMap = contextMap.get(authContextID);
        if (internalMap != null) {
            context = internalMap.get(this.getHashCode(properties));
        }
        if (context != null && this.isLoggable(Level.FINE)) {
            this.logIfLevel(Level.FINE, null, "AuthContextID found in Map: ", authContextID);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <M> M getContext(Map<String, Map<Integer, M>> contextMap, String authContextID, Subject subject, Map<String, Object> properties) throws AuthException {
        Object context = null;
        this.doRefreshIfNeeded();
        this.instanceReadLock.lock();
        try {
            context = this.getContextFromMap(contextMap, authContextID, properties);
            if (context != null) {
                Object v = context;
                return (M)v;
            }
        }
        finally {
            this.instanceReadLock.unlock();
        }
        this.instanceWriteLock.lock();
        try {
            context = this.getContextFromMap(contextMap, authContextID, properties);
            if (context == null) {
                context = this.createAuthContext(authContextID, properties);
                Map<Integer, M> internalMap = contextMap.get(authContextID);
                if (internalMap == null) {
                    internalMap = new HashMap<Integer, M>();
                    contextMap.put(authContextID, internalMap);
                }
                internalMap.put(this.getHashCode(properties), context);
            }
            Object v = context;
            return (M)v;
        }
        finally {
            this.instanceWriteLock.unlock();
        }
    }

    protected boolean isLoggable(Level level) {
        return Logger.getLogger(this.loggerName).isLoggable(level);
    }

    protected void logIfLevel(Level level, Throwable t, String ... msgParts) {
        Logger logger = Logger.getLogger(this.loggerName);
        if (logger.isLoggable(level)) {
            StringBuilder messageBuffer = new StringBuilder("");
            for (String m : msgParts) {
                messageBuffer.append(m);
            }
            String msg = messageBuffer.toString();
            if (!msg.isEmpty() && t != null) {
                logger.log(level, msg, t);
            } else if (!msg.isEmpty()) {
                logger.log(level, msg);
            }
        }
    }

    protected void checkMessageTypes(Class<?>[] supportedMessageTypes) throws AuthException {
        Class<?>[] requiredMessageTypes;
        for (Class<?> requiredType : requiredMessageTypes = this.policyDelegate.getMessageTypes()) {
            boolean supported = false;
            for (Class<?> supportedType : supportedMessageTypes) {
                if (!requiredType.isAssignableFrom(supportedType)) continue;
                supported = true;
            }
            if (supported) continue;
            throw new AuthException("module does not support message type: " + requiredType.getName());
        }
    }

    protected abstract void initializeContextMap();

    protected abstract <M> M createAuthContext(String var1, Map<String, Object> var2) throws AuthException;
}

