/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.AppTenant;
import com.sun.enterprise.config.serverbeans.AppTenants;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.ClassloaderResourceLocatorAdapter;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.ReadableArchiveScannerAdapter;
import com.sun.enterprise.v3.server.SnifferManagerImpl;
import fish.payara.deployment.transformer.api.JakartaNamespaceDeploymentTransformer;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.hotdeploy.ApplicationState;
import fish.payara.nucleus.hotdeploy.HotDeployService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.virtualization.VirtualizationEnv;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.ClientJarWriter;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.monitor.DeploymentLifecycleProbeProvider;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.util.CommonModelRegistry;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.ApplicationLifecycleInterceptor;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.analysis.DeploymentSpan;
import org.glassfish.internal.deployment.analysis.SpanSequence;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;
import org.glassfish.internal.deployment.analysis.TraceContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class ApplicationLifecycle
implements Deployment,
PostConstruct {
    private static final String[] UPLOADED_GENERATED_DIRS = new String[]{"policy", "xml", "ejb", "jsp"};
    @Inject
    protected SnifferManagerImpl snifferManager;
    @Inject
    ServiceLocator habitat;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    protected Applications applications;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    @Inject
    protected Domain domain;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    @Optional
    VirtualizationEnv virtEnv;
    @Inject
    Events events;
    @Inject
    ConfigSupport configSupport;
    @Inject
    CommonClassLoaderServiceImpl commonClassLoaderService;
    @Inject
    PayaraExecutorService executorService;
    @Inject
    private HotDeployService hotDeployService;
    protected Logger logger = KernelLoggerInfo.getLogger();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    private final ThreadLocal<Deque<ExtendedDeploymentContext>> currentDeploymentContext = new ThreadLocal<Deque<ExtendedDeploymentContext>>(){

        @Override
        protected Deque<ExtendedDeploymentContext> initialValue() {
            return new ArrayDeque<ExtendedDeploymentContext>(5);
        }
    };
    protected DeploymentLifecycleProbeProvider deploymentLifecycleProbeProvider = null;
    private Collection<ApplicationLifecycleInterceptor> alcInterceptors = Collections.EMPTY_LIST;

    public void postConstruct() {
        this.deploymentLifecycleProbeProvider = new DeploymentLifecycleProbeProvider();
        this.alcInterceptors = this.habitat.getAllServices(ApplicationLifecycleInterceptor.class, new Annotation[0]);
        this.habitat.getAllServices((Filter)BuilderHelper.createNameFilter((String)"ManagedBeanManagerImpl"));
        this.habitat.getAllServices((Filter)BuilderHelper.createNameFilter((String)"ResourceManager"));
        this.habitat.getAllServices((Filter)BuilderHelper.createNameFilter((String)"ApplicationScopedResourcesManager"));
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        return this.getArchiveHandler(archive, null);
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive, String type) throws IOException {
        ArchiveDetector archiveDetector;
        if (type != null && (archiveDetector = (ArchiveDetector)this.habitat.getService(ArchiveDetector.class, type, new Annotation[0])) != null) {
            return archiveDetector.getArchiveHandler();
        }
        ArrayList detectors = new ArrayList(this.habitat.getAllServices(ArchiveDetector.class, new Annotation[0]));
        Collections.sort(detectors, new Comparator<ArchiveDetector>(){

            @Override
            public int compare(ArchiveDetector o1, ArchiveDetector o2) {
                return o1.rank() - o2.rank();
            }
        });
        for (ArchiveDetector ad : detectors) {
            if (!ad.handles(archive)) continue;
            return ad.getArchiveHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Deployment.ApplicationDeployment prepare(Collection<? extends Sniffer> sniffers, final ExtendedDeploymentContext context) {
        ApplicationInfo appInfo;
        block84: {
            Deployment.ApplicationDeployment applicationDeployment;
            StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
            DeploymentSpan eventSpan = tracing.startSpan((Enum)DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.DEPLOYMENT_START.type());
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_START, context), false);
            eventSpan.close();
            this.currentDeploymentContext.get().push(context);
            ActionReport report = context.getActionReport();
            final DeployCommandParameters commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
            final String appName = commandParams.name();
            java.util.Optional appState = this.hotDeployService.getApplicationState((DeploymentContext)context);
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            ProgressTracker tracker = new ProgressTracker(){

                public void actOn(Logger logger) {
                    for (EngineRef module : this.get("loaded", EngineRef.class)) {
                        try {
                            module.stop((ApplicationContext)context);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        ((PreDestroy)PreDestroy.class.cast(context)).preDestroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (EngineRef module : this.get("loaded", EngineRef.class)) {
                        try {
                            module.unload(context);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        ApplicationInfo appInfo = ApplicationLifecycle.this.appRegistry.get(appName);
                        if (appInfo != null) {
                            ApplicationLifecycle.this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_DISABLED, appInfo));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (EngineRef module : this.get("prepared", EngineRef.class)) {
                        try {
                            module.clean(context);
                        }
                        catch (Exception exception) {}
                    }
                    if (!commandParams.keepfailedstubs.booleanValue()) {
                        try {
                            context.clean();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ApplicationLifecycle.this.appRegistry.remove(appName);
                }
            };
            try (DeploymentSpan topSpan = tracing.startSpan((Enum)DeploymentTracing.AppStage.PREPARE);
                 SpanSequence span = tracing.startSequence((Enum)DeploymentTracing.AppStage.PREPARE, "ArchiveMetadata");){
                void var20_33;
                SpanSequence innerSpan;
                List<EngineInfo> sortedEngineInfos;
                if (commandParams.origin == OpsParams.Origin.deploy && this.appRegistry.get(appName) != null && !commandParams.hotDeploy.booleanValue()) {
                    report.setMessage(localStrings.getLocalString("appnamenotunique", "Application name {0} is already in use. Please pick a different name.", new Object[]{appName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    Deployment.ApplicationDeployment applicationDeployment2 = null;
                    return applicationDeployment2;
                }
                if (commandParams.virtualservers == null) {
                    commandParams.virtualservers = DeploymentUtils.getVirtualServers((String)commandParams.target, (ServerEnvironment)this.env, (Domain)this.domain);
                }
                if (commandParams.enabled == null) {
                    commandParams.enabled = Boolean.TRUE;
                }
                if (commandParams.altdd != null) {
                    context.getSource().addArchiveMetaData("altdd", commandParams.altdd);
                }
                if (commandParams.runtimealtdd != null) {
                    context.getSource().addArchiveMetaData("runtimealtdd", commandParams.runtimealtdd);
                }
                context.addTransientAppMetaData("tracker", (Object)tracker);
                context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
                span.start("ArchiveHandler");
                ArchiveHandler handler = context.getArchiveHandler();
                if (handler == null) {
                    handler = this.getArchiveHandler(context.getSource(), commandParams.type);
                    context.setArchiveHandler(handler);
                }
                if (handler == null) {
                    report.setMessage(localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{context.getSourceDir()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    Deployment.ApplicationDeployment applicationDeployment3 = null;
                    return applicationDeployment3;
                }
                span.start((Enum)DeploymentTracing.AppStage.CLASS_SCANNING);
                Types types = null;
                if (handler.requiresAnnotationScanning(context.getSource())) {
                    types = this.getDeployableTypes((DeploymentContext)context);
                }
                span.finish();
                this.transformApplication(context, types, tracing, span);
                if (sniffers != null && this.logger.isLoggable(Level.FINE)) {
                    for (Sniffer sniffer : sniffers) {
                        this.logger.log(Level.FINE, "Before Sorting{0}", sniffer.getModuleType());
                    }
                }
                span.start((Enum)DeploymentTracing.AppStage.PREPARE, "Sniffer");
                Collection<? extends Sniffer> selectedSniffers = sniffers = this.getSniffers(handler, sniffers, (DeploymentContext)context);
                appState.ifPresent(s -> s.setSniffers(selectedSniffers));
                span.start((Enum)DeploymentTracing.AppStage.PREPARE, "ClassLoaderHierarchy");
                ClassLoaderHierarchy classLoaderHierarchy = (ClassLoaderHierarchy)this.habitat.getService(ClassLoaderHierarchy.class, new Annotation[0]);
                span.start((Enum)DeploymentTracing.AppStage.PREPARE, "ClassLoader");
                context.createDeploymentClassLoader(classLoaderHierarchy, handler);
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.AFTER_DEPLOYMENT_CLASSLOADER_CREATION, context), false);
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                span.start((Enum)DeploymentTracing.AppStage.PREPARE, "Container");
                if (appState.map(ApplicationState::getEngineInfos).isPresent()) {
                    sortedEngineInfos = ((ApplicationState)appState.get()).getEngineInfos();
                    this.loadDeployers(sortedEngineInfos.stream().collect(Collectors.toMap(EngineInfo::getDeployer, Function.identity())), (DeploymentContext)context);
                } else {
                    sortedEngineInfos = this.setupContainerInfos(handler, sniffers, (DeploymentContext)context);
                    appState.ifPresent(s -> s.setEngineInfos(sortedEngineInfos));
                }
                span.start((Enum)DeploymentTracing.AppStage.CREATE_CLASSLOADER);
                if (sortedEngineInfos.isEmpty()) {
                    throw new DeploymentException(localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource().getName()}));
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    for (EngineInfo engineInfo : sortedEngineInfos) {
                        this.logger.log(Level.FINE, "After Sorting {0}", engineInfo.getSniffer().getModuleType());
                    }
                }
                ApplicationInfo tempAppInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                for (Object m : context.getModuleMetadata()) {
                    tempAppInfo.addMetaData(m);
                }
                tempAppInfo.setIsJavaEEApp(sortedEngineInfos);
                context.getSource().setExtraData(Boolean.class, tempAppInfo.isJavaEEApp());
                this.appRegistry.add(appName, tempAppInfo);
                try {
                    this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.PREPARE, context);
                }
                catch (Throwable throwable) {
                    Object m;
                    report.failure(this.logger, "Exception while invoking the lifecycle interceptor", null);
                    report.setFailureCause(throwable);
                    this.logger.log(Level.SEVERE, "NCLS-CORE-00026", throwable);
                    tracker.actOn(this.logger);
                    m = null;
                    if (span != null) {
                        span.close();
                    }
                    if (topSpan != null) {
                        topSpan.close();
                    }
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) return m;
                    context.postDeployClean(false);
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    this.currentDeploymentContext.get().pop();
                    return m;
                }
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION, context), false);
                context.createApplicationClassLoader(classLoaderHierarchy, handler);
                tempAppInfo.setAppClassLoader(context.getFinalClassLoader());
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.AFTER_APPLICATION_CLASSLOADER_CREATION, context), false);
                try {
                    innerSpan = span.start((Enum)DeploymentTracing.AppStage.PREPARE, "Module");
                    try {
                        if (appState.map(ApplicationState::getModuleInfo).isPresent()) {
                            ModuleInfo moduleInfo = ((ApplicationState)appState.get()).getModuleInfo();
                            moduleInfo.reset();
                        } else {
                            ModuleInfo moduleInfo = this.prepareModule(sortedEngineInfos, appName, (DeploymentContext)context, tracker);
                            appState.ifPresent(s -> s.setModuleInfo(moduleInfo));
                        }
                        ClientJarWriter cjw = new ClientJarWriter(context);
                        cjw.run();
                    }
                    finally {
                        if (innerSpan != null) {
                            innerSpan.close();
                        }
                    }
                }
                catch (Throwable prepareException) {
                    report.failure(this.logger, "Exception while preparing the app", null);
                    report.setFailureCause(prepareException);
                    this.logger.log(Level.SEVERE, "NCLS-CORE-00026", prepareException);
                    tracker.actOn(this.logger);
                    Deployment.ApplicationDeployment cjw = null;
                    if (span != null) {
                        span.close();
                    }
                    if (topSpan != null) {
                        topSpan.close();
                    }
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) return cjw;
                    context.postDeployClean(false);
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    this.currentDeploymentContext.get().pop();
                    return cjw;
                }
                span.start((Enum)DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.APPLICATION_PREPARED.type());
                if (appState.map(ApplicationState::getApplicationInfo).isPresent()) {
                    appInfo = ((ApplicationState)appState.get()).getApplicationInfo();
                    appInfo.reset(context.getSource());
                    for (Object metadata : context.getModuleMetadata()) {
                        var20_33.addMetaData(metadata);
                        appInfo.addMetaData(metadata);
                    }
                } else {
                    appInfo = (ApplicationInfo)context.getModuleMetaData(ApplicationInfo.class);
                    if (appInfo == null) {
                        ApplicationInfo applicationInfo;
                        appInfo = applicationInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                        appInfo.addModule((ModuleInfo)var20_33);
                        appState.ifPresent(s -> s.setApplicationInfo(applicationInfo));
                        for (Object metadata : context.getModuleMetadata()) {
                            var20_33.addMetaData(metadata);
                            appInfo.addMetaData(metadata);
                        }
                    } else {
                        for (EngineRef ref : var20_33.getEngineRefs()) {
                            appInfo.add(ref);
                        }
                    }
                }
                this.appRegistry.remove(appName);
                appInfo.setIsJavaEEApp(sortedEngineInfos);
                this.appRegistry.add(appName, appInfo);
                this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.PREPARE, context);
                context.setPhase(ExtendedDeploymentContext.Phase.PREPARED);
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                appInfo.setAppClassLoader(context.getClassLoader());
                appState.ifPresent(s -> s.setApplicationClassLoader(context.getClassLoader()));
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_PREPARED, context), false);
                if (!this.loadOnCurrentInstance((DeploymentContext)context)) break block84;
                appInfo.setLibraries(commandParams.libraries());
                try {
                    innerSpan = span.start((Enum)DeploymentTracing.AppStage.LOAD);
                    try {
                        this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.LOAD, context);
                        appInfo.load(context, tracker);
                        this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.LOAD, context);
                    }
                    finally {
                        if (innerSpan != null) {
                            innerSpan.close();
                        }
                    }
                }
                catch (Throwable loadException) {
                    this.logger.log(Level.SEVERE, "NCLS-CORE-00026", loadException);
                    report.failure(this.logger, "Exception while loading the app", null);
                    report.setFailureCause(loadException);
                    tracker.actOn(this.logger);
                    Deployment.ApplicationDeployment applicationDeployment4 = null;
                    if (span != null) {
                        span.close();
                    }
                    if (topSpan != null) {
                        topSpan.close();
                    }
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) return applicationDeployment4;
                    context.postDeployClean(false);
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    this.currentDeploymentContext.get().pop();
                    return applicationDeployment4;
                }
            }
            catch (DeploymentException de) {
                report.failure(this.logger, de.getMessage());
                tracker.actOn(this.logger);
                applicationDeployment = null;
                return applicationDeployment;
            }
            catch (Exception e) {
                report.failure(this.logger, localStrings.getLocalString("error.deploying.app", "Exception while deploying the app [{0}]", new Object[]{appName}), null);
                report.setFailureCause(e);
                this.logger.log(Level.SEVERE, "NCLS-CORE-00026", e);
                tracker.actOn(this.logger);
                applicationDeployment = null;
                return applicationDeployment;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCL);
                if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                    context.postDeployClean(false);
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    this.currentDeploymentContext.get().pop();
                }
            }
        }
        Deployment.ApplicationDeployment depl = new Deployment.ApplicationDeployment(appInfo, context);
        this.appRegistry.addTransient(depl);
        return depl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ApplicationInfo appInfo, Collection<? extends Sniffer> sniffers, ExtendedDeploymentContext context) {
        if (appInfo == null) {
            return;
        }
        this.appRegistry.removeTransient(appInfo.getName());
        ActionReport report = context.getActionReport();
        ProgressTracker tracker = (ProgressTracker)context.getTransientAppMetaData("tracker", ProgressTracker.class);
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
        if (this.loadOnCurrentInstance((DeploymentContext)context)) {
            try (SpanSequence span = tracing.startSequence((Enum)DeploymentTracing.AppStage.INITIALIZE);){
                this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.START, context);
                appInfo.initialize();
                appInfo.getModuleInfos().forEach(moduleInfo -> moduleInfo.getEngineRefs().forEach(engineRef -> tracker.add("initialized", EngineRef.class, engineRef)));
                span.start((Enum)DeploymentTracing.AppStage.START);
                appInfo.start(context, tracker);
                this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.START, context);
            }
            catch (Throwable loadException) {
                this.logger.log(Level.SEVERE, "NCLS-CORE-00026", loadException);
                report.failure(this.logger, "Exception while loading the app", null);
                report.setFailureCause(loadException);
                tracker.actOn(this.logger);
            }
            finally {
                context.postDeployClean(false);
                if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                } else {
                    this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                }
            }
        }
        this.currentDeploymentContext.get().pop();
    }

    public ApplicationInfo deploy(ExtendedDeploymentContext context) {
        return this.deploy(null, context);
    }

    public ApplicationInfo deploy(Collection<? extends Sniffer> sniffers, ExtendedDeploymentContext context) {
        ApplicationInfo appInfo;
        long operationStartTime = System.currentTimeMillis();
        Deployment.ApplicationDeployment rv = this.prepare(sniffers, context);
        ApplicationInfo applicationInfo = appInfo = rv != null ? rv.appInfo : null;
        if (appInfo != null) {
            this.initialize(appInfo, sniffers, context);
            long operationTime = System.currentTimeMillis() - operationStartTime;
            this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appInfo.getName(), this.getApplicationType(appInfo), String.valueOf(operationTime));
        }
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Types getDeployableTypes(DeploymentContext context) throws IOException {
        DeploymentContext deploymentContext = context;
        synchronized (deploymentContext) {
            Types types = context.getTransientAppMetaData(Types.class.getName(), Types.class);
            if (types != null) {
                return types;
            }
            StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
            Boolean skipScanExternalLibProp = Boolean.valueOf(context.getAppProps().getProperty("skipScanExternalLib"));
            Parser parser = this.getDeployableParser(context.getSource(), skipScanExternalLibProp, false, tracing, context.getLogger(), context);
            ParsingContext parsingContext = parser.getContext();
            context.addTransientAppMetaData(Types.class.getName(), parsingContext.getTypes());
            context.addTransientAppMetaData(Parser.class.getName(), parser);
            return parsingContext.getTypes();
        }
    }

    public Parser getDeployableParser(ReadableArchive source, boolean skipScanExternalLibProp, boolean modelUnAnnotatedMembers, StructuredDeploymentTracing tracing, Logger logger, DeploymentContext deploymentContext) throws IOException {
        Parser parser = new Parser(this.createBuilder(modelUnAnnotatedMembers, logger).build());
        try (ReadableArchiveScannerAdapter scannerAdapter = new ReadableArchiveScannerAdapter(parser, source);){
            DeploymentSpan mainScanSpan = tracing.startSpan((Enum)DeploymentTracing.AppStage.CLASS_SCANNING, source.getName());
            Parser parser2 = this.processParsing(skipScanExternalLibProp, tracing, parser, scannerAdapter, mainScanSpan, deploymentContext);
            return parser2;
        }
    }

    public Parser getDeployableParser(ReadableArchive source, boolean skipScanExternalLibProp, boolean modelUnAnnotatedMembers, StructuredDeploymentTracing tracing, Logger logger) throws IOException {
        Parser parser = new Parser(this.createBuilder(modelUnAnnotatedMembers, logger).build());
        ReadableArchiveScannerAdapter scannerAdapter = new ReadableArchiveScannerAdapter(parser, source);
        DeploymentSpan mainScanSpan = tracing.startSpan((Enum)DeploymentTracing.AppStage.CLASS_SCANNING, source.getName());
        return this.processParsing(source, skipScanExternalLibProp, tracing, parser, scannerAdapter, mainScanSpan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parser processParsing(ReadableArchive source, boolean skipScanExternalLibProp, StructuredDeploymentTracing tracing, Parser parser, ReadableArchiveScannerAdapter scannerAdapter, DeploymentSpan mainScanSpan) throws IOException {
        try {
            parser.parse((ArchiveAdapter)scannerAdapter, () -> mainScanSpan.close());
            for (ReadableArchive externalLibArchive : this.getExternalLibraries(source, skipScanExternalLibProp)) {
                ReadableArchiveScannerAdapter libAdapter = null;
                try {
                    DeploymentSpan span = tracing.startSpan((Enum)DeploymentTracing.AppStage.CLASS_SCANNING, externalLibArchive.getName());
                    libAdapter = new ReadableArchiveScannerAdapter(parser, externalLibArchive);
                    parser.parse((ArchiveAdapter)libAdapter, () -> span.close());
                }
                finally {
                    if (libAdapter == null) continue;
                    libAdapter.close();
                }
            }
            parser.awaitTermination();
            scannerAdapter.close();
            return parser;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public Parser processParsing(boolean skipScanExternalLibProp, StructuredDeploymentTracing tracing, Parser parser, ReadableArchiveScannerAdapter scannerAdapter, DeploymentSpan mainScanSpan, DeploymentContext deploymentContext) throws IOException {
        try {
            parser.parse((ArchiveAdapter)scannerAdapter, () -> mainScanSpan.close());
            List<ReadableArchive> externalLibraries = this.getExternalLibraries(skipScanExternalLibProp, deploymentContext);
            for (ReadableArchive externalLibArchive : externalLibraries) {
                DeploymentSpan span = tracing.startSpan((Enum)DeploymentTracing.AppStage.CLASS_SCANNING, externalLibArchive.getName());
                try (ReadableArchiveScannerAdapter libAdapter = new ReadableArchiveScannerAdapter(parser, externalLibArchive);){
                    parser.parse((ArchiveAdapter)libAdapter, () -> span.close());
                }
            }
            parser.awaitTermination();
            for (ReadableArchive externalLibArchive : externalLibraries) {
                externalLibArchive.close();
            }
            return parser;
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public ParsingContext.Builder createBuilder(final boolean modelUnAnnotatedMembers, Logger logger) {
        ResourceLocator locator = this.determineLocator();
        ParsingContext.Builder parsingContextBuilder = new ParsingContext.Builder().logger(logger).executorService(this.executorService.getUnderlyingExecutorService()).config(new ParsingConfig(){

            public Set<String> getAnnotationsOfInterest() {
                return Collections.emptySet();
            }

            public Set<String> getTypesOfInterest() {
                return Collections.emptySet();
            }

            public boolean modelUnAnnotatedMembers() {
                return modelUnAnnotatedMembers;
            }
        });
        parsingContextBuilder.locator(locator);
        return parsingContextBuilder;
    }

    private ResourceLocator determineLocator() {
        if (CommonModelRegistry.getInstance().canLoadResources()) {
            return null;
        }
        return new ClassloaderResourceLocatorAdapter((ClassLoader)this.commonClassLoaderService.getCommonClassLoader());
    }

    private void transformApplication(ExtendedDeploymentContext context, Types types, StructuredDeploymentTracing tracing, SpanSequence span) throws IOException {
        String transformNS = System.getProperty("fish.payara.deployment.transform.namespace");
        if (Boolean.parseBoolean(transformNS) || transformNS == null) {
            java.util.Optional<JakartaNamespaceDeploymentTransformer> jakartaNamespaceDeploymentTransformerOptional;
            span.start((Enum)DeploymentTracing.AppStage.TRANSFORM_ARCHIVE);
            try {
                jakartaNamespaceDeploymentTransformerOptional = ServiceLoader.load(JakartaNamespaceDeploymentTransformer.class).findFirst();
            }
            catch (NoClassDefFoundError exception) {
                this.logger.log(Level.WARNING, "Caught exception trying to instantiate a deployment transformer, skipping...", exception);
                span.finish();
                return;
            }
            if (!jakartaNamespaceDeploymentTransformerOptional.isPresent()) {
                this.logger.log(Level.INFO, "No deployment transformer implementation found.");
                span.finish();
                return;
            }
            JakartaNamespaceDeploymentTransformer jakartaNamespaceDeploymentTransformerService = jakartaNamespaceDeploymentTransformerOptional.get();
            if (types == null) {
                types = this.getDeployableTypes((DeploymentContext)context);
            }
            if (!jakartaNamespaceDeploymentTransformerService.isJakartaEEApplication(types)) {
                context.getSource().close();
                File output = jakartaNamespaceDeploymentTransformerService.transformApplication(context);
                context.getAppProps().setProperty("emptyBeansXmlModeALL", Boolean.TRUE.toString());
                context.setSource((ReadableArchive)((FileArchive)this.archiveFactory.createArchive(output)));
                context.removeTransientAppMetaData(Types.class.getName());
                context.removeTransientAppMetaData(Parser.class.getName());
                context.resetModuleMetaData();
                tracing.register((DeploymentContext)context);
                this.getDeployableTypes((DeploymentContext)context);
            }
            span.finish();
        }
    }

    private void notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext dc) {
        for (ApplicationLifecycleInterceptor i : this.alcInterceptors) {
            i.before(phase, dc);
        }
    }

    private void notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase phase, ExtendedDeploymentContext dc) {
        for (ApplicationLifecycleInterceptor i : this.alcInterceptors) {
            i.after(phase, dc);
        }
    }

    private List<ReadableArchive> getExternalLibraries(ReadableArchive source, Boolean skipScanExternalLibProp) throws IOException {
        ArrayList<ReadableArchive> externalLibArchives = new ArrayList<ReadableArchive>();
        if (skipScanExternalLibProp.booleanValue()) {
            return Collections.emptyList();
        }
        List externalLibs = DeploymentUtils.getExternalLibraries((ReadableArchive)source);
        for (URI externalLib : externalLibs) {
            externalLibArchives.add(this.archiveFactory.openArchive(new File(externalLib.getPath())));
        }
        return externalLibArchives;
    }

    private List<ReadableArchive> getExternalLibraries(Boolean skipScanExternalLibProp, DeploymentContext deploymentContext) throws IOException, URISyntaxException {
        ArrayList<ReadableArchive> externalLibArchives = new ArrayList<ReadableArchive>();
        if (skipScanExternalLibProp.booleanValue()) {
            return Collections.emptyList();
        }
        for (URI externalLib : DeploymentUtils.getExternalLibraries((ReadableArchive)deploymentContext.getSource())) {
            externalLibArchives.add(this.archiveFactory.openArchive(new File(externalLib.getPath())));
        }
        for (URI externalLib : deploymentContext.getAppLibs()) {
            externalLibArchives.add(this.archiveFactory.openArchive(new File(externalLib.getPath())));
        }
        return externalLibArchives;
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(this.logger);
        }
        return isSuccess;
    }

    public List<EngineInfo> setupContainerInfos(DeploymentContext context) throws Exception {
        return this.setupContainerInfos(context.getArchiveHandler(), this.getSniffers(context.getArchiveHandler(), null, context), context);
    }

    public Collection<? extends Sniffer> getSniffers(ArchiveHandler handler, Collection<? extends Sniffer> sniffers, DeploymentContext context) {
        if (handler == null) {
            return Collections.emptyList();
        }
        if (sniffers == null) {
            if (handler instanceof CompositeHandler) {
                ((CompositeHandler)handler).initCompositeMetaData(context);
                context.getAppProps().setProperty("isComposite", "true");
            }
            sniffers = this.snifferManager.getSniffers(context);
        }
        context.addTransientAppMetaData("sniffers", sniffers);
        this.snifferManager.validateSniffers(sniffers, context);
        return sniffers;
    }

    public List<EngineInfo> setupContainerInfos(ArchiveHandler handler, Collection<? extends Sniffer> sniffers, DeploymentContext context) throws Exception {
        ActionReport report = context.getActionReport();
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
        LinkedHashMap<Deployer, EngineInfo> containerInfosByDeployers = new LinkedHashMap<Deployer, EngineInfo>();
        for (Sniffer sniffer : sniffers) {
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                throw new DeploymentException(localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource().getName()}));
            }
            String containerName = sniffer.getContainersNames()[0];
            EngineInfo engineInfo = this.startEngine(context, sniffer, containerName);
            Deployer deployer = this.startDeployer(context, containerName, engineInfo);
            containerInfosByDeployers.put(deployer, engineInfo);
        }
        ArrayList<EngineInfo> sortedEngineInfos = new ArrayList<EngineInfo>();
        List<Deployer> list = this.loadDeployers(containerInfosByDeployers, context);
        for (Deployer deployer : list) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Ordered Deployer {0}", deployer.getClass());
            }
            MetaData metadata = deployer.getMetaData();
            EngineInfo engineInfo = (EngineInfo)containerInfosByDeployers.get(deployer);
            try (DeploymentSpan span = tracing.startSpan(TraceContext.Level.CONTAINER, engineInfo.getSniffer().getModuleType(), (Enum)DeploymentTracing.AppStage.PREPARE, "MetaData");){
                if (metadata != null) {
                    if (metadata.provides() == null || metadata.provides().length == 0) {
                        deployer.loadMetaData(null, context);
                    } else {
                        for (Class provide : metadata.provides()) {
                            if (context.getModuleMetaData(provide) == null) {
                                context.addModuleMetaData(deployer.loadMetaData(provide, context));
                                continue;
                            }
                            deployer.loadMetaData(null, context);
                        }
                    }
                } else {
                    deployer.loadMetaData(null, context);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
            sortedEngineInfos.add((EngineInfo)containerInfosByDeployers.get(deployer));
        }
        return sortedEngineInfos;
    }

    private Deployer startDeployer(DeploymentContext context, String containerName, EngineInfo engineInfo) throws Exception {
        ActionReport report = context.getActionReport();
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
        try (DeploymentSpan span = tracing.startSpan(TraceContext.Level.CONTAINER, engineInfo.getSniffer().getModuleType(), (Enum)DeploymentTracing.AppStage.PREPARE, "Deployer");){
            Deployer deployer = engineInfo.getDeployer();
            if (deployer == null) {
                if (!this.startContainers(Collections.singleton(engineInfo), this.logger, context)) {
                    String msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
                deployer = engineInfo.getDeployer();
                if (deployer == null) {
                    report.failure(this.logger, "Got a null deployer out of the " + engineInfo.getContainer().getClass() + " container, is it annotated with @Service ?");
                    throw new DeploymentException("Deployer not found for container " + containerName);
                }
            }
            Deployer deployer2 = deployer;
            return deployer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineInfo startEngine(DeploymentContext context, Sniffer sniffer, String containerName) throws Exception {
        ActionReport report = context.getActionReport();
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
        try (DeploymentSpan span = tracing.startSpan(TraceContext.Level.CONTAINER, sniffer.getModuleType(), (Enum)DeploymentTracing.AppStage.PREPARE);){
            EngineInfo engineInfo = this.containerRegistry.getContainer(containerName);
            if (engineInfo == null) {
                Collection<EngineInfo> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.containerRegistry.getContainer(containerName) == null) {
                        DeploymentSpan innerSpan = tracing.startSpan((Enum)DeploymentTracing.AppStage.CONTAINER_START);
                        containersInfo = this.setupContainer(sniffer, this.logger, context);
                        innerSpan.close();
                        if (containersInfo == null || containersInfo.isEmpty()) {
                            String msg = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                            report.failure(this.logger, msg, null);
                            throw new Exception(msg);
                        }
                    }
                }
                if (containersInfo != null && !this.startContainers(containersInfo, this.logger, context)) {
                    String msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
            }
            if ((engineInfo = this.containerRegistry.getContainer(containerName)) == null) {
                String msg = "Aborting, Failed to start container " + containerName;
                report.failure(this.logger, msg, null);
                throw new Exception(msg);
            }
            EngineInfo engineInfo2 = engineInfo;
            return engineInfo2;
        }
    }

    public Map<Class, ApplicationMetaDataProvider> getTypeByProvider() {
        HashMap<Class, ApplicationMetaDataProvider> typeByProvider = new HashMap<Class, ApplicationMetaDataProvider>();
        List providers = this.habitat.getAllServices(ApplicationMetaDataProvider.class, new Annotation[0]);
        for (ApplicationMetaDataProvider provider : providers) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                typeByProvider.put(provided, provider);
            }
        }
        for (ApplicationMetaDataProvider provider : providers) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (typeByProvider.containsKey(dependency)) continue;
                this.logger.log(Level.WARNING, "NCLS-CORE-00027", new Object[]{provider, dependency});
            }
        }
        return typeByProvider;
    }

    private Map<Class, Deployer> getTypeByDeployer(Map<Deployer, EngineInfo> containerInfosByDeployers) {
        HashMap<Class, Deployer> typeByDeployer = new HashMap<Class, Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        return typeByDeployer;
    }

    private List<Deployer> loadDeployers(Map<Deployer, EngineInfo> containerInfosByDeployers, DeploymentContext context) throws IOException {
        ActionReport report = context.getActionReport();
        Map<Class, ApplicationMetaDataProvider> typeByProvider = this.getTypeByProvider();
        Map<Class, Deployer> typeByDeployer = this.getTypeByDeployer(containerInfosByDeployers);
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class dependency : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                Service s = deployer.getClass().getAnnotation(Service.class);
                String serviceName = s != null && s.name() != null && s.name().length() > 0 ? s.name() : deployer.getClass().getSimpleName();
                report.failure(this.logger, serviceName + " deployer requires " + dependency + " but no other deployer provides it", null);
                return null;
            }
        }
        ArrayList<Deployer> orderedDeployers = new ArrayList<Deployer>();
        for (Map.Entry<Deployer, EngineInfo> entry : containerInfosByDeployers.entrySet()) {
            Deployer deployer = entry.getKey();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Keyed Deployer {0}", deployer.getClass());
            }
            DeploymentSpan span = tracing.startSpan(TraceContext.Level.CONTAINER, entry.getValue().getSniffer().getModuleType(), (Enum)DeploymentTracing.AppStage.PREPARE);
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, typeByProvider, context);
            span.close();
        }
        return orderedDeployers;
    }

    private void loadDeployer(List<Deployer> results, Deployer deployer, Map<Class, Deployer> typeByDeployer, Map<Class, ApplicationMetaDataProvider> typeByProvider, DeploymentContext dc) throws IOException {
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)dc);
        if (results.contains(deployer)) {
            return;
        }
        results.add(deployer);
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (dc.getModuleMetaData(required) != null) continue;
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider provider = typeByProvider.get(required);
                if (provider == null) {
                    this.logger.log(Level.SEVERE, "NCLS-CORE-00028", required);
                    continue;
                }
                LinkedList<ApplicationMetaDataProvider> providers = new LinkedList<ApplicationMetaDataProvider>();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider p : providers) {
                    DeploymentSpan span = tracing.startSpan(TraceContext.Level.APPLICATION, null, (Enum)DeploymentTracing.AppStage.LOAD, "DeploymentDescriptor");
                    try {
                        dc.addModuleMetaData(p.load(dc));
                    }
                    finally {
                        if (span == null) continue;
                        span.close();
                    }
                }
            }
        }
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider> results, Map<Class, ApplicationMetaDataProvider> providers, ApplicationMetaDataProvider provider) {
        results.addFirst(provider);
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
    }

    public ModuleInfo prepareModule(List<EngineInfo> sortedEngineInfos, String moduleName, DeploymentContext context, ProgressTracker tracker) throws Exception {
        String isComposite;
        ArrayList<EngineRef> addedEngines = new ArrayList<EngineRef>();
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load((DeploymentContext)context);
        tracing.switchToContext(TraceContext.Level.MODULE, moduleName);
        for (EngineInfo engineInfo : sortedEngineInfos) {
            Deployer deployer = engineInfo.getDeployer();
            try {
                DeploymentSpan span = tracing.startSpan(TraceContext.Level.CONTAINER, engineInfo.getSniffer().getModuleType(), (Enum)DeploymentTracing.AppStage.PREPARE);
                try {
                    deployer.prepare(context);
                    EngineRef engineRef = new EngineRef(engineInfo, null);
                    addedEngines.add(engineRef);
                    tracker.add("prepared", EngineRef.class, (Object)engineRef);
                    tracker.add(Deployer.class, (Object)deployer);
                }
                finally {
                    if (span == null) continue;
                    span.close();
                }
            }
            catch (Exception e) {
                ActionReport report = context.getActionReport();
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
        }
        if (this.events != null) {
            DeploymentSpan span = tracing.startSpan(TraceContext.Level.MODULE, moduleName, (Enum)DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.MODULE_PREPARED.type());
            this.events.send(new EventListener.Event<DeploymentContext>(Deployment.MODULE_PREPARED, context), false);
            span.close();
        }
        if ((isComposite = context.getAppProps().getProperty("isComposite")) != null) {
            context.getModuleProps().setProperty("isComposite", isComposite);
        }
        ModuleInfo mi = new ModuleInfo(this.events, moduleName, addedEngines, context.getModuleProps());
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(context.getAppProps());
        for (EngineRef er : mi.getEngineRefs()) {
            ApplicationConfig c = savedAppConfig.get(mi.getName(), er.getContainerInfo().getSniffer().getModuleType());
            if (c == null) continue;
            er.setApplicationConfig(c);
        }
        return mi;
    }

    protected Collection<EngineInfo> setupContainer(Sniffer sniffer, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        ContainerStarter starter = (ContainerStarter)this.habitat.getService(ContainerStarter.class, new Annotation[0]);
        Collection<EngineInfo> containersInfo = starter.startContainer(sniffer);
        if (containersInfo == null || containersInfo.isEmpty()) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<EngineInfo> containersInfo, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        for (EngineInfo engineInfo : containersInfo) {
            Container container;
            try {
                container = engineInfo.getContainer();
            }
            catch (Exception e) {
                if (e instanceof MultiException) {
                    for (Throwable se : ((MultiException)((Object)e)).getErrors()) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                logger.log(Level.SEVERE, "NCLS-CORE-00029", new Object[]{engineInfo.getSniffer().getModuleType(), e});
                return false;
            }
            Class<? extends Deployer> deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.habitat.getService(deployerClass, new Annotation[0]);
                engineInfo.setDeployer(deployer);
            }
            catch (MultiException e) {
                report.failure(logger, "Cannot instantiate or inject " + deployerClass, e);
                engineInfo.stop(logger);
                return false;
            }
            catch (ClassCastException e) {
                engineInfo.stop(logger);
                report.failure(logger, deployerClass + " does not implement  the org.jvnet.glassfish.api.deployment.Deployer interface", e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(EngineInfo[] ctrInfos, Logger logger) {
        for (EngineInfo ctrInfo : ctrInfos) {
            try {
                ctrInfo.stop(logger);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "NCLS-CORE-00030", new Object[]{ctrInfo.getSniffer().getModuleType(), e});
            }
        }
    }

    public ApplicationInfo unload(ApplicationInfo info, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        if (info == null) {
            report.failure(context.getLogger(), "Application not registered", null);
            return null;
        }
        this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.STOP, context);
        if (info.isLoaded()) {
            info.stop(context, context.getLogger());
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.STOP, context);
            this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.UNLOAD, context);
            info.unload(context);
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.UNLOAD, context);
        }
        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_DISABLED, info), false);
        try {
            this.notifyLifecycleInterceptorsBefore(ExtendedDeploymentContext.Phase.CLEAN, context);
            info.clean(context);
            this.notifyLifecycleInterceptorsAfter(ExtendedDeploymentContext.Phase.CLEAN, context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while cleaning", e);
            return info;
        }
        return info;
    }

    public void undeploy(String appName, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        UndeployCommandParameters params = (UndeployCommandParameters)context.getCommandParameters(UndeployCommandParameters.class);
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.UNDEPLOYMENT_START, info));
        this.unload(info, context);
        if (report != null && report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_SUCCESS, context));
            this.deploymentLifecycleProbeProvider.applicationUndeployedEvent(appName, this.getApplicationType(info));
        } else {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
        }
        this.appRegistry.remove(appName);
    }

    public Transaction prepareAppConfigChanges(DeploymentContext context) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        Transaction tx = null;
        Application app_w = null;
        if (deployParams.hotDeploy.booleanValue()) {
            app_w = this.applications.getApplication(deployParams.name);
        }
        if (app_w == null) {
            try {
                tx = new Transaction();
                ConfigBean newBean = ((ConfigBean)Dom.unwrap((ConfigBeanProxy)this.applications)).allocate(Application.class);
                Application app = (Application)newBean.createProxy();
                app_w = (Application)tx.enroll((ConfigBeanProxy)app);
                this.setInitialAppAttributes(app_w, deployParams, appProps, context);
            }
            catch (TransactionFailure e) {
                tx.rollback();
                throw e;
            }
            catch (Exception e) {
                tx.rollback();
                throw new TransactionFailure(e.getMessage(), (Throwable)e);
            }
        }
        context.addTransientAppMetaData("application", app_w);
        return tx;
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t) throws TransactionFailure {
        this.registerAppInDomainXML(applicationInfo, context, t, false);
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t, boolean appRefOnly) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        if (t != null) {
            try {
                if (!appRefOnly) {
                    Application app_w = context.getTransientAppMetaData("application", Application.class);
                    this.setRestAppAttributes(app_w, appProps);
                    Applications apps_w = (Applications)t.enroll((ConfigBeanProxy)this.applications);
                    apps_w.getModules().add(app_w);
                    if (applicationInfo != null) {
                        applicationInfo.save(app_w);
                    }
                }
                List targets = new ArrayList<String>();
                if (!DeploymentUtils.isDomainTarget((String)deployParams.target)) {
                    targets.add(deployParams.target);
                } else {
                    List previousTargets = context.getTransientAppMetaData("previousTargets", List.class);
                    if (previousTargets == null) {
                        previousTargets = this.domain.getAllReferencedTargetsForApplication(deployParams.name);
                    }
                    targets = previousTargets;
                }
                String origVS = deployParams.virtualservers;
                Boolean origEnabled = deployParams.enabled;
                Properties previousVirtualServers = context.getTransientAppMetaData("previousVirtualServers", Properties.class);
                Properties previousEnabledAttributes = context.getTransientAppMetaData("previousEnabledAttributes", Properties.class);
                for (String target : targets) {
                    DeploymentGroup dg;
                    Cluster cluster;
                    ApplicationRef appRef;
                    ApplicationRef instanceApplicationRef;
                    Server servr;
                    deployParams.virtualservers = origVS;
                    deployParams.enabled = origEnabled;
                    if (DeploymentUtils.isDomainTarget((String)deployParams.target)) {
                        String enabledAttr;
                        String vs = previousVirtualServers.getProperty(target);
                        if (vs != null) {
                            deployParams.virtualservers = vs;
                        }
                        if ((enabledAttr = previousEnabledAttributes.getProperty(target)) != null) {
                            deployParams.enabled = Boolean.valueOf(enabledAttr);
                        }
                    }
                    if (deployParams.enabled == null) {
                        deployParams.enabled = Boolean.TRUE;
                    }
                    if ((servr = this.domain.getServerNamed(target)) != null && (instanceApplicationRef = this.domain.getApplicationRefInTarget(deployParams.name, servr.getName())) == null) {
                        ConfigBeanProxy servr_w = t.enroll((ConfigBeanProxy)servr);
                        appRef = (ApplicationRef)servr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef, deployParams);
                        ((Server)servr_w).getApplicationRef().add(appRef);
                    }
                    if ((cluster = this.domain.getClusterNamed(target)) != null) {
                        ConfigBeanProxy cluster_w = t.enroll((ConfigBeanProxy)cluster);
                        appRef = (ApplicationRef)cluster_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef, deployParams);
                        ((Cluster)cluster_w).getApplicationRef().add(appRef);
                        for (Server svr : cluster.getInstances()) {
                            ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                            ApplicationRef appRef2 = (ApplicationRef)svr_w.createChild(ApplicationRef.class);
                            this.setAppRefAttributes(appRef2, deployParams);
                            ((Server)svr_w).getApplicationRef().add(appRef2);
                        }
                    }
                    if ((dg = this.domain.getDeploymentGroupNamed(target)) == null) continue;
                    ConfigBeanProxy dg_w = t.enroll((ConfigBeanProxy)dg);
                    ApplicationRef appRef2 = (ApplicationRef)dg_w.createChild(ApplicationRef.class);
                    this.setAppRefAttributes(appRef2, deployParams);
                    ((DeploymentGroup)dg_w).getApplicationRef().add(appRef2);
                    for (Server svr : dg.getInstances()) {
                        ApplicationRef instanceApplicationRef2 = this.domain.getApplicationRefInTarget(deployParams.name, svr.getName());
                        if (instanceApplicationRef2 != null) continue;
                        ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                        ApplicationRef appRef22 = (ApplicationRef)svr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef22, deployParams);
                        ((Server)svr_w).getApplicationRef().add(appRef22);
                    }
                }
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
            catch (Exception e) {
                t.rollback();
                throw new TransactionFailure(e.getMessage(), (Throwable)e);
            }
            try {
                t.commit();
            }
            catch (RetryableException e) {
                System.out.println("Retryable...");
                t.rollback();
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
        }
    }

    public void registerTenantWithAppInDomainXML(String appName, ExtendedDeploymentContext context) throws TransactionFailure {
        Transaction t = new Transaction();
        try {
            AppTenant appTenant_w = this.writeableTenantForApp(appName, t);
            appTenant_w.setContextRoot(context.getAppProps().getProperty("context-root"));
            appTenant_w.setTenant(context.getTenant());
            t.commit();
        }
        catch (TransactionFailure ex) {
            t.rollback();
            throw ex;
        }
        catch (Throwable ex) {
            t.rollback();
            throw new TransactionFailure(ex.getLocalizedMessage(), ex);
        }
    }

    public void unregisterTenantWithAppInDomainXML(String appName, String tenantName) throws TransactionFailure, RetryableException {
        Application app = this.applications.getApplication(appName);
        if (app == null) {
            throw new IllegalArgumentException("Application " + appName + " not found");
        }
        AppTenants appTenants = app.getAppTenants();
        AppTenant appTenant = appTenants.getAppTenant(tenantName);
        if (appTenant == null) {
            throw new IllegalArgumentException("Tenant " + tenantName + " not provisioned for application " + appName);
        }
        Transaction t = new Transaction();
        AppTenants appTenants_w = (AppTenants)t.enroll((ConfigBeanProxy)appTenants);
        appTenants_w.getAppTenant().remove(appTenant);
        t.commit();
    }

    private AppTenant writeableTenantForApp(String appName, Transaction t) throws TransactionFailure, PropertyVetoException {
        AppTenants appTenants_w;
        Application app = this.applications.getApplication(appName);
        if (app == null) {
            throw new IllegalArgumentException("Application " + appName + " not found");
        }
        AppTenants appTenants = app.getAppTenants();
        if (appTenants == null) {
            Application app_w = (Application)t.enroll((ConfigBeanProxy)app);
            appTenants_w = (AppTenants)app_w.createChild(AppTenants.class);
            app_w.setAppTenants(appTenants_w);
        } else {
            appTenants_w = (AppTenants)t.enroll((ConfigBeanProxy)appTenants);
        }
        List appTenantList = appTenants_w.getAppTenant();
        AppTenant appTenant_w = (AppTenant)appTenants_w.createChild(AppTenant.class);
        appTenantList.add(appTenant_w);
        return appTenant_w;
    }

    private void setInitialAppAttributes(Application app, DeployCommandParameters deployParams, Properties appProps, DeploymentContext context) throws PropertyVetoException {
        Properties previousEnabledAttributes = context.getTransientAppMetaData("previousEnabledAttributes", Properties.class);
        app.setName(deployParams.name);
        if (deployParams.libraries != null) {
            app.setLibraries(deployParams.libraries);
        }
        if (deployParams.description != null) {
            app.setDescription(deployParams.description);
        }
        if (deployParams.deploymentorder != null) {
            app.setDeploymentOrder(deployParams.deploymentorder.toString());
        }
        app.setEnabled(String.valueOf(true));
        if (appProps.getProperty("location") != null) {
            String enabledAttr;
            app.setLocation(appProps.getProperty("location"));
            if (DeploymentUtils.isDomainTarget((String)deployParams.target) && previousEnabledAttributes != null && (enabledAttr = previousEnabledAttributes.getProperty("domain")) != null) {
                app.setEnabled(enabledAttr);
            }
            app.setAvailabilityEnabled(deployParams.availabilityenabled.toString());
            app.setAsyncReplication(deployParams.asyncreplication.toString());
        }
        if (appProps.getProperty("object-type") != null) {
            app.setObjectType(appProps.getProperty("object-type"));
        }
        if (appProps.getProperty("directory-deployed") != null) {
            app.setDirectoryDeployed(appProps.getProperty("directory-deployed"));
        }
    }

    private void setRestAppAttributes(Application app, Properties appProps) throws PropertyVetoException, TransactionFailure {
        if (appProps.getProperty("context-root") != null) {
            app.setContextRoot(appProps.getProperty("context-root"));
        }
        for (Object element : appProps.keySet()) {
            String propName = (String)element;
            if (propName.equals("location") || propName.equals("context-root") || propName.equals("object-type") || propName.equals("directory-deployed") || propName.startsWith("appConfig") || appProps.getProperty(propName) == null) continue;
            Property prop = (Property)app.createChild(Property.class);
            app.getProperty().add(prop);
            prop.setName(propName);
            prop.setValue(appProps.getProperty(propName));
        }
    }

    public void unregisterAppFromDomainXML(String appName, String target) throws TransactionFailure {
        this.unregisterAppFromDomainXML(appName, target, false);
    }

    public void unregisterAppFromDomainXML(final String appName, final String tgt, final boolean appRefOnly) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    List targets = new ArrayList<String>();
                    if (!DeploymentUtils.isDomainTarget((String)tgt)) {
                        targets.add(tgt);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    if (!(param instanceof Domain)) {
                        return Boolean.FALSE;
                    }
                    Domain dmn = (Domain)param;
                    for (String target : targets) {
                        DeploymentGroup dg;
                        Cluster cluster;
                        Server servr = dmn.getServerNamed(target);
                        if (servr != null) {
                            ConfigBeanProxy servr_w = t.enroll((ConfigBeanProxy)servr);
                            for (Object appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ((Server)servr_w).getApplicationRef().remove(appRef);
                                break;
                            }
                        }
                        if ((cluster = dmn.getClusterNamed(target)) != null) {
                            Object appRef;
                            ConfigBeanProxy cluster_w = t.enroll((ConfigBeanProxy)cluster);
                            for (ApplicationRef appRef2 : cluster.getApplicationRef()) {
                                if (!appRef2.getRef().equals(appName)) continue;
                                ((Cluster)cluster_w).getApplicationRef().remove(appRef2);
                                break;
                            }
                            appRef = cluster.getInstances().iterator();
                            block3: while (appRef.hasNext()) {
                                Server svr = (Server)appRef.next();
                                ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                                for (ApplicationRef appRef3 : svr.getApplicationRef()) {
                                    if (!appRef3.getRef().equals(appName)) continue;
                                    ((Server)svr_w).getApplicationRef().remove(appRef3);
                                    continue block3;
                                }
                            }
                        }
                        if ((dg = dmn.getDeploymentGroupNamed(target)) == null) continue;
                        ConfigBeanProxy dg_w = t.enroll((ConfigBeanProxy)dg);
                        for (ApplicationRef appRef : dg.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ((DeploymentGroup)dg_w).getApplicationRef().remove(appRef);
                            break;
                        }
                        block6: for (Server svr : dg.getInstances()) {
                            if (targets.contains(svr.getName())) continue;
                            ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ((Server)svr_w).getApplicationRef().remove(appRef);
                                continue block6;
                            }
                        }
                    }
                    if (!appRefOnly) {
                        Applications apps = dmn.getApplications();
                        ConfigBeanProxy apps_w = t.enroll((ConfigBeanProxy)apps);
                        for (ApplicationName module : apps.getModules()) {
                            if (!module.getName().equals(appName)) continue;
                            ((Applications)apps_w).getModules().remove(module);
                            break;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    public void updateAppEnabledAttributeInDomainXML(final String appName, final String target, final boolean enabled) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    if (!(param instanceof Domain)) {
                        return Boolean.FALSE;
                    }
                    Domain dmn = (Domain)param;
                    if (enabled || DeploymentUtils.isDomainTarget((String)target)) {
                        Application app = dmn.getApplications().getApplication(appName);
                        ConfigBeanProxy app_w = t.enroll((ConfigBeanProxy)app);
                        ((Application)app_w).setEnabled(String.valueOf(enabled));
                    }
                    List<String> targets = new ArrayList<String>();
                    if (!DeploymentUtils.isDomainTarget((String)target)) {
                        targets.add(target);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    for (String target2 : targets) {
                        DeploymentGroup deploymentGroup;
                        Cluster cluster;
                        Server servr = dmn.getServerNamed(target2);
                        if (servr != null) {
                            for (Object appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                break;
                            }
                            ApplicationLifecycle.this.updateClusterAppRefWithInstanceUpdate(t, servr, appName, enabled);
                        }
                        if ((cluster = dmn.getClusterNamed(target2)) != null) {
                            Object appRef;
                            for (ApplicationRef appRef2 : cluster.getApplicationRef()) {
                                if (!appRef2.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef2);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                break;
                            }
                            appRef = cluster.getInstances().iterator();
                            block3: while (appRef.hasNext()) {
                                Server svr = (Server)appRef.next();
                                for (ApplicationRef appRef3 : svr.getApplicationRef()) {
                                    if (!appRef3.getRef().equals(appName)) continue;
                                    ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef3);
                                    ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                    continue block3;
                                }
                            }
                        }
                        if ((deploymentGroup = dmn.getDeploymentGroupNamed(target2)) == null) continue;
                        for (ApplicationRef appRef : deploymentGroup.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                            ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                            break;
                        }
                        block6: for (Server svr : deploymentGroup.getInstances()) {
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                continue block6;
                            }
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    public boolean isRegistered(String appName) {
        return this.applications.getApplication(appName) != null;
    }

    public ApplicationInfo get(String appName) {
        return this.appRegistry.get(appName);
    }

    private boolean isPaaSEnabled(Boolean isClassicStyle) {
        if (isClassicStyle.booleanValue()) {
            return false;
        }
        return this.virtEnv != null && this.virtEnv.isPaasEnabled();
    }

    public String getDefaultTarget(Boolean isClassicStyle) {
        if (!this.isPaaSEnabled(isClassicStyle)) {
            return "server";
        }
        return null;
    }

    public String getDefaultTarget(String appName, OpsParams.Origin origin, Boolean isClassicStyle) {
        if (!this.isPaaSEnabled(isClassicStyle)) {
            return "server";
        }
        if (origin == OpsParams.Origin.deploy) {
            return null;
        }
        List targets = this.domain.getAllReferencedTargetsForApplication(appName);
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Application not registered");
        }
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Cannot determine the default target. Please specify an explicit target for the operation.");
        }
        return (String)targets.get(0);
    }

    public Deployment.DeploymentContextBuilder getBuilder(Logger logger, OpsParams params, ActionReport report) {
        return new DeploymentContextBuidlerImpl(logger, params, report);
    }

    private void updateClusterAppRefWithInstanceUpdate(Transaction t, Server servr, String appName, boolean isNewInstanceAppRefStateEnabled) throws TransactionFailure, PropertyVetoException {
        Cluster clusterContainingInstance = servr.getCluster();
        if (clusterContainingInstance != null) {
            boolean isAppRefEnabledOnAnyClusterInstance = false;
            for (Server inst : clusterContainingInstance.getInstances()) {
                isAppRefEnabledOnAnyClusterInstance |= servr.getName().equals(inst.getName()) ? isNewInstanceAppRefStateEnabled : Boolean.parseBoolean(inst.getApplicationRef(appName).getEnabled());
            }
            ApplicationRef clusterAppRef = clusterContainingInstance.getApplicationRef(appName);
            if (Boolean.parseBoolean(clusterAppRef.getEnabled()) != isAppRefEnabledOnAnyClusterInstance) {
                ((ApplicationRef)t.enroll((ConfigBeanProxy)clusterAppRef)).setEnabled(String.valueOf(isAppRefEnabledOnAnyClusterInstance));
            }
        }
    }

    private ReadableArchive getArchive(Deployment.DeploymentContextBuilder builder) throws IOException {
        ReadableArchive archive = builder.sourceAsArchive();
        if (archive == null && builder.sourceAsFile() == null) {
            throw new IOException("Source archive or file not provided to builder");
        }
        if (archive == null && builder.sourceAsFile() != null && (archive = ((ArchiveFactory)this.habitat.getService(ArchiveFactory.class, new Annotation[0])).openArchive(builder.sourceAsFile())) == null) {
            throw new IOException("Invalid archive type : " + builder.sourceAsFile().getAbsolutePath());
        }
        return archive;
    }

    private ExtendedDeploymentContext getContext(ExtendedDeploymentContext initial, Deployment.DeploymentContextBuilder builder) throws IOException {
        ArchiveHandler archiveHandler;
        DeploymentContextBuidlerImpl copy = new DeploymentContextBuidlerImpl(builder);
        ReadableArchive archive = this.getArchive(copy);
        copy.source(archive);
        if (initial == null) {
            initial = new DeploymentContextImpl((Deployment.DeploymentContextBuilder)copy, (ServerEnvironment)this.env);
        }
        if ((archiveHandler = copy.archiveHandler()) == null) {
            String type = null;
            OpsParams params = builder.params();
            if (params != null) {
                if (params instanceof DeployCommandParameters) {
                    type = ((DeployCommandParameters)params).type;
                } else if (params instanceof UndeployCommandParameters) {
                    type = ((UndeployCommandParameters)params)._type;
                }
            }
            archiveHandler = this.getArchiveHandler(archive, type);
        }
        File sourceFile = new File(archive.getURI().getSchemeSpecificPart());
        initial.getAppProps().put("defaultAppName", DeploymentUtils.getDefaultEEName((String)sourceFile.getName()));
        if (!sourceFile.isDirectory()) {
            String repositoryBitName = copy.params().name();
            try {
                repositoryBitName = VersioningUtils.getRepositoryName((String)repositoryBitName);
            }
            catch (VersioningSyntaxException e) {
                ActionReport report = copy.report();
                report.setMessage(e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            File expansionDir = new File(this.domain.getApplicationRoot(), repositoryBitName);
            if (!expansionDir.mkdirs()) {
                this.logger.fine(localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
            }
            try {
                Long start = System.currentTimeMillis();
                WritableArchive expandedArchive = this.archiveFactory.createArchive(expansionDir);
                archiveHandler.expand(archive, expandedArchive, (DeploymentContext)initial);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Deployment expansion took {0}", System.currentTimeMillis() - start);
                }
                try {
                    archive.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "NCLS-CORE-00031", new Object[]{archive.getURI().getSchemeSpecificPart(), e});
                    throw e;
                }
                archive = (FileArchive)expandedArchive;
                initial.setSource(archive);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "NCLS-CORE-00032", e);
                throw e;
            }
        }
        initial.setArchiveHandler(archiveHandler);
        return initial;
    }

    private void setAppRefAttributes(ApplicationRef appRef, DeployCommandParameters deployParams) throws PropertyVetoException {
        appRef.setRef(deployParams.name);
        if (deployParams.virtualservers != null) {
            appRef.setVirtualServers(deployParams.virtualservers);
        } else {
            appRef.setVirtualServers(DeploymentUtils.getVirtualServers((String)deployParams.target, (ServerEnvironment)this.env, (Domain)this.domain));
        }
        if (deployParams.lbenabled != null) {
            appRef.setLbEnabled(deployParams.lbenabled);
        } else {
            String lbEnabledDefault = System.getProperty("org.glassfish.lb-enabled-default");
            if (lbEnabledDefault != null) {
                appRef.setLbEnabled(lbEnabledDefault);
            }
        }
        appRef.setEnabled(deployParams.enabled.toString());
    }

    public ParameterMap prepareInstanceDeployParamMap(DeploymentContext dc) throws Exception {
        Properties previousEnabledAttributes;
        String runtimeAltDDLocation;
        String altDDLocation;
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        ArrayList<String> excludedParams = new ArrayList<String>();
        excludedParams.add("path");
        excludedParams.add("deploymentplan");
        excludedParams.add("altdd");
        excludedParams.add("runtimealtdd");
        excludedParams.add("upload");
        ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{params});
        ParameterMap paramMap = extractor.extract(excludedParams);
        this.prepareGeneratedContent(dc, paramMap);
        Application application = this.applications.getApplication(params.name);
        Properties appProperties = application.getDeployProperties();
        String archiveLocation = appProperties.getProperty("appLocation");
        File archiveFile = new File(new URI(archiveLocation));
        paramMap.set("DEFAULT", archiveFile.getAbsolutePath());
        String planLocation = appProperties.getProperty("deploymentPlanLocation");
        if (planLocation != null) {
            File actualPlan = new File(new URI(planLocation));
            paramMap.set("deploymentplan", actualPlan.getAbsolutePath());
        }
        if ((altDDLocation = appProperties.getProperty("altDDLocation")) != null) {
            File altDD = new File(new URI(altDDLocation));
            paramMap.set("altdd", altDD.getAbsolutePath());
        }
        if ((runtimeAltDDLocation = appProperties.getProperty("runtimeAltDDLocation")) != null) {
            File runtimeAltDD = new File(new URI(runtimeAltDDLocation));
            paramMap.set("runtimealtdd", runtimeAltDD.getAbsolutePath());
        }
        paramMap.set("upload", "true");
        if (params.previousContextRoot != null) {
            paramMap.set("preservedcontextroot", params.previousContextRoot);
        }
        Properties appProps = dc.getAppProps();
        appProps.remove("appConfig");
        paramMap.set("appprops", extractor.propertiesValue(appProps, ':'));
        Properties previousVirtualServers = dc.getTransientAppMetaData("previousVirtualServers", Properties.class);
        if (previousVirtualServers != null) {
            paramMap.set("previousVirtualServers", extractor.propertiesValue(previousVirtualServers, ':'));
        }
        if ((previousEnabledAttributes = dc.getTransientAppMetaData("previousEnabledAttributes", Properties.class)) != null) {
            paramMap.set("previousEnabledAttributes", extractor.propertiesValue(previousEnabledAttributes, ':'));
        }
        return paramMap;
    }

    private void prepareGeneratedContent(DeploymentContext dc, ParameterMap paramMap) throws IOException {
        File generatedContentZip = this.createGeneratedContentZip();
        ZipOutputStream zipOS = null;
        File baseDir = dc.getScratchDir("xml").getParentFile().getParentFile();
        for (String scratchType : UPLOADED_GENERATED_DIRS) {
            zipOS = this.addScratchContentIfPresent(dc, baseDir, zipOS, generatedContentZip, scratchType);
        }
        if (zipOS != null) {
            zipOS.close();
            paramMap.set("generatedcontent", generatedContentZip.getAbsolutePath());
        }
    }

    private File createGeneratedContentZip() throws IOException {
        File tempFile = File.createTempFile("gendContent", ".zip");
        FileUtils.deleteOnExit((File)tempFile);
        return tempFile;
    }

    private ZipOutputStream addScratchContentIfPresent(DeploymentContext dc, File baseDir, ZipOutputStream zipOS, File generatedContentZip, String scratchDirName) throws IOException {
        File genDir = dc.getScratchDir(scratchDirName);
        if (genDir.isDirectory()) {
            if (zipOS == null) {
                zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(generatedContentZip)));
            }
            this.addFileToZip(zipOS, baseDir, genDir);
        }
        return zipOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToZip(ZipOutputStream zipOS, File baseDir, File f) throws IOException {
        String entryName = baseDir.toURI().relativize(f.toURI()).getPath();
        ZipEntry entry = new ZipEntry(entryName);
        zipOS.putNextEntry(entry);
        if (!f.isDirectory()) {
            byte[] buffer = new byte[1024];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            try {
                int bytesRead;
                while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                    zipOS.write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((InputStream)is).close();
                zipOS.closeEntry();
            }
        } else {
            zipOS.closeEntry();
            for (File subFile : f.listFiles()) {
                this.addFileToZip(zipOS, baseDir, subFile);
            }
        }
    }

    public void validateDeploymentTarget(String target, String name, boolean isRedeploy) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.isEmpty()) {
            if (this.isRegistered(name)) {
                if (!isRedeploy && DeploymentUtils.isDomainTarget((String)target)) {
                    throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
                }
                if (!DeploymentUtils.isDomainTarget((String)target)) {
                    throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref_2", "Application {0} is already deployed in this domain. Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
                }
            }
            return;
        }
        if (!isRedeploy) {
            if (DeploymentUtils.isDomainTarget((String)target)) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.deploy_domain", "Application with name {0} is already referenced by other target(s). Please specify force option to redeploy to domain.", new Object[]{name}));
            }
            if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
            }
            throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref", "Application {0} is already referenced by other target(s). Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
        }
        if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
            return;
        }
        if (!DeploymentUtils.isDomainTarget((String)target) && this.domain.getDeploymentGroupNamed(target) == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("redeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove other references or specify all targets (or domain target if using asadmin command line) before attempting redeploy operation.", new Object[]{name}));
        }
    }

    public void validateUndeploymentTarget(String target, String name) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.size() > 1) {
            Application app = this.applications.getApplication(name);
            if (!DeploymentUtils.isDomainTarget((String)target) && this.domain.getDeploymentGroupNamed(target) == null) {
                if (app.isLifecycleModule()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("delete_lifecycle_on_multiple_targets", "Lifecycle module {0} is referenced by more than one targets. Please remove other references before attempting delete operation.", new Object[]{name}));
                }
                throw new IllegalArgumentException(localStrings.getLocalString("undeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove other references or specify all targets (or domain target if using asadmin command line) before attempting undeploy operation.", new Object[]{name}));
            }
        }
    }

    public void validateSpecifiedTarget(String target) {
        if (this.env.isDas()) {
            if (target == null) {
                return;
            }
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && cluster.isVirtual()) {
                throw new IllegalArgumentException(localStrings.getLocalString("cannot_specify_managed_target", "Cannot specify target {0} for the operation. Target {0} is a managed target.", new Object[]{target}));
            }
        }
    }

    public boolean isAppEnabled(Application app) {
        ApplicationRef appRef;
        return Boolean.valueOf(app.getEnabled()) != false && (appRef = this.server.getApplicationRef(app.getName())) != null && Boolean.valueOf(appRef.getEnabled()) != false;
    }

    public ExtendedDeploymentContext disable(UndeployCommandParameters commandParams, Application app, ApplicationInfo appInfo, ActionReport report, Logger logger) throws Exception {
        if (appInfo == null) {
            report.failure(logger, "Application not registered", null);
            return null;
        }
        if (!this.env.isDas() && !appInfo.isLoaded()) {
            return null;
        }
        if (app != null) {
            commandParams._type = app.archiveType();
        }
        ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, commandParams, report).source(appInfo.getSource()).build();
        if (app != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
            deploymentContext.setModulePropsMap(app.getModulePropertiesMap());
        }
        if (commandParams.properties != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)commandParams.properties);
        }
        this.unload(appInfo, deploymentContext);
        return deploymentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedDeploymentContext enable(String target, Application app, ApplicationRef appRef, ActionReport report, Logger logger) throws Exception {
        Archive archive = null;
        DeployCommandParameters commandParams = app.getDeployParameters(appRef);
        ApplicationInfo appInfo = this.appRegistry.get(commandParams.name);
        if (appInfo != null && appInfo.isLoaded()) {
            ExtendedDeploymentContext extendedDeploymentContext = null;
            return extendedDeploymentContext;
        }
        commandParams.origin = OpsParams.Origin.load;
        commandParams.command = OpsParams.Command.enable;
        commandParams.target = target;
        commandParams.enabled = Boolean.TRUE;
        Properties contextProps = app.getDeployProperties();
        Map modulePropsMap = app.getModulePropertiesMap();
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(app);
        URI uri = new URI(app.getLocation());
        File file = new File(uri);
        if (!file.exists()) {
            throw new Exception(localStrings.getLocalString("fnf", "File not found {0}", new Object[]{file.getAbsolutePath()}));
        }
        archive = this.archiveFactory.openArchive(file);
        ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, commandParams, report).source((ReadableArchive)archive).build();
        Properties appProps = deploymentContext.getAppProps();
        appProps.putAll((Map<?, ?>)contextProps);
        savedAppConfig.store(appProps);
        if (modulePropsMap != null) {
            deploymentContext.setModulePropsMap(modulePropsMap);
        }
        this.deploy(this.getSniffersFromApp(app), deploymentContext);
        ExtendedDeploymentContext extendedDeploymentContext = deploymentContext;
        return extendedDeploymentContext;
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean loadOnCurrentInstance(DeploymentContext context) {
        DeployCommandParameters commandParams = context.getCommandParameters(DeployCommandParameters.class);
        Properties appProps = context.getAppProps();
        if (commandParams.enabled.booleanValue()) {
            String objectType;
            if (this.domain.isCurrentInstanceMatchingTarget(commandParams.target, commandParams.name(), this.server.getName(), context.getTransientAppMetaData("previousTargets", List.class))) {
                return true;
            }
            if (this.server.isDas() && (objectType = appProps.getProperty("object-type")) != null && (objectType.equals("system-admin") || objectType.equals("system-all"))) {
                return true;
            }
        }
        return false;
    }

    private String getApplicationType(ApplicationInfo appInfo) {
        StringBuilder sb = new StringBuilder();
        if (appInfo.getSniffers().size() > 0) {
            for (Sniffer sniffer : appInfo.getSniffers()) {
                if (!sniffer.isUserVisible()) continue;
                sb.append(sniffer.getModuleType()).append(", ");
            }
        }
        if (sb.length() > 2) {
            return sb.substring(0, sb.length() - 2);
        }
        return sb.toString();
    }

    public List<Sniffer> getSniffersFromApp(Application app) {
        ArrayList<String> snifferTypes = new ArrayList<String>();
        for (Module module : app.getModule()) {
            for (Engine engine : module.getEngines()) {
                snifferTypes.add(engine.getSniffer());
            }
        }
        if (snifferTypes.isEmpty()) {
            return null;
        }
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        if (app.isStandaloneModule()) {
            for (String snifferType : snifferTypes) {
                Sniffer sniffer = this.snifferManager.getSniffer(snifferType);
                if (sniffer != null) {
                    sniffers.add(sniffer);
                    continue;
                }
                this.logger.log(Level.SEVERE, "NCLS-CORE-00033", snifferType);
            }
            if (sniffers.isEmpty()) {
                this.logger.log(Level.SEVERE, "NCLS-CORE-00034", app.getName());
                return null;
            }
        } else {
            return null;
        }
        return sniffers;
    }

    private ExecutorService createExecutorService() {
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        return new ThreadPoolExecutor(0, nrOfProcessors, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("deployment-jar-scanner");
                t.setContextClassLoader(this.getClass().getClassLoader());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public ExtendedDeploymentContext getCurrentDeploymentContext() {
        return this.currentDeploymentContext.get().peek();
    }

    public class DeploymentContextBuidlerImpl
    implements Deployment.DeploymentContextBuilder {
        private final Logger logger;
        private final ActionReport report;
        private final OpsParams params;
        private File sFile;
        private ReadableArchive sArchive;
        private ArchiveHandler handler;

        public DeploymentContextBuidlerImpl(Logger logger, OpsParams params, ActionReport report) {
            this.logger = logger;
            this.report = report;
            this.params = params;
        }

        public DeploymentContextBuidlerImpl(Deployment.DeploymentContextBuilder b) throws IOException {
            this.logger = b.logger();
            this.report = b.report();
            this.params = b.params();
            ReadableArchive archive = ApplicationLifecycle.this.getArchive(b);
            this.source(archive);
            this.handler = b.archiveHandler();
        }

        public Deployment.DeploymentContextBuilder source(File source) {
            this.sFile = source;
            return this;
        }

        public File sourceAsFile() {
            return this.sFile;
        }

        public ReadableArchive sourceAsArchive() {
            return this.sArchive;
        }

        public ArchiveHandler archiveHandler() {
            return this.handler;
        }

        public Deployment.DeploymentContextBuilder source(ReadableArchive archive) {
            this.sArchive = archive;
            return this;
        }

        public Deployment.DeploymentContextBuilder archiveHandler(ArchiveHandler handler) {
            this.handler = handler;
            return this;
        }

        public ExtendedDeploymentContext build() throws IOException {
            return this.build(null);
        }

        public Logger logger() {
            return this.logger;
        }

        public ActionReport report() {
            return this.report;
        }

        public OpsParams params() {
            return this.params;
        }

        public ExtendedDeploymentContext build(ExtendedDeploymentContext initialContext) throws IOException {
            return ApplicationLifecycle.this.getContext(initialContext, this);
        }
    }
}

