/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.v3.server.DynamicReloader;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=20)
public class DynamicReloadService
implements ConfigListener,
PostConstruct,
PreDestroy {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    Applications applications;
    @Inject
    ServiceLocator habitat;
    @Inject
    PayaraExecutorService executor;
    private Logger logger;
    ScheduledFuture<?> timerTask;
    private DynamicReloader reloader;
    private static final String DEFAULT_POLL_INTERVAL_IN_SECONDS = "2";
    private static final List<String> configPropertyNames = Arrays.asList("dynamic-reload-enabled", "dynamic-reload-poll-interval-in-seconds");

    public void postConstruct() {
        this.logger = KernelLoggerInfo.getLogger();
        try {
            this.logger.fine("[Reloader] ReloaderService starting");
            this.reloader = new DynamicReloader(this.applications, this.habitat);
            if (this.isEnabled(this.activeDasConfig)) {
                this.start(this.getPollIntervalInSeconds(this.activeDasConfig));
            } else {
                this.logger.fine("[Reloader] Reloader is configured as disabled, so NOT starting the periodic task");
            }
            this.logger.fine("[Reloader] Service start-up complete");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "NCLS-CORE-00088", e);
        }
    }

    public void preDestroy() {
        this.stop();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private boolean isEnabled(DasConfig config) {
        return Boolean.parseBoolean(config.getDynamicReloadEnabled());
    }

    private int getPollIntervalInSeconds(DasConfig config) {
        int result;
        try {
            result = Integer.parseInt(config.getDynamicReloadPollIntervalInSeconds());
        }
        catch (NumberFormatException e) {
            result = Integer.parseInt(DEFAULT_POLL_INTERVAL_IN_SECONDS);
        }
        return result;
    }

    private void start(int pollIntervalInSeconds) {
        this.reloader.init();
        this.timerTask = this.executor.scheduleAtFixedRate(() -> {
            try {
                this.reloader.run();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error in the DynamicReloader Scheduled Task", ex);
            }
        }, 0L, (long)pollIntervalInSeconds, TimeUnit.SECONDS);
        this.logger.log(Level.FINE, "[Reloader] Started, monitoring every {0} seconds", pollIntervalInSeconds);
    }

    private void stop() {
        this.logger.fine("[Reloader] Stopping");
        this.reloader.cancel();
        if (this.timerTask != null) {
            this.timerTask.cancel(false);
        }
    }

    private void reschedule(int pollIntervalInSeconds) {
        this.logger.fine("[Reloader] Restarting...");
        this.stop();
        try {
            this.reloader.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.start(pollIntervalInSeconds);
    }

    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList unprocessedEvents = new ArrayList();
        Boolean newEnabled = null;
        Integer newPollIntervalInSeconds = null;
        for (PropertyChangeEvent event : events) {
            String propName = event.getPropertyName();
            if (!(event.getSource() instanceof DasConfig)) continue;
            if (configPropertyNames.contains(propName) && event.getOldValue().equals(event.getNewValue())) {
                this.logger.log(Level.FINE, "[DynamicReload] Ignoring reconfig of {0} from {1} to {2}", new Object[]{propName, event.getOldValue(), event.getNewValue()});
                continue;
            }
            if (propName.equals("dynamic-reload-enabled")) {
                newEnabled = Boolean.valueOf((String)event.getNewValue());
                continue;
            }
            if (!propName.equals("dynamic-reload-poll-interval-in-seconds")) continue;
            try {
                newPollIntervalInSeconds = Integer.valueOf((String)event.getNewValue());
            }
            catch (NumberFormatException ex) {
                String reason = ex.getClass().getName() + " " + ex.getLocalizedMessage();
                this.logger.log(Level.WARNING, reason);
            }
        }
        if (newEnabled != null) {
            if (newEnabled.booleanValue()) {
                this.start(newPollIntervalInSeconds == null ? this.getPollIntervalInSeconds(this.activeDasConfig) : newPollIntervalInSeconds.intValue());
            } else {
                this.stop();
            }
        } else if (newPollIntervalInSeconds != null && this.isEnabled(this.activeDasConfig)) {
            this.reschedule(newPollIntervalInSeconds);
        }
        return !unprocessedEvents.isEmpty() ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

