/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="jdbc-resource")
@I18n(value="jdbc.resource.manager")
@ConfiguredBy(value=Resources.class)
public class JDBCResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCResourceManager.class);
    private static final String DESCRIPTION = "description";
    private String jndiName = null;
    private String description = null;
    private String poolName = null;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    public String getResourceType() {
        return "jdbc-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    return JDBCResourceManager.this.createResource(param, properties);
                }
            }, (ConfigBeanProxy)resources);
            this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jdbc.resource.fail", "JDBC resource {0} create failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("create.jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, JdbcResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        if (ConnectorsUtil.getResourceByName((Resources)resources, ResourcePool.class, (String)this.poolName) == null) {
            String msg = localStrings.getLocalString("create.jdbc.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of jdbc connection pools.", new Object[]{this.poolName});
            return new ResourceStatus(1, msg);
        }
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.poolName = (String)attributes.get("pool-name");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
    }

    private JdbcResource createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private JdbcResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcResource jdbcResource = (JdbcResource)param.createChild(JdbcResource.class);
        jdbcResource.setJndiName(this.jndiName);
        if (this.description != null) {
            jdbcResource.setDescription(this.description);
        }
        jdbcResource.setPoolName(this.poolName);
        jdbcResource.setEnabled(this.enabled);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)jdbcResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                jdbcResource.getProperty().add(prop);
            }
        }
        return jdbcResource;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = null;
        status = !validate ? new ResourceStatus(0, "") : this.isValid(resources, false, null);
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }

    public ResourceStatus delete(final Resources resources, final String jndiName, String target) throws Exception {
        if (jndiName == null) {
            String msg = localStrings.getLocalString("jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            return new ResourceStatus(1, msg);
        }
        if (ConnectorsUtil.getResourceByName((Resources)resources, JdbcResource.class, (String)jndiName) == null) {
            String msg = localStrings.getLocalString("delete.jdbc.resource.notfound", "A JDBC resource named {0} does not exist.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if (this.environment.isDas()) {
            if ("domain".equals(target)) {
                if (this.resourceUtil.getTargetsReferringResourceRef(jndiName).size() > 0) {
                    String msg = localStrings.getLocalString("delete.jdbc.resource.resource-ref.exist", "jdbc-resource [ {0} ] is referenced in aninstance/cluster target, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(jndiName, target)) {
                    String msg = localStrings.getLocalString("delete.jdbc.resource.no.resource-ref", "jdbc-resource [ {0} ] is not referenced in target [ {1} ]", new Object[]{jndiName, target});
                    return new ResourceStatus(1, msg);
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(jndiName).size() > 1) {
                    String msg = localStrings.getLocalString("delete.jdbc.resource.multiple.resource-refs", "jdbc resource [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            }
        }
        try {
            JdbcResource jdbcResource = (JdbcResource)ConnectorsUtil.getResourceByName((Resources)resources, JdbcResource.class, (String)jndiName);
            if ("system-all-req".equals(jdbcResource.getObjectType())) {
                String msg = localStrings.getLocalString("delete.jdbc.resource.system-all-req.object-type", "The jdbc resource [ {0} ] cannot be deleted as it is required to be configured in the system.", new Object[]{jndiName});
                return new ResourceStatus(1, msg);
            }
            this.resourceUtil.deleteResourceRef(jndiName, target);
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcResource resource = (JdbcResource)ConnectorsUtil.getResourceByName((Resources)resources, JdbcResource.class, (String)jndiName);
                    return param.getResources().remove(resource);
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbc.resource.deleteSuccess", "JDBC resource {0} deleted successfully", new Object[]{jndiName});
        return new ResourceStatus(0, msg);
    }
}

