/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileProtectionUtility;
import org.jvnet.hk2.annotations.Service;

@Service(name="_change-master-password-node")
@PerLookup
public class ChangeNodeMasterPasswordCommand
extends LocalInstanceCommand {
    private static final Logger LOGGER = Logger.getLogger(ChangeNodeMasterPasswordCommand.class.getName());
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(ChangeNodeMasterPasswordCommand.class);
    protected static final String OLD_PASSWORD_ALIAS = "AS_ADMIN_MASTERPASSWORD";
    protected static final String NEW_PASSWORD_ALIAS = "AS_ADMIN_NEWMASTERPASSWORD";
    @Param(name="node", primary=true)
    protected String passwordNode;
    @Param(name="savemasterpassword", optional=true)
    private boolean saveMasterPassword;
    protected File selectedNodeDir;
    private String newPassword;

    protected void inject() throws CommandException {
        super.inject();
        this.selectedNodeDir = new File(this.nodeDir, this.passwordNode);
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        String currentPassword;
        super.validate();
        if (this.saveMasterPassword) {
            LOGGER.warning(STRINGS.get("savemasterpassword.unused"));
        }
        if (!this.selectedNodeDir.isDirectory() || !this.getServerDirs().getAgentDir().exists()) {
            throw new CommandException(STRINGS.get("bad.node.dir", new Object[]{this.selectedNodeDir}));
        }
        for (File instanceDir : this.getInstanceDirectories()) {
            if (!this.isRunning(instanceDir)) continue;
            throw new CommandException(STRINGS.get("instance.is.running", new Object[]{instanceDir.getName()}));
        }
        String oldPassword = this.findOldPassword();
        if (!oldPassword.equals(currentPassword = Optional.ofNullable(this.readFromMasterPasswordFile()).orElse("changeit"))) {
            throw new CommandException(STRINGS.get("incorrect.old.mp"));
        }
        this.setNewPassword();
        try {
            if (this.dataGridEncryptionEnabled()) {
                LOGGER.warning("Data grid encryption is enabled - you will need to regenerate the encryption key");
            }
        }
        catch (IOException | XMLStreamException exception) {
            LOGGER.warning("Could not determine if data grid encryption is enabled - you will need to regenerate the encryption key if it is");
        }
        try {
            this.checkAdditionalTrustAndKeyStores();
        }
        catch (IOException | XMLStreamException exception) {
            LOGGER.warning("Could not determine if there were additional Key Stores or Trust stores, if the master-password has been updated, the password for the additional stores need updating in order to continue using them.");
        }
    }

    protected int executeCommand() throws CommandException {
        File pwdFile = new File(this.getServerDirs().getAgentDir(), "master-password");
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), "master-password".toCharArray());
            p.setPasswordForAlias("master-password", this.newPassword.getBytes(StandardCharsets.UTF_8));
            FileProtectionUtility.chmod0600((File)pwdFile);
            return 0;
        }
        catch (Exception ex) {
            throw new CommandException(STRINGS.get("masterPasswordFileNotCreated", new Object[]{pwdFile}), (Throwable)ex);
        }
    }

    public int execute(String ... argv) throws CommandException {
        this.checkOneAndOnly = false;
        return super.execute(argv);
    }

    protected String findOldPassword() throws CommandException {
        String oldPassword = super.readFromMasterPasswordFile();
        if (oldPassword == null) {
            oldPassword = (String)this.passwords.get(OLD_PASSWORD_ALIAS);
        }
        if (oldPassword == null) {
            char[] opArr = super.readPassword(STRINGS.get("old.mp"));
            String string = oldPassword = opArr != null ? new String(opArr) : null;
        }
        if (oldPassword == null) {
            throw new CommandException(STRINGS.get("no.console"));
        }
        return oldPassword;
    }

    protected void setNewPassword() throws CommandException {
        CommandModelData.ParamModelData nmpo = new CommandModelData.ParamModelData(NEW_PASSWORD_ALIAS, String.class, false, null);
        nmpo.prompt = STRINGS.get("new.mp");
        nmpo.promptAgain = STRINGS.get("new.mp.again");
        nmpo.param._password = true;
        char[] npArr = super.getPassword((CommandModel.ParamModel)nmpo, null, true);
        String string = this.newPassword = npArr != null ? new String(npArr) : null;
        if (this.newPassword == null) {
            throw new CommandException(STRINGS.get("no.console"));
        }
    }

    private List<File> getInstanceDirectories() throws CommandException {
        File[] instanceDirectories = this.selectedNodeDir.listFiles(f -> f.isDirectory() && !f.getName().equals("agent"));
        if (instanceDirectories == null || instanceDirectories.length == 0) {
            throw new CommandException(STRINGS.get("Instance.noInstanceDirs", new Object[]{this.selectedNodeDir}));
        }
        return Arrays.asList(instanceDirectories);
    }

    private boolean isRunning(File instanceDir) throws CommandException {
        try {
            File configDir = new File(instanceDir, "config");
            File domainXml = new File(configDir, "domain.xml");
            if (!domainXml.exists()) {
                return false;
            }
            MiniXmlParser parser = new MiniXmlParser(domainXml, instanceDir.getName());
            List addrSet = parser.getAdminAddresses();
            if (addrSet.isEmpty()) {
                throw new CommandException(STRINGS.get("NoAdminPort"));
            }
            HostAndPort addr = (HostAndPort)addrSet.get(0);
            return this.isRunning(addr.getHost(), addr.getPort());
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(STRINGS.get("NoAdminPortEx", new Object[]{ex}), (Throwable)ex);
        }
    }
}

