/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.InstallNodeBaseCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.io.FileUtils;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="install-node-ssh")
@PerLookup
public class InstallNodeSshCommand
extends InstallNodeBaseCommand {
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(optional=true, defaultValue="22", name="sshport")
    int port;
    @Param(optional=true)
    String sshkeyfile;
    @Inject
    private SSHLauncher sshLauncher;
    private Map<String, char[]> sshPasswords = new HashMap<String, char[]>();
    private static final String ASADMIN = "/lib/nadmin' version --local --terse";

    @Override
    String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return this.port;
    }

    @Override
    String getSshKeyFile() {
        return this.sshkeyfile;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey;
            }
        } else {
            this.validateKey(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && SSHUtil.isEncryptedKey((String)this.sshkeyfile)) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    @Override
    void copyToHosts(File zipFile, ArrayList<String> binDirFiles) throws CommandException {
        try {
            this.copyToHostsInternal(zipFile, binDirFiles);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (IOException | InterruptedException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    private void copyToHostsInternal(File zipFile, ArrayList<String> binDirFiles) throws IOException, InterruptedException, CommandException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        boolean prompt = this.promptPass;
        for (String host : this.hosts) {
            this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, this.getSshKeyFile(), this.sshkeypassphrase, logger);
            if (this.getSshKeyFile() != null && !this.sshLauncher.checkConnection()) {
                prompt = true;
            }
            if (prompt) {
                String sshpass = null;
                sshpass = this.sshPasswords.containsKey(host) ? String.valueOf(this.sshPasswords.get(host)) : this.getSSHPassword(host);
                this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), sshpass, this.getSshKeyFile(), this.sshkeypassphrase, logger);
                prompt = false;
            }
            String sshInstallDir = this.getInstallDir().replace('\\', '/');
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            SCPClient scpClient = this.sshLauncher.getSCPClient();
            try {
                if (!sftpClient.exists(sshInstallDir)) {
                    sftpClient.mkdirs(sshInstallDir, 493);
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("mkdir.failed", sshInstallDir, host));
                throw new IOException(ioe);
            }
            try {
                List<String> files = this.getListOfInstallFiles(sshInstallDir);
                this.deleteRemoteFiles(sftpClient, files, sshInstallDir, this.getForce());
            }
            catch (IOException ex) {
                logger.finer("Failed to remove sshInstallDir contents");
                throw new IOException(ex);
            }
            String zip = zipFile.getCanonicalPath();
            try {
                logger.log(Level.INFO, "Copying {0} ({1} bytes) to {2}:{3}", new Object[]{zip, zipFile.length(), host, sshInstallDir});
                scpClient.put(zipFile.getAbsolutePath(), FileUtils.quoteString((String)sshInstallDir));
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Copied {0} to {1}:{2}", new Object[]{zip, host, sshInstallDir});
                }
            }
            catch (IOException ex) {
                logger.info(Strings.get("cannot.copy.zip.file", zip, host));
                throw new IOException(ex);
            }
            try {
                logger.log(Level.INFO, "Installing {0} into {1}:{2}", new Object[]{this.getArchiveName(), host, sshInstallDir});
                String unzipCommand = "cd '" + sshInstallDir + "'; jar -xvf " + this.getArchiveName();
                int status = this.sshLauncher.runCommand(unzipCommand, (OutputStream)outStream);
                if (status != 0) {
                    String outStreamToString = outStream.toString(StandardCharsets.UTF_8);
                    logger.info(Strings.get("jar.failed", host, outStreamToString));
                    throw new CommandException("Remote command output: " + outStreamToString);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Installed {0} into {1}:{2}", new Object[]{this.getArchiveName(), host, sshInstallDir});
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("jar.failed", host, outStream.toString(StandardCharsets.UTF_8)));
                throw new IOException(ioe);
            }
            try {
                logger.log(Level.INFO, "Removing {0}:{1}/{2}", new Object[]{host, sshInstallDir, this.getArchiveName()});
                sftpClient.rm(sshInstallDir + "/" + this.getArchiveName());
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Removed {0}:{1}/{2}", new Object[]{host, sshInstallDir, this.getArchiveName()});
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("remove.glassfish.failed", host, sshInstallDir));
                throw new IOException(ioe);
            }
            logger.log(Level.INFO, "Fixing file permissions of all bin files under {0}:{1}", new Object[]{host, sshInstallDir});
            try {
                if (binDirFiles.isEmpty()) {
                    this.searchAndFixBinDirectoryFiles(sshInstallDir, sftpClient);
                } else {
                    for (String binDirFile : binDirFiles) {
                        sftpClient.chmod(sshInstallDir + "/" + binDirFile, 493);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Fixed file permissions of all bin files under {0}:{1}", new Object[]{host, sshInstallDir});
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("fix.permissions.failed", host, sshInstallDir));
                throw new IOException(ioe);
            }
            logger.log(Level.INFO, "Fixing file permissions for nadmin file under {0}:{1}/{2}/lib", new Object[]{host, sshInstallDir, SystemPropertyConstants.getComponentName()});
            try {
                sftpClient.chmod(sshInstallDir + "/" + SystemPropertyConstants.getComponentName() + "/lib/nadmin", 493);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Fixed file permission for nadmin under {0}:{1}/{2}/lib/nadmin", new Object[]{host, sshInstallDir, SystemPropertyConstants.getComponentName()});
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("fix.permissions.failed", host, sshInstallDir));
                throw new IOException(ioe);
            }
            sftpClient.close();
        }
    }

    private void searchAndFixBinDirectoryFiles(String installDir, SFTPClient sftpClient) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(installDir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..") || !directoryEntry.attributes.isDirectory()) continue;
            String subDir = installDir + "/" + directoryEntry.filename;
            if (directoryEntry.filename.equals("bin")) {
                this.fixAllFiles(subDir, sftpClient);
                continue;
            }
            this.searchAndFixBinDirectoryFiles(subDir, sftpClient);
        }
    }

    private void fixAllFiles(String binDir, SFTPClient sftpClient) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(binDir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..")) continue;
            String fName = binDir + "/" + directoryEntry.filename;
            sftpClient.chmod(fName, 493);
        }
    }

    private void checkIfAlreadyInstalled(String host, String sshInstallDir) throws CommandException, IOException, InterruptedException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            String cmd = "'" + sshInstallDir + "/" + SystemPropertyConstants.getComponentName() + ASADMIN;
            int status = this.sshLauncher.runCommand(cmd, (OutputStream)outStream);
            if (status == 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "{0}:''{1}'' returned [{2}]", new Object[]{host, cmd, outStream.toString(StandardCharsets.UTF_8)});
                }
                throw new CommandException(Strings.get("install.dir.exists", sshInstallDir));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0}:''{1}'' failed [{2}]", new Object[]{host, cmd, outStream.toString(StandardCharsets.UTF_8)});
            }
        }
        catch (IOException ex) {
            logger.info(Strings.get("glassfish.install.check.failed", host));
            throw new IOException(ex);
        }
    }

    @Override
    final void precopy() throws CommandException {
        if (this.getForce()) {
            return;
        }
        boolean prompt = this.promptPass;
        for (String host : this.hosts) {
            this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, this.getSshKeyFile(), this.sshkeypassphrase, logger);
            if (this.getSshKeyFile() != null && !this.sshLauncher.checkConnection()) {
                prompt = true;
            }
            if (prompt) {
                String sshpass = this.getSSHPassword(host);
                this.sshPasswords.put(host, sshpass.toCharArray());
                this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), sshpass, this.getSshKeyFile(), this.sshkeypassphrase, logger);
                prompt = false;
            }
            String sshInstallDir = this.getInstallDir().replaceAll("\\\\", "/");
            try {
                SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
                if (sftpClient.exists(sshInstallDir)) {
                    this.checkIfAlreadyInstalled(host, sshInstallDir);
                }
                sftpClient.close();
            }
            catch (IOException ex) {
                throw new CommandException((Throwable)ex);
            }
            catch (InterruptedException ex) {
                throw new CommandException((Throwable)ex);
            }
        }
    }
}

