/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.audit;

import fish.payara.audit.AdminAuditConfiguration;
import fish.payara.audit.AuditLevel;
import fish.payara.internal.notification.EventLevel;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationFactory;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.messaging.Topic;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="asadmin-audit")
@RunLevel(value=10)
public class AdminAuditService {
    private static final String AUDIT_MESSAGE = "Admin Command Audit";
    private static final List<String> ACCESSOR_COMMAND_START = Arrays.asList("_", "get", "list", "help", "version");
    private boolean enabled;
    private AuditLevel auditLevel = AuditLevel.MODIFIERS;
    @Inject
    private Topic<PayaraNotification> notificationEventBus;
    @Inject
    private PayaraNotificationFactory notificationFactory;
    @Inject
    AdminAuditConfiguration configuration;
    private final Set<String> enabledNotifiers = new LinkedHashSet<String>();

    @PostConstruct
    public void postConstruct() {
        this.enabled = Boolean.valueOf(this.configuration.getEnabled());
        this.auditLevel = AuditLevel.valueOf(this.configuration.getAuditLevel());
        if (this.enabled) {
            this.bootstrapNotifierList();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        if (!this.enabled && enabled.booleanValue()) {
            Logger.getLogger("fish.payara.audit").log(Level.INFO, "Admin Audit Service Started");
            this.bootstrapNotifierList();
        }
        this.enabled = enabled;
    }

    public AuditLevel getAuditLevel() {
        return this.auditLevel;
    }

    public void setAuditLevel(AuditLevel level) {
        this.auditLevel = level;
    }

    public Set<String> getEnabledNotifiers() {
        return this.enabledNotifiers;
    }

    public synchronized void bootstrapNotifierList() {
        this.enabledNotifiers.clear();
        if (this.configuration.getNotifierList() != null) {
            this.configuration.getNotifierList().forEach(this.enabledNotifiers::add);
        }
    }

    public void recordAsadminCommand(String command, ParameterMap parameters, Subject subject) {
        if (this.enabled && !this.enabledNotifiers.isEmpty() && this.checkAuditLevel(command)) {
            Set<Principal> principals = subject.getPrincipals();
            String name = principals.iterator().next().getName();
            PayaraNotification notification = this.notificationFactory.newBuilder().whitelist(this.enabledNotifiers.toArray(new String[0])).subject(AUDIT_MESSAGE).message(name + " issued command " + command + " with parameters " + parameters.toString()).level(this.getEventLevel()).build();
            this.notificationEventBus.publish((Object)notification);
        }
    }

    private EventLevel getEventLevel() {
        switch (this.auditLevel) {
            case INTERNAL: {
                return EventLevel.INFO;
            }
            case ACCESSORS: {
                return EventLevel.WARNING;
            }
        }
        return EventLevel.SEVERE;
    }

    private boolean checkAuditLevel(String command) {
        switch (this.auditLevel) {
            case INTERNAL: {
                return true;
            }
            case ACCESSORS: {
                return !command.startsWith("_");
            }
            default: {
                for (String start : ACCESSOR_COMMAND_START) {
                    if (!command.startsWith(start)) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

