/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.node.admin;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="update-node-docker")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@CommandLock(value=CommandLock.LockType.NONE)
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Node.class, opType=RestEndpoint.OpType.POST, path="update-node-docker", description="Updates the configuration of a Docker Node", params={@RestParam(name="id", value="$parent")})})
public class UpdateNodeDockerCommand
implements AdminCommand {
    @Param(name="name", primary=true)
    String name;
    @Param(name="nodehost", optional=true)
    String nodehost;
    @Param(name="nodedir", optional=true)
    String nodedir;
    @Param(name="installdir", optional=true)
    String installdir;
    @Param(name="dockerImage", optional=true, alias="dockerimage")
    String dockerImage;
    @Param(name="dockerPasswordFile", optional=true, alias="dockerpasswordfile")
    String dockerPasswordFile;
    @Param(name="dockerPort", optional=true, alias="dockerport")
    Integer dockerPort;
    @Param(name="useTls", alias="usetls", optional=true)
    Boolean useTls;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Nodes nodes;

    public void execute(AdminCommandContext adminCommandContext) {
        ActionReport actionReport = adminCommandContext.getActionReport();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            actionReport.setMessage("No node with given name: " + this.name);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (node.isDefaultLocalNode()) {
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setMessage("Cannot update default node with this command");
            return;
        }
        if (!StringUtils.ok((String)this.nodehost) && !StringUtils.ok((String)node.getNodeHost())) {
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            actionReport.setMessage("A node must have a host");
            return;
        }
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.add((Object)"DEFAULT", (Object)this.name);
        if (this.nodehost != null) {
            parameterMap.add((Object)"nodehost", (Object)this.nodehost);
        }
        if (this.nodedir != null) {
            parameterMap.add((Object)"nodedir", (Object)this.nodedir);
        }
        if (this.installdir != null) {
            parameterMap.add((Object)"installdir", (Object)this.installdir);
        }
        if (this.dockerImage != null) {
            parameterMap.add((Object)"dockerImage", (Object)this.dockerImage);
        }
        if (this.dockerPasswordFile != null) {
            parameterMap.add((Object)"dockerPasswordFile", (Object)this.dockerPasswordFile);
        }
        if (this.dockerPort != null) {
            parameterMap.add((Object)"dockerPort", (Object)Integer.toString(this.dockerPort));
        }
        if (this.useTls != null) {
            parameterMap.add((Object)"useTls", (Object)this.useTls.toString());
        }
        if (parameterMap.size() > 1) {
            CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_update-node", actionReport, adminCommandContext.getSubject());
            commandInvocation.parameters(parameterMap);
            commandInvocation.execute();
        }
    }
}

