/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdNonce;
import fish.payara.security.openid.http.HttpStorageController;
import fish.payara.security.shaded.nimbusds.jose.util.Base64URL;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

@ApplicationScoped
public class NonceController {
    private static final String NONCE_KEY = "oidc.nonce";

    public void store(OpenIdNonce nonce, OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        if (configuration.isUseNonce()) {
            HttpStorageController.getInstance(configuration, request, response).store(NONCE_KEY, nonce.getValue(), null);
        }
    }

    public OpenIdNonce get(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        return HttpStorageController.getInstance(configuration, request, response).getAsString(NONCE_KEY).filter(OpenIdUtil.not(OpenIdUtil::isEmpty)).map(OpenIdNonce::new).orElse(null);
    }

    public void remove(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(configuration, request, response).remove(NONCE_KEY);
    }

    public String getNonceHash(OpenIdNonce nonce) {
        String nonceHash;
        Objects.requireNonNull(nonce, "OpenId nonce value must not be null");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(nonce.getValue().getBytes(StandardCharsets.US_ASCII));
            byte[] hash = md.digest();
            nonceHash = Base64URL.encode(hash).toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("No MessageDigest instance found with the specified algorithm for nonce hash", ex);
        }
        return nonceHash;
    }
}

