/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.crypto;

import fish.payara.security.shaded.nimbusds.jose.JOSEException;
import fish.payara.security.shaded.nimbusds.jose.JWEAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.JWECryptoParts;
import fish.payara.security.shaded.nimbusds.jose.JWEEncrypter;
import fish.payara.security.shaded.nimbusds.jose.JWEHeader;
import fish.payara.security.shaded.nimbusds.jose.KeyLengthException;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.AAD;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import fish.payara.security.shaded.nimbusds.jose.jwk.OctetSequenceKey;
import fish.payara.security.shaded.nimbusds.jose.shaded.jcip.ThreadSafe;
import fish.payara.security.shaded.nimbusds.jose.util.Base64URL;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        return this.encrypt(header, clearText, AAD.compute(header));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText, byte[] aad) throws JOSEException {
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, aad, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

