/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.jwk.source;

import fish.payara.security.shaded.nimbusds.jose.KeySourceException;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKSet;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetSource;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetSourceWrapper;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.RateLimitReachedException;
import fish.payara.security.shaded.nimbusds.jose.proc.SecurityContext;
import fish.payara.security.shaded.nimbusds.jose.shaded.jcip.ThreadSafe;
import fish.payara.security.shaded.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class RateLimitedJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final long minTimeInterval;
    private long nextOpeningTime = -1L;
    private int counter = 0;
    private final EventListener<RateLimitedJWKSetSource<C>, C> eventListener;

    public RateLimitedJWKSetSource(JWKSetSource<C> source, long minTimeInterval, EventListener<RateLimitedJWKSetSource<C>, C> eventListener) {
        super(source);
        this.minTimeInterval = minTimeInterval;
        this.eventListener = eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator refreshEvaluator, long currentTime, C context) throws KeySourceException {
        boolean rateLimitHit;
        RateLimitedJWKSetSource rateLimitedJWKSetSource = this;
        synchronized (rateLimitedJWKSetSource) {
            if (this.nextOpeningTime <= currentTime) {
                this.nextOpeningTime = currentTime + this.minTimeInterval;
                this.counter = 1;
                rateLimitHit = false;
            } else {
                boolean bl = rateLimitHit = this.counter <= 0;
                if (!rateLimitHit) {
                    --this.counter;
                }
            }
        }
        if (rateLimitHit) {
            if (this.eventListener != null) {
                this.eventListener.notify(new RateLimitedEvent(this, (SecurityContext)context, null));
            }
            throw new RateLimitReachedException();
        }
        return this.getSource().getJWKSet(refreshEvaluator, currentTime, context);
    }

    public long getMinTimeInterval() {
        return this.minTimeInterval;
    }

    public static class RateLimitedEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<RateLimitedJWKSetSource<C>, C> {
        private RateLimitedEvent(RateLimitedJWKSetSource<C> source, C securityContext) {
            super(source, securityContext);
        }

        /* synthetic */ RateLimitedEvent(RateLimitedJWKSetSource x0, SecurityContext x1, 1 x2) {
            this(x0, x1);
        }
    }
}

