/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing;

import fish.payara.opentracing.OpenTelemetryService;
import fish.payara.opentracing.PropagationHelper;
import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.InvocationManager;
import org.jboss.weld.interceptor.WeldInvocationContext;

public class WithSpanMethodInterceptor {
    private static final Logger LOG = Logger.getLogger(WithSpanMethodInterceptor.class.getName());
    private static final Class[] HTTP_METHODS = new Class[]{GET.class, POST.class, DELETE.class, PUT.class, HEAD.class, PATCH.class, OPTIONS.class};
    private final BeanManager bm;

    public WithSpanMethodInterceptor(BeanManager bm) {
        this.bm = bm;
    }

    private static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationClass, InvocationContext invocationContext) {
        A annotation = WithSpanMethodInterceptor.getInterceptedAnnotation(annotationClass, invocationContext);
        if (annotation == null) {
            annotation = WithSpanMethodInterceptor.getAnnotation(beanManager, annotationClass, invocationContext.getMethod().getDeclaringClass(), invocationContext.getMethod());
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationClass, Class<?> annotatedClass, Method method) {
        WithSpanMethodInterceptor.logGetAnnotation(annotationClass, method);
        Objects.requireNonNull(annotatedClass, "annotatedClass");
        Objects.requireNonNull(method, "method");
        if (method.isAnnotationPresent(annotationClass)) {
            LOG.log(Level.FINER, "Annotation was directly present on the method");
            return method.getAnnotation(annotationClass);
        }
        if (annotatedClass.isAnnotationPresent(annotationClass)) {
            LOG.log(Level.FINER, "Annotation was directly present on the class");
            return annotatedClass.getAnnotation(annotationClass);
        }
        LOG.log(Level.FINER, "Annotation wasn't directly present on the method or class, checking stereotypes");
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedClass.getAnnotations()));
        while (!annotations.isEmpty()) {
            Annotation a = (Annotation)annotations.remove();
            if (a.annotationType().equals(annotationClass)) {
                LOG.log(Level.FINER, "Annotation was found in a stereotype");
                return (A)((Annotation)annotationClass.cast(a));
            }
            if (!beanManager.isStereotype(a.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(a.annotationType()));
        }
        return null;
    }

    private static <A extends Annotation> A getInterceptedAnnotation(Class<A> annotationClass, InvocationContext invocationContext) {
        if (invocationContext instanceof WeldInvocationContext) {
            Set interceptorBindings = ((WeldInvocationContext)invocationContext).getInterceptorBindings();
            for (Annotation annotationBound : interceptorBindings) {
                if (!annotationBound.annotationType().equals(annotationClass)) continue;
                return (A)annotationBound;
            }
        }
        return null;
    }

    private static void logGetAnnotation(Class<?> annotatedClass, Method method) {
        LOG.log(Level.FINER, "Attempting to get annotation {0} from {1}", new String[]{WithSpanMethodInterceptor.getString(annotatedClass, Class::getSimpleName), WithSpanMethodInterceptor.getString(method, Method::getName)});
    }

    private static <T> String getString(T object, Function<T, String> toString) {
        if (object == null) {
            return null;
        }
        return toString.apply(object);
    }

    @AroundInvoke
    public Object withSpanCdiCall(InvocationContext invocationContext) throws Exception {
        LOG.fine(() -> "withSpanCdiCall(" + invocationContext + ")");
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        OpenTelemetryService openTelemetryService = payaraTracingServices.getOpenTelemetryService();
        InvocationManager invocationManager = payaraTracingServices.getInvocationManager();
        AttributesBuilder builder = Attributes.builder();
        this.extractSpanAttributes(invocationContext, builder);
        Attributes attributes = builder.build();
        if (openTelemetryService == null || !openTelemetryService.isEnabled() || this.isJaxRsMethod(invocationContext) || this.isWebServiceMethod(invocationContext, invocationManager)) {
            LOG.finest("The call is already monitored by some different component, proceeding the invocation.");
            Span currentSpan = Span.current();
            currentSpan.setAllAttributes(attributes);
            return invocationContext.proceed();
        }
        WithSpan withSpan = WithSpanMethodInterceptor.getAnnotation(this.bm, WithSpan.class, invocationContext);
        SpanBuilder spanBuilder = openTelemetryService.getCurrentTracer().spanBuilder(this.getWithSpanValue(invocationContext, withSpan)).setSpanKind(withSpan.kind()).setAllAttributes(attributes);
        spanBuilder.setParent(Context.current());
        Span span = spanBuilder.startSpan();
        if (invocationContext.getMethod().getReturnType().equals(CompletionStage.class)) {
            return this.handleAsyncInvocation(invocationContext, span);
        }
        return this.handleSyncInvocation(invocationContext, span);
    }

    private boolean isJaxRsMethod(InvocationContext invocationContext) {
        for (Class httpMethod : HTTP_METHODS) {
            if (WithSpanMethodInterceptor.getAnnotation(this.bm, httpMethod, invocationContext) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isWebServiceMethod(InvocationContext invocationContext, InvocationManager invocationManager) {
        return invocationContext.getMethod().equals(invocationManager.peekWebServiceMethod());
    }

    private String getWithSpanValue(InvocationContext invocationContext, WithSpan withSpan) {
        String withSpanValue = withSpan.value();
        if (withSpanValue.isEmpty()) {
            if (invocationContext.getMethod().getDeclaringClass().getName().contains("$")) {
                return invocationContext.getMethod().getDeclaringClass().getSimpleName() + "." + invocationContext.getMethod().getName();
            }
            return invocationContext.getMethod().getDeclaringClass().getCanonicalName() + "." + invocationContext.getMethod().getName();
        }
        return withSpanValue;
    }

    private void extractSpanAttributes(InvocationContext invocationContext, AttributesBuilder builder) {
        MethodSpanAttributesExtractor extractor = MethodSpanAttributesExtractor.create(InvocationContext::getMethod, (m, p) -> (String[])Arrays.stream(m.getParameters()).map(v -> {
            SpanAttribute spanAttribute = v.getAnnotation(SpanAttribute.class);
            String name = v.isNamePresent() ? v.getName() : null;
            return spanAttribute != null ? spanAttribute.value().trim() : name;
        }).toArray(String[]::new), InvocationContext::getParameters);
        extractor.onStart(builder, Context.current(), (Object)invocationContext);
    }

    private Object handleSyncInvocation(InvocationContext invocationContext, Span span) throws Exception {
        PropagationHelper ignore = PropagationHelper.start((Span)span, (Context)Context.current());
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        catch (Exception ex) {
            this.markSpanAsFailed(span, ex);
            throw ex;
        }
        finally {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Object handleAsyncInvocation(InvocationContext invocationContext, Span span) throws Exception {
        PropagationHelper helper = PropagationHelper.startMultiThreaded((Span)span, (Context)Context.current());
        CompletionStage future = (CompletionStage)invocationContext.proceed();
        return future.whenComplete((value, ex) -> {
            if (ex != null) {
                this.markSpanAsFailed(helper.span(), (Throwable)ex);
            }
            helper.end();
            helper.close();
        });
    }

    private void markSpanAsFailed(Span span, Throwable ex) {
        LOG.log(Level.FINEST, "Setting the error to the active span ...", ex);
        span.setAttribute("error", true);
        span.setAttribute(SemanticAttributes.EXCEPTION_TYPE, (Object)Throwable.class.getName());
        span.addEvent("exception", Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_MESSAGE, (Object)ex.getMessage()));
        span.recordException(ex);
    }
}

