/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs;

import fish.payara.microprofile.telemetry.tracing.PayaraTracingServices;
import fish.payara.microprofile.telemetry.tracing.jaxrs.OpenTelemetryRequestEventListener;
import fish.payara.microprofile.telemetry.tracing.jaxrs.OpenTracingHelper;
import fish.payara.opentracing.OpenTelemetryService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import java.util.logging.Logger;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Priority(value=2500)
public class OpenTelemetryApplicationEventListener
implements ApplicationEventListener {
    private static final Logger LOG = Logger.getLogger(OpenTelemetryApplicationEventListener.class.getName());
    private OpenTelemetryService openTelemetryService;
    @Context
    private ResourceInfo resourceInfo;
    private OpenTracingHelper openTracingHelper;

    @PostConstruct
    public void postConstruct() {
        LOG.finest("postConstruct()");
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        this.openTelemetryService = payaraTracingServices.getOpenTelemetryService();
        this.openTracingHelper = new OpenTracingHelper();
    }

    public void onEvent(ApplicationEvent event) {
        switch (event.getType()) {
            case DESTROY_FINISHED: 
            case RELOAD_FINISHED: {
                OpenTracingHelper.canTraceCache.clear(event.getResourceConfig().getClassLoader());
            }
        }
        LOG.config(() -> "onEvent(event.type=" + event.getType() + ")");
    }

    public RequestEventListener onRequest(RequestEvent event) {
        LOG.finer(() -> "onRequest(event.type=" + event.getType() + ")");
        if (!this.isRequestTracingInProgress()) {
            LOG.finest("isRequestTracingInProgress() returned false, nothing to do.");
            return null;
        }
        return new OpenTelemetryRequestEventListener(this.resourceInfo, this.openTelemetryService, this.openTracingHelper);
    }

    private boolean isRequestTracingInProgress() {
        return this.openTelemetryService.isEnabled();
    }
}

