/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.connectors.jms.config.JmsAvailability;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="configure-jms-cluster")
@PerLookup
@I18n(value="configure.jms.cluster")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="configure-jms-cluster", description="configure-jms-cluster", params={@RestParam(name="id", value="$parent")})})
public class ConfigureJMSCluster
implements AdminCommand {
    private static final String SUPPORTED_DB_VENDORS = "oracle|postgresql|mysql|h2|db2|sqlserver";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigureJMSCluster.class);
    private static final String MASTER_BROKER = "masterbroker";
    private static final String SHARED_DB = "shareddb";
    private static final String FILE = "file";
    private static final String JDBC = "jdbc";
    private static final String CONVENTIONAL = "conventional";
    private static final String ENHANCED = "enhanced";
    private static final String LOCAL = "LOCAL";
    private static final String REMOTE = "REMOTE";
    private static final String EMBEDDED = "EMBEDDED";
    private static final String PASSWORD_KEY = "AS_ADMIN_JMSDBPASSWORD";
    @Param(name="configstoretype", optional=true, alias="cs")
    String configStoreType;
    @Param(name="messagestoretype", optional=true, alias="ms")
    String messageStoreType;
    @Param(name="clustertype", alias="ct", optional=false)
    String clusterType;
    @Param(name="dbvendor", alias="db", optional=true)
    String dbvendor;
    @Param(name="dbuser", alias="user", optional=true)
    String dbuser;
    @Param(name="jmsDbPassword", optional=true, password=true)
    String jmsDbPassword;
    @Param(name="dburl", alias="url", optional=true)
    String dburl;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(primary=true)
    String clusterName;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;
    @Inject
    CommandRunner commandRunner;
    Config config;

    public void execute(AdminCommandContext context) {
        Config config;
        JmsService jmsService;
        ActionReport report = context.getActionReport();
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (cluster == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.invalidClusterName", "No Cluster by this name has been configured"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List instances = cluster.getInstances();
        Object warning = null;
        if (instances.size() > 0) {
            ActionReport listReport = (ActionReport)this.habitat.getService(ActionReport.class, new Annotation[0]);
            ParameterMap parameters = new ParameterMap();
            parameters.set((Object)"DEFAULT", (Object)this.clusterName);
            this.commandRunner.getCommandInvocation("list-instances", listReport, context.getSubject()).parameters(parameters).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)listReport.getActionExitCode())) {
                warning = localStrings.getLocalString("configure.jms.cluster.clusterWithInstances", "Warning: Please make sure running this command with all cluster instances stopped, otherwise it may lead to inconsistent JMS behavior and corruption of configuration and message stores.");
            } else {
                String result = listReport.getMessage();
                String fixedResult = result.replaceAll("not running", "stopped");
                if (fixedResult.indexOf("running") > -1) {
                    warning = localStrings.getLocalString("configure.jms.cluster.clusterWithInstances", "Warning: Please make sure running this command with all cluster instances stopped, otherwise it may lead to inconsistent JMS behavior and corruption of configuration and message stores.");
                    warning = (String)warning + "\r\n" + result + "\r\n";
                }
            }
        }
        if ((jmsService = (JmsService)(config = this.domain.getConfigNamed(cluster.getConfigRef())).getExtensionByType(JmsService.class)) == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.nojmsservice", "No JMS Service element in config"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!CONVENTIONAL.equalsIgnoreCase(this.clusterType) && !ENHANCED.equalsIgnoreCase(this.clusterType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongClusterType", "Invalid option sepecified for clustertype. Valid options are conventional and enhanced"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && !MASTER_BROKER.equalsIgnoreCase(this.configStoreType) && !SHARED_DB.equalsIgnoreCase(this.configStoreType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongConfigStoreType", "Invalid option sepecified for configstoretype. Valid options are masterbroker and shareddb"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (ENHANCED.equalsIgnoreCase(this.clusterType) && this.configStoreType != null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongStoreType", "configstoretype option is not configurable for Enhanced clusters."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && !MASTER_BROKER.equalsIgnoreCase(this.configStoreType) && !FILE.equalsIgnoreCase(this.messageStoreType) && !JDBC.equalsIgnoreCase(this.messageStoreType)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongMessageStoreType", "Invalid option sepecified for messagestoretype. Valid options are file and jdbc"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (ENHANCED.equalsIgnoreCase(this.clusterType) && this.messageStoreType != null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.wrongmsgStoreType", "messagestoretype option is not configurable for Enhanced clusters."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String integrationMode = jmsService.getType();
        if (REMOTE.equalsIgnoreCase(integrationMode)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.remoteMode", "JMS integration mode should be either EMBEDDED or LOCAL to run this command. Please use the asadmin.set command to change the integration mode"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String changeIntegrationMode = null;
        if (EMBEDDED.equalsIgnoreCase(integrationMode) && ENHANCED.equalsIgnoreCase(this.clusterType)) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsService>(){

                    public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                        param.setType(ConfigureJMSCluster.LOCAL);
                        return param;
                    }
                }, (ConfigBeanProxy)jmsService);
                changeIntegrationMode = localStrings.getLocalString("configure.jms.cluster.integrationModeChanged", "WARNING: JMS integration mode has been changed from EMBEDDED to LOCAL automatically.");
            }
            catch (TransactionFailure tfe) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.cannotChangeIntegrationMode", "Unable to change the JMS integration mode to LOCAL for Enhanced cluster {0}.", new Object[]{this.clusterName}) + " " + tfe.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)tfe);
                return;
            }
        }
        if (MASTER_BROKER.equalsIgnoreCase(this.configStoreType) && FILE.equals(this.messageStoreType) && (this.dbvendor != null || this.dburl != null || this.dbuser != null)) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.invalidDboptions", "Database options should not be specified for this configuration"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!MASTER_BROKER.equalsIgnoreCase(this.configStoreType) || ENHANCED.equalsIgnoreCase(this.clusterType) || JDBC.equalsIgnoreCase(this.messageStoreType)) {
            if (this.dbvendor == null) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.nodbvendor", "No DataBase vendor specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.dburl == null) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.nojdbcurl", "No JDBC URL specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.isSupportedDbVendor()) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.invaliddbvendor", "Invalid DB Vednor specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && this.configStoreType == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.noConfigStoreType", "No configstoretype specified. Using the default value - masterbroker"));
            this.configStoreType = MASTER_BROKER;
        }
        if (CONVENTIONAL.equalsIgnoreCase(this.clusterType) && this.messageStoreType == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.noMessagetoreType", "No messagestoretype specified. Using the default value - file"));
            this.messageStoreType = FILE;
        }
        config = this.domain.getConfigNamed(cluster.getConfigRef());
        JmsAvailability jmsAvailability = (JmsAvailability)config.getAvailabilityService().getExtensionByType(JmsAvailability.class);
        final Boolean availabilityEnabled = ENHANCED.equalsIgnoreCase(this.clusterType);
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsAvailability>(){

                public Object run(JmsAvailability param) throws PropertyVetoException, TransactionFailure {
                    param.setAvailabilityEnabled(availabilityEnabled.toString());
                    if (availabilityEnabled.booleanValue()) {
                        param.setMessageStoreType(ConfigureJMSCluster.JDBC);
                    } else {
                        param.setConfigStoreType(ConfigureJMSCluster.this.configStoreType.toLowerCase(Locale.ENGLISH));
                        param.setMessageStoreType(ConfigureJMSCluster.this.messageStoreType.toLowerCase(Locale.ENGLISH));
                    }
                    param.setDbVendor(ConfigureJMSCluster.this.dbvendor);
                    param.setDbUsername(ConfigureJMSCluster.this.dbuser);
                    param.setDbPassword(ConfigureJMSCluster.this.jmsDbPassword);
                    param.setDbUrl(ConfigureJMSCluster.this.dburl);
                    if (ConfigureJMSCluster.this.props != null) {
                        for (Map.Entry<Object, Object> e : ConfigureJMSCluster.this.props.entrySet()) {
                            Property prop = (Property)param.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            param.getProperty().add(prop);
                        }
                    }
                    return param;
                }
            }, (ConfigBeanProxy)jmsAvailability);
        }
        catch (TransactionFailure tfe) {
            report.setMessage((String)(changeIntegrationMode == null ? "" : changeIntegrationMode + "\n") + localStrings.getLocalString("configure.jms.cluster.fail", "Unable to Configure JMS Cluster for cluster {0}.", new Object[]{this.clusterName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage((String)(warning == null ? "" : (String)warning + "\n") + (String)(changeIntegrationMode == null ? "" : changeIntegrationMode + "\n") + localStrings.getLocalString("configure.jms.cluster.success", "JMS Cluster Configuration updated for Cluster {0}.", new Object[]{this.clusterName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isSupportedDbVendor() {
        if (this.dbvendor != null) {
            return SUPPORTED_DB_VENDORS.contains(this.dbvendor.toLowerCase(Locale.ENGLISH));
        }
        return false;
    }
}

