/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.DefaultResourceProxy;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-jms-resources")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.jms.resources")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DOMAIN, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-jms-resources", description="list-jms-resources")})
public class ListJMSResources
implements AdminCommand {
    private static final String JMSRA = "jmsra";
    private static final String QUEUE = "jakarta.jms.Queue";
    private static final String TOPIC = "jakarta.jms.Topic";
    private static final String QUEUE_CF = "jakarta.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "jakarta.jms.TopicConnectionFactory";
    private static final String UNIFIED_CF = "jakarta.jms.ConnectionFactory";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJMSResources.class);
    @Param(name="resType", optional=true)
    String resourceType;
    @Param(primary=true, optional=true)
    String target = "server";
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Properties extraProperties = new Properties();
        Collection adminObjectResourceList = this.domain.getResources().getResources(AdminObjectResource.class);
        Collection connectorResourcesList = this.domain.getResources().getResources(ConnectorResource.class);
        Object[] connectorResources = connectorResourcesList.toArray();
        Object[] adminObjectResources = adminObjectResourceList.toArray();
        if (this.resourceType == null) {
            try {
                for (Object object : adminObjectResources) {
                    AdminObjectResource adminObject = (AdminObjectResource)object;
                    if (!JMSRA.equals(adminObject.getResAdapter())) continue;
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("name", adminObject.getJndiName());
                    list.add(m);
                }
                for (Object object : connectorResources) {
                    ConnectorResource cr = (ConnectorResource)object;
                    ConnectorConnectionPool cp = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorConnectionPool.class, (String)cr.getPoolName());
                    if (cp == null || !JMSRA.equals(cp.getResourceAdapterName())) continue;
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("name", cr.getJndiName());
                    list.add(m);
                }
            }
            catch (Exception e) {
                report.setMessage(localStrings.getLocalString("list.jms.resources.fail", "Unable to list JMS Resources") + " " + e.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
        } else {
            switch (this.resourceType) {
                case "jakarta.jms.TopicConnectionFactory": 
                case "jakarta.jms.QueueConnectionFactory": 
                case "jakarta.jms.ConnectionFactory": {
                    for (Object c : connectorResources) {
                        ConnectorResource cr = (ConnectorResource)c;
                        ConnectorConnectionPool cp = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorConnectionPool.class, (String)cr.getPoolName());
                        if (cp == null || !this.resourceType.equals(cp.getConnectionDefinitionName()) || !JMSRA.equals(cp.getResourceAdapterName())) continue;
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("name", cr.getJndiName());
                        list.add(m);
                    }
                    break;
                }
                case "jakarta.jms.Topic": 
                case "jakarta.jms.Queue": {
                    for (Object r : adminObjectResources) {
                        AdminObjectResource res = (AdminObjectResource)r;
                        if (!this.resourceType.equals(res.getResType()) || !JMSRA.equals(res.getResAdapter())) continue;
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("name", res.getJndiName());
                        list.add(m);
                    }
                    break;
                }
            }
        }
        if (!list.isEmpty()) {
            ArrayList<Map<String, String>> resourceList = CommandTarget.DOMAIN.isValid(this.habitat, this.target) ? list : this.filterListForTarget(list);
            List drps = this.habitat.getAllServices(DefaultResourceProxy.class, new Annotation[0]);
            for (Map map : resourceList) {
                String jndiName = (String)map.get("name");
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
                String logicalName = DefaultResourceProxy.Util.getLogicalName((List)drps, (String)jndiName);
                if (logicalName == null) continue;
                map.put("logical-jndi-name", logicalName);
            }
            extraProperties.put("jmsResources", resourceList);
        }
        report.setExtraProperties(extraProperties);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private List filterListForTarget(List<Map<String, String>> list) {
        ArrayList<Map<String, String>> resourceList = new ArrayList<Map<String, String>>();
        if (this.target != null) {
            List resourceRefs = null;
            Cluster cluster = this.domain.getClusterNamed(this.target);
            if (cluster != null) {
                resourceRefs = cluster.getResourceRef();
            } else {
                Server server = this.domain.getServerNamed(this.target);
                if (server != null) {
                    resourceRefs = server.getResourceRef();
                }
            }
            if (resourceRefs != null && !resourceRefs.isEmpty()) {
                for (Map<String, String> m : list) {
                    String jndiName = m.get("name");
                    for (ResourceRef resource : resourceRefs) {
                        if (!jndiName.equals(resource.getRef())) continue;
                        resourceList.add(m);
                    }
                }
            }
        }
        return resourceList;
    }
}

