/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.admin.report.ActionReporter;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.ActionReportJsonProvider;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class ActionReportJson2Provider
extends ActionReportJsonProvider {
    @Override
    protected JsonObject processReport(ActionReporter ar) throws JsonException {
        JsonObject result = super.processReport(ar);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder((JsonObject)result);
        String combinedMessage = result.getString("message", null);
        String msg = this.decodeEol(ar.getTopMessagePart().getMessage());
        if (combinedMessage != null && !combinedMessage.equals(msg)) {
            if (msg != null) {
                objectBuilder.add("top_message", msg);
            } else {
                objectBuilder.add("top_message", JsonValue.NULL);
            }
        }
        if (ar.getFailureCause() != null) {
            objectBuilder.add("failure_cause", ar.getFailureCause().getLocalizedMessage() != null ? ar.getFailureCause().getLocalizedMessage() : "");
        }
        return objectBuilder.build();
    }
}

