/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.oracle.webservices.api.databinding.JavaCallInfo;
import com.oracle.webservices.api.message.MessageContext;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.model.SOAPSEIModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.SOAPMessageContextImpl;
import org.glassfish.webservices.monitoring.HttpResponseInfoImpl;
import org.glassfish.webservices.monitoring.JAXWSEndpointImpl;
import org.glassfish.webservices.monitoring.MonitorContextImpl;
import org.glassfish.webservices.monitoring.MonitorFilter;
import org.glassfish.webservices.monitoring.ThreadLocalInfo;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class MonitoringPipe
extends AbstractFilterPipeImpl {
    private final SEIModel seiModel;
    private final WSDLPort wsdlModel;
    private final WSEndpoint<?> ownerEndpoint;
    private final WebServiceEndpoint endpoint;
    private final WebServiceEngineImpl wsMonitor;

    public MonitoringPipe(ServerPipeAssemblerContext assemblerContext, Pipe tail, WebServiceEndpoint endpoint) {
        super(tail);
        this.endpoint = endpoint;
        this.seiModel = assemblerContext.getSEIModel();
        this.wsdlModel = assemblerContext.getWsdlModel();
        this.ownerEndpoint = assemblerContext.getEndpoint();
        this.wsMonitor = WebServiceEngineImpl.getInstance();
    }

    public MonitoringPipe(MonitoringPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.endpoint = that.endpoint;
        this.seiModel = that.seiModel;
        this.wsdlModel = that.wsdlModel;
        this.ownerEndpoint = that.ownerEndpoint;
        this.wsMonitor = WebServiceEngineImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet process(Packet pipeRequest) {
        String delegateClassName = pipeRequest.webServiceContextDelegate.getClass().getName();
        if (delegateClassName.equals("com.sun.enterprise.jbi.serviceengine.bridge.transport.NMRServerConnection")) {
            return this.next.process(pipeRequest);
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            return this.next.process(pipeRequest);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)pipeRequest.get((Object)"jakarta.xml.ws.servlet.request");
        HttpServletResponse httpResponse = (HttpServletResponse)pipeRequest.get((Object)"jakarta.xml.ws.servlet.response");
        JAXWSEndpointImpl endpointTracer = this.getEndpointTracer(httpRequest);
        SOAPMessageContextImpl soapMessageContext = new SOAPMessageContextImpl(pipeRequest);
        InvocationManager invocationManager = (InvocationManager)Globals.get(InvocationManager.class);
        JavaCallInfo javaCallInfo = this.getJavaCallInfo(pipeRequest);
        try {
            this.pushWebServiceMethod(invocationManager, javaCallInfo);
            this.firePreInvocation(httpRequest, pipeRequest, endpointTracer, soapMessageContext, javaCallInfo);
            Packet originalPipeRequest = pipeRequest.copy(true);
            Packet pipeResponse = this.next.process(pipeRequest);
            this.firePostInvocation(httpResponse, pipeResponse, originalPipeRequest, endpointTracer, soapMessageContext);
            Packet packet = pipeResponse;
            return packet;
        }
        finally {
            this.popWebServiceMethod(invocationManager, javaCallInfo);
        }
    }

    public final Pipe copy(PipeCloner cloner) {
        return new MonitoringPipe(this, cloner);
    }

    private JAXWSEndpointImpl getEndpointTracer(HttpServletRequest httpRequest) {
        if (this.endpoint.implementedByWebComponent()) {
            return this.getJAXWSEndpointImpl(httpRequest.getServletPath());
        }
        return this.getJAXWSEndpointImpl(httpRequest.getRequestURI());
    }

    private JAXWSEndpointImpl getJAXWSEndpointImpl(String uri) {
        return (JAXWSEndpointImpl)this.wsMonitor.getEndpoint(uri);
    }

    private void firePreInvocation(HttpServletRequest httpRequest, Packet pipeRequest, JAXWSEndpointImpl endpointTracer, SOAPMessageContextImpl soapMessageContext, JavaCallInfo javaCallInfo) {
        String messageTraceId;
        if (this.seiModel instanceof SOAPSEIModel) {
            SOAPSEIModel soapSEIModel = (SOAPSEIModel)this.seiModel;
            ((MonitorFilter)Globals.get(MonitorFilter.class)).filterRequest(pipeRequest, new MonitorContextImpl(javaCallInfo, soapSEIModel, this.wsdlModel, this.ownerEndpoint, this.endpoint));
        }
        if ((messageTraceId = this.wsMonitor.preProcessRequest(endpointTracer)) != null) {
            soapMessageContext.put("MONITORING_MESSAGE_ID", (Object)messageTraceId);
            this.wsMonitor.getThreadLocal().set(new ThreadLocalInfo(messageTraceId, httpRequest));
        }
        try {
            endpointTracer.processRequest(soapMessageContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JavaCallInfo getJavaCallInfo(Packet pipeRequest) {
        if (this.seiModel instanceof SOAPSEIModel) {
            SOAPSEIModel soapSEIModel = (SOAPSEIModel)this.seiModel;
            return soapSEIModel.getDatabinding().deserializeRequest((MessageContext)pipeRequest.copy(true));
        }
        return null;
    }

    private void pushWebServiceMethod(InvocationManager invocationManager, JavaCallInfo javaCallInfo) {
        if (javaCallInfo != null) {
            invocationManager.pushWebServiceMethod(javaCallInfo.getMethod());
        }
    }

    private void popWebServiceMethod(InvocationManager invocationManager, JavaCallInfo javaCallInfo) {
        if (javaCallInfo != null) {
            invocationManager.popWebServiceMethod();
        }
    }

    private void firePostInvocation(HttpServletResponse httpResponse, Packet pipeResponse, Packet pipeRequest, JAXWSEndpointImpl endpointTracer, SOAPMessageContextImpl soapMessageContext) {
        if (this.seiModel instanceof SOAPSEIModel) {
            SOAPSEIModel soapSEIModel = (SOAPSEIModel)this.seiModel;
            ((MonitorFilter)Globals.get(MonitorFilter.class)).filterResponse(pipeRequest, pipeResponse, new MonitorContextImpl(soapSEIModel.getDatabinding().deserializeRequest((MessageContext)pipeRequest), soapSEIModel, this.wsdlModel, this.ownerEndpoint, this.endpoint));
        }
        soapMessageContext.setPacket(pipeResponse);
        try {
            endpointTracer.processResponse(soapMessageContext);
        }
        catch (Exception soapSEIModel) {
            // empty catch block
        }
        String messageTraceId = (String)soapMessageContext.get("MONITORING_MESSAGE_ID");
        if (messageTraceId != null) {
            this.wsMonitor.postProcessResponse(messageTraceId, new HttpResponseInfoImpl(httpResponse));
        }
    }
}

