/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.jws.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.glassfish.appclient.client.jws.boot.ClassPathManager15;
import org.glassfish.appclient.client.jws.boot.ClassPathManager16;

public abstract class ClassPathManager {
    public static final String PERSISTENCE_JAR_CLASSES = "org.h2.jdbcx.JdbcDataSource,persistence.antlr.ActionElement,org.netbeans.modules.dbschema.ColumnElement,";
    private static volatile ClassPathManager mgr = null;
    private final boolean keepJWSClassLoader;
    private ClassLoader jnlpClassLoader = null;

    public static ClassPathManager getClassPathManager(boolean keepJWSClassLoader) {
        if (mgr == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            mgr = loader instanceof URLClassLoader ? new ClassPathManager16(loader, keepJWSClassLoader) : new ClassPathManager15(loader, keepJWSClassLoader);
        }
        return mgr;
    }

    protected ClassPathManager(ClassLoader loader, boolean keepJWSClassLoader) {
        this.jnlpClassLoader = loader;
        this.keepJWSClassLoader = keepJWSClassLoader;
    }

    protected boolean keepJWSClassLoader() {
        return this.keepJWSClassLoader;
    }

    protected ClassLoader getJnlpClassLoader() {
        return this.jnlpClassLoader;
    }

    public URI locateClass(String className) throws IllegalAccessException, InvocationTargetException, MalformedURLException, URISyntaxException, ClassNotFoundException {
        String resourceName = this.classNameToResourceName(className);
        URL classURL = this.locateResource(resourceName);
        File f = this.findContainingJar(classURL);
        if (f == null) {
            throw new ClassNotFoundException(className + "->" + resourceName);
        }
        return f.toURI();
    }

    public abstract ClassLoader getParentClassLoader();

    public abstract File findContainingJar(URL var1) throws IllegalArgumentException, URISyntaxException, MalformedURLException, IllegalAccessException, InvocationTargetException;

    protected ClassLoader getJNLPClassLoader() {
        return this.jnlpClassLoader;
    }

    protected String classNameToResourceName(String className) {
        return className.replace(".", "/") + ".class";
    }

    protected URL locateResource(String resourceName) {
        URL resourceURL = this.getClass().getClassLoader().getResource(resourceName);
        return resourceURL;
    }

    public URL[] locateDownloadedJars() throws ClassNotFoundException, URISyntaxException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        String probeClassNames = System.getProperty("com.sun.aas.jar.probe.class.names", "com.sun.enterprise.appclient.jws.boot.JWSACCMain,com.sun.enterprise.appclient.Main,com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer,com.sun.enterprise.admin.servermgmt.DomainConfig,com.sun.enterprise.deployment.client.DeploymentClientUtils,jakarta.ejb.EJB,jakarta.security.auth.message.module.ServerAuthModule,com.sun.appserv.management.ext.logging.LogAnalyzer,org.eclipse.angus.mail.iap.Argument,com.sun.activation.viewers.ImageViewer,com.sun.xml.ws.api.server.WSEndpoint,com.sun.tools.ws.wsdl.parser.W3CAddressingExtensionHandler,com.sun.jms.spi.xa.JMSXAConnection,com.sun.jndi.fscontext.FSContext");
        return this.locateJARs(probeClassNames);
    }

    public URL[] locateJARs(String classNamesString) throws IllegalAccessException, InvocationTargetException, MalformedURLException, URISyntaxException, ClassNotFoundException {
        String[] classNames = classNamesString.split(",");
        URL[] urls = new URL[classNames.length];
        int nextURL = 0;
        for (String className : classNames) {
            URI jarFileURI = this.locateClass(className);
            URL url = jarFileURI.toURL();
            urls[nextURL++] = url;
        }
        return urls;
    }

    public URL[] locatePersistenceJARs() throws IllegalAccessException, InvocationTargetException, MalformedURLException, URISyntaxException, ClassNotFoundException {
        return this.locateJARs(PERSISTENCE_JAR_CLASSES);
    }
}

