/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.phonehome;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.phonehome.PhoneHomeRuntimeConfiguration;
import fish.payara.nucleus.phonehome.PhoneHomeTask;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="phonehome-core")
@RunLevel(value=10)
public class PhoneHomeCore
implements EventListener {
    private static final String THREAD_NAME = "PhoneHomeThread";
    private static PhoneHomeCore theCore;
    private static Boolean overrideEnabled;
    private boolean enabled;
    private UUID phoneHomeId;
    @Inject
    private PayaraExecutorService executor;
    @Inject
    @Named(value="default-instance-name")
    PhoneHomeRuntimeConfiguration configuration;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Events events;
    @Inject
    private Domain domain;

    @PostConstruct
    public void postConstruct() {
        theCore = this;
        this.events.register((EventListener)this);
        if (this.env.isDas()) {
            block9: {
                if (this.configuration == null) {
                    this.enabled = true;
                    this.phoneHomeId = UUID.randomUUID();
                } else {
                    this.enabled = Boolean.valueOf(this.configuration.getEnabled());
                    try {
                        this.phoneHomeId = UUID.fromString(this.configuration.getPhoneHomeId());
                    }
                    catch (NullPointerException ex) {
                        this.phoneHomeId = UUID.randomUUID();
                        if (this.env.isMicro()) break block9;
                        try {
                            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<PhoneHomeRuntimeConfiguration>(){

                                public Object run(PhoneHomeRuntimeConfiguration configurationProxy) throws PropertyVetoException, TransactionFailure {
                                    configurationProxy.setPhoneHomeId(PhoneHomeCore.this.phoneHomeId.toString());
                                    return configurationProxy;
                                }
                            }, (ConfigBeanProxy)this.configuration);
                        }
                        catch (TransactionFailure transactionFailure) {
                            // empty catch block
                        }
                    }
                }
            }
            if (overrideEnabled != null) {
                this.enabled = overrideEnabled;
            }
        } else {
            this.enabled = false;
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapPhoneHome();
        } else if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownPhoneHome();
        }
    }

    private void bootstrapPhoneHome() {
        if (this.enabled) {
            this.executor.scheduleAtFixedRate((Runnable)new PhoneHomeTask(this.phoneHomeId.toString(), this.domain, this.env), 0L, 1L, TimeUnit.DAYS);
        }
    }

    private void shutdownPhoneHome() {
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
        if (this.enabled) {
            this.shutdownPhoneHome();
            this.bootstrapPhoneHome();
        } else {
            this.enabled = true;
            this.bootstrapPhoneHome();
        }
    }

    public void stop() {
        if (this.enabled) {
            this.enabled = false;
            this.shutdownPhoneHome();
        }
    }

    public static void setOverrideEnabled(boolean enabled) {
        overrideEnabled = enabled;
    }
}

