/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.session;

import org.apache.catalina.core.SessionCookieConfigImpl;
import org.apache.catalina.core.StandardContext;

public final class WebSessionCookieConfig
extends SessionCookieConfigImpl {
    private CookieSecureType secureCookieType = CookieSecureType.DYNAMIC;
    private CookieSameSiteType sameSiteCookie = null;

    public WebSessionCookieConfig(StandardContext context) {
        super(context);
    }

    public void setSecure(boolean secure) {
        super.setSecure(secure);
        this.secureCookieType = secure ? CookieSecureType.TRUE : CookieSecureType.DYNAMIC;
    }

    public void setSecure(String secure) {
        boolean isTrue = Boolean.parseBoolean(secure);
        super.setSecure(isTrue);
        this.secureCookieType = isTrue ? CookieSecureType.TRUE : ("false".equalsIgnoreCase(secure) ? CookieSecureType.FALSE : CookieSecureType.DYNAMIC);
    }

    public CookieSecureType getSecure() {
        return this.secureCookieType;
    }

    public void setSameSite(String value) {
        this.sameSiteCookie = CookieSameSiteType.STRICT.name().equalsIgnoreCase(value) ? CookieSameSiteType.STRICT : (CookieSameSiteType.LAX.name().equalsIgnoreCase(value) ? CookieSameSiteType.LAX : CookieSameSiteType.NONE);
    }

    public CookieSameSiteType getSameSite() {
        return this.sameSiteCookie;
    }

    public static enum CookieSameSiteType {
        NONE,
        LAX,
        STRICT;

    }

    public static enum CookieSecureType {
        TRUE,
        FALSE,
        DYNAMIC;

    }
}

