/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import fish.payara.security.annotations.AzureAuthenticationDefinition;
import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.annotations.OpenIdProviderMetadata;
import fish.payara.security.annotations.ProxyDefinition;
import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.DisplayType;
import fish.payara.security.openid.api.PromptType;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class AzureDefinitionConverter {
    static OpenIdAuthenticationDefinition toOpenIdAuthDefinition(final AzureAuthenticationDefinition azureDefinition) {
        return new OpenIdAuthenticationDefinition(){

            public String providerURI() {
                Config provider = ConfigProvider.getConfig();
                String tenantId = OpenIdUtil.getConfiguredValue(String.class, azureDefinition.tenantId(), provider, "payara.security.openid.azure.tenantId");
                if (OpenIdUtil.isEmpty(tenantId)) {
                    throw new IllegalStateException("tenantId must not be null");
                }
                String providerURI = OpenIdUtil.getConfiguredValue(String.class, azureDefinition.providerURI(), provider, "payara.security.openid.providerURI");
                return providerURI.replace("{tenantid}", tenantId);
            }

            public OpenIdProviderMetadata providerMetadata() {
                return azureDefinition.providerMetadata();
            }

            public ClaimsDefinition claimsDefinition() {
                return azureDefinition.claimsDefinition();
            }

            public ProxyDefinition proxyDefinition() {
                return azureDefinition.proxyDefinition();
            }

            public LogoutDefinition logout() {
                return azureDefinition.logout();
            }

            public String clientId() {
                return azureDefinition.clientId();
            }

            public String clientSecret() {
                return azureDefinition.clientSecret();
            }

            public String redirectURI() {
                return azureDefinition.redirectURI();
            }

            public String[] scope() {
                return azureDefinition.scope();
            }

            public String responseType() {
                return azureDefinition.responseType();
            }

            public String responseMode() {
                return azureDefinition.responseMode();
            }

            public PromptType[] prompt() {
                return azureDefinition.prompt();
            }

            public DisplayType display() {
                return azureDefinition.display();
            }

            public boolean useNonce() {
                return azureDefinition.useNonce();
            }

            public boolean useSession() {
                return azureDefinition.useSession();
            }

            public String[] extraParameters() {
                return azureDefinition.extraParameters();
            }

            public Class<? extends Annotation> annotationType() {
                return azureDefinition.annotationType();
            }

            public int jwksConnectTimeout() {
                return azureDefinition.jwksConnectTimeout();
            }

            public int jwksReadTimeout() {
                return azureDefinition.jwksReadTimeout();
            }

            public boolean tokenAutoRefresh() {
                return azureDefinition.tokenAutoRefresh();
            }

            public int tokenMinValidity() {
                return azureDefinition.tokenMinValidity();
            }

            public boolean userClaimsFromIDToken() {
                return azureDefinition.userClaimsFromIDToken();
            }
        };
    }
}

