/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import jakarta.el.ELProcessor;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.microprofile.config.Config;

public final class OpenIdUtil {
    private OpenIdUtil() {
    }

    public static String readConfiguredValueFromMetadataOrProvider(String metadataValue, JsonObject providerDocument, String openIdConstant, Config provider, String openIdProviderMetadataName) {
        String value = OpenIdUtil.isEmpty(metadataValue) && providerDocument.containsKey((Object)openIdConstant) ? OpenIdUtil.getConfiguredValue(String.class, providerDocument.getString(openIdConstant), provider, openIdProviderMetadataName) : OpenIdUtil.getConfiguredValue(String.class, metadataValue, provider, openIdProviderMetadataName);
        return value;
    }

    public static Set<String> readConfiguredValueFromMetadataOrProvider(String[] metadataValue, JsonObject providerDocument, String openIdConstant, Config provider, String openIdProviderMetadataName) {
        String[] valueArr = metadataValue.length == 0 && providerDocument.containsKey((Object)openIdConstant) ? OpenIdUtil.getConfiguredValue(String[].class, OpenIdUtil.getValues(providerDocument, openIdConstant), provider, openIdProviderMetadataName) : OpenIdUtil.getConfiguredValue(String[].class, metadataValue, provider, openIdProviderMetadataName);
        return new HashSet<String>(Arrays.asList(valueArr));
    }

    private static String[] getValues(JsonObject document, String key) {
        JsonArray jsonArray = document.getJsonArray(key);
        if (Objects.isNull(jsonArray)) {
            return new String[0];
        }
        return (String[])jsonArray.stream().filter(element -> element.getValueType() == JsonValue.ValueType.STRING).map(element -> (JsonString)element).map(JsonString::getString).toArray(String[]::new);
    }

    public static <T> T getConfiguredValue(Class<T> type, T value, Config provider, String mpConfigKey) {
        Object result = value;
        Optional configResult = provider.getOptionalValue(mpConfigKey, type);
        if (configResult.isPresent()) {
            return configResult.get();
        }
        if (type == String.class && OpenIdUtil.isELExpression((String)value)) {
            ELProcessor elProcessor = new ELProcessor();
            BeanManager beanManager = OpenIdUtil.getBeanManagerForCurrentModule();
            elProcessor.getELManager().addELResolver(beanManager.getELResolver());
            result = elProcessor.getValue(OpenIdUtil.toRawExpression((String)result), type);
        }
        return result;
    }

    private static BeanManager getBeanManagerForCurrentModule() {
        try {
            return (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isELExpression(String expression) {
        return expression != null && !expression.isEmpty() && OpenIdUtil.isDeferredExpression(expression);
    }

    public static boolean isDeferredExpression(String expression) {
        return expression.startsWith("#{") && expression.endsWith("}");
    }

    public static String toRawExpression(String expression) {
        return expression.substring(2, expression.length() - 1);
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static Long parseLong(JsonObject json, String fieldName) {
        Long longField = null;
        JsonValue jsonField = (JsonValue)json.get((Object)fieldName);
        if (jsonField instanceof JsonNumber) {
            longField = ((JsonNumber)jsonField).longValue();
        } else if (jsonField instanceof JsonString) {
            longField = Long.valueOf(((JsonString)jsonField).getString());
        }
        return longField;
    }
}

