/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

@ApplicationScoped
public class ProviderMetadataContoller {
    private static final String WELL_KNOWN_CONFIGURATION_ADDRESS = "/.well-known/openid-configuration";
    private final Map<String, JsonObject> providerDocuments = new HashMap<String, JsonObject>();

    public JsonObject getDocument(String providerURI) {
        if (!this.providerDocuments.containsKey(providerURI)) {
            JsonObject responseObject = providerURI.isEmpty() ? JsonObject.EMPTY_JSON_OBJECT : this.downloadWellKnownUris(providerURI);
            this.providerDocuments.put(providerURI, responseObject);
        }
        return this.providerDocuments.get(providerURI);
    }

    private JsonObject downloadWellKnownUris(String providerURI) {
        if (((String)providerURI).endsWith("/")) {
            providerURI = ((String)providerURI).substring(0, ((String)providerURI).length() - 1);
        }
        if (!((String)providerURI).endsWith(WELL_KNOWN_CONFIGURATION_ADDRESS)) {
            providerURI = (String)providerURI + WELL_KNOWN_CONFIGURATION_ADDRESS;
        }
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target((String)providerURI);
        Response response = target.request().accept(new String[]{"application/json"}).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String responseBody = (String)response.readEntity(String.class);
            try (JsonReader reader = Json.createReader((Reader)new StringReader(responseBody));){
                JsonObject responseObject;
                JsonObject jsonObject = responseObject = reader.readObject();
                return jsonObject;
            }
        }
        throw new IllegalStateException(String.format("Unable to retrieve OpenID Provider's [%s] configuration document, HTTP response code : [%s] ", providerURI, response.getStatus()));
    }
}

