/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.jwk;

import fish.payara.security.shaded.nimbusds.jose.Algorithm;
import fish.payara.security.shaded.nimbusds.jose.JWEAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.JWSAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.Requirement;
import fish.payara.security.shaded.nimbusds.jose.shaded.jcip.Immutable;
import fish.payara.security.shaded.nimbusds.jose.util.JSONStringUtils;
import java.io.Serializable;

@Immutable
public final class KeyType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Requirement requirement;
    public static final KeyType EC = new KeyType("EC", Requirement.RECOMMENDED);
    public static final KeyType RSA = new KeyType("RSA", Requirement.REQUIRED);
    public static final KeyType OCT = new KeyType("oct", Requirement.OPTIONAL);
    public static final KeyType OKP = new KeyType("OKP", Requirement.OPTIONAL);

    public KeyType(String value, Requirement req) {
        if (value == null) {
            throw new IllegalArgumentException("The key type value must not be null");
        }
        this.value = value;
        this.requirement = req;
    }

    public String getValue() {
        return this.value;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof KeyType && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.value;
    }

    public String toJSONString() {
        return JSONStringUtils.toJSONString(this.value);
    }

    public static KeyType parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("The key type to parse must not be null");
        }
        if (s.equals(EC.getValue())) {
            return EC;
        }
        if (s.equals(RSA.getValue())) {
            return RSA;
        }
        if (s.equals(OCT.getValue())) {
            return OCT;
        }
        if (s.equals(OKP.getValue())) {
            return OKP;
        }
        return new KeyType(s, null);
    }

    public static KeyType forAlgorithm(Algorithm alg) {
        if (alg == null) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains(alg)) {
            return RSA;
        }
        if (JWSAlgorithm.Family.EC.contains(alg)) {
            return EC;
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.RSA.contains(alg)) {
            return RSA;
        }
        if (JWEAlgorithm.Family.ECDH_ES.contains(alg)) {
            return EC;
        }
        if (JWEAlgorithm.DIR.equals(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.AES_GCM_KW.contains(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.AES_KW.contains(alg)) {
            return OCT;
        }
        if (JWEAlgorithm.Family.PBES2.contains(alg)) {
            return OCT;
        }
        if (JWSAlgorithm.Family.ED.contains(alg)) {
            return OKP;
        }
        return null;
    }
}

